# Autogenerated with DRAKON Editor 1.21
######### Public #########
proc reset_db {  } {
    variable f_manager_rcount
    array unset f_manager_rcount
    array set f_manager_rcount {}

    variable f_manager_type_id
    array unset f_manager_type_id
    array set f_manager_type_id {}

    variable f_manager_bonus
    array unset f_manager_bonus
    array set f_manager_bonus {}

    variable f_creature_rcount
    array unset f_creature_rcount
    array set f_creature_rcount {}

    variable f_creature_type_id
    array unset f_creature_type_id
    array set f_creature_type_id {}

    variable f_creature_dna
    array unset f_creature_dna
    array set f_creature_dna {}

    variable f_human_rcount
    array unset f_human_rcount
    array set f_human_rcount {}

    variable f_human_type_id
    array unset f_human_type_id
    array set f_human_type_id {}

    variable f_human_name
    array unset f_human_name
    array set f_human_name {}

    variable f_human_items
    array unset f_human_items
    array set f_human_items {}

    variable f_employee_rcount
    array unset f_employee_rcount
    array set f_employee_rcount {}

    variable f_employee_type_id
    array unset f_employee_type_id
    array set f_employee_type_id {}

    variable f_employee_salary
    array unset f_employee_salary
    array set f_employee_salary {}

    variable f_tool_rcount
    array unset f_tool_rcount
    array set f_tool_rcount {}

    variable f_tool_type_id
    array unset f_tool_type_id
    array set f_tool_type_id {}

    variable f_tool_usage
    array unset f_tool_usage
    array set f_tool_usage {}

    variable f_snack_rcount
    array unset f_snack_rcount
    array set f_snack_rcount {}

    variable f_snack_type_id
    array unset f_snack_type_id
    array set f_snack_type_id {}

    variable f_snack_taste
    array unset f_snack_taste
    array set f_snack_taste {}

    variable f_item_rcount
    array unset f_item_rcount
    array set f_item_rcount {}

    variable f_item_type_id
    array unset f_item_type_id
    array set f_item_type_id {}

    variable f_item_price
    array unset f_item_price
    array set f_item_price {}

    variable f_item_owner
    array unset f_item_owner
    array set f_item_owner {}

    variable i_creature_dna
    array unset i_creature_dna
    array set i_creature_dna {}

    variable i_human_name
    array unset i_human_name
    array set i_human_name {}

    variable g_manager_next
    set g_manager_next 1
    variable g_creature_next
    set g_creature_next 1
    variable g_human_next
    set g_human_next 1
    variable g_employee_next
    set g_employee_next 1
    variable g_tool_next
    set g_tool_next 1
    variable g_snack_next
    set g_snack_next 1
    variable g_item_next
    set g_item_next 1
}
proc manager_keys {  } {
    variable f_manager_rcount
    set names [ array names f_manager_rcount ]
    return $names
}
proc manager_count {  } {
    variable f_manager_rcount
    set names [ array names f_manager_rcount ]
    return [ llength $names ]
}
proc manager_exists { id } {
    variable f_manager_rcount
    return [ info exists f_manager_rcount($id) ]
}
proc manager_insert { id dna name } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "manager"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable f_human_rcount
    set f_human_rcount($id) 0
    variable f_human_name
    set f_human_name($id) $name
    variable f_manager_rcount
    set f_manager_rcount($id) 0
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
    return $id
}
proc get_manager_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc manager_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ manager_exists $id ] } {
        error "'manager' with id '$id' does not exist."
    }
    manager_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc get_manager_bonus { id } {
    variable f_manager_bonus
    if { [ info exists f_manager_bonus($id) ] } {
        return $f_manager_bonus($id)
    } else {
        return {}
    }
}
proc set_manager_bonus { id bonus } {
    variable f_manager_bonus
    set f_manager_bonus($id) $bonus
}
proc creature_keys {  } {
    variable f_creature_rcount
    set names [ array names f_creature_rcount ]
    return $names
}
proc creature_count {  } {
    variable f_creature_rcount
    set names [ array names f_creature_rcount ]
    return [ llength $names ]
}
proc creature_exists { id } {
    variable f_creature_rcount
    return [ info exists f_creature_rcount($id) ]
}
proc creature_insert { id dna } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable i_creature_dna
    set _key_ "$dna"
    if { [ info exists i_creature_dna($_key_) ] } {
        error "Fields 'dna' are not unique for 'creature'."
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "creature"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    return $id
}
proc get_creature_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc creature_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ creature_exists $id ] } {
        error "'creature' with id '$id' does not exist."
    }
    creature_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc find_creature_by_dna { dna } {
    variable i_creature_dna
    set _key_ "$dna"
    if { [ info exists i_creature_dna($_key_) ] } {
        return $i_creature_dna($_key_)
    } else {
        return {}
    }
}
proc get_creature_dna { id } {
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        return $f_creature_dna($id)
    } else {
        return {}
    }
}
proc set_creature_dna { id dna } {
    if { ![ creature_exists $id ] } {
        error "'creature' with id '$id' does not exist."
    }
    set old [ get_creature_dna $id ]
    if { $old == $dna } {
        return
    }
    variable i_creature_dna
    set _key_ "$dna"
    if { [ info exists i_creature_dna($_key_) ] } {
        error "Fields 'dna' are not unique for 'creature'."
    }
    set _key_ "$old"
    unset i_creature_dna($_key_)
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
}
proc human_keys {  } {
    variable f_human_rcount
    set names [ array names f_human_rcount ]
    return $names
}
proc human_count {  } {
    variable f_human_rcount
    set names [ array names f_human_rcount ]
    return [ llength $names ]
}
proc human_exists { id } {
    variable f_human_rcount
    return [ info exists f_human_rcount($id) ]
}
proc human_insert { id dna name } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        error "Fields 'name' are not unique for 'human'."
    }
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        error "Fields 'name' are not unique for 'human'."
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "human"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable f_human_rcount
    set f_human_rcount($id) 0
    variable f_human_name
    set f_human_name($id) $name
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
    return $id
}
proc get_human_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc human_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ human_exists $id ] } {
        error "'human' with id '$id' does not exist."
    }
    human_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc find_human_by_name { name } {
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        return $i_human_name($_key_)
    } else {
        return {}
    }
}
proc get_human_name { id } {
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        return $f_human_name($id)
    } else {
        return {}
    }
}
proc set_human_name { id name } {
    if { ![ human_exists $id ] } {
        error "'human' with id '$id' does not exist."
    }
    set old [ get_human_name $id ]
    if { $old == $name } {
        return
    }
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        error "Fields 'name' are not unique for 'human'."
    }
    set _key_ "$old"
    unset i_human_name($_key_)
    variable f_human_name
    set f_human_name($id) $name
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
}
proc get_human_items { id } {
    variable f_human_items
    if { [ info exists f_human_items($id) ] } {
        return $f_human_items($id)
    } else {
        return {}
    }
}
proc employee_keys {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return $names
}
proc employee_count {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return [ llength $names ]
}
proc employee_exists { id } {
    variable f_employee_rcount
    return [ info exists f_employee_rcount($id) ]
}
proc employee_insert { id dna name } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "employee"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable f_human_rcount
    set f_human_rcount($id) 0
    variable f_human_name
    set f_human_name($id) $name
    variable f_employee_rcount
    set f_employee_rcount($id) 0
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
    return $id
}
proc get_employee_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc employee_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    employee_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc get_employee_salary { id } {
    variable f_employee_salary
    if { [ info exists f_employee_salary($id) ] } {
        return $f_employee_salary($id)
    } else {
        return {}
    }
}
proc set_employee_salary { id salary } {
    variable f_employee_salary
    set f_employee_salary($id) $salary
}
proc tool_keys {  } {
    variable f_tool_rcount
    set names [ array names f_tool_rcount ]
    return $names
}
proc tool_count {  } {
    variable f_tool_rcount
    set names [ array names f_tool_rcount ]
    return [ llength $names ]
}
proc tool_exists { id } {
    variable f_tool_rcount
    return [ info exists f_tool_rcount($id) ]
}
proc tool_insert { id } {
    variable g_item_next
    if { $id == {} } {
        set id $g_item_next
    } else {
        if { [ item_exists $id ] } {
            set class_name [ get_item_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_item_next } {
        set g_item_next [ expr { $id + 1 } ]
    }
    variable f_item_type_id
    set f_item_type_id($id) "tool"
    variable f_item_rcount
    set f_item_rcount($id) 0
    variable f_tool_rcount
    set f_tool_rcount($id) 0
    return $id
}
proc get_tool_type_id { id } {
    variable f_item_type_id
    if { [ info exists f_item_type_id($id) ] } {
        return $f_item_type_id($id)
    } else {
        return {}
    }
}
proc tool_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ tool_exists $id ] } {
        error "'tool' with id '$id' does not exist."
    }
    tool_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_item_type_id
    unset f_item_type_id($id)
}
proc get_tool_usage { id } {
    variable f_tool_usage
    if { [ info exists f_tool_usage($id) ] } {
        return $f_tool_usage($id)
    } else {
        return {}
    }
}
proc set_tool_usage { id usage } {
    variable f_tool_usage
    set f_tool_usage($id) $usage
}
proc snack_keys {  } {
    variable f_snack_rcount
    set names [ array names f_snack_rcount ]
    return $names
}
proc snack_count {  } {
    variable f_snack_rcount
    set names [ array names f_snack_rcount ]
    return [ llength $names ]
}
proc snack_exists { id } {
    variable f_snack_rcount
    return [ info exists f_snack_rcount($id) ]
}
proc snack_insert { id } {
    variable g_item_next
    if { $id == {} } {
        set id $g_item_next
    } else {
        if { [ item_exists $id ] } {
            set class_name [ get_item_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_item_next } {
        set g_item_next [ expr { $id + 1 } ]
    }
    variable f_item_type_id
    set f_item_type_id($id) "snack"
    variable f_item_rcount
    set f_item_rcount($id) 0
    variable f_snack_rcount
    set f_snack_rcount($id) 0
    return $id
}
proc get_snack_type_id { id } {
    variable f_item_type_id
    if { [ info exists f_item_type_id($id) ] } {
        return $f_item_type_id($id)
    } else {
        return {}
    }
}
proc snack_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ snack_exists $id ] } {
        error "'snack' with id '$id' does not exist."
    }
    snack_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_item_type_id
    unset f_item_type_id($id)
}
proc get_snack_taste { id } {
    variable f_snack_taste
    if { [ info exists f_snack_taste($id) ] } {
        return $f_snack_taste($id)
    } else {
        return {}
    }
}
proc set_snack_taste { id taste } {
    variable f_snack_taste
    set f_snack_taste($id) $taste
}
proc item_keys {  } {
    variable f_item_rcount
    set names [ array names f_item_rcount ]
    return $names
}
proc item_count {  } {
    variable f_item_rcount
    set names [ array names f_item_rcount ]
    return [ llength $names ]
}
proc item_exists { id } {
    variable f_item_rcount
    return [ info exists f_item_rcount($id) ]
}
proc item_insert { id } {
    variable g_item_next
    if { $id == {} } {
        set id $g_item_next
    } else {
        if { [ item_exists $id ] } {
            set class_name [ get_item_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_item_next } {
        set g_item_next [ expr { $id + 1 } ]
    }
    variable f_item_type_id
    set f_item_type_id($id) "item"
    variable f_item_rcount
    set f_item_rcount($id) 0
    return $id
}
proc get_item_type_id { id } {
    variable f_item_type_id
    if { [ info exists f_item_type_id($id) ] } {
        return $f_item_type_id($id)
    } else {
        return {}
    }
}
proc item_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ item_exists $id ] } {
        error "'item' with id '$id' does not exist."
    }
    item_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_item_type_id
    unset f_item_type_id($id)
}
proc get_item_price { id } {
    variable f_item_price
    if { [ info exists f_item_price($id) ] } {
        return $f_item_price($id)
    } else {
        return {}
    }
}
proc set_item_price { id price } {
    variable f_item_price
    set f_item_price($id) $price
}
proc get_item_owner { id } {
    variable f_item_owner
    if { [ info exists f_item_owner($id) ] } {
        return $f_item_owner($id)
    } else {
        return {}
    }
}
proc set_item_owner { id owner } {
    if { ![ item_exists $id ] } {
        error "'item' with id '$id' does not exist."
    }
    set old [ get_item_owner $id ]
    if { $old == $owner } {
        return
    }
    if { $owner != {} && ![ human_exists $owner ] } {
        error "'human' with id '$owner' does not exist."
    }
    if { $old != {} } {
        variable f_human_items
        if { [ info exists f_human_items($old) ] } {
            set _col_ $f_human_items($old)
            set _index_ [ lsearch $_col_ $id ]
            if { $_index_ != -1 } {
                set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                set f_human_items($old) $_col_2
            }
        }
    }
    variable f_item_owner
    set f_item_owner($id) $owner
    if { $owner != {} } {
        variable f_human_items
        if { [ info exists f_human_items($owner) ] } {
            set _col_ $f_human_items($owner)
        } else {
            set _col_ {}
        }
        lappend _col_ $id
        set f_human_items($owner) $_col_
    }
}
######### Private #########
variable g_del_list
array set g_del_list {}
variable f_manager_rcount
array set f_manager_rcount {}
variable f_manager_type_id
array set f_manager_type_id {}
variable g_manager_next 1
variable f_manager_bonus
array set f_manager_bonus {}
variable f_creature_rcount
array set f_creature_rcount {}
variable f_creature_type_id
array set f_creature_type_id {}
variable g_creature_next 1
variable f_creature_dna
array set f_creature_dna {}
variable f_human_rcount
array set f_human_rcount {}
variable f_human_type_id
array set f_human_type_id {}
variable g_human_next 1
variable f_human_name
array set f_human_name {}
variable f_human_items
array set f_human_items {}
variable f_employee_rcount
array set f_employee_rcount {}
variable f_employee_type_id
array set f_employee_type_id {}
variable g_employee_next 1
variable f_employee_salary
array set f_employee_salary {}
variable f_tool_rcount
array set f_tool_rcount {}
variable f_tool_type_id
array set f_tool_type_id {}
variable g_tool_next 1
variable f_tool_usage
array set f_tool_usage {}
variable f_snack_rcount
array set f_snack_rcount {}
variable f_snack_type_id
array set f_snack_type_id {}
variable g_snack_next 1
variable f_snack_taste
array set f_snack_taste {}
variable f_item_rcount
array set f_item_rcount {}
variable f_item_type_id
array set f_item_type_id {}
variable g_item_next 1
variable f_item_price
array set f_item_price {}
variable f_item_owner
array set f_item_owner {}
variable i_creature_dna
array set i_creature_dna {}
variable i_human_name
array set i_human_name {}
proc manager_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc manager_pre_delete_middle { id } {
    creature_pre_delete_inner $id
    human_pre_delete_inner $id
    manager_pre_delete_inner $id
}
proc manager_pre_delete_inner { id } {
}
proc manager_can_delete { id } {
}
proc manager_do_delete { id } {
    set name [ get_human_name $id ]
    variable i_human_name
    set _key_ "$name"
    unset i_human_name($_key_)
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_manager_bonus
    if { [ info exists f_manager_bonus($id) ] } {
        unset f_manager_bonus($id)
    }
    variable f_manager_rcount
    unset f_manager_rcount($id)
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        unset f_human_name($id)
    }
    variable f_human_items
    if { [ info exists f_human_items($id) ] } {
        unset f_human_items($id)
    }
    variable f_human_rcount
    unset f_human_rcount($id)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}
proc creature_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc creature_pre_delete_middle { id } {
    creature_pre_delete_inner $id
}
proc creature_pre_delete_inner { id } {
}
proc creature_can_delete { id } {
}
proc creature_do_delete { id } {
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}
proc human_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc human_pre_delete_middle { id } {
    creature_pre_delete_inner $id
    human_pre_delete_inner $id
}
proc human_pre_delete_inner { id } {
    set items [ get_human_items $id ]
    foreach that $items {
        item_pre_delete $that
    }
}
proc human_can_delete { id } {
}
proc human_do_delete { id } {
    set name [ get_human_name $id ]
    variable i_human_name
    set _key_ "$name"
    unset i_human_name($_key_)
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        unset f_human_name($id)
    }
    variable f_human_items
    if { [ info exists f_human_items($id) ] } {
        unset f_human_items($id)
    }
    variable f_human_rcount
    unset f_human_rcount($id)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}
proc employee_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc employee_pre_delete_middle { id } {
    creature_pre_delete_inner $id
    human_pre_delete_inner $id
    employee_pre_delete_inner $id
}
proc employee_pre_delete_inner { id } {
}
proc employee_can_delete { id } {
}
proc employee_do_delete { id } {
    set name [ get_human_name $id ]
    variable i_human_name
    set _key_ "$name"
    unset i_human_name($_key_)
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_employee_salary
    if { [ info exists f_employee_salary($id) ] } {
        unset f_employee_salary($id)
    }
    variable f_employee_rcount
    unset f_employee_rcount($id)
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        unset f_human_name($id)
    }
    variable f_human_items
    if { [ info exists f_human_items($id) ] } {
        unset f_human_items($id)
    }
    variable f_human_rcount
    unset f_human_rcount($id)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}
proc tool_pre_delete { id } {
    set type [ get_item_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc tool_pre_delete_middle { id } {
    item_pre_delete_inner $id
    tool_pre_delete_inner $id
}
proc tool_pre_delete_inner { id } {
}
proc tool_can_delete { id } {
}
proc tool_do_delete { id } {
    set owner [ get_item_owner $id ]
    if { $owner != {} } {
        variable g_del_list
        set _type_ [ get_human_type_id $owner ]
        set _key_ "$owner,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_human_items
            if { [ info exists f_human_items($owner) ] } {
                set _col_ $f_human_items($owner)
                set _index_ [ lsearch $_col_ $id ]
                if { $_index_ != -1 } {
                    set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                    set f_human_items($owner) $_col_2
                }
            }
        }
    }
    variable f_tool_usage
    if { [ info exists f_tool_usage($id) ] } {
        unset f_tool_usage($id)
    }
    variable f_tool_rcount
    unset f_tool_rcount($id)
    variable f_item_price
    if { [ info exists f_item_price($id) ] } {
        unset f_item_price($id)
    }
    variable f_item_owner
    if { [ info exists f_item_owner($id) ] } {
        unset f_item_owner($id)
    }
    variable f_item_rcount
    unset f_item_rcount($id)
}
proc snack_pre_delete { id } {
    set type [ get_item_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc snack_pre_delete_middle { id } {
    item_pre_delete_inner $id
    snack_pre_delete_inner $id
}
proc snack_pre_delete_inner { id } {
}
proc snack_can_delete { id } {
}
proc snack_do_delete { id } {
    set owner [ get_item_owner $id ]
    if { $owner != {} } {
        variable g_del_list
        set _type_ [ get_human_type_id $owner ]
        set _key_ "$owner,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_human_items
            if { [ info exists f_human_items($owner) ] } {
                set _col_ $f_human_items($owner)
                set _index_ [ lsearch $_col_ $id ]
                if { $_index_ != -1 } {
                    set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                    set f_human_items($owner) $_col_2
                }
            }
        }
    }
    variable f_snack_taste
    if { [ info exists f_snack_taste($id) ] } {
        unset f_snack_taste($id)
    }
    variable f_snack_rcount
    unset f_snack_rcount($id)
    variable f_item_price
    if { [ info exists f_item_price($id) ] } {
        unset f_item_price($id)
    }
    variable f_item_owner
    if { [ info exists f_item_owner($id) ] } {
        unset f_item_owner($id)
    }
    variable f_item_rcount
    unset f_item_rcount($id)
}
proc item_pre_delete { id } {
    set type [ get_item_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc item_pre_delete_middle { id } {
    item_pre_delete_inner $id
}
proc item_pre_delete_inner { id } {
}
proc item_can_delete { id } {
}
proc item_do_delete { id } {
    set owner [ get_item_owner $id ]
    if { $owner != {} } {
        variable g_del_list
        set _type_ [ get_human_type_id $owner ]
        set _key_ "$owner,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_human_items
            if { [ info exists f_human_items($owner) ] } {
                set _col_ $f_human_items($owner)
                set _index_ [ lsearch $_col_ $id ]
                if { $_index_ != -1 } {
                    set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                    set f_human_items($owner) $_col_2
                }
            }
        }
    }
    variable f_item_price
    if { [ info exists f_item_price($id) ] } {
        unset f_item_price($id)
    }
    variable f_item_owner
    if { [ info exists f_item_owner($id) ] } {
        unset f_item_owner($id)
    }
    variable f_item_rcount
    unset f_item_rcount($id)
}

proc create_snack { owner price taste } {
    #item 285
    set id [ snack_insert "" ]
    set_snack_taste $id $taste
    set_item_price $id $price
    set_item_owner $id $owner
    #item 286
    return $id
}

proc create_tool { owner price usage } {
    #item 292
    set id [ tool_insert "" ]
    set_tool_usage $id $usage
    set_item_price $id $price
    set_item_owner $id $owner
    #item 293
    return $id
}

proc equal { expected actual } {
    #item 18
    if { $expected != $actual } {
    	error "'equal' fails:\nExpected: $expected \nActual:   $actual"
    }
}

proc exception { expression } {
    #item 7
    if { ![ catch { uplevel $expression } ] } {
    	error "Error expected!"
    }
}

proc main { } {
    #item 19
    reset_db
    #item 257
    set gandalf [ manager_insert "" 10101 "Gandalf" ]
    set bilbo   [ employee_insert "" 10102 "Bilbo" ]
    set fedor   [ employee_insert "" 10103 "Fedor" ]
    #item 268
    set hammer [ create_tool $gandalf 100 "nail" ]
    set loaf   [ create_snack $gandalf 110 "fresh" ]
    set saw    [ create_tool $fedor 200 "saw" ]
    set driver [ create_tool $fedor 120 "drive screws" ]
    set spade  [ create_tool $fedor 150 "dig" ]
    #item 294
    equal [ list $hammer $loaf ] \
     [ get_human_items $gandalf ]
    equal {} \
     [ get_human_items $bilbo ]
    equal [ list $saw $driver $spade ] \
     [ get_human_items $fedor ]
    #item 318
    equal 5 [ item_count ]
    equal 4 [ tool_count ]
    equal 1 [ snack_count ]
    #item 303
    equal 1 [ item_exists $hammer ]
    equal 1 [ tool_exists $hammer ]
    equal 0 [ snack_exists $hammer ]
    equal "tool" [ get_item_type_id $hammer ]
    #item 304
    equal 1 [ item_exists $saw ]
    equal 1 [ tool_exists $saw ]
    equal 0 [ snack_exists $saw ]
    equal "tool" [ get_item_type_id $saw ]
    #item 305
    equal 1 [ item_exists $driver ]
    equal 1 [ tool_exists $driver ]
    equal 0 [ snack_exists $driver ]
    equal "tool" [ get_item_type_id $driver ]
    #item 306
    equal 1 [ item_exists $spade ]
    equal 1 [ tool_exists $spade ]
    equal 0 [ snack_exists $spade ]
    equal "tool" [ get_item_type_id $spade ]
    #item 307
    equal 1 [ item_exists $loaf ]
    equal 0 [ tool_exists $loaf ]
    equal 1 [ snack_exists $loaf ]
    equal "snack" [ get_item_type_id $loaf ]
    #item 308
    item_delete $hammer
    #item 309
    equal $loaf \
     [ get_human_items $gandalf ]
    #item 295
    equal 0 [ item_exists $hammer ]
    equal 0 [ tool_exists $hammer ]
    equal 0 [ snack_exists $hammer ]
    #item 310
    tool_delete $spade
    #item 311
    equal 0 [ item_exists $spade ]
    equal 0 [ tool_exists $spade ]
    equal 0 [ snack_exists $spade ]
    #item 312
    equal [ list $saw $driver ] \
     [ get_human_items $fedor ]
    #item 313
    human_delete $fedor
    #item 314
    equal 0 [ item_exists $saw ]
    equal 0 [ tool_exists $saw ]
    equal 0 [ snack_exists $saw ]
    #item 315
    equal 0 [ item_exists $driver ]
    equal 0 [ tool_exists $driver ]
    equal 0 [ snack_exists $driver ]
    #item 319
    equal 1 [ item_exists $loaf ]
    equal 0 [ tool_exists $loaf ]
    equal 1 [ snack_exists $loaf ]
    equal "snack" [ get_item_type_id $loaf ]
    #item 317
    equal 1 [ item_count ]
    equal 0 [ tool_count ]
    equal 1 [ snack_count ]
}

proc not_equal { left right } {
    #item 31
    if { $left == $right } {
    	error "'not_equal' fails:\nLeft:    $left \nRight:   $right"
    }
}

main
