# Autogenerated with DRAKON Editor 1.21
######### Public #########
proc reset_db {  } {
    variable f_manager_rcount
    array unset f_manager_rcount
    array set f_manager_rcount {}

    variable f_manager_type_id
    array unset f_manager_type_id
    array set f_manager_type_id {}

    variable f_manager_bonus
    array unset f_manager_bonus
    array set f_manager_bonus {}

    variable f_human_rcount
    array unset f_human_rcount
    array set f_human_rcount {}

    variable f_human_type_id
    array unset f_human_type_id
    array set f_human_type_id {}

    variable f_human_name
    array unset f_human_name
    array set f_human_name {}

    variable f_creature_rcount
    array unset f_creature_rcount
    array set f_creature_rcount {}

    variable f_creature_type_id
    array unset f_creature_type_id
    array set f_creature_type_id {}

    variable f_creature_dna
    array unset f_creature_dna
    array set f_creature_dna {}

    variable f_employee_rcount
    array unset f_employee_rcount
    array set f_employee_rcount {}

    variable f_employee_type_id
    array unset f_employee_type_id
    array set f_employee_type_id {}

    variable f_employee_salary
    array unset f_employee_salary
    array set f_employee_salary {}

    variable i_human_name
    array unset i_human_name
    array set i_human_name {}

    variable i_creature_dna
    array unset i_creature_dna
    array set i_creature_dna {}

    variable g_manager_next
    set g_manager_next 1
    variable g_human_next
    set g_human_next 1
    variable g_creature_next
    set g_creature_next 1
    variable g_employee_next
    set g_employee_next 1
}
proc manager_keys {  } {
    variable f_manager_rcount
    set names [ array names f_manager_rcount ]
    return $names
}
proc manager_count {  } {
    variable f_manager_rcount
    set names [ array names f_manager_rcount ]
    return [ llength $names ]
}
proc manager_exists { id } {
    variable f_manager_rcount
    return [ info exists f_manager_rcount($id) ]
}
proc manager_insert { id dna name } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "manager"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable f_human_rcount
    set f_human_rcount($id) 0
    variable f_human_name
    set f_human_name($id) $name
    variable f_manager_rcount
    set f_manager_rcount($id) 0
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
    return $id
}
proc get_manager_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc manager_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ manager_exists $id ] } {
        error "'manager' with id '$id' does not exist."
    }
    manager_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc get_manager_bonus { id } {
    variable f_manager_bonus
    if { [ info exists f_manager_bonus($id) ] } {
        return $f_manager_bonus($id)
    } else {
        return {}
    }
}
proc set_manager_bonus { id bonus } {
    variable f_manager_bonus
    set f_manager_bonus($id) $bonus
}
proc human_keys {  } {
    variable f_human_rcount
    set names [ array names f_human_rcount ]
    return $names
}
proc human_count {  } {
    variable f_human_rcount
    set names [ array names f_human_rcount ]
    return [ llength $names ]
}
proc human_exists { id } {
    variable f_human_rcount
    return [ info exists f_human_rcount($id) ]
}
proc human_insert { id dna name } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        error "Fields 'name' are not unique for 'human'."
    }
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        error "Fields 'name' are not unique for 'human'."
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "human"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable f_human_rcount
    set f_human_rcount($id) 0
    variable f_human_name
    set f_human_name($id) $name
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
    return $id
}
proc get_human_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc human_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ human_exists $id ] } {
        error "'human' with id '$id' does not exist."
    }
    human_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc find_human_by_name { name } {
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        return $i_human_name($_key_)
    } else {
        return {}
    }
}
proc get_human_name { id } {
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        return $f_human_name($id)
    } else {
        return {}
    }
}
proc set_human_name { id name } {
    if { ![ human_exists $id ] } {
        error "'human' with id '$id' does not exist."
    }
    set old [ get_human_name $id ]
    if { $old == $name } {
        return
    }
    variable i_human_name
    set _key_ "$name"
    if { [ info exists i_human_name($_key_) ] } {
        error "Fields 'name' are not unique for 'human'."
    }
    set _key_ "$old"
    unset i_human_name($_key_)
    variable f_human_name
    set f_human_name($id) $name
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
}
proc creature_keys {  } {
    variable f_creature_rcount
    set names [ array names f_creature_rcount ]
    return $names
}
proc creature_count {  } {
    variable f_creature_rcount
    set names [ array names f_creature_rcount ]
    return [ llength $names ]
}
proc creature_exists { id } {
    variable f_creature_rcount
    return [ info exists f_creature_rcount($id) ]
}
proc creature_insert { id dna } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable i_creature_dna
    set _key_ "$dna"
    if { [ info exists i_creature_dna($_key_) ] } {
        error "Fields 'dna' are not unique for 'creature'."
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "creature"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    return $id
}
proc get_creature_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc creature_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ creature_exists $id ] } {
        error "'creature' with id '$id' does not exist."
    }
    creature_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc find_creature_by_dna { dna } {
    variable i_creature_dna
    set _key_ "$dna"
    if { [ info exists i_creature_dna($_key_) ] } {
        return $i_creature_dna($_key_)
    } else {
        return {}
    }
}
proc get_creature_dna { id } {
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        return $f_creature_dna($id)
    } else {
        return {}
    }
}
proc set_creature_dna { id dna } {
    if { ![ creature_exists $id ] } {
        error "'creature' with id '$id' does not exist."
    }
    set old [ get_creature_dna $id ]
    if { $old == $dna } {
        return
    }
    variable i_creature_dna
    set _key_ "$dna"
    if { [ info exists i_creature_dna($_key_) ] } {
        error "Fields 'dna' are not unique for 'creature'."
    }
    set _key_ "$old"
    unset i_creature_dna($_key_)
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
}
proc employee_keys {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return $names
}
proc employee_count {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return [ llength $names ]
}
proc employee_exists { id } {
    variable f_employee_rcount
    return [ info exists f_employee_rcount($id) ]
}
proc employee_insert { id dna name } {
    variable g_creature_next
    if { $id == {} } {
        set id $g_creature_next
    } else {
        if { [ creature_exists $id ] } {
            set class_name [ get_creature_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_creature_next } {
        set g_creature_next [ expr { $id + 1 } ]
    }
    variable f_creature_type_id
    set f_creature_type_id($id) "employee"
    variable f_creature_rcount
    set f_creature_rcount($id) 0
    variable f_creature_dna
    set f_creature_dna($id) $dna
    variable f_human_rcount
    set f_human_rcount($id) 0
    variable f_human_name
    set f_human_name($id) $name
    variable f_employee_rcount
    set f_employee_rcount($id) 0
    variable i_creature_dna
    set _key_ "$dna"
    set i_creature_dna($_key_) $id
    variable i_human_name
    set _key_ "$name"
    set i_human_name($_key_) $id
    return $id
}
proc get_employee_type_id { id } {
    variable f_creature_type_id
    if { [ info exists f_creature_type_id($id) ] } {
        return $f_creature_type_id($id)
    } else {
        return {}
    }
}
proc employee_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    employee_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_creature_type_id
    unset f_creature_type_id($id)
}
proc get_employee_salary { id } {
    variable f_employee_salary
    if { [ info exists f_employee_salary($id) ] } {
        return $f_employee_salary($id)
    } else {
        return {}
    }
}
proc set_employee_salary { id salary } {
    variable f_employee_salary
    set f_employee_salary($id) $salary
}
######### Private #########
variable g_del_list
array set g_del_list {}
variable f_manager_rcount
array set f_manager_rcount {}
variable f_manager_type_id
array set f_manager_type_id {}
variable g_manager_next 1
variable f_manager_bonus
array set f_manager_bonus {}
variable f_human_rcount
array set f_human_rcount {}
variable f_human_type_id
array set f_human_type_id {}
variable g_human_next 1
variable f_human_name
array set f_human_name {}
variable f_creature_rcount
array set f_creature_rcount {}
variable f_creature_type_id
array set f_creature_type_id {}
variable g_creature_next 1
variable f_creature_dna
array set f_creature_dna {}
variable f_employee_rcount
array set f_employee_rcount {}
variable f_employee_type_id
array set f_employee_type_id {}
variable g_employee_next 1
variable f_employee_salary
array set f_employee_salary {}
variable i_human_name
array set i_human_name {}
variable i_creature_dna
array set i_creature_dna {}
proc manager_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc manager_pre_delete_middle { id } {
    creature_pre_delete_inner $id
    human_pre_delete_inner $id
    manager_pre_delete_inner $id
}
proc manager_pre_delete_inner { id } {
}
proc manager_can_delete { id } {
}
proc manager_do_delete { id } {
    set name [ get_human_name $id ]
    variable i_human_name
    set _key_ "$name"
    unset i_human_name($_key_)
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_manager_bonus
    if { [ info exists f_manager_bonus($id) ] } {
        unset f_manager_bonus($id)
    }
    variable f_manager_rcount
    unset f_manager_rcount($id)
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        unset f_human_name($id)
    }
    variable f_human_rcount
    unset f_human_rcount($id)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}
proc human_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc human_pre_delete_middle { id } {
    creature_pre_delete_inner $id
    human_pre_delete_inner $id
}
proc human_pre_delete_inner { id } {
}
proc human_can_delete { id } {
}
proc human_do_delete { id } {
    set name [ get_human_name $id ]
    variable i_human_name
    set _key_ "$name"
    unset i_human_name($_key_)
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        unset f_human_name($id)
    }
    variable f_human_rcount
    unset f_human_rcount($id)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}
proc creature_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc creature_pre_delete_middle { id } {
    creature_pre_delete_inner $id
}
proc creature_pre_delete_inner { id } {
}
proc creature_can_delete { id } {
}
proc creature_do_delete { id } {
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}
proc employee_pre_delete { id } {
    set type [ get_creature_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc employee_pre_delete_middle { id } {
    creature_pre_delete_inner $id
    human_pre_delete_inner $id
    employee_pre_delete_inner $id
}
proc employee_pre_delete_inner { id } {
}
proc employee_can_delete { id } {
}
proc employee_do_delete { id } {
    set name [ get_human_name $id ]
    variable i_human_name
    set _key_ "$name"
    unset i_human_name($_key_)
    set dna [ get_creature_dna $id ]
    variable i_creature_dna
    set _key_ "$dna"
    unset i_creature_dna($_key_)
    variable f_employee_salary
    if { [ info exists f_employee_salary($id) ] } {
        unset f_employee_salary($id)
    }
    variable f_employee_rcount
    unset f_employee_rcount($id)
    variable f_human_name
    if { [ info exists f_human_name($id) ] } {
        unset f_human_name($id)
    }
    variable f_human_rcount
    unset f_human_rcount($id)
    variable f_creature_dna
    if { [ info exists f_creature_dna($id) ] } {
        unset f_creature_dna($id)
    }
    variable f_creature_rcount
    unset f_creature_rcount($id)
}

proc equal { expected actual } {
    #item 18
    if { $expected != $actual } {
    	error "'equal' fails:\nExpected: $expected \nActual:   $actual"
    }
}

proc exception { expression } {
    #item 7
    if { ![ catch { uplevel $expression } ] } {
    	error "Error expected!"
    }
}

proc main { } {
    #item 19
    reset_db
    #item 257
    set gandalf [ manager_insert "" 10101 "Gandalf" ]
    set bilbo   [ employee_insert "" 10102 "Bilbo" ]
    set fedor   [ employee_insert "" 10103 "Fedor" ]
    #item 269
    equal "manager" [ get_manager_type_id $gandalf ]
    equal "manager" [ get_human_type_id $gandalf ]
    equal "manager" [ get_creature_type_id $gandalf ]
    #item 258
    equal 1 [ employee_exists $bilbo ]
    equal 1 [ human_exists $bilbo ]
    equal 1 [ creature_exists $bilbo ]
    equal 0 [ manager_exists $bilbo ]
    #item 259
    equal 1 [ employee_exists $fedor ]
    equal 1 [ human_exists $fedor ]
    equal 1 [ creature_exists $fedor ]
    equal 0 [ manager_exists $fedor ]
    #item 260
    equal 0 [ employee_exists $gandalf ]
    equal 1 [ human_exists $gandalf ]
    equal 1 [ creature_exists $gandalf ]
    equal 1 [ manager_exists $gandalf ]
    #item 265
    equal [ list $gandalf $bilbo $fedor ] \
     [ lsort [ creature_keys ]]
    #item 266
    equal [ list $gandalf $bilbo $fedor ] \
     [ lsort [ human_keys ]]
    #item 267
    equal [ list $bilbo $fedor ] \
     [ lsort [ employee_keys ]]
    #item 268
    equal $gandalf \
     [ manager_keys ]
    #item 261
    human_delete $bilbo
    #item 262
    equal 0 [ employee_exists $bilbo ]
    equal 0 [ human_exists $bilbo ]
    equal 0 [ creature_exists $bilbo ]
    equal 0 [ manager_exists $bilbo ]
    #item 263
    equal 1 [ employee_exists $fedor ]
    equal 1 [ human_exists $fedor ]
    equal 1 [ creature_exists $fedor ]
    equal 0 [ manager_exists $fedor ]
    #item 264
    equal 0 [ employee_exists $gandalf ]
    equal 1 [ human_exists $gandalf ]
    equal 1 [ creature_exists $gandalf ]
    equal 1 [ manager_exists $gandalf ]
}

proc not_equal { left right } {
    #item 31
    if { $left == $right } {
    	error "'not_equal' fails:\nLeft:    $left \nRight:   $right"
    }
}

main
