# Autogenerated with DRAKON Editor 1.21
######### Public #########
proc reset_db {  } {
    variable f_employee_rcount
    array unset f_employee_rcount
    array set f_employee_rcount {}

    variable f_employee_type_id
    array unset f_employee_type_id
    array set f_employee_type_id {}

    variable f_employee_name
    array unset f_employee_name
    array set f_employee_name {}

    variable f_employee_departments
    array unset f_employee_departments
    array set f_employee_departments {}

    variable f_employee_company
    array unset f_employee_company
    array set f_employee_company {}

    variable f_department_rcount
    array unset f_department_rcount
    array set f_department_rcount {}

    variable f_department_type_id
    array unset f_department_type_id
    array set f_department_type_id {}

    variable f_department_title
    array unset f_department_title
    array set f_department_title {}

    variable f_department_employees
    array unset f_department_employees
    array set f_department_employees {}

    variable f_department_company
    array unset f_department_company
    array set f_department_company {}

    variable f_company_rcount
    array unset f_company_rcount
    array set f_company_rcount {}

    variable f_company_type_id
    array unset f_company_type_id
    array set f_company_type_id {}

    variable f_company_departments
    array unset f_company_departments
    array set f_company_departments {}

    variable f_company_employees
    array unset f_company_employees
    array set f_company_employees {}

    variable i_employee_name
    array unset i_employee_name
    array set i_employee_name {}

    variable i_department_title
    array unset i_department_title
    array set i_department_title {}

    variable g_employee_next
    set g_employee_next 1
    variable g_department_next
    set g_department_next 1
    variable g_company_next
    set g_company_next 1
}
proc employee_keys {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return $names
}
proc employee_count {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return [ llength $names ]
}
proc employee_exists { id } {
    variable f_employee_rcount
    return [ info exists f_employee_rcount($id) ]
}
proc employee_insert { id name } {
    variable g_employee_next
    if { $id == {} } {
        set id $g_employee_next
    } else {
        if { [ employee_exists $id ] } {
            set class_name [ get_employee_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_employee_next } {
        set g_employee_next [ expr { $id + 1 } ]
    }
    variable i_employee_name
    set _key_ "$name"
    if { [ info exists i_employee_name($_key_) ] } {
        error "Fields 'name' are not unique for 'employee'."
    }
    variable f_employee_type_id
    set f_employee_type_id($id) "employee"
    variable f_employee_rcount
    set f_employee_rcount($id) 0
    variable f_employee_name
    set f_employee_name($id) $name
    variable i_employee_name
    set _key_ "$name"
    set i_employee_name($_key_) $id
    return $id
}
proc get_employee_type_id { id } {
    variable f_employee_type_id
    if { [ info exists f_employee_type_id($id) ] } {
        return $f_employee_type_id($id)
    } else {
        return {}
    }
}
proc employee_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    employee_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_employee_type_id
    unset f_employee_type_id($id)
}
proc find_employee_by_name { name } {
    variable i_employee_name
    set _key_ "$name"
    if { [ info exists i_employee_name($_key_) ] } {
        return $i_employee_name($_key_)
    } else {
        return {}
    }
}
proc get_employee_name { id } {
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        return $f_employee_name($id)
    } else {
        return {}
    }
}
proc set_employee_name { id name } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    set old [ get_employee_name $id ]
    if { $old == $name } {
        return
    }
    variable i_employee_name
    set _key_ "$name"
    if { [ info exists i_employee_name($_key_) ] } {
        error "Fields 'name' are not unique for 'employee'."
    }
    set _key_ "$old"
    unset i_employee_name($_key_)
    variable f_employee_name
    set f_employee_name($id) $name
    variable i_employee_name
    set _key_ "$name"
    set i_employee_name($_key_) $id
}
proc get_employee_departments { id } {
    variable f_employee_departments
    if { [ info exists f_employee_departments($id) ] } {
        return $f_employee_departments($id)
    } else {
        return {}
    }
}
proc employee_departments_add { id element } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    if { $element == {} } { return }
    if { ![ department_exists $element ] } {
        error "'department' with id '$element' does not exist."
    }
    variable f_department_employees
    if { [ info exists f_department_employees($element) ] } {
        set _col_ $f_department_employees($element)
    } else {
        set _col_ {}
    }
    lappend _col_ $id
    set f_department_employees($element) $_col_
    variable f_employee_departments
    if { [ info exists f_employee_departments($id) ] } {
        set _col_ $f_employee_departments($id)
    } else {
        set _col_ {}
    }
    lappend _col_ $element
    set f_employee_departments($id) $_col_
}
proc employee_departments_remove { id element } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    if { $element == {} } { return }
    if { ![ department_exists $element ] } {
        error "'department' with id '$element' does not exist."
    }
    variable f_department_employees
    if { [ info exists f_department_employees($element) ] } {
        set _col_ $f_department_employees($element)
        set _index_ [ lsearch $_col_ $id ]
        if { $_index_ != -1 } {
            set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
            set f_department_employees($element) $_col_2
        }
    }
    variable f_employee_departments
    if { [ info exists f_employee_departments($id) ] } {
        set _col_ $f_employee_departments($id)
        set _index_ [ lsearch $_col_ $element ]
        if { $_index_ != -1 } {
            set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
            set f_employee_departments($id) $_col_2
        }
    }
}
proc get_employee_company { id } {
    variable f_employee_company
    if { [ info exists f_employee_company($id) ] } {
        return $f_employee_company($id)
    } else {
        return {}
    }
}
proc set_employee_company { id company } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    set old [ get_employee_company $id ]
    if { $old == $company } {
        return
    }
    if { $company != {} && ![ company_exists $company ] } {
        error "'company' with id '$company' does not exist."
    }
    if { $old != {} } {
        variable f_company_employees
        if { [ info exists f_company_employees($old) ] } {
            set _col_ $f_company_employees($old)
            set _index_ [ lsearch $_col_ $id ]
            if { $_index_ != -1 } {
                set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                set f_company_employees($old) $_col_2
            }
        }
    }
    variable f_employee_company
    set f_employee_company($id) $company
    if { $company != {} } {
        variable f_company_employees
        if { [ info exists f_company_employees($company) ] } {
            set _col_ $f_company_employees($company)
        } else {
            set _col_ {}
        }
        lappend _col_ $id
        set f_company_employees($company) $_col_
    }
}
proc department_keys {  } {
    variable f_department_rcount
    set names [ array names f_department_rcount ]
    return $names
}
proc department_count {  } {
    variable f_department_rcount
    set names [ array names f_department_rcount ]
    return [ llength $names ]
}
proc department_exists { id } {
    variable f_department_rcount
    return [ info exists f_department_rcount($id) ]
}
proc department_insert { id title } {
    variable g_department_next
    if { $id == {} } {
        set id $g_department_next
    } else {
        if { [ department_exists $id ] } {
            set class_name [ get_department_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_department_next } {
        set g_department_next [ expr { $id + 1 } ]
    }
    variable i_department_title
    set _key_ "$title"
    if { [ info exists i_department_title($_key_) ] } {
        error "Fields 'title' are not unique for 'department'."
    }
    variable f_department_type_id
    set f_department_type_id($id) "department"
    variable f_department_rcount
    set f_department_rcount($id) 0
    variable f_department_title
    set f_department_title($id) $title
    variable i_department_title
    set _key_ "$title"
    set i_department_title($_key_) $id
    return $id
}
proc get_department_type_id { id } {
    variable f_department_type_id
    if { [ info exists f_department_type_id($id) ] } {
        return $f_department_type_id($id)
    } else {
        return {}
    }
}
proc department_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ department_exists $id ] } {
        error "'department' with id '$id' does not exist."
    }
    department_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_department_type_id
    unset f_department_type_id($id)
}
proc find_department_by_title { title } {
    variable i_department_title
    set _key_ "$title"
    if { [ info exists i_department_title($_key_) ] } {
        return $i_department_title($_key_)
    } else {
        return {}
    }
}
proc get_department_title { id } {
    variable f_department_title
    if { [ info exists f_department_title($id) ] } {
        return $f_department_title($id)
    } else {
        return {}
    }
}
proc set_department_title { id title } {
    if { ![ department_exists $id ] } {
        error "'department' with id '$id' does not exist."
    }
    set old [ get_department_title $id ]
    if { $old == $title } {
        return
    }
    variable i_department_title
    set _key_ "$title"
    if { [ info exists i_department_title($_key_) ] } {
        error "Fields 'title' are not unique for 'department'."
    }
    set _key_ "$old"
    unset i_department_title($_key_)
    variable f_department_title
    set f_department_title($id) $title
    variable i_department_title
    set _key_ "$title"
    set i_department_title($_key_) $id
}
proc get_department_employees { id } {
    variable f_department_employees
    if { [ info exists f_department_employees($id) ] } {
        return $f_department_employees($id)
    } else {
        return {}
    }
}
proc department_employees_add { id element } {
    if { ![ department_exists $id ] } {
        error "'department' with id '$id' does not exist."
    }
    if { $element == {} } { return }
    if { ![ employee_exists $element ] } {
        error "'employee' with id '$element' does not exist."
    }
    variable f_employee_departments
    if { [ info exists f_employee_departments($element) ] } {
        set _col_ $f_employee_departments($element)
    } else {
        set _col_ {}
    }
    lappend _col_ $id
    set f_employee_departments($element) $_col_
    variable f_department_employees
    if { [ info exists f_department_employees($id) ] } {
        set _col_ $f_department_employees($id)
    } else {
        set _col_ {}
    }
    lappend _col_ $element
    set f_department_employees($id) $_col_
}
proc department_employees_remove { id element } {
    if { ![ department_exists $id ] } {
        error "'department' with id '$id' does not exist."
    }
    if { $element == {} } { return }
    if { ![ employee_exists $element ] } {
        error "'employee' with id '$element' does not exist."
    }
    variable f_employee_departments
    if { [ info exists f_employee_departments($element) ] } {
        set _col_ $f_employee_departments($element)
        set _index_ [ lsearch $_col_ $id ]
        if { $_index_ != -1 } {
            set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
            set f_employee_departments($element) $_col_2
        }
    }
    variable f_department_employees
    if { [ info exists f_department_employees($id) ] } {
        set _col_ $f_department_employees($id)
        set _index_ [ lsearch $_col_ $element ]
        if { $_index_ != -1 } {
            set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
            set f_department_employees($id) $_col_2
        }
    }
}
proc get_department_company { id } {
    variable f_department_company
    if { [ info exists f_department_company($id) ] } {
        return $f_department_company($id)
    } else {
        return {}
    }
}
proc set_department_company { id company } {
    if { ![ department_exists $id ] } {
        error "'department' with id '$id' does not exist."
    }
    set old [ get_department_company $id ]
    if { $old == $company } {
        return
    }
    if { $company != {} && ![ company_exists $company ] } {
        error "'company' with id '$company' does not exist."
    }
    if { $old != {} } {
        variable f_company_departments
        if { [ info exists f_company_departments($old) ] } {
            set _col_ $f_company_departments($old)
            set _index_ [ lsearch $_col_ $id ]
            if { $_index_ != -1 } {
                set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                set f_company_departments($old) $_col_2
            }
        }
    }
    variable f_department_company
    set f_department_company($id) $company
    if { $company != {} } {
        variable f_company_departments
        if { [ info exists f_company_departments($company) ] } {
            set _col_ $f_company_departments($company)
        } else {
            set _col_ {}
        }
        lappend _col_ $id
        set f_company_departments($company) $_col_
    }
}
proc company_keys {  } {
    variable f_company_rcount
    set names [ array names f_company_rcount ]
    return $names
}
proc company_count {  } {
    variable f_company_rcount
    set names [ array names f_company_rcount ]
    return [ llength $names ]
}
proc company_exists { id } {
    variable f_company_rcount
    return [ info exists f_company_rcount($id) ]
}
proc company_insert { id } {
    variable g_company_next
    if { $id == {} } {
        set id $g_company_next
    } else {
        if { [ company_exists $id ] } {
            set class_name [ get_company_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_company_next } {
        set g_company_next [ expr { $id + 1 } ]
    }
    variable f_company_type_id
    set f_company_type_id($id) "company"
    variable f_company_rcount
    set f_company_rcount($id) 0
    return $id
}
proc get_company_type_id { id } {
    variable f_company_type_id
    if { [ info exists f_company_type_id($id) ] } {
        return $f_company_type_id($id)
    } else {
        return {}
    }
}
proc company_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ company_exists $id ] } {
        error "'company' with id '$id' does not exist."
    }
    company_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_company_type_id
    unset f_company_type_id($id)
}
proc get_company_departments { id } {
    variable f_company_departments
    if { [ info exists f_company_departments($id) ] } {
        return $f_company_departments($id)
    } else {
        return {}
    }
}
proc get_company_employees { id } {
    variable f_company_employees
    if { [ info exists f_company_employees($id) ] } {
        return $f_company_employees($id)
    } else {
        return {}
    }
}
######### Private #########
variable g_del_list
array set g_del_list {}
variable f_employee_rcount
array set f_employee_rcount {}
variable f_employee_type_id
array set f_employee_type_id {}
variable g_employee_next 1
variable f_employee_name
array set f_employee_name {}
variable f_employee_departments
array set f_employee_departments {}
variable f_employee_company
array set f_employee_company {}
variable f_department_rcount
array set f_department_rcount {}
variable f_department_type_id
array set f_department_type_id {}
variable g_department_next 1
variable f_department_title
array set f_department_title {}
variable f_department_employees
array set f_department_employees {}
variable f_department_company
array set f_department_company {}
variable f_company_rcount
array set f_company_rcount {}
variable f_company_type_id
array set f_company_type_id {}
variable g_company_next 1
variable f_company_departments
array set f_company_departments {}
variable f_company_employees
array set f_company_employees {}
variable i_employee_name
array set i_employee_name {}
variable i_department_title
array set i_department_title {}
proc employee_pre_delete { id } {
    set type [ get_employee_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc employee_pre_delete_middle { id } {
    employee_pre_delete_inner $id
}
proc employee_pre_delete_inner { id } {
}
proc employee_can_delete { id } {
}
proc employee_do_delete { id } {
    set departments [ get_employee_departments $id ]
    foreach that $departments {
        variable g_del_list
        set _type_ [ get_department_type_id $that ]
        set _key_ "$that,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_department_employees
            if { [ info exists f_department_employees($that) ] } {
                set _col_ $f_department_employees($that)
                set _index_ [ lsearch $_col_ $id ]
                if { $_index_ != -1 } {
                    set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                    set f_department_employees($that) $_col_2
                }
            }
        }
    }
    set company [ get_employee_company $id ]
    if { $company != {} } {
        variable g_del_list
        set _type_ [ get_company_type_id $company ]
        set _key_ "$company,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_company_employees
            if { [ info exists f_company_employees($company) ] } {
                set _col_ $f_company_employees($company)
                set _index_ [ lsearch $_col_ $id ]
                if { $_index_ != -1 } {
                    set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                    set f_company_employees($company) $_col_2
                }
            }
        }
    }
    set name [ get_employee_name $id ]
    variable i_employee_name
    set _key_ "$name"
    unset i_employee_name($_key_)
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        unset f_employee_name($id)
    }
    variable f_employee_departments
    if { [ info exists f_employee_departments($id) ] } {
        unset f_employee_departments($id)
    }
    variable f_employee_company
    if { [ info exists f_employee_company($id) ] } {
        unset f_employee_company($id)
    }
    variable f_employee_rcount
    unset f_employee_rcount($id)
}
proc department_pre_delete { id } {
    set type [ get_department_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc department_pre_delete_middle { id } {
    department_pre_delete_inner $id
}
proc department_pre_delete_inner { id } {
}
proc department_can_delete { id } {
}
proc department_do_delete { id } {
    set employees [ get_department_employees $id ]
    foreach that $employees {
        variable g_del_list
        set _type_ [ get_employee_type_id $that ]
        set _key_ "$that,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_employee_departments
            if { [ info exists f_employee_departments($that) ] } {
                set _col_ $f_employee_departments($that)
                set _index_ [ lsearch $_col_ $id ]
                if { $_index_ != -1 } {
                    set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                    set f_employee_departments($that) $_col_2
                }
            }
        }
    }
    set company [ get_department_company $id ]
    if { $company != {} } {
        variable g_del_list
        set _type_ [ get_company_type_id $company ]
        set _key_ "$company,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_company_departments
            if { [ info exists f_company_departments($company) ] } {
                set _col_ $f_company_departments($company)
                set _index_ [ lsearch $_col_ $id ]
                if { $_index_ != -1 } {
                    set _col_2 [ lreplace $_col_ $_index_ $_index_ ]
                    set f_company_departments($company) $_col_2
                }
            }
        }
    }
    set title [ get_department_title $id ]
    variable i_department_title
    set _key_ "$title"
    unset i_department_title($_key_)
    variable f_department_title
    if { [ info exists f_department_title($id) ] } {
        unset f_department_title($id)
    }
    variable f_department_employees
    if { [ info exists f_department_employees($id) ] } {
        unset f_department_employees($id)
    }
    variable f_department_company
    if { [ info exists f_department_company($id) ] } {
        unset f_department_company($id)
    }
    variable f_department_rcount
    unset f_department_rcount($id)
}
proc company_pre_delete { id } {
    set type [ get_company_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc company_pre_delete_middle { id } {
    company_pre_delete_inner $id
}
proc company_pre_delete_inner { id } {
    set departments [ get_company_departments $id ]
    foreach that $departments {
        department_pre_delete $that
    }
    set employees [ get_company_employees $id ]
    foreach that $employees {
        employee_pre_delete $that
    }
}
proc company_can_delete { id } {
}
proc company_do_delete { id } {
    variable f_company_departments
    if { [ info exists f_company_departments($id) ] } {
        unset f_company_departments($id)
    }
    variable f_company_employees
    if { [ info exists f_company_employees($id) ] } {
        unset f_company_employees($id)
    }
    variable f_company_rcount
    unset f_company_rcount($id)
}

proc equal { expected actual } {
    #item 18
    if { $expected != $actual } {
    	error "'equal' fails:\nExpected: $expected \nActual:   $actual"
    }
}

proc exception { expression } {
    #item 7
    if { ![ catch { uplevel $expression } ] } {
    	error "Error expected!"
    }
}

proc main { } {
    #item 19
    reset_db
    #item 108
    equal 0 [ employee_count ]
    equal 0 [ department_count ]
    #item 161
    set yellow_m [ department_insert "" "Yellow marketing" ]
    set grey_m [ department_insert "" "Grey marketing" ]
    #item 162
    set mark  [ employee_insert 10 "Mark" ]
    set john  [ employee_insert 20 "John" ]
    set scott [ employee_insert 30 "Scott" ]
    #item 188
    department_employees_add $yellow_m $mark
    #item 238
    department_employees_add $yellow_m {}
    #item 213
    exception { department_employees_add $yellow_m 800 }
    #item 212
    employee_departments_add $mark  $grey_m
    employee_departments_add $john  $grey_m
    employee_departments_add $scott $grey_m
    #item 189
    set grey_employees [ get_department_employees $grey_m ]
    set yellow_employees [ get_department_employees $yellow_m ]
    #item 190
    equal {10 20 30} [ lsort $grey_employees ]
    equal {10} [ lsort $yellow_employees ]
    #item 214
    equal [list $yellow_m $grey_m ] [ get_employee_departments $mark ]
    equal $grey_m [ get_employee_departments $john ]
    equal $grey_m [ get_employee_departments $scott ]
    #item 227
    set company [ company_insert 888 ]
    #item 228
    set_employee_company $mark  $company
    set_employee_company $john  $company
    set_employee_company $scott $company
    #item 229
    set_department_company $grey_m   $company
    set_department_company $yellow_m $company
    #item 230
    department_employees_remove $yellow_m $mark
    #item 231
    employee_departments_remove $mark  $grey_m
    employee_departments_remove $john  $grey_m
    employee_departments_remove $scott $grey_m
    #item 232
    equal {} [ get_department_employees $grey_m ]
    equal {} [ get_department_employees $yellow_m ]
    #item 233
    equal {} [ get_employee_departments $mark ]
    equal {} [ get_employee_departments $john ]
    equal {} [ get_employee_departments $scott ]
    #item 234
    department_employees_add $yellow_m $john
    #item 235
    employee_departments_add $mark  $grey_m
    employee_departments_add $john  $grey_m
    employee_departments_add $scott $grey_m
    #item 236
    equal [ list $mark $john $scott ] [ get_department_employees $grey_m ]
    set $john [ get_department_employees $yellow_m ]
    #item 237
    equal [list $yellow_m $grey_m ] [ get_employee_departments $john ]
    equal $grey_m [ get_employee_departments $mark ]
    equal $grey_m [ get_employee_departments $scott ]
    #item 239
    employee_delete $scott
    #item 240
    equal [ list $mark $john ] [ get_department_employees $grey_m ]
    #item 241
    department_delete $yellow_m
    #item 242
    equal $grey_m [ get_employee_departments $john ]
    #item 243
    company_delete $company
    #item 244
    equal 0 [ employee_count ]
    equal 0 [ department_count ]
}

proc not_equal { left right } {
    #item 31
    if { $left == $right } {
    	error "'not_equal' fails:\nLeft:    $left \nRight:   $right"
    }
}

main
