# Autogenerated with DRAKON Editor 1.21
######### Public #########
proc reset_db {  } {
    variable f_employee_rcount
    array unset f_employee_rcount
    array set f_employee_rcount {}

    variable f_employee_type_id
    array unset f_employee_type_id
    array set f_employee_type_id {}

    variable f_employee_name
    array unset f_employee_name
    array set f_employee_name {}

    variable f_employee_birthday
    array unset f_employee_birthday
    array set f_employee_birthday {}

    variable f_employee_department
    array unset f_employee_department
    array set f_employee_department {}

    variable f_department_rcount
    array unset f_department_rcount
    array set f_department_rcount {}

    variable f_department_type_id
    array unset f_department_type_id
    array set f_department_type_id {}

    variable f_department_title
    array unset f_department_title
    array set f_department_title {}

    variable i_employee_name_birthday
    array unset i_employee_name_birthday
    array set i_employee_name_birthday {}

    variable i_department_title
    array unset i_department_title
    array set i_department_title {}

    variable g_employee_next
    set g_employee_next 1
    variable g_department_next
    set g_department_next 1
}
proc employee_keys {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return $names
}
proc employee_count {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return [ llength $names ]
}
proc employee_exists { id } {
    variable f_employee_rcount
    return [ info exists f_employee_rcount($id) ]
}
proc employee_insert { id name birthday } {
    variable g_employee_next
    if { $id == {} } {
        set id $g_employee_next
    } else {
        if { [ employee_exists $id ] } {
            set class_name [ get_employee_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_employee_next } {
        set g_employee_next [ expr { $id + 1 } ]
    }
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        error "Fields 'name birthday' are not unique for 'employee'."
    }
    variable f_employee_type_id
    set f_employee_type_id($id) "employee"
    variable f_employee_rcount
    set f_employee_rcount($id) 0
    variable f_employee_name
    set f_employee_name($id) $name
    variable f_employee_birthday
    set f_employee_birthday($id) $birthday
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    set i_employee_name_birthday($_key_) $id
    return $id
}
proc get_employee_type_id { id } {
    variable f_employee_type_id
    if { [ info exists f_employee_type_id($id) ] } {
        return $f_employee_type_id($id)
    } else {
        return {}
    }
}
proc employee_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    employee_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_employee_type_id
    unset f_employee_type_id($id)
}
proc find_employee_by_name_birthday { name birthday } {
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        return $i_employee_name_birthday($_key_)
    } else {
        return {}
    }
}
proc get_employee_name { id } {
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        return $f_employee_name($id)
    } else {
        return {}
    }
}
proc set_employee_name { id name } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    set old [ get_employee_name $id ]
    if { $old == $name } {
        return
    }
    set birthday [ get_employee_birthday $id ]
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        error "Fields 'name birthday' are not unique for 'employee'."
    }
    set _key_ "$old,|,$birthday"
    unset i_employee_name_birthday($_key_)
    variable f_employee_name
    set f_employee_name($id) $name
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    set i_employee_name_birthday($_key_) $id
}
proc get_employee_birthday { id } {
    variable f_employee_birthday
    if { [ info exists f_employee_birthday($id) ] } {
        return $f_employee_birthday($id)
    } else {
        return {}
    }
}
proc set_employee_birthday { id birthday } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    set old [ get_employee_birthday $id ]
    if { $old == $birthday } {
        return
    }
    set name [ get_employee_name $id ]
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        error "Fields 'name birthday' are not unique for 'employee'."
    }
    set _key_ "$name,|,$old"
    unset i_employee_name_birthday($_key_)
    variable f_employee_birthday
    set f_employee_birthday($id) $birthday
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    set i_employee_name_birthday($_key_) $id
}
proc get_employee_department { id } {
    variable f_employee_department
    if { [ info exists f_employee_department($id) ] } {
        return $f_employee_department($id)
    } else {
        return {}
    }
}
proc set_employee_department { id department } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    set old [ get_employee_department $id ]
    if { $old == $department } {
        return
    }
    if { $department != {} && ![ department_exists $department ] } {
        error "'department' with id '$department' does not exist."
    }
    if { $old != {} } {
        variable f_department_rcount
        set _ref_count $f_department_rcount($old)
        incr _ref_count -1
        set f_department_rcount($old) $_ref_count
    }
    variable f_employee_department
    set f_employee_department($id) $department
    if { $department != {} } {
        variable f_department_rcount
        set _ref_count $f_department_rcount($department)
        incr _ref_count
        set f_department_rcount($department) $_ref_count
    }
}
proc department_keys {  } {
    variable f_department_rcount
    set names [ array names f_department_rcount ]
    return $names
}
proc department_count {  } {
    variable f_department_rcount
    set names [ array names f_department_rcount ]
    return [ llength $names ]
}
proc department_exists { id } {
    variable f_department_rcount
    return [ info exists f_department_rcount($id) ]
}
proc department_insert { id title } {
    variable g_department_next
    if { $id == {} } {
        set id $g_department_next
    } else {
        if { [ department_exists $id ] } {
            set class_name [ get_department_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_department_next } {
        set g_department_next [ expr { $id + 1 } ]
    }
    variable i_department_title
    set _key_ "$title"
    if { [ info exists i_department_title($_key_) ] } {
        error "Fields 'title' are not unique for 'department'."
    }
    variable f_department_type_id
    set f_department_type_id($id) "department"
    variable f_department_rcount
    set f_department_rcount($id) 0
    variable f_department_title
    set f_department_title($id) $title
    variable i_department_title
    set _key_ "$title"
    set i_department_title($_key_) $id
    return $id
}
proc get_department_type_id { id } {
    variable f_department_type_id
    if { [ info exists f_department_type_id($id) ] } {
        return $f_department_type_id($id)
    } else {
        return {}
    }
}
proc department_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ department_exists $id ] } {
        error "'department' with id '$id' does not exist."
    }
    department_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_department_type_id
    unset f_department_type_id($id)
}
proc find_department_by_title { title } {
    variable i_department_title
    set _key_ "$title"
    if { [ info exists i_department_title($_key_) ] } {
        return $i_department_title($_key_)
    } else {
        return {}
    }
}
proc get_department_title { id } {
    variable f_department_title
    if { [ info exists f_department_title($id) ] } {
        return $f_department_title($id)
    } else {
        return {}
    }
}
proc set_department_title { id title } {
    if { ![ department_exists $id ] } {
        error "'department' with id '$id' does not exist."
    }
    set old [ get_department_title $id ]
    if { $old == $title } {
        return
    }
    variable i_department_title
    set _key_ "$title"
    if { [ info exists i_department_title($_key_) ] } {
        error "Fields 'title' are not unique for 'department'."
    }
    set _key_ "$old"
    unset i_department_title($_key_)
    variable f_department_title
    set f_department_title($id) $title
    variable i_department_title
    set _key_ "$title"
    set i_department_title($_key_) $id
}
######### Private #########
variable g_del_list
array set g_del_list {}
variable f_employee_rcount
array set f_employee_rcount {}
variable f_employee_type_id
array set f_employee_type_id {}
variable g_employee_next 1
variable f_employee_name
array set f_employee_name {}
variable f_employee_birthday
array set f_employee_birthday {}
variable f_employee_department
array set f_employee_department {}
variable f_department_rcount
array set f_department_rcount {}
variable f_department_type_id
array set f_department_type_id {}
variable g_department_next 1
variable f_department_title
array set f_department_title {}
variable i_employee_name_birthday
array set i_employee_name_birthday {}
variable i_department_title
array set i_department_title {}
proc employee_pre_delete { id } {
    set type [ get_employee_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc employee_pre_delete_middle { id } {
    employee_pre_delete_inner $id
}
proc employee_pre_delete_inner { id } {
}
proc employee_can_delete { id } {
}
proc employee_do_delete { id } {
    set department [ get_employee_department $id ]
    if { $department != {} } {
        variable g_del_list
        set _type_ [ get_department_type_id $department ]
        set _key_ "$department,$_type_"
        if { ![ info exists g_del_list($_key_) ] } {
            variable f_department_rcount
            set _ref_count $f_department_rcount($department)
            incr _ref_count -1
            set f_department_rcount($department) $_ref_count
        }
    }
    set name [ get_employee_name $id ]
    set birthday [ get_employee_birthday $id ]
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    unset i_employee_name_birthday($_key_)
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        unset f_employee_name($id)
    }
    variable f_employee_birthday
    if { [ info exists f_employee_birthday($id) ] } {
        unset f_employee_birthday($id)
    }
    variable f_employee_department
    if { [ info exists f_employee_department($id) ] } {
        unset f_employee_department($id)
    }
    variable f_employee_rcount
    unset f_employee_rcount($id)
}
proc department_pre_delete { id } {
    set type [ get_department_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    variable f_department_rcount
    set _ref_count_ $f_department_rcount($id)
    if { $_ref_count_ > 0 } {
        set _type_id_ [ get_department_type_id $id ]
        error "'$_type_id_' with id '$id' is referenced by other record."
    }
    ${type}_pre_delete_middle $id
}
proc department_pre_delete_middle { id } {
    department_pre_delete_inner $id
}
proc department_pre_delete_inner { id } {
}
proc department_can_delete { id } {
}
proc department_do_delete { id } {
    set title [ get_department_title $id ]
    variable i_department_title
    set _key_ "$title"
    unset i_department_title($_key_)
    variable f_department_title
    if { [ info exists f_department_title($id) ] } {
        unset f_department_title($id)
    }
    variable f_department_rcount
    unset f_department_rcount($id)
}

proc equal { expected actual } {
    #item 18
    if { $expected != $actual } {
    	error "'equal' fails:\nExpected: $expected \nActual:   $actual"
    }
}

proc exception { expression } {
    #item 7
    if { ![ catch { uplevel $expression } ] } {
    	error "Error expected!"
    }
}

proc main { } {
    #item 19
    reset_db
    #item 108
    equal 0 [ employee_count ]
    equal 0 [ department_count ]
    #item 76
    set john [ employee_insert "" "John" 1978 ]
    set mark [ employee_insert "" "Mark" 1978 ]
    set john2 [ employee_insert "" "John" 1985 ]
    #item 75
    department_insert "" "Marketing"
    department_insert "" "Sales"
    department_insert "" "Logistics"
    
    set marketing [ find_department_by_title "Marketing" ]
    set sales     [ find_department_by_title "Sales" ]
    set logistics [ find_department_by_title "Logistics" ]
    #item 112
    equal "" [ get_employee_department $john ]
    equal "" [ get_employee_department $john2 ]
    equal "" [ get_employee_department $mark ]
    #item 137
    set_employee_department $john ""
    set_employee_department $john2 ""
    set_employee_department $mark ""
    #item 136
    equal "" [ get_employee_department $john ]
    equal "" [ get_employee_department $john2 ]
    equal "" [ get_employee_department $mark ]
    #item 114
    exception {
     set_employee_department $john 1000
    }
    #item 138
    set_employee_department $john $marketing
    set_employee_department $john2 $sales
    set_employee_department $mark $marketing
    #item 139
    equal $marketing [ get_employee_department $john ]
    equal $sales [ get_employee_department $john2 ]
    equal $marketing [ get_employee_department $mark ]
    #item 141
    set_employee_department $john $marketing
    set_employee_department $john2 $logistics
    set_employee_department $mark {}
    #item 142
    equal $marketing [ get_employee_department $john ]
    equal $logistics [ get_employee_department $john2 ]
    equal {} [ get_employee_department $mark ]
    #item 143
    department_delete $sales
    equal {} [ find_department_by_title "Sales" ]
    #item 144
    exception { department_delete $marketing }
    exception { department_delete $logistics }
    #item 100
    employee_delete $john
    department_delete $marketing
    #item 101
    set_employee_department $john2 {}
    department_delete $logistics
    #item 145
    equal 2 [ employee_count ]
    equal 0 [ department_count ]
}

proc not_equal { left right } {
    #item 31
    if { $left == $right } {
    	error "'not_equal' fails:\nLeft:    $left \nRight:   $right"
    }
}

main
