# Autogenerated with DRAKON Editor 1.21
######### Public #########
proc reset_db {  } {
    variable f_employee_rcount
    array unset f_employee_rcount
    array set f_employee_rcount {}

    variable f_employee_type_id
    array unset f_employee_type_id
    array set f_employee_type_id {}

    variable f_employee_name
    array unset f_employee_name
    array set f_employee_name {}

    variable f_employee_birthday
    array unset f_employee_birthday
    array set f_employee_birthday {}

    variable i_employee_name_birthday
    array unset i_employee_name_birthday
    array set i_employee_name_birthday {}

    variable g_employee_next
    set g_employee_next 1
}
proc employee_keys {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return $names
}
proc employee_count {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return [ llength $names ]
}
proc employee_exists { id } {
    variable f_employee_rcount
    return [ info exists f_employee_rcount($id) ]
}
proc employee_insert { id name birthday } {
    variable g_employee_next
    if { $id == {} } {
        set id $g_employee_next
    } else {
        if { [ employee_exists $id ] } {
            set class_name [ get_employee_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_employee_next } {
        set g_employee_next [ expr { $id + 1 } ]
    }
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        error "Fields 'name birthday' are not unique for 'employee'."
    }
    variable f_employee_type_id
    set f_employee_type_id($id) "employee"
    variable f_employee_rcount
    set f_employee_rcount($id) 0
    variable f_employee_name
    set f_employee_name($id) $name
    variable f_employee_birthday
    set f_employee_birthday($id) $birthday
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    set i_employee_name_birthday($_key_) $id
    return $id
}
proc get_employee_type_id { id } {
    variable f_employee_type_id
    if { [ info exists f_employee_type_id($id) ] } {
        return $f_employee_type_id($id)
    } else {
        return {}
    }
}
proc employee_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    employee_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_employee_type_id
    unset f_employee_type_id($id)
}
proc find_employee_by_name_birthday { name birthday } {
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        return $i_employee_name_birthday($_key_)
    } else {
        return {}
    }
}
proc get_employee_name { id } {
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        return $f_employee_name($id)
    } else {
        return {}
    }
}
proc set_employee_name { id name } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    set old [ get_employee_name $id ]
    if { $old == $name } {
        return
    }
    set birthday [ get_employee_birthday $id ]
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        error "Fields 'name birthday' are not unique for 'employee'."
    }
    set _key_ "$old,|,$birthday"
    unset i_employee_name_birthday($_key_)
    variable f_employee_name
    set f_employee_name($id) $name
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    set i_employee_name_birthday($_key_) $id
}
proc get_employee_birthday { id } {
    variable f_employee_birthday
    if { [ info exists f_employee_birthday($id) ] } {
        return $f_employee_birthday($id)
    } else {
        return {}
    }
}
proc set_employee_birthday { id birthday } {
    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    set old [ get_employee_birthday $id ]
    if { $old == $birthday } {
        return
    }
    set name [ get_employee_name $id ]
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    if { [ info exists i_employee_name_birthday($_key_) ] } {
        error "Fields 'name birthday' are not unique for 'employee'."
    }
    set _key_ "$name,|,$old"
    unset i_employee_name_birthday($_key_)
    variable f_employee_birthday
    set f_employee_birthday($id) $birthday
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    set i_employee_name_birthday($_key_) $id
}
######### Private #########
variable g_del_list
array set g_del_list {}
variable f_employee_rcount
array set f_employee_rcount {}
variable f_employee_type_id
array set f_employee_type_id {}
variable g_employee_next 1
variable f_employee_name
array set f_employee_name {}
variable f_employee_birthday
array set f_employee_birthday {}
variable i_employee_name_birthday
array set i_employee_name_birthday {}
proc employee_pre_delete { id } {
    set type [ get_employee_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc employee_pre_delete_middle { id } {
    employee_pre_delete_inner $id
}
proc employee_pre_delete_inner { id } {
}
proc employee_can_delete { id } {
}
proc employee_do_delete { id } {
    set name [ get_employee_name $id ]
    set birthday [ get_employee_birthday $id ]
    variable i_employee_name_birthday
    set _key_ "$name,|,$birthday"
    unset i_employee_name_birthday($_key_)
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        unset f_employee_name($id)
    }
    variable f_employee_birthday
    if { [ info exists f_employee_birthday($id) ] } {
        unset f_employee_birthday($id)
    }
    variable f_employee_rcount
    unset f_employee_rcount($id)
}

proc equal { expected actual } {
    #item 18
    if { $expected != $actual } {
    	error "'equal' fails:\nExpected: $expected \nActual:   $actual"
    }
}

proc exception { expression } {
    #item 7
    if { ![ catch { uplevel $expression } ] } {
    	error "Error expected!"
    }
}

proc main { } {
    #item 19
    reset_db
    #item 35
    equal "" [ find_employee_by_name_birthday "John" 1978 ]
    equal "" [ find_employee_by_name_birthday "John" 1980 ]
    equal "" [ find_employee_by_name_birthday "Mark" 1965 ]
    #item 108
    equal 0 [ employee_count ]
    #item 76
    set john [ employee_insert 400 "John" 1978 ]
    #item 77
    equal 400 $john
    #item 75
    set mark [ employee_insert "" "Mark" 1965 ]
    set john2 [ employee_insert "" "John" 1980 ]
    #item 112
    equal $john [ find_employee_by_name_birthday "John" 1978 ]
    equal $john2 [ find_employee_by_name_birthday "John" 1980 ]
    equal $mark [ find_employee_by_name_birthday "Mark" 1965 ]
    #item 114
    exception {
     employee_insert "" "Mark" 1965
    }
    #item 69
    equal "John" [ get_employee_name $john ]
    equal "John" [ get_employee_name $john2 ]
    equal "Mark" [ get_employee_name $mark ]
    equal 1978 [ get_employee_birthday $john ]
    #item 122
    exception {
      set_employee_birthday $john 1980
    }
    #item 124
    set_employee_name $mark "John"
    #item 129
    equal $john [ find_employee_by_name_birthday "John" 1978 ]
    equal $john2 [ find_employee_by_name_birthday "John" 1980 ]
    equal $mark [ find_employee_by_name_birthday "John" 1965 ]
    #item 125
    equal "" [ find_employee_by_name_birthday "Mark" 1965 ]
    #item 127
    equal "John" [ get_employee_name $john ]
    equal "John" [ get_employee_name $mark ]
    #item 99
    employee_delete $john
    employee_delete $john2
    #item 100
    employee_delete $mark
    #item 101
    equal 0 [ employee_exists $john ]
    equal 0 [ employee_exists $john2 ]
    equal 0 [ employee_exists $mark ]
    #item 131
    equal "" [ find_employee_by_name_birthday "John" 1978 ]
    equal "" [ find_employee_by_name_birthday "John" 1980 ]
    equal "" [ find_employee_by_name_birthday "John" 1965 ]
}

proc not_equal { left right } {
    #item 31
    if { $left == $right } {
    	error "'not_equal' fails:\nLeft:    $left \nRight:   $right"
    }
}

main
