# Autogenerated with DRAKON Editor 1.21
######### Public #########
proc reset_db {  } {
    variable f_employee_rcount
    array unset f_employee_rcount
    array set f_employee_rcount {}

    variable f_employee_type_id
    array unset f_employee_type_id
    array set f_employee_type_id {}

    variable f_employee_name
    array unset f_employee_name
    array set f_employee_name {}

    variable g_employee_next
    set g_employee_next 1
}
proc employee_keys {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return $names
}
proc employee_count {  } {
    variable f_employee_rcount
    set names [ array names f_employee_rcount ]
    return [ llength $names ]
}
proc employee_exists { id } {
    variable f_employee_rcount
    return [ info exists f_employee_rcount($id) ]
}
proc employee_insert { id } {
    variable g_employee_next
    if { $id == {} } {
        set id $g_employee_next
    } else {
        if { [ employee_exists $id ] } {
            set class_name [ get_employee_type_id $id ]
            error "'$class_name' with id $id already exists."
        }
    }
    if { $id >= $g_employee_next } {
        set g_employee_next [ expr { $id + 1 } ]
    }
    variable f_employee_type_id
    set f_employee_type_id($id) "employee"
    variable f_employee_rcount
    set f_employee_rcount($id) 0
    return $id
}
proc get_employee_type_id { id } {
    variable f_employee_type_id
    if { [ info exists f_employee_type_id($id) ] } {
        return $f_employee_type_id($id)
    } else {
        return {}
    }
}
proc employee_delete { id } {
    variable g_del_list
    array unset g_del_list
    array set g_del_list {}

    if { ![ employee_exists $id ] } {
        error "'employee' with id '$id' does not exist."
    }
    employee_pre_delete $id
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_can_delete"
        $proc_name $pk
    }
    foreach item [ array names g_del_list ] {
        lassign [ split $item "," ] pk type
        set proc_name "${type}_do_delete"
        $proc_name $pk
    }
    variable f_employee_type_id
    unset f_employee_type_id($id)
}
proc get_employee_name { id } {
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        return $f_employee_name($id)
    } else {
        return {}
    }
}
proc set_employee_name { id name } {
    variable f_employee_name
    set f_employee_name($id) $name
}
######### Private #########
variable g_del_list
array set g_del_list {}
variable f_employee_rcount
array set f_employee_rcount {}
variable f_employee_type_id
array set f_employee_type_id {}
variable g_employee_next 1
variable f_employee_name
array set f_employee_name {}
proc employee_pre_delete { id } {
    set type [ get_employee_type_id $id ]
    variable g_del_list
    set key "$id,$type"
    if { [ info exists g_del_list($key) ] } {
        return
    } else {
        set g_del_list($key) 1
    }
    ${type}_pre_delete_middle $id
}
proc employee_pre_delete_middle { id } {
    employee_pre_delete_inner $id
}
proc employee_pre_delete_inner { id } {
}
proc employee_can_delete { id } {
}
proc employee_do_delete { id } {
    variable f_employee_name
    if { [ info exists f_employee_name($id) ] } {
        unset f_employee_name($id)
    }
    variable f_employee_rcount
    unset f_employee_rcount($id)
}

proc equal { expected actual } {
    #item 18
    if { $expected != $actual } {
    	error "'equal' fails:\nExpected: $expected \nActual:   $actual"
    }
}

proc exception { expression message } {
    #item 7
    if { ![ catch { uplevel $expression } ] } {
    	error $message
    }
}

proc main { } {
    #item 19
    reset_db
    #item 35
    equal 0 [ employee_exists 400 ]
    #item 108
    equal 0 [ employee_count ]
    #item 76
    set john [ employee_insert 400 ]
    #item 77
    equal 400 $john
    #item 78
    equal 1 [ employee_exists 400 ]
    #item 75
    set mark [ employee_insert "" ]
    #item 83
    not_equal $mark $john
    #item 69
    equal "" [ get_employee_name $john ]
    equal "" [ get_employee_name $mark ]
    #item 67
    set_employee_name $john "John"
    #item 68
    set_employee_name $mark "Mark"
    #item 70
    equal "John" [ get_employee_name $john ]
    #item 71
    equal "Mark" [ get_employee_name $mark ]
    #item 92
    set names {}
    #item 89
    set ids [ employee_keys ]
    #item 900001
    set _col90 $ids
    set _len90 [ llength $_col90 ]
    set _ind90 0
    while { 1 } {
        #item 900002
        if {$_ind90 < $_len90} {
            
        } else {
            break
        }
        #item 900004
        set id [ lindex $_col90 $_ind90 ]
        #item 93
        set name [ get_employee_name $id ]
        #item 94
        lappend names $name
        #item 900003
        incr _ind90
    }
    #item 95
    equal {John Mark} [ lsort $names ]
    #item 102
    equal 2 [ employee_count ]
    #item 99
    employee_delete $john
    #item 100
    employee_delete $mark
    #item 101
    equal 0 [ employee_exists $john ]
    equal 0 [ employee_exists $mark ]
    #item 103
    equal 0 [ employee_count ]
}

proc not_equal { left right } {
    #item 31
    if { $left == $right } {
    	error "'not_equal' fails:\nLeft:    $left \nRight:   $right"
    }
}

main
