// Autogenerated with DRAKON Editor 1.21
using System;
using System.Linq;
using System.Collections.Generic;
using System.Collections.ObjectModel;

class Bar {
	public delegate void AnyCode();
    public interface IBaseRecord
    {
        int Id { get; }
    }
    private interface IDelRecord
    {
        void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master);
        void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList);
        void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList);
    }
    public interface ICreature : IBaseRecord {
        int Dna { get; }
    }
    public interface IHuman : ICreature {
        string Name { get; }
    }
    public interface IEmployee : IHuman {
        double Salary { get; set; }
    }
    public interface IManager : IHuman {
        Int64 Bonus { get; set; }
    }
    private int _next_creature = 1;
    private readonly Dictionary<int, Creature> _creature_pk = new Dictionary<int, Creature>();
    private readonly Dictionary<int, Human> _human_pk = new Dictionary<int, Human>();
    private readonly Dictionary<int, Employee> _employee_pk = new Dictionary<int, Employee>();
    private readonly Dictionary<int, Manager> _manager_pk = new Dictionary<int, Manager>();
    private class Human_Name_Comparer : IEqualityComparer<Human> {
        public bool Equals(Human x, Human y) {
            if (!Object.Equals(x._name, y._name)) return false;
            return true;
        }
        public int GetHashCode(Human obj) {
            int code = ((obj._name == null) ? 0 : obj._name.GetHashCode());
            return code;
        }
    }
    private readonly Dictionary<Human, Human> _human_Name = new Dictionary<Human, Human>(new Human_Name_Comparer());
    private class Creature_Dna_Comparer : IEqualityComparer<Creature> {
        public bool Equals(Creature x, Creature y) {
            if (x._dna != y._dna) return false;
            return true;
        }
        public int GetHashCode(Creature obj) {
            int code = obj._dna.GetHashCode();;
            return code;
        }
    }
    private readonly Dictionary<Creature, Creature> _creature_Dna = new Dictionary<Creature, Creature>(new Creature_Dna_Comparer());
    private class Creature : ICreature, IDelRecord {
        public readonly int _id;
        public int Id { get { return _id; } }
        public Creature(int id) {
            _id = id;
        }
        public int _dna;
        public int Dna {
            get { return _dna; }
        }
        public virtual void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public virtual void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._creature_Dna.Remove(this);
            db._creature_pk.Remove(_id);
        }
        public virtual void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public virtual void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
    }
    private readonly Creature _creature_Key = new Creature(0);
    private class Human : Creature, IHuman, IDelRecord {
        public Human(int id) : base(id) {
        }
        public string _name;
        public string Name {
            get { return _name; }
        }
        public override void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public override void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._human_Name.Remove(this);
            db._creature_Dna.Remove(this);
            db._human_pk.Remove(_id);
            db._creature_pk.Remove(_id);
        }
        public override void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public override void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            base.PreDeleteInner(deletionList);
        }
    }
    private readonly Human _human_Key = new Human(0);
    private class Employee : Human, IEmployee, IDelRecord {
        public Employee(int id) : base(id) {
        }
        public double _salary;
        public double Salary {
            get { return _salary; }
            set { _salary = value; }
        }
        public override void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public override void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._human_Name.Remove(this);
            db._creature_Dna.Remove(this);
            db._employee_pk.Remove(_id);
            db._human_pk.Remove(_id);
            db._creature_pk.Remove(_id);
        }
        public override void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public override void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            base.PreDeleteInner(deletionList);
        }
    }
    private class Manager : Human, IManager, IDelRecord {
        public Manager(int id) : base(id) {
        }
        public Int64 _bonus;
        public Int64 Bonus {
            get { return _bonus; }
            set { _bonus = value; }
        }
        public override void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public override void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._human_Name.Remove(this);
            db._creature_Dna.Remove(this);
            db._manager_pk.Remove(_id);
            db._human_pk.Remove(_id);
            db._creature_pk.Remove(_id);
        }
        public override void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public override void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            base.PreDeleteInner(deletionList);
        }
    }
    public ICreature InsertCreature(int id, int dna) {
        if ( id == 0 ) {
            id = _next_creature;
        } else {
            if (_creature_pk.ContainsKey(id)) {
                string className = _creature_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_creature ) {
            _next_creature = id + 1;
        }
        _creature_Key._dna = dna;
        if ( _creature_Dna.ContainsKey(_creature_Key)) {
            throw new ArgumentException(
              "Fields 'Dna' are not unique for 'Employee'.");
        }
        var _record_ = new Creature(id);
        _record_._dna = dna;
        _creature_pk[id] = _record_;
        _creature_Dna[_record_] = _record_;
        return _record_;
    }
    public ICreature GetCreature(int id) {
        Creature _record_;
        if (!_creature_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int CreatureCount() {
        return _creature_pk.Count;
    }
    public IEnumerable<ICreature> EachCreature() {
        foreach (KeyValuePair<int, Creature> record in _creature_pk) {
            yield return record.Value;
        }
    }
    public void DeleteCreature(ICreature record) {
        if (record == null) return;
        Creature _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_creature_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Creature' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public ICreature FindCreatureByDna(int dna) {
        Creature _record_;
        _creature_Key._dna = dna;
        if (_creature_Dna.TryGetValue(_creature_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetCreatureDna(ICreature record, int newValue) {
        Creature _record_;
        if ( !_creature_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Creature' with id '{0}' does not exist.",
                record.Id));
        }
        if (_record_._dna == newValue) {
            return;
        }
        _creature_Key._dna = newValue;
        if ( _creature_Dna.ContainsKey(_creature_Key)) {
            throw new ArgumentException(
              "Fields 'Dna' are not unique for 'Employee'.");
        }
        _creature_Dna.Remove(_record_);
        _record_._dna = newValue;
        _creature_Dna[_record_] = _record_;
    }
    public IHuman InsertHuman(int id, int dna, string name) {
        if ( id == 0 ) {
            id = _next_creature;
        } else {
            if (_creature_pk.ContainsKey(id)) {
                string className = _creature_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_creature ) {
            _next_creature = id + 1;
        }
        _human_Key._name = name;
        if ( _human_Name.ContainsKey(_human_Key)) {
            throw new ArgumentException(
              "Fields 'Name' are not unique for 'Human'.");
        }
        _human_Key._name = name;
        if ( _human_Name.ContainsKey(_human_Key)) {
            throw new ArgumentException(
              "Fields 'Name' are not unique for 'Human'.");
        }
        var _record_ = new Human(id);
        _record_._dna = dna;
        _record_._name = name;
        _creature_pk[id] = _record_;
        _human_pk[id] = _record_;
        _creature_Dna[_record_] = _record_;
        _human_Name[_record_] = _record_;
        return _record_;
    }
    public IHuman GetHuman(int id) {
        Human _record_;
        if (!_human_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int HumanCount() {
        return _human_pk.Count;
    }
    public IEnumerable<IHuman> EachHuman() {
        foreach (KeyValuePair<int, Human> record in _human_pk) {
            yield return record.Value;
        }
    }
    public void DeleteHuman(IHuman record) {
        if (record == null) return;
        Human _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_human_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Human' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IHuman FindHumanByName(string name) {
        Human _record_;
        _human_Key._name = name;
        if (_human_Name.TryGetValue(_human_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetHumanName(IHuman record, string newValue) {
        Human _record_;
        if ( !_human_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Human' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._name, newValue)) {
            return;
        }
        _human_Key._name = newValue;
        if ( _human_Name.ContainsKey(_human_Key)) {
            throw new ArgumentException(
              "Fields 'Name' are not unique for 'Human'.");
        }
        _human_Name.Remove(_record_);
        _record_._name = newValue;
        _human_Name[_record_] = _record_;
    }
    public IEmployee InsertEmployee(int id, int dna, string name) {
        if ( id == 0 ) {
            id = _next_creature;
        } else {
            if (_creature_pk.ContainsKey(id)) {
                string className = _creature_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_creature ) {
            _next_creature = id + 1;
        }
        var _record_ = new Employee(id);
        _record_._dna = dna;
        _record_._name = name;
        _creature_pk[id] = _record_;
        _human_pk[id] = _record_;
        _employee_pk[id] = _record_;
        _creature_Dna[_record_] = _record_;
        _human_Name[_record_] = _record_;
        return _record_;
    }
    public IEmployee GetEmployee(int id) {
        Employee _record_;
        if (!_employee_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int EmployeeCount() {
        return _employee_pk.Count;
    }
    public IEnumerable<IEmployee> EachEmployee() {
        foreach (KeyValuePair<int, Employee> record in _employee_pk) {
            yield return record.Value;
        }
    }
    public void DeleteEmployee(IEmployee record) {
        if (record == null) return;
        Employee _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IManager InsertManager(int id, int dna, string name) {
        if ( id == 0 ) {
            id = _next_creature;
        } else {
            if (_creature_pk.ContainsKey(id)) {
                string className = _creature_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_creature ) {
            _next_creature = id + 1;
        }
        var _record_ = new Manager(id);
        _record_._dna = dna;
        _record_._name = name;
        _creature_pk[id] = _record_;
        _human_pk[id] = _record_;
        _manager_pk[id] = _record_;
        _creature_Dna[_record_] = _record_;
        _human_Name[_record_] = _record_;
        return _record_;
    }
    public IManager GetManager(int id) {
        Manager _record_;
        if (!_manager_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int ManagerCount() {
        return _manager_pk.Count;
    }
    public IEnumerable<IManager> EachManager() {
        foreach (KeyValuePair<int, Manager> record in _manager_pk) {
            yield return record.Value;
        }
    }
    public void DeleteManager(IManager record) {
        if (record == null) return;
        Manager _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_manager_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Manager' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }

    public static void Equal(object expected, object actual) {
        // item 296
        //PutObj(expected);
        //PutObj(actual);
        //Put("\n");
        // item 293
        if (Object.Equals(expected, actual)) {
            
        } else {
            // item 275
            if (expected is System.Collections.IEnumerable) {
                // item 281
                if (actual is System.Collections.IEnumerable) {
                    // item 284
                    var expectedEn = (System.Collections.IEnumerable)expected;
                    var actualEn = (System.Collections.IEnumerable)actual;
                    // item 295
                    List<object> exList = expectedEn.Cast<object>().ToList();
                    List<object> acList = actualEn.Cast<object>().ToList();
                    // item 285
                    if (exList.Count == acList.Count) {
                        // item 2880001
                        int i = 0;
                        while (true) {
                            // item 2880002
                            if (i < exList.Count) {
                                
                            } else {
                                break;
                            }
                            // item 290
                            Equal(exList[i], acList[i]);
                            // item 2880003
                            i++;
                        }
                    } else {
                        // item 297
                        string message = 
                        String.Format("Collections have different sizes: expected={0}, actual={1}", 
                        	exList.Count, acList.Count);
                        // item 287
                        throw new Exception(message);
                    }
                } else {
                    // item 283
                    throw new Exception("Both should be IEnumerable");
                }
            } else {
                // item 278
                if (actual is System.Collections.IEnumerable) {
                    // item 279
                    throw new Exception("Both should be IEnumerable");
                } else {
                    // item 291
                    throw new Exception("Objects are not equal.");
                }
            }
        }
    }

    public static void ExpectException(AnyCode code) {
        // item 312
        bool caught = false;
        try {
            code();
        }
        catch {
            caught = true;
        }
        // item 313
        if (caught) {
            
        } else {
            // item 316
            throw new Exception("Exception expected but not thrown.");
        }
    }

    public static void Main() {
        // item 336
        Bar db = new Bar();
        // item 257
        Bar.ICreature gandalf = db.InsertManager(0, 10101, "Gandalf");
        Bar.ICreature bilbo = db.InsertEmployee(0, 10102, "Bilbo");
        Bar.ICreature fedor = db.InsertEmployee(0, 10103, "Fedor");
        // item 269
        Equal(true, gandalf is IManager);
        Equal(true, bilbo is IEmployee);
        Equal(true, fedor is IEmployee);
        // item 258
        Equal(bilbo, db.GetEmployee(bilbo.Id));
        Equal(bilbo, db.GetHuman(bilbo.Id));
        Equal(bilbo, db.GetCreature(bilbo.Id));
        Equal(null,  db.GetManager(bilbo.Id));
        // item 259
        Equal(fedor, db.GetEmployee(fedor.Id));
        Equal(fedor, db.GetHuman(fedor.Id));
        Equal(fedor, db.GetCreature(fedor.Id));
        Equal(null, db.GetManager(fedor.Id));
        // item 260
        Equal(null, db.GetEmployee(gandalf.Id));
        Equal(gandalf, db.GetHuman(gandalf.Id));
        Equal(gandalf, db.GetCreature(gandalf.Id));
        Equal(gandalf, db.GetManager(gandalf.Id));
        // item 265
        Equal(new ICreature[] {gandalf, bilbo, fedor},
         Sort(db.EachCreature()));
        // item 266
        Equal(new ICreature[] {gandalf, bilbo, fedor},
         Sort(db.EachHuman()));
        // item 267
        Equal(new ICreature[] {bilbo, fedor},
         Sort(db.EachEmployee()));
        // item 268
        Equal(new ICreature[] {gandalf},
         Sort(db.EachManager()));
        // item 261
        db.DeleteHuman((IHuman)bilbo);
        // item 262
        Equal(null, db.GetEmployee(bilbo.Id));
        Equal(null, db.GetHuman(bilbo.Id));
        Equal(null, db.GetCreature(bilbo.Id));
        Equal(null, db.GetManager(bilbo.Id));
        // item 263
        Equal(fedor, db.GetEmployee(fedor.Id));
        Equal(fedor, db.GetHuman(fedor.Id));
        Equal(fedor, db.GetCreature(fedor.Id));
        Equal(null, db.GetManager(fedor.Id));
        // item 264
        Equal(null, db.GetEmployee(gandalf.Id));
        Equal(gandalf, db.GetHuman(gandalf.Id));
        Equal(gandalf, db.GetCreature(gandalf.Id));
        Equal(gandalf, db.GetManager(gandalf.Id));
    }

    public static void NotEqual(object left, object right) {
        // item 303
        if (Object.Equals(left, right)) {
            // item 306
            throw new Exception("Objects are equal.");
        } else {
            
        }
    }

    public static void Put(string format, params object[] args) {
        // item 322
        System.Console.WriteLine(format, args);
    }

    public static void PutObj(object obj) {
        // item 328
        IBaseRecord rec = obj as IBaseRecord;
        // item 330
        if (rec == null) {
            // item 333
            Put("{0}", obj);
        } else {
            // item 329
            Console.WriteLine("{0} {1}", rec.GetType().Name, rec.Id);
        }
    }

    private static List<IBaseRecord> Sort<T>(IEnumerable<T> input) {
        // item 341
        List<IBaseRecord> records = (
        	from it in input
        	select (IBaseRecord)it).ToList();
        // item 344
        return (from rec in records
        	orderby rec.Id
        	select rec).ToList();
    }
}

