// Autogenerated with DRAKON Editor 1.21
using System;
using System.Linq;
using System.Collections.Generic;

class Bar {
	public delegate void AnyCode();
	
	private class FakeDepartment : IDepartment {
		public int Id { get; set; }
		public string Title { get; set; }
	}
    public interface IBaseRecord
    {
        int Id { get; }
    }
    private interface IDelRecord
    {
        void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master);
        void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList);
        void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList);
    }
    public interface IEmployee : IBaseRecord {
        string Name { get; }
        DateTime Birthday { get; }
        IDepartment Department { get; }
    }
    public interface IDepartment : IBaseRecord {
        string Title { get; }
    }
    private int _next_employee = 1;
    private readonly Dictionary<int, Employee> _employee_pk = new Dictionary<int, Employee>();
    private int _next_department = 1;
    private readonly Dictionary<int, Department> _department_pk = new Dictionary<int, Department>();
    private class Employee_Name_Birthday_Comparer : IEqualityComparer<Employee> {
        public bool Equals(Employee x, Employee y) {
            if (!Object.Equals(x._name, y._name)) return false;
            if (x._birthday != y._birthday) return false;
            return true;
        }
        public int GetHashCode(Employee obj) {
            int code = ((obj._name == null) ? 0 : obj._name.GetHashCode());
            code = (code * 397) ^ obj._birthday.GetHashCode();;
            return code;
        }
    }
    private readonly Dictionary<Employee, Employee> _employee_Name_Birthday = new Dictionary<Employee, Employee>(new Employee_Name_Birthday_Comparer());
    private class Department_Title_Comparer : IEqualityComparer<Department> {
        public bool Equals(Department x, Department y) {
            if (!Object.Equals(x._title, y._title)) return false;
            return true;
        }
        public int GetHashCode(Department obj) {
            int code = ((obj._title == null) ? 0 : obj._title.GetHashCode());
            return code;
        }
    }
    private readonly Dictionary<Department, Department> _department_Title = new Dictionary<Department, Department>(new Department_Title_Comparer());
    private class Employee : IEmployee, IDelRecord {
        public readonly int _id;
        public int Id { get { return _id; } }
        public Employee(int id) {
            _id = id;
        }
        public string _name;
        public string Name {
            get { return _name; }
        }
        public DateTime _birthday;
        public DateTime Birthday {
            get { return _birthday; }
        }
        public Department _department;
        public IDepartment Department {
            get { return _department; }
        }
        public virtual void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public virtual void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            if (_department != null ) {
                if ( !deletionList.Contains(_department)) {
                    _department._refCount--;
                }
            }
            db._employee_Name_Birthday.Remove(this);
            db._employee_pk.Remove(_id);
        }
        public virtual void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public virtual void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
    }
    private readonly Employee _employee_Key = new Employee(0);
    private class Department : IDepartment, IDelRecord {
        public readonly int _id;
        public int Id { get { return _id; } }
        public Department(int id) {
            _id = id;
        }
        public int _refCount = 0;
        public string _title;
        public string Title {
            get { return _title; }
        }
        public virtual void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public virtual void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._department_Title.Remove(this);
            db._department_pk.Remove(_id);
        }
        public virtual void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            if ( _refCount > 0 ) {
                string className = GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' is referenced by other record.",
                    className, _id));
            }
            PreDeleteInner(deletionList);
        }
        public virtual void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
    }
    private readonly Department _department_Key = new Department(0);
    public IEmployee InsertEmployee(int id, string name, DateTime birthday) {
        if ( id == 0 ) {
            id = _next_employee;
        } else {
            if (_employee_pk.ContainsKey(id)) {
                string className = _employee_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_employee ) {
            _next_employee = id + 1;
        }
        _employee_Key._name = name;
        _employee_Key._birthday = birthday;
        if ( _employee_Name_Birthday.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name Birthday' are not unique for 'Employee'.");
        }
        var _record_ = new Employee(id);
        _record_._name = name;
        _record_._birthday = birthday;
        _employee_pk[id] = _record_;
        _employee_Name_Birthday[_record_] = _record_;
        return _record_;
    }
    public IEmployee GetEmployee(int id) {
        Employee _record_;
        if (!_employee_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int EmployeeCount() {
        return _employee_pk.Count;
    }
    public IEnumerable<IEmployee> EachEmployee() {
        foreach (KeyValuePair<int, Employee> record in _employee_pk) {
            yield return record.Value;
        }
    }
    public void DeleteEmployee(IEmployee record) {
        if (record == null) return;
        Employee _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IEmployee FindEmployeeByNameBirthday(string name, DateTime birthday) {
        Employee _record_;
        _employee_Key._name = name;
        _employee_Key._birthday = birthday;
        if (_employee_Name_Birthday.TryGetValue(_employee_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetEmployeeName(IEmployee record, string newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._name, newValue)) {
            return;
        }
        _employee_Key._name = newValue;
        _employee_Key._birthday = _record_._birthday;
        if ( _employee_Name_Birthday.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name Birthday' are not unique for 'Employee'.");
        }
        _employee_Name_Birthday.Remove(_record_);
        _record_._name = newValue;
        _employee_Name_Birthday[_record_] = _record_;
    }
    public void SetEmployeeBirthday(IEmployee record, DateTime newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (_record_._birthday == newValue) {
            return;
        }
        _employee_Key._name = _record_._name;
        _employee_Key._birthday = newValue;
        if ( _employee_Name_Birthday.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name Birthday' are not unique for 'Employee'.");
        }
        _employee_Name_Birthday.Remove(_record_);
        _record_._birthday = newValue;
        _employee_Name_Birthday[_record_] = _record_;
    }
    public void SetEmployeeDepartment(IEmployee record, IDepartment newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._department, newValue)) {
            return;
        }
        Department _that_;
        if (newValue == null ) {
            _that_ = null;
        } else if (!_department_pk.TryGetValue(newValue.Id, out _that_)) {
            throw new ArgumentException(String.Format(
                "'Department' with id '{0}' does not exist.",
                newValue.Id));
        }
        if (_record_._department != null ) {
            _record_._department._refCount--;
        }
        _record_._department = _that_;
        if (_record_._department != null ) {
            _record_._department._refCount++;
        }
    }
    public IDepartment InsertDepartment(int id, string title) {
        if ( id == 0 ) {
            id = _next_department;
        } else {
            if (_department_pk.ContainsKey(id)) {
                string className = _department_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_department ) {
            _next_department = id + 1;
        }
        _department_Key._title = title;
        if ( _department_Title.ContainsKey(_department_Key)) {
            throw new ArgumentException(
              "Fields 'Title' are not unique for 'Department'.");
        }
        var _record_ = new Department(id);
        _record_._title = title;
        _department_pk[id] = _record_;
        _department_Title[_record_] = _record_;
        return _record_;
    }
    public IDepartment GetDepartment(int id) {
        Department _record_;
        if (!_department_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int DepartmentCount() {
        return _department_pk.Count;
    }
    public IEnumerable<IDepartment> EachDepartment() {
        foreach (KeyValuePair<int, Department> record in _department_pk) {
            yield return record.Value;
        }
    }
    public void DeleteDepartment(IDepartment record) {
        if (record == null) return;
        Department _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_department_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Department' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IDepartment FindDepartmentByTitle(string title) {
        Department _record_;
        _department_Key._title = title;
        if (_department_Title.TryGetValue(_department_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetDepartmentTitle(IDepartment record, string newValue) {
        Department _record_;
        if ( !_department_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Department' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._title, newValue)) {
            return;
        }
        _department_Key._title = newValue;
        if ( _department_Title.ContainsKey(_department_Key)) {
            throw new ArgumentException(
              "Fields 'Title' are not unique for 'Department'.");
        }
        _department_Title.Remove(_record_);
        _record_._title = newValue;
        _department_Title[_record_] = _record_;
    }

    public static void Equal(object expected, object actual) {
        // item 183
        if (Object.Equals(expected, actual)) {
            
        } else {
            // item 165
            if (expected is System.Collections.IEnumerable) {
                // item 171
                if (actual is System.Collections.IEnumerable) {
                    // item 174
                    var expectedEn = (System.Collections.IEnumerable)expected;
                    var actualEn = (System.Collections.IEnumerable)actual;
                    // item 185
                    List<object> exList = expectedEn.Cast<object>().ToList();
                    List<object> acList = actualEn.Cast<object>().ToList();
                    // item 175
                    if (exList.Count == acList.Count) {
                        // item 1780001
                        int i = 0;
                        while (true) {
                            // item 1780002
                            if (i < exList.Count) {
                                
                            } else {
                                break;
                            }
                            // item 180
                            Equal(exList[i], acList[i]);
                            // item 1780003
                            i++;
                        }
                    } else {
                        // item 177
                        throw new Exception("Collections have different sizes");
                    }
                } else {
                    // item 173
                    throw new Exception("Both should be IEnumerable");
                }
            } else {
                // item 168
                if (actual is System.Collections.IEnumerable) {
                    // item 169
                    throw new Exception("Both should be IEnumerable");
                } else {
                    // item 181
                    throw new Exception("Objects are not equal.");
                }
            }
        }
    }

    public static void ExpectException(AnyCode code) {
        // item 200
        bool caught = false;
        try {
            code();
        }
        catch {
            caught = true;
        }
        // item 201
        if (caught) {
            
        } else {
            // item 204
            throw new Exception("Exception expected but not thrown.");
        }
    }

    public static void Main() {
        // item 159
        Bar db = new Bar();
        // item 76
        Bar.IEmployee john = db.InsertEmployee(0, "John", new DateTime(1978, 1, 1));
        Bar.IEmployee mark = db.InsertEmployee(0, "Mark", new DateTime(1978, 1, 1));
        Bar.IEmployee john2 = db.InsertEmployee(0, "John", new DateTime(1985, 1, 1));
        // item 75
        db.InsertDepartment(0, "Marketing");
        db.InsertDepartment(0, "Sales");
        db.InsertDepartment(0, "Logistics");
        
        Bar.IDepartment marketing = db.FindDepartmentByTitle("Marketing");
        Bar.IDepartment sales     = db.FindDepartmentByTitle("Sales");
        Bar.IDepartment logistics = db.FindDepartmentByTitle("Logistics");
        // item 205
        Equal(null, john.Department);
        Equal(null, john2.Department);
        Equal(null, mark.Department);
        // item 137
        db.SetEmployeeDepartment(john, null);
        db.SetEmployeeDepartment(john2, null);
        db.SetEmployeeDepartment(mark, null);
        // item 136
        Equal(null, john.Department);
        Equal(null, john2.Department);
        Equal(null, mark.Department);
        // item 114
        var fakeDepartment = new FakeDepartment { 
        	Id = 1000, Title = "Fake" 
        };
        ExpectException(() =>
         db.SetEmployeeDepartment(john, fakeDepartment)
        );
        // item 138
        db.SetEmployeeDepartment(john, marketing);
        db.SetEmployeeDepartment(john2, sales);
        db.SetEmployeeDepartment(mark, marketing);
        // item 139
        Equal(marketing, john.Department);
        Equal(sales, john2.Department);
        Equal(marketing, mark.Department);
        // item 141
        db.SetEmployeeDepartment(john, marketing);
        db.SetEmployeeDepartment(john2, logistics);
        db.SetEmployeeDepartment(mark, null);
        // item 142
        Equal(marketing, john.Department);
        Equal(logistics, john2.Department);
        Equal(null, mark.Department);
        // item 143
        db.DeleteDepartment(sales);
        Equal(null, db.FindDepartmentByTitle("Sales"));
        // item 144
        ExpectException(() => db.DeleteDepartment(marketing));
        ExpectException(() => db.DeleteDepartment(logistics));
        // item 100
        db.DeleteEmployee(john);
        db.DeleteDepartment(marketing);
        // item 101
        db.SetEmployeeDepartment(john2, null);
        db.DeleteDepartment(logistics);
        // item 145
        Equal(2, db.EmployeeCount());
        Equal(0, db.DepartmentCount());
    }

    public static void NotEqual(object left, object right) {
        // item 191
        if (Object.Equals(left, right)) {
            // item 194
            throw new Exception("Objects are equal.");
        } else {
            
        }
    }
}

