// Autogenerated with DRAKON Editor 1.21
using System;
using System.Linq;
using System.Collections.Generic;

class Bar {
	public delegate void AnyCode();
    public interface IBaseRecord
    {
        int Id { get; }
    }
    private interface IDelRecord
    {
        void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master);
        void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList);
        void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList);
    }
    public interface IEmployee : IBaseRecord {
        string Name { get; }
        int Birthday { get; }
    }
    private int _next_employee = 1;
    private readonly Dictionary<int, Employee> _employee_pk = new Dictionary<int, Employee>();
    private class Employee_Name_Birthday_Comparer : IEqualityComparer<Employee> {
        public bool Equals(Employee x, Employee y) {
            if (!Object.Equals(x._name, y._name)) return false;
            if (x._birthday != y._birthday) return false;
            return true;
        }
        public int GetHashCode(Employee obj) {
            int code = ((obj._name == null) ? 0 : obj._name.GetHashCode());
            code = (code * 397) ^ obj._birthday.GetHashCode();;
            return code;
        }
    }
    private readonly Dictionary<Employee, Employee> _employee_Name_Birthday = new Dictionary<Employee, Employee>(new Employee_Name_Birthday_Comparer());
    private class Employee : IEmployee, IDelRecord {
        public readonly int _id;
        public int Id { get { return _id; } }
        public Employee(int id) {
            _id = id;
        }
        public string _name;
        public string Name {
            get { return _name; }
        }
        public int _birthday;
        public int Birthday {
            get { return _birthday; }
        }
        public virtual void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public virtual void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._employee_Name_Birthday.Remove(this);
            db._employee_pk.Remove(_id);
        }
        public virtual void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public virtual void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
    }
    private readonly Employee _employee_Key = new Employee(0);
    public IEmployee InsertEmployee(int id, string name, int birthday) {
        if ( id == 0 ) {
            id = _next_employee;
        } else {
            if (_employee_pk.ContainsKey(id)) {
                string className = _employee_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_employee ) {
            _next_employee = id + 1;
        }
        _employee_Key._name = name;
        _employee_Key._birthday = birthday;
        if ( _employee_Name_Birthday.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name Birthday' are not unique for 'Employee'.");
        }
        var _record_ = new Employee(id);
        _record_._name = name;
        _record_._birthday = birthday;
        _employee_pk[id] = _record_;
        _employee_Name_Birthday[_record_] = _record_;
        return _record_;
    }
    public IEmployee GetEmployee(int id) {
        Employee _record_;
        if (!_employee_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int EmployeeCount() {
        return _employee_pk.Count;
    }
    public IEnumerable<IEmployee> EachEmployee() {
        foreach (KeyValuePair<int, Employee> record in _employee_pk) {
            yield return record.Value;
        }
    }
    public void DeleteEmployee(IEmployee record) {
        if (record == null) return;
        Employee _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IEmployee FindEmployeeByNameBirthday(string name, int birthday) {
        Employee _record_;
        _employee_Key._name = name;
        _employee_Key._birthday = birthday;
        if (_employee_Name_Birthday.TryGetValue(_employee_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetEmployeeName(IEmployee record, string newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._name, newValue)) {
            return;
        }
        _employee_Key._name = newValue;
        _employee_Key._birthday = _record_._birthday;
        if ( _employee_Name_Birthday.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name Birthday' are not unique for 'Employee'.");
        }
        _employee_Name_Birthday.Remove(_record_);
        _record_._name = newValue;
        _employee_Name_Birthday[_record_] = _record_;
    }
    public void SetEmployeeBirthday(IEmployee record, int newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (_record_._birthday == newValue) {
            return;
        }
        _employee_Key._name = _record_._name;
        _employee_Key._birthday = newValue;
        if ( _employee_Name_Birthday.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name Birthday' are not unique for 'Employee'.");
        }
        _employee_Name_Birthday.Remove(_record_);
        _record_._birthday = newValue;
        _employee_Name_Birthday[_record_] = _record_;
    }

    public static void Equal(object expected, object actual) {
        // item 156
        if (Object.Equals(expected, actual)) {
            
        } else {
            // item 138
            if (expected is System.Collections.IEnumerable) {
                // item 144
                if (actual is System.Collections.IEnumerable) {
                    // item 147
                    var expectedEn = (System.Collections.IEnumerable)expected;
                    var actualEn = (System.Collections.IEnumerable)actual;
                    // item 158
                    List<object> exList = expectedEn.Cast<object>().ToList();
                    List<object> acList = actualEn.Cast<object>().ToList();
                    // item 148
                    if (exList.Count == acList.Count) {
                        // item 1510001
                        int i = 0;
                        while (true) {
                            // item 1510002
                            if (i < exList.Count) {
                                
                            } else {
                                break;
                            }
                            // item 153
                            Equal(exList[i], acList[i]);
                            // item 1510003
                            i++;
                        }
                    } else {
                        // item 150
                        throw new Exception("Collections have different sizes");
                    }
                } else {
                    // item 146
                    throw new Exception("Both should be IEnumerable");
                }
            } else {
                // item 141
                if (actual is System.Collections.IEnumerable) {
                    // item 142
                    throw new Exception("Both should be IEnumerable");
                } else {
                    // item 154
                    throw new Exception("Objects are not equal.");
                }
            }
        }
    }

    public static void ExpectException(AnyCode code) {
        // item 173
        bool caught = false;
        try {
            code();
        }
        catch {
            caught = true;
        }
        // item 174
        if (caught) {
            
        } else {
            // item 177
            throw new Exception("Exception expected but not thrown.");
        }
    }

    public static void Main() {
        // item 180
        Bar db = new Bar();
        // item 35
        Equal(null, db.FindEmployeeByNameBirthday("John", 1978));
        Equal(null, db.FindEmployeeByNameBirthday("John", 1980));
        Equal(null, db.FindEmployeeByNameBirthday("Mark", 1965));
        // item 76
        Bar.IEmployee john = db.InsertEmployee(400, "John", 1978);
        // item 77
        Equal(400, john.Id);
        // item 75
        Bar.IEmployee mark = db.InsertEmployee(0, "Mark", 1965);
        Bar.IEmployee john2 = db.InsertEmployee(0, "John", 1980);
        // item 181
        Equal(john, db.FindEmployeeByNameBirthday("John", 1978));
        Equal(john2, db.FindEmployeeByNameBirthday("John", 1980));
        Equal(mark, db.FindEmployeeByNameBirthday("Mark", 1965));
        // item 114
        ExpectException (
         () => db.InsertEmployee(0, "Mark", 1965)
        );
        // item 69
        Equal("John", john.Name);
        Equal("John", john2.Name);
        Equal("Mark", mark.Name);
        Equal(1978, john.Birthday);
        // item 122
        ExpectException (
          () => db.SetEmployeeBirthday(john, 1980)
        );
        // item 124
        db.SetEmployeeName(mark, "John");
        // item 129
        Equal(john, db.FindEmployeeByNameBirthday("John", 1978));
        Equal(john2, db.FindEmployeeByNameBirthday("John", 1980));
        Equal(mark, db.FindEmployeeByNameBirthday("John", 1965));
        // item 125
        Equal(null, db.FindEmployeeByNameBirthday("Mark", 1965));
        // item 127
        Equal("John", john.Name);
        Equal("John", mark.Name);
        // item 99
        db.DeleteEmployee(john);
        db.DeleteEmployee(john2);
        // item 100
        db.DeleteEmployee(mark);
        // item 101
        Equal(null, db.GetEmployee(john.Id));
        Equal(null, db.GetEmployee(john2.Id));
        Equal(null, db.GetEmployee(mark.Id));
        // item 182
        Equal(null, db.FindEmployeeByNameBirthday("John", 1978));
        Equal(null, db.FindEmployeeByNameBirthday("John", 1980));
        Equal(null, db.FindEmployeeByNameBirthday("John", 1965));
    }

    public static void NotEqual(object left, object right) {
        // item 164
        if (Object.Equals(left, right)) {
            // item 167
            throw new Exception("Objects are equal.");
        } else {
            
        }
    }
}

