// Autogenerated with DRAKON Editor 1.21
using System;
using System.Linq;
using System.Collections.Generic;

class Bar {
	public delegate void AnyCode();
    public interface IBaseRecord
    {
        int Id { get; }
    }
    private interface IDelRecord
    {
        void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master);
        void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList);
        void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList);
    }
    public interface IEmployee : IBaseRecord {
        string Name { get; }
    }
    private int _next_employee = 1;
    private readonly Dictionary<int, Employee> _employee_pk = new Dictionary<int, Employee>();
    private class Employee_Name_Comparer : IEqualityComparer<Employee> {
        public bool Equals(Employee x, Employee y) {
            if (!Object.Equals(x._name, y._name)) return false;
            return true;
        }
        public int GetHashCode(Employee obj) {
            int code = ((obj._name == null) ? 0 : obj._name.GetHashCode());
            return code;
        }
    }
    private readonly Dictionary<Employee, Employee> _employee_Name = new Dictionary<Employee, Employee>(new Employee_Name_Comparer());
    private class Employee : IEmployee, IDelRecord {
        public readonly int _id;
        public int Id { get { return _id; } }
        public Employee(int id) {
            _id = id;
        }
        public string _name;
        public string Name {
            get { return _name; }
        }
        public virtual void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public virtual void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._employee_Name.Remove(this);
            db._employee_pk.Remove(_id);
        }
        public virtual void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public virtual void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
    }
    private readonly Employee _employee_Key = new Employee(0);
    public IEmployee InsertEmployee(int id, string name) {
        if ( id == 0 ) {
            id = _next_employee;
        } else {
            if (_employee_pk.ContainsKey(id)) {
                string className = _employee_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_employee ) {
            _next_employee = id + 1;
        }
        _employee_Key._name = name;
        if ( _employee_Name.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name' are not unique for 'Employee'.");
        }
        var _record_ = new Employee(id);
        _record_._name = name;
        _employee_pk[id] = _record_;
        _employee_Name[_record_] = _record_;
        return _record_;
    }
    public IEmployee GetEmployee(int id) {
        Employee _record_;
        if (!_employee_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int EmployeeCount() {
        return _employee_pk.Count;
    }
    public IEnumerable<IEmployee> EachEmployee() {
        foreach (KeyValuePair<int, Employee> record in _employee_pk) {
            yield return record.Value;
        }
    }
    public void DeleteEmployee(IEmployee record) {
        if (record == null) return;
        Employee _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IEmployee FindEmployeeByName(string name) {
        Employee _record_;
        _employee_Key._name = name;
        if (_employee_Name.TryGetValue(_employee_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetEmployeeName(IEmployee record, string newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._name, newValue)) {
            return;
        }
        _employee_Key._name = newValue;
        if ( _employee_Name.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Name' are not unique for 'Employee'.");
        }
        _employee_Name.Remove(_record_);
        _record_._name = newValue;
        _employee_Name[_record_] = _record_;
    }

    public static void Equal(object expected, object actual) {
        // item 152
        if (Object.Equals(expected, actual)) {
            
        } else {
            // item 134
            if (expected is System.Collections.IEnumerable) {
                // item 140
                if (actual is System.Collections.IEnumerable) {
                    // item 143
                    var expectedEn = (System.Collections.IEnumerable)expected;
                    var actualEn = (System.Collections.IEnumerable)actual;
                    // item 154
                    List<object> exList = expectedEn.Cast<object>().ToList();
                    List<object> acList = actualEn.Cast<object>().ToList();
                    // item 144
                    if (exList.Count == acList.Count) {
                        // item 1470001
                        int i = 0;
                        while (true) {
                            // item 1470002
                            if (i < exList.Count) {
                                
                            } else {
                                break;
                            }
                            // item 149
                            Equal(exList[i], acList[i]);
                            // item 1470003
                            i++;
                        }
                    } else {
                        // item 146
                        throw new Exception("Collections have different sizes");
                    }
                } else {
                    // item 142
                    throw new Exception("Both should be IEnumerable");
                }
            } else {
                // item 137
                if (actual is System.Collections.IEnumerable) {
                    // item 138
                    throw new Exception("Both should be IEnumerable");
                } else {
                    // item 150
                    throw new Exception("Objects are not equal.");
                }
            }
        }
    }

    public static void ExpectException(AnyCode code) {
        // item 169
        bool caught = false;
        try {
            code();
        }
        catch {
            caught = true;
        }
        // item 170
        if (caught) {
            
        } else {
            // item 173
            throw new Exception("Exception expected but not thrown.");
        }
    }

    public static void Main() {
        // item 176
        Bar db = new Bar();
        // item 35
        Equal(null, db.FindEmployeeByName("John"));
        Equal(null, db.FindEmployeeByName("Mark"));
        // item 76
        Bar.IEmployee john = db.InsertEmployee(0, "John");
        Bar.IEmployee mark = db.InsertEmployee(0, "Mark");
        // item 177
        Equal(john, db.FindEmployeeByName("John"));
        Equal(mark, db.FindEmployeeByName("Mark"));
        // item 114
        ExpectException(
        	() => db.InsertEmployee(0, "John")
        );
        // item 118
        db.SetEmployeeName(john, "John");
        // item 120
        Equal("John", john.Name);
        Equal(john, db.FindEmployeeByName("John"));
        // item 178
        ExpectException(
        	() => db.SetEmployeeName(john, "Mark")
        );
        // item 179
        db.SetEmployeeName(john, "John Connor");
        // item 180
        Equal(null, db.FindEmployeeByName("John"));
        Equal(john, db.FindEmployeeByName("John Connor"));
        // item 127
        Equal("John Connor", john.Name);
        Equal("Mark", mark.Name);
        // item 99
        db.DeleteEmployee(john);
        db.DeleteEmployee(mark);
        // item 181
        Equal(null, db.FindEmployeeByName("John"));
        Equal(null, db.FindEmployeeByName("Mark"));
    }

    public static void NotEqual(object left, object right) {
        // item 160
        if (Object.Equals(left, right)) {
            // item 163
            throw new Exception("Objects are equal.");
        } else {
            
        }
    }
}

