// Autogenerated with DRAKON Editor 1.22
using System;
using System.Collections.Generic;
using System.Text;

namespace AutomatonTest {

public enum TokenType
{
	None,
	Identifier,
	Number,
	Operator
}

public class Token
{
	public readonly String Text;
	public readonly TokenType Type;
	public Token(string text, TokenType type)
	{
		Text = text;
		Type = type;
	}
	public override string ToString()
	{
		return String.Format("{0} {1}", Text, Type);
	}
}

public class Lexer {

	private readonly StringBuilder _buffer = new StringBuilder();
	private readonly List<Token> _tokens = new List<Token>();
	private readonly List<string> _longOperators = new List<string>
		{ "==", "<=", ">=", "!=", "&&", "||" };
	private readonly bool[] _operatorChars = new bool[255];
	
	public List<Token> Tokens { get { return _tokens; } }

    public interface ILexer_State
    {
        string Name { get; }
        void Digit(Lexer obj, char c);
        void Letter(Lexer obj, char c);
        void Operator(Lexer obj, char c);
        void Whitespace(Lexer obj, char c);
    }
    private ILexer_State _state = Idle_State;
    public ILexer_State State { get { return _state; } }
    private class Idle_State_Definition : ILexer_State {
        public string Name { get { return "Idle"; } }
        public void Digit(Lexer obj, char c) {
            obj.Idle_Digit(c);
        }
        public void Letter(Lexer obj, char c) {
            obj.Idle_Letter(c);
        }
        public void Operator(Lexer obj, char c) {
            obj.Idle_Operator(c);
        }
        public void Whitespace(Lexer obj, char c) {
            obj.Idle_Whitespace(c);
        }
    }
    public static readonly ILexer_State Idle_State = new Idle_State_Definition();
    private class Identifier_State_Definition : ILexer_State {
        public string Name { get { return "Identifier"; } }
        public void Digit(Lexer obj, char c) {
            obj.Identifier_Digit(c);
        }
        public void Letter(Lexer obj, char c) {
            obj.Identifier_Letter(c);
        }
        public void Operator(Lexer obj, char c) {
            obj.Identifier_Operator(c);
        }
        public void Whitespace(Lexer obj, char c) {
            obj.Identifier_Whitespace(c);
        }
    }
    public static readonly ILexer_State Identifier_State = new Identifier_State_Definition();
    private class Number_State_Definition : ILexer_State {
        public string Name { get { return "Number"; } }
        public void Digit(Lexer obj, char c) {
            obj.Number_Digit(c);
        }
        public void Letter(Lexer obj, char c) {
            obj.Number_Letter(c);
        }
        public void Operator(Lexer obj, char c) {
            obj.Number_Operator(c);
        }
        public void Whitespace(Lexer obj, char c) {
            obj.Number_Whitespace(c);
        }
    }
    public static readonly ILexer_State Number_State = new Number_State_Definition();
    private class Operator_State_Definition : ILexer_State {
        public string Name { get { return "Operator"; } }
        public void Digit(Lexer obj, char c) {
            obj.Operator_Digit(c);
        }
        public void Letter(Lexer obj, char c) {
            obj.Operator_Letter(c);
        }
        public void Operator(Lexer obj, char c) {
            obj.Operator_Operator(c);
        }
        public void Whitespace(Lexer obj, char c) {
            obj.Operator_Whitespace(c);
        }
    }
    public static readonly ILexer_State Operator_State = new Operator_State_Definition();
    private class Intermediate_State_Definition : ILexer_State {
        public string Name { get { return "Intermediate"; } }
        public void Digit(Lexer obj, char c) {
            throw new System.InvalidOperationException("The 'Lexer' object is in the intermediate state.");
        }
        public void Letter(Lexer obj, char c) {
            throw new System.InvalidOperationException("The 'Lexer' object is in the intermediate state.");
        }
        public void Operator(Lexer obj, char c) {
            throw new System.InvalidOperationException("The 'Lexer' object is in the intermediate state.");
        }
        public void Whitespace(Lexer obj, char c) {
            throw new System.InvalidOperationException("The 'Lexer' object is in the intermediate state.");
        }
    }
    public static readonly ILexer_State Intermediate_State = new Intermediate_State_Definition();
    public void Digit(char c) {
        ILexer_State current = _state;
        _state = Intermediate_State;
        current.Digit(this, c);
    }
    public void Letter(char c) {
        ILexer_State current = _state;
        _state = Intermediate_State;
        current.Letter(this, c);
    }
    public void Operator(char c) {
        ILexer_State current = _state;
        _state = Intermediate_State;
        current.Operator(this, c);
    }
    public void Whitespace(char c) {
        ILexer_State current = _state;
        _state = Intermediate_State;
        current.Whitespace(this, c);
    }

    public Lexer() {
        // item 203
        _operatorChars['!'] = true;
        _operatorChars['='] = true;
        _operatorChars['<'] = true;
        _operatorChars['>'] = true;
        _operatorChars['-'] = true;
        _operatorChars['+'] = true;
        _operatorChars['/'] = true;
        _operatorChars['\\'] = true;
        _operatorChars['*'] = true;
        _operatorChars['%'] = true;
        _operatorChars['('] = true;
        _operatorChars[')'] = true;
        _operatorChars['['] = true;
        _operatorChars[']'] = true;
        _operatorChars['{'] = true;
        _operatorChars['}'] = true;
        _operatorChars[':'] = true;
        _operatorChars['.'] = true;
        _operatorChars[';'] = true;
        _operatorChars[','] = true;
        _operatorChars['^'] = true;
        _operatorChars['|'] = true;
        _operatorChars['&'] = true;
        _operatorChars['"'] = true;
        _operatorChars['\''] = true;
    }

    public static List<Token> Lex(string text) {
        IEnumerator<char> _it168 = null;
        char c = default(char);
        // item 167
        Lexer lexer = new Lexer();
        // item 1680001
        _it168 = ((IEnumerable<char>)text).GetEnumerator();
        while (true) {
            // item 1680002
            if (_it168.MoveNext()) {
                
            } else {
                break;
            }
            // item 1680004
            c = _it168.Current;
            // item 172
            if (c == '_') {
                // item 181
                lexer.Letter(c);
            } else {
                // item 175
                if (Char.IsLetter(c)) {
                    // item 181
                    lexer.Letter(c);
                } else {
                    // item 178
                    if (Char.IsDigit(c)) {
                        // item 182
                        lexer.Digit(c);
                    } else {
                        // item 183
                        if (lexer.IsOperator(c)) {
                            // item 186
                            lexer.Operator(c);
                        } else {
                            // item 187
                            lexer.Whitespace(' ');
                        }
                    }
                }
            }
        }
        // item 171
        lexer.Whitespace(' ');
        // item 170
        return lexer.Tokens;
    }

    public static void Main() {
        IEnumerator<Token> _it204 = null;
        Token token = default(Token);
        // item 161
        string text = "foo.Bar(34 / 4-(18+m * 3));";
        List<Token> tokens = Lex(text);
        // item 207
        Console.WriteLine("Text:\n{0}", text);
        Console.WriteLine("Tokens:");
        // item 2040001
        _it204 = ((IEnumerable<Token>)tokens).GetEnumerator();
        while (true) {
            // item 2040002
            if (_it204.MoveNext()) {
                
            } else {
                break;
            }
            // item 2040004
            token = _it204.Current;
            // item 206
            Console.WriteLine(token);
        }
    }

    private void AddChar(char c) {
        // item 120
        _buffer.Append(c);
    }

    private void CreateIdentifier() {
        // item 126
        CreateToken(TokenType.Identifier);
    }

    private void CreateNumber() {
        // item 142
        CreateToken(TokenType.Number);
    }

    private void CreateOperator() {
        // item 148
        CreateToken(TokenType.Operator);
    }

    private void CreateToken(TokenType type) {
        // item 132
        if (_buffer.Length == 0) {
            
        } else {
            // item 135
            string text = _buffer.ToString();
            _buffer.Length = 0;
            // item 136
            Token token = new Token(text, type);
            _tokens.Add(token);
        }
    }

    private void Identifier_Digit(char c) {
        // item 60
        AddChar(c);
        // item 63
        _state = Identifier_State;
    }

    private void Identifier_Letter(char c) {
        // item 59
        AddChar(c);
        // item 62
        _state = Identifier_State;
    }

    private void Identifier_Operator(char c) {
        // item 66
        CreateIdentifier();
        // item 61
        AddChar(c);
        // item 64
        _state = Operator_State;
    }

    private void Identifier_Whitespace(char c) {
        // item 65
        CreateIdentifier();
        // item 31
        _state = Idle_State;
    }

    private void Idle_Digit(char c) {
        // item 45
        AddChar(c);
        // item 48
        _state = Number_State;
    }

    private void Idle_Letter(char c) {
        // item 44
        AddChar(c);
        // item 47
        _state = Identifier_State;
    }

    private void Idle_Operator(char c) {
        // item 46
        AddChar(c);
        // item 49
        _state = Operator_State;
    }

    private void Idle_Whitespace(char c) {
        // item 23
        _state = Idle_State;
    }

    private bool IsOperator(char c) {
        // item 194
        if (c >= _operatorChars.Length) {
            // item 197
            return false;
        } else {
            // item 193
            return _operatorChars[c];
        }
    }

    private void Number_Digit(char c) {
        // item 77
        AddChar(c);
        // item 80
        _state = Number_State;
    }

    private void Number_Letter(char c) {
        // item 76
        AddChar(c);
        // item 79
        _state = Number_State;
    }

    private void Number_Operator(char c) {
        // item 83
        CreateNumber();
        // item 78
        AddChar(c);
        // item 81
        _state = Operator_State;
    }

    private void Number_Whitespace(char c) {
        // item 82
        CreateNumber();
        // item 34
        _state = Idle_State;
    }

    private void Operator_Digit(char c) {
        // item 101
        CreateOperator();
        // item 94
        AddChar(c);
        // item 97
        _state = Number_State;
    }

    private void Operator_Letter(char c) {
        // item 100
        CreateOperator();
        // item 93
        AddChar(c);
        // item 96
        _state = Identifier_State;
    }

    private void Operator_Operator(char c) {
        // item 103
        if (TryMakeLongOperator(c)) {
            // item 106
            _state = Idle_State;
        } else {
            // item 107
            CreateOperator();
            // item 95
            AddChar(c);
            // item 98
            _state = Operator_State;
        }
    }

    private void Operator_Whitespace(char c) {
        // item 99
        CreateOperator();
        // item 26
        _state = Idle_State;
    }

    private bool TryMakeLongOperator(char c) {
        // item 154
        char previous = _buffer[0];
        char[] chars = { previous, c };
        string text = new String(chars);
        // item 155
        if (_longOperators.Contains(text)) {
            // item 158
            _buffer.Length = 0;
            Token token = new Token(text, TokenType.Operator);
            _tokens.Add(token);
            // item 159
            return true;
        } else {
            // item 160
            return false;
        }
    }
}
}
