#!/usr/bin/env tclsh

# Autogenerated with DRAKON Editor 1.22

proc fibonacci { n } {
    #item 1530001
    if {$n == 0} {
        #item 157
        set result { 0 }
    } else {
        #item 1530002
        if {$n == 1} {
            #item 158
            set result { 0 1 }
        } else {
            #item 182
            set result { 0 1 }
            #item 1630001
            set i 2
            while { 1 } {
                #item 1630002
                if {$i <= $n} {
                    
                } else {
                    break
                }
                #item 164
                set index2 [expr { $i - 2 }]
                set index1 [expr { $i - 1 }]
                set f2 [lindex $result $index2]
                set f1 [lindex $result $index1]
                #item 285
                set fib \
                [expr {$f1 + $f2}]
                #item 165
                lappend result $fib
                #item 1630003
                incr i
            }
        }
    }
    #item 168
    return $result
}

proc foreach_demo { } {
    #item 178
    puts "iteration demo"
    #item 169
    set sequence [fibonacci 15]
    #item 170
    print_list_arrow $sequence
    print_list_for $sequence
    print_list_foreach $sequence
    #item 183
    puts ""
}

proc main { } {
    #item 278
    puts "DRAKON-Tcl demo"
    puts "==============="
    #item 174
    foreach_demo
    #item 175
    quick_sort_demo
}

proc print_list_arrow { collection } {
    #item 134
    puts "using if and arrow:"
    #item 120
    set length [llength $collection]
    set i 0
    while { 1 } {
        #item 121
        if {$i < $length} {
            
        } else {
            break
        }
        #item 119
        set item [lindex $collection $i]
        write $item
        #item 123
        incr i
    }
    #item 135
    puts ""
}

proc print_list_for { collection } {
    #item 176
    puts "using for:"
    #item 130
    set length [llength $collection]
    #item 1310001
    set i 0
    while { 1 } {
        #item 1310002
        if {$i < $length} {
            
        } else {
            break
        }
        #item 133
        set item [lindex $collection $i]
        write $item
        #item 1310003
        incr i
    }
    #item 177
    puts ""
}

proc print_list_foreach { collection } {
    #item 137
    puts "using foreach:"
    #item 1110001
    set _col111 $collection
    set _len111 [ llength $_col111 ]
    set _ind111 0
    while { 1 } {
        #item 1110002
        if {$_ind111 < $_len111} {
            
        } else {
            break
        }
        #item 1110004
        set item [ lindex $_col111 $_ind111 ]
        #item 112
        write $item
        #item 1110003
        incr _ind111
    }
    #item 136
    puts ""
}

proc quick_sort { collection comparer } {
    #item 198
    set length [llength $collection]
    #item 1990001
    if {($length == 0) || ($length == 1)} {
        #item 210
        set result $collection
    } else {
        #item 1990003
        if {$length == 2} {
            #item 215
            set first [lindex $collection 0]
            set second [lindex $collection 1]
            #item 216
            if {[$comparer $first $second] < 0} {
                #item 275
                set result $collection
            } else {
                #item 218
                set result [list $second $first]
            }
        } else {
            #item 221
            set half [expr { $length / 2 }]
            set median [lindex $collection $half]
            set left {}
            set right {}
            #item 2220001
            set i 0
            while { 1 } {
                #item 2220002
                if {$i < $length} {
                    
                } else {
                    break
                }
                #item 235
                if {$i == $half} {
                    
                } else {
                    #item 224
                    set current [lindex $collection $i]
                    #item 225
                    if {[$comparer $current $median] < 0} {
                        #item 226
                        lappend left $current
                    } else {
                        #item 227
                        lappend right $current
                    }
                }
                #item 2220003
                incr i
            }
            #item 233
            set left_sorted [quick_sort $left $comparer]
            set right_sorted [quick_sort $right $comparer]
            #item 234
            lappend left_sorted $median
            set result [concat $left_sorted $right_sorted]
        }
    }
    #item 276
    return $result
}

proc quick_sort_demo { } {
    #item 277
    puts "quick sort demo"
    #item 246
    set unsorted { the sooner we start this the better }
    set sorted { aa bb cc dd ee ff }
    set reverse { ff ee dd cc bb aa }
    set empty {}
    set flat { flat flat flat flat }
    #item 247
    set unsorted2 [quick_sort $unsorted string_comparer]
    set sorted2 [quick_sort $sorted string_comparer]
    set reverse2 [quick_sort $reverse string_comparer]
    set empty2 [quick_sort $empty string_comparer]
    set flat2 [quick_sort $flat string_comparer]
    #item 248
    puts $unsorted2
    puts $sorted2
    puts $reverse2
    puts $empty2
    puts $flat2
    #item 249
    strings_are_sorted $unsorted2
    strings_are_sorted $sorted2
    strings_are_sorted $reverse2
    strings_are_sorted $empty2
    strings_are_sorted $flat2
}

proc string_comparer { left right } {
    #item 240
    return [string compare $left $right]
}

proc strings_are_sorted { array } {
    set length [llength $array]
    #item 2550001
    set i 0
    
    set _next_item_ 2550002
    while { 1 } {
        if {$_next_item_ == 2550002} {
            if {$i < $length} {
                #item 257
                set current [lindex $array $i]
                #item 2580001
                set j [expr { $i + 1 }]
                set _next_item_ 2580002
            } else {
                return {}
            }
    
        } elseif {$_next_item_ == 2580002} {
            if {$j < $length} {
                #item 260
                set after [lindex $array $j]
                #item 2650000
                set _sw2650000_ [string compare $current $after]
                set _next_item_ 2650001
            } else {
                #item 2550003
                incr i
                set _next_item_ 2550002
            }
    
        } elseif {$_next_item_ == 2650001} {
            if {$_sw2650000_ == -1} {
                #item 272
                set _next_item_ 2580003
            } else {
                set _next_item_ 2650002
            }
    
        } elseif {$_next_item_ == 2650002} {
            if {$_sw2650000_ == 0} {
                #item 273
                set _next_item_ 2580003
            } else {
                set _next_item_ 2650003
            }
    
        } elseif {$_next_item_ == 2580003} {
            incr j
            set _next_item_ 2580002
    
        } elseif {$_next_item_ == 2650003} {
            if {$_sw2650000_ == 1} {
                set _next_item_ 274
            } else {
                #item 2650004
                error "Unexpected switch value: $_sw2650000_"
                set _next_item_ 274
            }
    
        } elseif {$_next_item_ == 274} {
            #item 261
            error "Collection is not sorted:\n$array"
            return {}
    
        }
    }
}

proc write { item } {
    #item 142
    puts -nonewline "$item "
}

main
