/*
 * This file is part of EasyRPG Player.
 *
 * EasyRPG Player is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EasyRPG Player is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EasyRPG Player. If not, see <http://www.gnu.org/licenses/>.
 */

// Headers
#include "scene_logo.h"
#include "bitmap.h"
#include "filefinder.h"
#include "graphics.h"
#include "input.h"
#include "player.h"
#include "scene_map.h"
#include "scene_title.h"

static const uint8_t easyrpg_logo[] = {
	0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D,
	0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0xF0,
	0x08, 0x03, 0x00, 0x00, 0x00, 0x46, 0xF3, 0x4D, 0x59, 0x00, 0x00, 0x03,
	0x00, 0x50, 0x4C, 0x54, 0x45, 0x56, 0x6D, 0x45, 0x81, 0x92, 0x74, 0x76,
	0x76, 0x76, 0x81, 0x81, 0x81, 0xEE, 0xEE, 0xEE, 0xF2, 0xF2, 0xF2, 0x9F,
	0x9F, 0x9F, 0xB7, 0xB7, 0xB7, 0xF9, 0xF9, 0xF9, 0xCE, 0xE1, 0xC1, 0xFD,
	0xFD, 0xFD, 0x53, 0x53, 0x53, 0x7A, 0x7A, 0x7A, 0xE1, 0xE1, 0xE1, 0x76,
	0x88, 0x69, 0x9D, 0x9D, 0x9D, 0xB9, 0xB9, 0xB9, 0x70, 0x70, 0x6F, 0x7B,
	0x87, 0x71, 0xF8, 0xF8, 0xF8, 0x4F, 0x5A, 0x47, 0xB2, 0xB2, 0xB2, 0x4F,
	0x4F, 0x4F, 0x93, 0x93, 0x93, 0xD9, 0xD9, 0xD9, 0xE7, 0xE7, 0xE7, 0xE9,
	0xE9, 0xE9, 0x63, 0x71, 0x5A, 0xB0, 0xB0, 0xB0, 0x62, 0x6D, 0x5C, 0x94,
	0x94, 0x94, 0x4D, 0x64, 0x3C, 0xEC, 0xEC, 0xEC, 0x6D, 0x7B, 0x64, 0xF0,
	0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x6E, 0x78, 0x67, 0x4C, 0x4C, 0x4C, 0xCC,
	0xD2, 0xC8, 0xB4, 0xB4, 0xB4, 0x79, 0x93, 0x68, 0xC2, 0xC2, 0xC2, 0x4B,
	0x4B, 0x4B, 0xA2, 0xA2, 0xA2, 0xDB, 0xDB, 0xDB, 0x69, 0x69, 0x69, 0x2C,
	0x2C, 0x2C, 0xF7, 0xF8, 0xF7, 0x30, 0x3D, 0x2A, 0x3D, 0x4F, 0x32, 0x8F,
	0x8F, 0x8F, 0x63, 0x65, 0x62, 0x82, 0x8F, 0x79, 0x42, 0x42, 0x42, 0x58,
	0x58, 0x58, 0xA7, 0xBB, 0x99, 0xBD, 0xBD, 0xBD, 0x3B, 0x3B, 0x3B, 0x7D,
	0x7D, 0x7D, 0xF6, 0xF6, 0xF6, 0xB7, 0xB7, 0xB6, 0xAB, 0xAB, 0xAB, 0x4C,
	0x60, 0x3D, 0xAD, 0xAD, 0xAD, 0x0C, 0x0C, 0x0C, 0x80, 0x9D, 0x6E, 0xB1,
	0xC7, 0xA3, 0xCB, 0xCB, 0xCB, 0x31, 0x31, 0x31, 0xED, 0xEE, 0xEC, 0xEB,
	0xEB, 0xEB, 0xF3, 0xF3, 0xF3, 0x23, 0x23, 0x23, 0x66, 0x73, 0x5F, 0x1C,
	0x1C, 0x1C, 0xCE, 0xCE, 0xCE, 0xAF, 0xB1, 0xAF, 0xD2, 0xD3, 0xD1, 0x9A,
	0xBD, 0x85, 0x3E, 0x3E, 0x3E, 0x55, 0x6F, 0x43, 0x81, 0x8E, 0x78, 0xDC,
	0xDE, 0xDC, 0xA8, 0xC2, 0x97, 0x06, 0x06, 0x06, 0xB5, 0xC0, 0xAE, 0x7B,
	0x94, 0x6B, 0xFA, 0xFB, 0xFA, 0x15, 0x15, 0x15, 0x47, 0x47, 0x47, 0xB3,
	0xB4, 0xB3, 0xEA, 0xEB, 0xE9, 0xF1, 0xF2, 0xF1, 0xC9, 0xCA, 0xC8, 0xE4,
	0xE4, 0xE4, 0x01, 0x01, 0x01, 0xA7, 0xA7, 0xA7, 0x4F, 0x6A, 0x3D, 0x56,
	0x63, 0x4C, 0x72, 0x72, 0x72, 0x6D, 0x6E, 0x6D, 0xE7, 0xE9, 0xE7, 0xCC,
	0xCD, 0xCB, 0x75, 0x75, 0x75, 0x7D, 0xA8, 0x66, 0xDE, 0xDF, 0xDE, 0x7F,
	0xAD, 0x66, 0xD8, 0xD8, 0xD8, 0x84, 0x98, 0x76, 0x3E, 0x52, 0x31, 0x99,
	0xAC, 0x8D, 0x37, 0x37, 0x37, 0x85, 0xAC, 0x71, 0x9B, 0x9D, 0x9B, 0xEE,
	0xEF, 0xEE, 0x03, 0x03, 0x03, 0x8B, 0x8B, 0x89, 0xC5, 0xDB, 0xB7, 0xD6,
	0xD6, 0xD6, 0x4B, 0x5A, 0x3F, 0x9A, 0x9A, 0x99, 0x87, 0x88, 0x86, 0xC6,
	0xC6, 0xC6, 0x9D, 0xA1, 0x9B, 0x61, 0x64, 0x60, 0xD4, 0xD4, 0xD3, 0x35,
	0x40, 0x2E, 0xE2, 0xE2, 0xE1, 0xFA, 0xFA, 0xFA, 0x96, 0x99, 0x94, 0xF5,
	0xF5, 0xF5, 0xAC, 0xAE, 0xAA, 0x69, 0x75, 0x61, 0xF3, 0xF4, 0xF3, 0xA6,
	0xB0, 0x9D, 0x92, 0x94, 0x91, 0x7A, 0x84, 0x72, 0xB1, 0xCE, 0x9F, 0x63,
	0x7B, 0x54, 0x44, 0x48, 0x41, 0xB8, 0xB9, 0xB7, 0xB9, 0xD3, 0xA9, 0xEF,
	0xF0, 0xEF, 0x63, 0x6F, 0x5D, 0xB9, 0xD2, 0xA8, 0x78, 0x88, 0x6B, 0x8F,
	0x93, 0x8C, 0xCF, 0xD1, 0xCD, 0x97, 0xBB, 0x82, 0x51, 0x53, 0x50, 0x13,
	0x13, 0x13, 0x96, 0xB3, 0x85, 0xAF, 0xCD, 0x9B, 0x7A, 0x7C, 0x79, 0xC1,
	0xDA, 0xB1, 0xDA, 0xDB, 0xDA, 0x9E, 0xC0, 0x89, 0x56, 0x5A, 0x53, 0xCC,
	0xE0, 0xBF, 0x88, 0xA2, 0x78, 0x82, 0x97, 0x74, 0x80, 0xAE, 0x6A, 0xCB,
	0xDF, 0xBD, 0x77, 0x78, 0x77, 0xA9, 0xC8, 0x94, 0xA7, 0xA9, 0xA5, 0x84,
	0x86, 0x82, 0xBA, 0xBE, 0xB8, 0x63, 0x88, 0x4C, 0xC7, 0xDC, 0xB8, 0x7A,
	0x93, 0x6A, 0xFC, 0xFC, 0xFC, 0x6F, 0x7C, 0x66, 0x84, 0x9E, 0x74, 0xB0,
	0xCD, 0x9D, 0xE6, 0xE7, 0xE5, 0xBE, 0xD6, 0xAD, 0xC0, 0xD8, 0xB1, 0x9B,
	0xA5, 0x95, 0x87, 0xA2, 0x76, 0xA9, 0xC7, 0x95, 0x56, 0x72, 0x44, 0xA8,
	0xB0, 0xA2, 0x65, 0x87, 0x4F, 0xA3, 0xC3, 0x8D, 0x5B, 0x7C, 0x45, 0x8A,
	0xA7, 0x78, 0x57, 0x7B, 0x41, 0xB5, 0xD1, 0xA3, 0xBF, 0xD7, 0xAF, 0xC2,
	0xDA, 0xB3, 0x73, 0x8D, 0x62, 0x75, 0x8E, 0x64, 0x44, 0x65, 0x2F, 0x4C,
	0x6F, 0x37, 0xC5, 0xC8, 0xC3, 0x7E, 0x97, 0x6F, 0x60, 0x85, 0x49, 0xC8,
	0xDE, 0xBA, 0xAE, 0xCA, 0x9C, 0xC4, 0xDB, 0xB5, 0x48, 0x6A, 0x33, 0x50,
	0x73, 0x3B, 0xA7, 0xC7, 0x92, 0x8A, 0xA5, 0x78, 0x80, 0x9A, 0x70, 0x59,
	0x7D, 0x43, 0x61, 0x85, 0x4A, 0x77, 0x91, 0x67, 0x85, 0x9C, 0x77, 0xBC,
	0xD4, 0xAD, 0xFE, 0xFE, 0xFE, 0x81, 0x9B, 0x70, 0xA5, 0xC5, 0x90, 0x49,
	0x6B, 0x34, 0x55, 0x7A, 0x3F, 0xCE, 0xE2, 0xC1, 0x55, 0x78, 0x3E, 0x74,
	0x8C, 0x64, 0x83, 0x9D, 0x74, 0x43, 0x64, 0x2E, 0x56, 0x8C, 0x3A, 0x86,
	0xA0, 0x75, 0x5D, 0x80, 0x47, 0xBF, 0xD7, 0xB0, 0x46, 0x68, 0x31, 0xA1,
	0xC2, 0x8B, 0x4E, 0x70, 0x38, 0x50, 0x72, 0x3A, 0x7E, 0x98, 0x6D, 0x71,
	0x89, 0x62, 0x5E, 0x82, 0x48, 0x76, 0x8F, 0x65, 0x4B, 0x6D, 0x36, 0x7C,
	0x96, 0x6B, 0x7A, 0x93, 0x6B, 0x5D, 0x7B, 0x49, 0xBB, 0xD4, 0xAB, 0xB8,
	0xD2, 0xA7, 0x78, 0x91, 0x68, 0x45, 0x67, 0x30, 0x53, 0x76, 0x3D, 0x2E,
	0x3D, 0x25, 0x62, 0x6E, 0x5C, 0x4D, 0x60, 0x3D, 0x80, 0xAE, 0x6B, 0x00,
	0x00, 0x00, 0x81, 0x92, 0x75, 0x3E, 0x4F, 0x32, 0x57, 0x6D, 0x45, 0x41,
	0x63, 0x2C, 0x6E, 0x7B, 0x66, 0x7A, 0x88, 0x6E, 0x42, 0x42, 0x41, 0x71,
	0x71, 0x71, 0xFF, 0xFF, 0xFF, 0x98, 0x6D, 0x87, 0xA6, 0x00, 0x00, 0x25,
	0xEE, 0x49, 0x44, 0x41, 0x54, 0x78, 0xDA, 0xEC, 0xDD, 0x5B, 0x4C, 0x54,
	0xD7, 0xFE, 0x07, 0xF0, 0xF3, 0x7F, 0xFC, 0xBF, 0x34, 0x69, 0xEB, 0x5B,
	0x63, 0xD4, 0xC4, 0x34, 0xBE, 0xA9, 0x09, 0x8D, 0x0F, 0x12, 0x13, 0x4C,
	0x7C, 0x30, 0x41, 0x22, 0x18, 0x39, 0x09, 0xE2, 0x03, 0x8A, 0x28, 0x5E,
	0x88, 0x36, 0x68, 0x50, 0x88, 0xDC, 0x05, 0x51, 0x44, 0x11, 0x32, 0xA0,
	0x43, 0x01, 0x61, 0x18, 0x15, 0x14, 0x45, 0x86, 0x9B, 0x5C, 0xDA, 0xCE,
	0x58, 0x14, 0xB1, 0x75, 0x33, 0x82, 0x6D, 0xB1, 0x88, 0xDC, 0x2A, 0xFE,
	0x17, 0x28, 0xA3, 0x46, 0xF4, 0xAF, 0xCE, 0xFF, 0xB7, 0xD6, 0xBE, 0xAC,
	0xBD, 0xF6, 0x65, 0xF6, 0x4C, 0xCF, 0xCB, 0x9F, 0x0D, 0xDF, 0xE4, 0x9C,
	0x63, 0x99, 0x2D, 0x95, 0xCF, 0xF9, 0xAD, 0xF5, 0x5B, 0x6B, 0xED, 0x3D,
	0xE3, 0xBF, 0xBC, 0x0B, 0xF9, 0x8F, 0xB2, 0x00, 0xB8, 0x00, 0xB8, 0x00,
	0xB8, 0x00, 0xB8, 0x00, 0xF8, 0xFF, 0x30, 0x19, 0xDB, 0x33, 0xD3, 0xC3,
	0xEB, 0xEA, 0xB2, 0xB2, 0x36, 0x66, 0xD5, 0xD5, 0xE5, 0xA6, 0x67, 0x3A,
	0x77, 0x2D, 0x00, 0xFA, 0x9D, 0x5A, 0x67, 0x7A, 0x6E, 0xC1, 0x6B, 0x65,
	0x96, 0x17, 0x3A, 0x6B, 0x17, 0x00, 0xFD, 0xC8, 0xBE, 0xF4, 0x2C, 0x09,
	0xAD, 0x60, 0x23, 0xA4, 0x40, 0xC2, 0xCC, 0x6A, 0xD8, 0xB7, 0x00, 0x68,
	0x90, 0xB8, 0x70, 0xDE, 0x6A, 0x63, 0xDD, 0xC7, 0x73, 0xAE, 0x0A, 0x31,
	0x91, 0x1F, 0xEB, 0x04, 0xD5, 0xF0, 0xB8, 0x05, 0x40, 0x1F, 0xB9, 0xC8,
	0xF3, 0x65, 0x81, 0xDD, 0xBB, 0xC8, 0xAB, 0x0F, 0xFF, 0xEC, 0xE2, 0xF3,
	0xE3, 0xCB, 0xAB, 0x91, 0xAE, 0x8A, 0x8F, 0x75, 0xA4, 0x14, 0x73, 0x2F,
	0x2E, 0x00, 0xEA, 0x24, 0x3A, 0x1D, 0x0B, 0x15, 0xD4, 0xB9, 0x2A, 0x22,
	0xC1, 0x4E, 0x99, 0x3F, 0xAF, 0x82, 0x61, 0x16, 0xBE, 0xA0, 0x21, 0x63,
	0x01, 0x50, 0x2B, 0xE7, 0x97, 0x63, 0x9D, 0x8F, 0x15, 0xAE, 0x97, 0x7F,
	0x6A, 0x05, 0x57, 0x62, 0x24, 0x4F, 0xB8, 0xFC, 0xFC, 0x02, 0xA0, 0x2A,
	0x6E, 0x1B, 0x2E, 0xBF, 0xBA, 0x77, 0xAE, 0x87, 0xD4, 0x4C, 0x8D, 0xF8,
	0x67, 0x64, 0xC5, 0xB9, 0x02, 0x60, 0x6E, 0x72, 0x2F, 0x00, 0xB2, 0x49,
	0x2B, 0xC4, 0x9D, 0xE3, 0x63, 0x85, 0x58, 0x7D, 0x3F, 0x2A, 0x22, 0x19,
	0xFE, 0xE8, 0xAA, 0xA8, 0x83, 0x4B, 0x8F, 0x66, 0x2C, 0x00, 0xCA, 0x93,
	0x81, 0xBB, 0xC7, 0xB2, 0x8A, 0xC8, 0x1F, 0xA9, 0xDD, 0x73, 0x59, 0x18,
	0xC5, 0x97, 0xEF, 0x70, 0x11, 0xE6, 0x46, 0x2F, 0x00, 0xD2, 0x44, 0xE7,
	0x82, 0xDF, 0xB9, 0x8A, 0xAB, 0xBC, 0xDE, 0x73, 0x9D, 0x48, 0x86, 0xAE,
	0xC8, 0x2C, 0x10, 0xDC, 0xB0, 0x00, 0x28, 0x26, 0x2D, 0x9C, 0xF8, 0x3D,
	0xA4, 0x7A, 0xBA, 0xE1, 0x0D, 0x23, 0xDF, 0x81, 0x60, 0x5D, 0xF4, 0x02,
	0x20, 0x1F, 0x77, 0x21, 0xF6, 0x73, 0x3D, 0x97, 0xEB, 0x3D, 0x54, 0x86,
	0x35, 0x8C, 0x74, 0x81, 0x60, 0x90, 0x7B, 0x01, 0x10, 0xE7, 0x7B, 0xEC,
	0xF7, 0x85, 0x4B, 0x65, 0xF7, 0x52, 0x8A, 0x84, 0x48, 0x09, 0xAF, 0x56,
	0x80, 0x60, 0xE8, 0x02, 0xA0, 0xD7, 0x9B, 0x9D, 0xBC, 0x11, 0xFC, 0x3E,
	0x56, 0x08, 0x3A, 0x94, 0x4E, 0x15, 0x6A, 0x88, 0x09, 0x23, 0x5D, 0x05,
	0xAF, 0xB3, 0xA2, 0xE7, 0x3D, 0xA0, 0x3B, 0x14, 0xF8, 0xC0, 0x6F, 0xFF,
	0x43, 0xA5, 0x9E, 0x3E, 0xA2, 0x40, 0xE8, 0x3A, 0x07, 0x25, 0x38, 0xDF,
	0x01, 0x37, 0xE5, 0x62, 0xBE, 0x48, 0xCB, 0xFE, 0x97, 0x40, 0xA2, 0xD0,
	0xBB, 0x2A, 0x8B, 0x16, 0xE1, 0xCB, 0x8A, 0x82, 0xD7, 0xE1, 0xF3, 0x1B,
	0x30, 0xAD, 0x81, 0x6C, 0x3E, 0x8A, 0xAC, 0x5C, 0x24, 0xE1, 0x93, 0xDB,
	0xFD, 0x8F, 0x22, 0x72, 0x45, 0x81, 0xD0, 0x55, 0xF7, 0xBA, 0xE0, 0xEB,
	0xF9, 0x0C, 0x18, 0x81, 0xCB, 0x6F, 0x63, 0x5B, 0x4B, 0xD1, 0x50, 0x85,
	0x9C, 0x8F, 0xE2, 0x69, 0x22, 0x52, 0xC2, 0x48, 0x18, 0xC3, 0xB9, 0xA9,
	0xF3, 0x17, 0x30, 0x14, 0x97, 0xDF, 0x55, 0x6B, 0x58, 0x65, 0xE5, 0x7E,
	0x0C, 0x42, 0xF5, 0x7C, 0x45, 0x4E, 0x18, 0xC9, 0xC1, 0xFC, 0x99, 0xE5,
	0x9C, 0xA7, 0x80, 0xB5, 0xE9, 0xC0, 0x97, 0x65, 0x19, 0x39, 0xF8, 0xF6,
	0xED, 0xA0, 0x4B, 0x83, 0xEF, 0x05, 0xC9, 0xB8, 0x0B, 0x67, 0x1C, 0x7E,
	0x25, 0x33, 0x14, 0x05, 0x5D, 0x6D, 0x56, 0xD8, 0x15, 0x17, 0xD8, 0xDC,
	0xF3, 0x11, 0xF0, 0x0C, 0xD9, 0x7B, 0x58, 0x8B, 0x2A, 0xDF, 0xBE, 0x3D,
	0xB8, 0x5F, 0x39, 0x76, 0x5F, 0xF0, 0xA9, 0xE0, 0xB8, 0x5E, 0x8B, 0xC5,
	0x92, 0x50, 0xBE, 0xDF, 0xC5, 0x7F, 0x41, 0x41, 0xE8, 0x1A, 0x6A, 0x6B,
	0xA9, 0xC0, 0x87, 0xD4, 0x19, 0xF3, 0x0F, 0xB0, 0x1E, 0x1F, 0xA8, 0x0C,
	0xB6, 0xB4, 0xBD, 0x85, 0x0C, 0xBA, 0x18, 0xBE, 0x17, 0x42, 0x06, 0x39,
	0xCB, 0xFA, 0x69, 0x9C, 0x2D, 0x1C, 0xF8, 0x89, 0x91, 0x13, 0xEE, 0xAF,
	0x7C, 0x7B, 0xD0, 0x6A, 0xD9, 0x88, 0x77, 0xC5, 0xF3, 0x0D, 0x30, 0x7E,
	0x39, 0x0C, 0xBD, 0x36, 0xEB, 0x41, 0xEC, 0x57, 0xC9, 0x17, 0xA0, 0x82,
	0x6F, 0x9C, 0x4B, 0x68, 0x9F, 0x22, 0x61, 0xFC, 0x20, 0xD2, 0x5C, 0x38,
	0x3E, 0x88, 0x7F, 0x77, 0x51, 0xD8, 0x32, 0x68, 0xE4, 0xF5, 0xF3, 0x0B,
	0xF0, 0x48, 0x16, 0x4C, 0x7F, 0x45, 0x61, 0x30, 0x7C, 0x21, 0x43, 0x2E,
	0x96, 0x8F, 0xC4, 0xC5, 0xAD, 0x99, 0x92, 0xFC, 0xC6, 0x49, 0x94, 0x84,
	0x91, 0x83, 0xFC, 0xEF, 0x2F, 0x1A, 0x81, 0x6A, 0x5E, 0x5E, 0x3F, 0x9F,
	0x00, 0x2F, 0x62, 0xBF, 0x30, 0x98, 0xFE, 0x48, 0x06, 0x23, 0xC1, 0x8F,
	0xE5, 0x1B, 0xAF, 0xE0, 0xD6, 0x13, 0xBD, 0xBE, 0x3E, 0xD1, 0x8F, 0x45,
	0xC4, 0x7E, 0x15, 0x43, 0x6F, 0xF9, 0xB4, 0xB5, 0x7C, 0x01, 0x82, 0xBB,
	0xE6, 0x0F, 0x60, 0x2A, 0xF8, 0x2D, 0x0B, 0x2B, 0x7A, 0xCB, 0xA7, 0x92,
	0x53, 0xF8, 0x81, 0xD3, 0x03, 0x6E, 0x7D, 0x1F, 0x0E, 0xEB, 0xC7, 0xD6,
	0x21, 0xB7, 0xA5, 0xBF, 0x52, 0x12, 0x3C, 0x07, 0xA3, 0xF8, 0xFB, 0xF9,
	0x02, 0xB8, 0x61, 0x39, 0xA9, 0xBF, 0xB7, 0x42, 0x86, 0x2A, 0x70, 0xF7,
	0xA0, 0x7C, 0x10, 0x97, 0xE8, 0x77, 0x63, 0x0B, 0xF7, 0xC0, 0x85, 0xA3,
	0x22, 0x1C, 0xE7, 0xD6, 0x9C, 0xBD, 0xD9, 0x0E, 0x73, 0x28, 0xC9, 0xC1,
	0x96, 0x8F, 0xD0, 0x49, 0x32, 0xCC, 0x0E, 0x48, 0xCF, 0x4E, 0x37, 0x82,
	0x9F, 0x98, 0x5B, 0x2E, 0xF9, 0xB2, 0x0F, 0x07, 0x70, 0xFA, 0x6E, 0xE0,
	0x80, 0xDF, 0xA3, 0x07, 0x24, 0x2C, 0x22, 0xF1, 0x83, 0xF6, 0xDC, 0x77,
	0x21, 0x4C, 0xAA, 0xC1, 0x3A, 0x7A, 0x3A, 0x68, 0x72, 0xC0, 0x24, 0xE8,
	0xBF, 0x45, 0xD4, 0x2F, 0x8C, 0x8B, 0x54, 0xFA, 0xB9, 0xCA, 0xFB, 0x6E,
	0x0C, 0xE3, 0x60, 0x3F, 0x1A, 0xB9, 0x21, 0xB7, 0x65, 0x1A, 0x67, 0xAA,
	0xB3, 0x5A, 0x14, 0xC4, 0x9D, 0x24, 0x79, 0x3E, 0x00, 0x06, 0xC3, 0xFA,
	0xAF, 0x0D, 0xFA, 0xAF, 0x90, 0x91, 0x29, 0x4E, 0xF2, 0x93, 0x74, 0xD6,
	0x0C, 0x93, 0xAC, 0xA7, 0x7E, 0xAC, 0xA1, 0x8B, 0xDB, 0x32, 0x35, 0x35,
	0x4D, 0xD2, 0x71, 0x52, 0xF8, 0x56, 0x45, 0x61, 0x59, 0xAF, 0x0B, 0x9C,
	0xE6, 0x07, 0xBC, 0x08, 0xFB, 0x5F, 0xD7, 0x88, 0xE8, 0x57, 0xD9, 0x78,
	0x73, 0x3D, 0xA7, 0xF0, 0x73, 0x3D, 0xE0, 0xFA, 0x88, 0x5F, 0x3B, 0x57,
	0xF1, 0x48, 0x8A, 0xCC, 0x10, 0x5A, 0x0C, 0xF8, 0x49, 0x82, 0xF9, 0x07,
	0x05, 0x41, 0x0B, 0x4C, 0xAD, 0xBB, 0xCC, 0x0E, 0x98, 0x96, 0x0B, 0xED,
	0xB2, 0x45, 0xF2, 0x2B, 0xB9, 0x30, 0xBD, 0x86, 0x63, 0xFC, 0x5C, 0xAE,
	0x07, 0x8F, 0x12, 0x30, 0xDF, 0xCD, 0xE1, 0xDE, 0xC1, 0x47, 0x6C, 0x04,
	0x41, 0xF0, 0x83, 0xFE, 0x22, 0x12, 0x82, 0x60, 0x25, 0xFF, 0xCD, 0xAC,
	0xD7, 0x60, 0x53, 0xE7, 0x36, 0x39, 0x60, 0x32, 0x54, 0x89, 0x55, 0x5A,
	0xC0, 0x5C, 0xBF, 0x39, 0x3D, 0xBD, 0xA6, 0x82, 0xF1, 0x03, 0x21, 0x18,
	0xC1, 0x37, 0x21, 0x30, 0x01, 0x42, 0xD4, 0x84, 0x8F, 0xB8, 0xF5, 0x37,
	0x6E, 0x30, 0x82, 0x7D, 0x82, 0x20, 0x5E, 0xCC, 0x34, 0x99, 0x1B, 0x70,
	0x13, 0x0C, 0x60, 0x8B, 0xD4, 0x40, 0x4A, 0x3A, 0xE0, 0xC7, 0xB7, 0x56,
	0x50, 0x3F, 0x17, 0xF6, 0x83, 0x02, 0xBB, 0x79, 0xB3, 0xB3, 0xB3, 0xD3,
	0x32, 0xF8, 0x28, 0x64, 0x50, 0x48, 0x08, 0x25, 0x04, 0xBF, 0xE1, 0x61,
	0x85, 0x60, 0xBE, 0xB8, 0x25, 0x81, 0x69, 0x30, 0xD5, 0xCC, 0x80, 0x6E,
	0x18, 0xC0, 0x2F, 0xA5, 0x09, 0xB0, 0xFF, 0xC2, 0x34, 0xC4, 0x52, 0xC1,
	0xFA, 0x61, 0xA1, 0xCE, 0xBB, 0x77, 0xEF, 0x1E, 0xE6, 0x04, 0x3C, 0x16,
	0x71, 0x10, 0xFC, 0x20, 0x3C, 0xA1, 0x24, 0xD8, 0x2E, 0x08, 0xB6, 0xE1,
	0x41, 0x6C, 0x62, 0xC0, 0x28, 0x58, 0x01, 0x5A, 0xC5, 0xC5, 0x6F, 0x58,
	0xE7, 0x34, 0x01, 0x74, 0x49, 0x7E, 0x0F, 0x88, 0xDF, 0x23, 0x6E, 0xFA,
	0x2E, 0x64, 0x18, 0x00, 0x95, 0x21, 0x7E, 0x37, 0x87, 0xD5, 0x82, 0x37,
	0x4B, 0xF8, 0x41, 0x3C, 0x02, 0xEB, 0x69, 0xBB, 0x79, 0x01, 0xCF, 0xC0,
	0x16, 0xAE, 0x57, 0x5C, 0xFA, 0x16, 0x75, 0x92, 0x9F, 0x7D, 0x0A, 0x00,
	0x19, 0x3F, 0x00, 0x6C, 0xC7, 0x05, 0x78, 0x73, 0x3F, 0x8F, 0x76, 0xED,
	0x9A, 0x4C, 0xF0, 0x1A, 0x37, 0xDD, 0x09, 0xD3, 0xA3, 0x5A, 0xF0, 0x82,
	0x95, 0xFF, 0xA6, 0xD6, 0x82, 0xD7, 0xCB, 0xD3, 0x4C, 0x0B, 0x98, 0x2C,
	0xEB, 0xC0, 0x95, 0x1D, 0xBC, 0xDF, 0x94, 0xB5, 0x82, 0xFA, 0x01, 0x1F,
	0x06, 0x5C, 0x7F, 0xF8, 0xF0, 0x95, 0x2B, 0x57, 0xB8, 0x6B, 0x4C, 0x04,
	0x3F, 0xB0, 0xC5, 0x84, 0x4A, 0xC1, 0xFC, 0xCE, 0x22, 0xBE, 0xAC, 0x07,
	0x5F, 0xBF, 0xCE, 0x34, 0x2B, 0xE0, 0x06, 0x79, 0x07, 0x39, 0xD9, 0xC1,
	0xFB, 0x4D, 0xAD, 0x01, 0x40, 0x71, 0xFE, 0x13, 0x66, 0xB9, 0x35, 0x57,
	0x20, 0xBF, 0x24, 0x5C, 0xBB, 0x36, 0x24, 0x85, 0x18, 0x82, 0xDF, 0xE1,
	0xBB, 0x58, 0xB0, 0x53, 0x2C, 0x42, 0x2A, 0xD8, 0xD7, 0x51, 0xC9, 0x6F,
	0x8A, 0xB3, 0xE0, 0x66, 0xBB, 0x49, 0x01, 0x1B, 0xE0, 0xF6, 0xB9, 0xD8,
	0x41, 0xC2, 0x2E, 0x4C, 0x8B, 0x80, 0xDC, 0x38, 0x0E, 0xF5, 0x1B, 0x1C,
	0x4C, 0xB8, 0xF2, 0x0B, 0x64, 0x3D, 0x37, 0xC4, 0x04, 0xFC, 0xA6, 0xAE,
	0x5C, 0x01, 0x41, 0x88, 0x86, 0x60, 0x47, 0x37, 0x3F, 0x88, 0xCB, 0x5F,
	0xBF, 0xB6, 0x99, 0x0D, 0x90, 0x16, 0xA0, 0xB8, 0x07, 0xAE, 0xBC, 0x90,
	0x2F, 0xF8, 0xF5, 0xAD, 0xE7, 0x98, 0x01, 0x3C, 0x08, 0x29, 0x07, 0x40,
	0x88, 0x85, 0x63, 0x01, 0xCB, 0xFB, 0x7E, 0xB9, 0x02, 0x39, 0xAC, 0x16,
	0x9C, 0xC6, 0xE1, 0x07, 0x71, 0x65, 0xCB, 0xE2, 0x37, 0x6F, 0x56, 0x9A,
	0x12, 0xD0, 0x26, 0x9B, 0x01, 0xBB, 0x3B, 0x44, 0xBF, 0xBE, 0x76, 0x8E,
	0xF5, 0x83, 0x70, 0xD3, 0xC0, 0x77, 0xE9, 0xD2, 0x30, 0x77, 0x4D, 0xE6,
	0xC7, 0x95, 0x0F, 0x63, 0x55, 0x56, 0x10, 0xE6, 0x41, 0x0C, 0x28, 0x4C,
	0xA7, 0x95, 0x6F, 0xF7, 0xEE, 0xF9, 0x6B, 0xEF, 0x53, 0x8F, 0xA7, 0xC9,
	0x8C, 0x80, 0xB5, 0xCB, 0xE9, 0x0C, 0x58, 0xD4, 0x29, 0xFA, 0x41, 0x38,
	0x17, 0x1D, 0xC0, 0x42, 0xDF, 0x4D, 0xB8, 0x84, 0xF3, 0xC3, 0x34, 0x07,
	0x35, 0x78, 0xEB, 0x16, 0xEF, 0xD7, 0x3B, 0x7C, 0x09, 0xFC, 0x28, 0xA1,
	0x5A, 0xB0, 0xA3, 0xE8, 0x2F, 0x9C, 0xCA, 0xE3, 0x9E, 0x1D, 0x66, 0x04,
	0xB4, 0xCB, 0x0A, 0x30, 0xBF, 0x8F, 0x07, 0xC4, 0x47, 0xA6, 0xC3, 0xBD,
	0x2E, 0xA5, 0xDF, 0x10, 0x37, 0x7D, 0xE9, 0x07, 0x9C, 0xE1, 0x5E, 0x0E,
	0x00, 0x21, 0x1C, 0x67, 0xF9, 0x05, 0x9B, 0xAA, 0x04, 0xE9, 0x34, 0xD8,
	0xDD, 0xDF, 0x52, 0x42, 0x00, 0xF7, 0x3A, 0x3C, 0x9E, 0xF3, 0x26, 0x04,
	0x0C, 0x7A, 0xFD, 0x7A, 0x48, 0x2C, 0xC0, 0x9B, 0x52, 0x01, 0xDE, 0xB8,
	0x31, 0xBC, 0x66, 0x50, 0xEC, 0xC0, 0x21, 0x82, 0xDF, 0xD0, 0xB5, 0xDE,
	0x2B, 0x3F, 0xFC, 0xF0, 0x3B, 0xE4, 0x87, 0xF5, 0xBD, 0x1C, 0x57, 0xCE,
	0x71, 0x09, 0x53, 0x04, 0x94, 0x12, 0xB2, 0x82, 0xD3, 0xD7, 0xEF, 0x8F,
	0x8C, 0x8C, 0x58, 0xEF, 0x1F, 0x24, 0x82, 0x7B, 0x3C, 0x9E, 0x5C, 0xF3,
	0x01, 0x9E, 0x81, 0x16, 0x62, 0x3D, 0xC8, 0x16, 0x20, 0xF1, 0x83, 0x53,
	0x3F, 0x5A, 0x80, 0xC4, 0x0F, 0xC2, 0x25, 0x80, 0x1F, 0x9F, 0x2B, 0x70,
	0xD5, 0x25, 0xF2, 0x2B, 0x1D, 0xC1, 0xA9, 0xF6, 0xC6, 0xFE, 0xFE, 0xFE,
	0x96, 0x11, 0x08, 0x5F, 0x82, 0x95, 0x07, 0x3C, 0xAB, 0xBF, 0x36, 0x1D,
	0x20, 0xEC, 0xE2, 0xCE, 0x8D, 0x08, 0x05, 0x78, 0x81, 0x16, 0xE0, 0x30,
	0x84, 0x7B, 0x00, 0x61, 0xFC, 0x40, 0x70, 0xCD, 0xEF, 0x6C, 0x28, 0x21,
	0x23, 0x78, 0xA3, 0xBD, 0xBB, 0xFA, 0xFE, 0xFD, 0xFB, 0x3C, 0xA0, 0xB5,
	0xBA, 0x92, 0x54, 0xE0, 0x6F, 0x1E, 0x8F, 0xDD, 0x74, 0x80, 0xE1, 0x70,
	0x0E, 0x2D, 0x8C, 0xE0, 0x76, 0xA6, 0x00, 0x87, 0x6F, 0x26, 0x0C, 0xD2,
	0x02, 0x24, 0x7E, 0xB8, 0x73, 0x40, 0x0D, 0xEA, 0x09, 0x5E, 0x12, 0x05,
	0x6F, 0x9E, 0xBD, 0x5E, 0xD2, 0xDD, 0xD8, 0x08, 0x82, 0x42, 0x09, 0xB6,
	0x08, 0x25, 0xB8, 0xCA, 0x93, 0x6B, 0x36, 0xC0, 0xEC, 0x82, 0xD7, 0x05,
	0x42, 0x0B, 0x39, 0xD8, 0xC9, 0x16, 0x20, 0x9C, 0x49, 0x2B, 0x0B, 0xF0,
	0x16, 0x04, 0xDA, 0xAE, 0x56, 0x11, 0x8A, 0x82, 0x57, 0x0E, 0xDF, 0x68,
	0xBF, 0x7E, 0xBD, 0xBB, 0x1B, 0x04, 0xAB, 0x1B, 0x69, 0x09, 0xEE, 0x25,
	0x6D, 0x64, 0x9D, 0x67, 0xB6, 0xD6, 0x64, 0x80, 0x4E, 0xFC, 0x20, 0x91,
	0x70, 0x8A, 0xD5, 0xC1, 0x16, 0xE0, 0xCD, 0xCE, 0x72, 0xE0, 0xE3, 0x01,
	0xA9, 0x5F, 0x79, 0x39, 0x07, 0x5B, 0x3A, 0x3D, 0xC1, 0xBB, 0xEB, 0x2D,
	0x43, 0x0F, 0x27, 0x26, 0x26, 0xBA, 0x5E, 0x84, 0xB4, 0x59, 0xFA, 0x69,
	0x09, 0xF6, 0x5B, 0xC9, 0x18, 0xFE, 0x1B, 0xFA, 0xB0, 0xC9, 0x00, 0xD3,
	0xE1, 0x49, 0xA2, 0x22, 0xF1, 0x14, 0x81, 0x2D, 0xC0, 0xCE, 0xBB, 0x6B,
	0x38, 0xDC, 0x82, 0x69, 0x01, 0x12, 0xBF, 0xDE, 0x5E, 0x30, 0x4C, 0x58,
	0xDF, 0xF7, 0xCB, 0x7F, 0x93, 0xF0, 0x5D, 0xF8, 0x17, 0x10, 0xFC, 0x65,
	0x7D, 0xC2, 0x73, 0x84, 0xFE, 0x46, 0xE8, 0xF6, 0xED, 0xDB, 0x8F, 0x6F,
	0x23, 0x48, 0xDE, 0x0A, 0x0B, 0xDB, 0x46, 0xA0, 0x0F, 0xA7, 0x9B, 0x0C,
	0x30, 0x17, 0xB6, 0x71, 0x6D, 0x62, 0x0B, 0x61, 0x0B, 0x10, 0x7A, 0x01,
	0xA7, 0x2C, 0xC0, 0x72, 0x00, 0xC4, 0x81, 0xFF, 0xE5, 0xF6, 0x33, 0xE1,
	0x7A, 0x7F, 0x6C, 0x46, 0xAD, 0xAD, 0xAD, 0xBF, 0xFE, 0xFA, 0x2B, 0xF8,
	0x3D, 0x7E, 0xFC, 0xC7, 0x1F, 0x33, 0x33, 0x33, 0x0E, 0x84, 0x1E, 0x5A,
	0x68, 0x1B, 0xC1, 0x6B, 0xE9, 0xC5, 0xE6, 0x02, 0x8C, 0x2E, 0x78, 0xBD,
	0x51, 0x98, 0x02, 0xAB, 0x3B, 0x94, 0x05, 0x78, 0xF7, 0xF0, 0x16, 0x10,
	0x54, 0x16, 0xA0, 0x3A, 0xC0, 0x79, 0xEB, 0x51, 0xD7, 0xDF, 0x4F, 0x21,
	0x00, 0x08, 0x21, 0x80, 0x44, 0xB0, 0x07, 0x0C, 0x9B, 0xDB, 0xF0, 0x18,
	0xEE, 0x27, 0x93, 0xE0, 0x12, 0xCF, 0x6A, 0xB7, 0xA9, 0x00, 0xCF, 0xD3,
	0x29, 0x90, 0x1D, 0xC1, 0x50, 0x80, 0x00, 0x78, 0xA5, 0x77, 0x90, 0x8E,
	0x60, 0xC6, 0xAF, 0x8D, 0x0F, 0xFF, 0x0F, 0xB7, 0x56, 0x34, 0xFF, 0x0D,
	0x21, 0x82, 0x04, 0xF0, 0xB6, 0x00, 0x08, 0x82, 0x63, 0x63, 0x33, 0x84,
	0xB0, 0x84, 0x0C, 0xE1, 0x3B, 0x1E, 0x4F, 0x84, 0xA9, 0x00, 0x43, 0xE1,
	0x66, 0x70, 0x91, 0xAC, 0x07, 0x33, 0x05, 0x78, 0xF7, 0xCA, 0x95, 0x69,
	0x4E, 0x31, 0x82, 0x25, 0x3F, 0x2A, 0x38, 0xB4, 0xA2, 0xF9, 0xCE, 0x9D,
	0xBF, 0x71, 0xB4, 0x01, 0xC7, 0x46, 0x81, 0xD0, 0x52, 0xBD, 0x47, 0x98,
	0x04, 0xA3, 0x4C, 0x05, 0x58, 0x28, 0xAD, 0x02, 0xC3, 0x68, 0x0F, 0xC6,
	0x7E, 0x64, 0x04, 0xC3, 0xE9, 0xE9, 0x1A, 0x8E, 0x01, 0x14, 0xFD, 0x68,
	0x42, 0xBA, 0x9A, 0x7F, 0xFB, 0xED, 0x0E, 0x08, 0x0A, 0x80, 0x74, 0x12,
	0xA4, 0x80, 0xA3, 0xA3, 0x0E, 0x14, 0x52, 0x44, 0xC6, 0xB0, 0xC7, 0x53,
	0x68, 0x2A, 0x40, 0xE8, 0x21, 0x16, 0xBE, 0x87, 0x94, 0xDC, 0x60, 0x46,
	0x30, 0xB9, 0xFF, 0x86, 0x8F, 0xFF, 0x12, 0x38, 0x71, 0x0A, 0xA4, 0x05,
	0xA8, 0xE0, 0x33, 0x06, 0xFC, 0x79, 0x72, 0x14, 0x35, 0x0B, 0x5D, 0x24,
	0xD7, 0x54, 0x80, 0x70, 0x94, 0x65, 0xE5, 0x7B, 0xC8, 0xD4, 0x14, 0xD3,
	0x83, 0x49, 0x01, 0x62, 0xC0, 0xC3, 0xE5, 0xD7, 0xE8, 0x14, 0xA8, 0x00,
	0x5C, 0xD1, 0x7C, 0xB9, 0xF9, 0xF2, 0x6F, 0x38, 0x02, 0x20, 0x44, 0x07,
	0x70, 0x72, 0xD2, 0x81, 0x70, 0x05, 0x1E, 0xF0, 0xEC, 0x30, 0x13, 0x60,
	0xAD, 0xD4, 0x84, 0x2B, 0xD9, 0x29, 0x90, 0x02, 0x5E, 0x1A, 0x2E, 0xD7,
	0x06, 0xEC, 0x05, 0xBE, 0xCB, 0x00, 0xD8, 0xEC, 0x1B, 0xB0, 0x47, 0x04,
	0x1C, 0x18, 0x43, 0x00, 0x18, 0xE3, 0x99, 0x35, 0x13, 0xE0, 0x2E, 0x38,
	0x0B, 0x1C, 0x61, 0x7A, 0x08, 0xD3, 0x83, 0xC9, 0xF9, 0xF3, 0x0F, 0x37,
	0x38, 0x15, 0x20, 0xE1, 0x6B, 0x0E, 0x10, 0x70, 0x60, 0x12, 0xFD, 0xB5,
	0xE7, 0xB6, 0xC7, 0x93, 0x66, 0x22, 0xC0, 0x23, 0x00, 0x28, 0xDC, 0xB8,
	0xED, 0x50, 0x4D, 0x81, 0x57, 0x04, 0xC0, 0xDF, 0xFB, 0xCA, 0xAF, 0x29,
	0x00, 0x7B, 0x9F, 0x03, 0x9C, 0x7F, 0x80, 0x63, 0x14, 0xF0, 0xDE, 0x64,
	0xEB, 0x65, 0x38, 0xD7, 0xAF, 0x37, 0x11, 0x60, 0x1C, 0xBC, 0x9D, 0x9A,
	0x07, 0x1C, 0xA1, 0x80, 0xEC, 0x08, 0xC6, 0x07, 0xA8, 0x30, 0x0F, 0xCA,
	0x01, 0x6F, 0x3D, 0xBF, 0x4C, 0x43, 0xFC, 0x28, 0x60, 0xAB, 0x2F, 0xC0,
	0x7B, 0x03, 0x08, 0x16, 0x82, 0x75, 0x26, 0x02, 0x74, 0xC2, 0x0D, 0xCD,
	0x30, 0x7E, 0x1F, 0x72, 0xC3, 0x07, 0xE0, 0xEF, 0x7D, 0x1C, 0xED, 0xC2,
	0x43, 0x50, 0x7D, 0x42, 0x68, 0x01, 0xFA, 0x09, 0xF8, 0x6C, 0x12, 0xAD,
	0xF6, 0x78, 0x6C, 0xE6, 0x01, 0x84, 0xFB, 0x21, 0x91, 0x3C, 0x60, 0xF7,
	0x0D, 0x55, 0x13, 0x26, 0x7E, 0x18, 0x10, 0xD2, 0x2B, 0x96, 0x60, 0xF9,
	0x0A, 0x10, 0x03, 0x36, 0xEA, 0xA7, 0x03, 0xF8, 0x87, 0x26, 0xE0, 0xAB,
	0x51, 0xC7, 0x2A, 0xCF, 0xF1, 0x78, 0xF3, 0x00, 0x4A, 0x1B, 0x91, 0xEB,
	0x7D, 0xB4, 0x87, 0x68, 0x00, 0xAE, 0xE7, 0x00, 0x10, 0x02, 0x7C, 0x38,
	0xCD, 0x60, 0x07, 0xC1, 0xFF, 0x4D, 0xFD, 0xF4, 0x76, 0x22, 0xA3, 0x12,
	0xE0, 0xB3, 0x67, 0xAF, 0x5E, 0x6D, 0x5E, 0xE2, 0xF1, 0x64, 0x99, 0x0D,
	0xB0, 0xF2, 0xE0, 0xC1, 0x35, 0x5B, 0xDA, 0x75, 0x00, 0x7F, 0x27, 0x49,
	0xC0, 0x82, 0x78, 0xCF, 0xF6, 0x1B, 0x09, 0xC6, 0x23, 0x7C, 0x4C, 0x01,
	0xEA, 0x01, 0xFE, 0x2C, 0x03, 0x7C, 0xE6, 0x80, 0x41, 0x6C, 0x37, 0xD1,
	0x1C, 0x08, 0x43, 0x78, 0x70, 0x7F, 0x85, 0x0B, 0xBF, 0xFF, 0x72, 0xCD,
	0x7A, 0x71, 0x0A, 0x54, 0x03, 0xDE, 0xE5, 0x86, 0xC6, 0xE1, 0xC4, 0xE0,
	0x0E, 0x08, 0x8A, 0x84, 0xC0, 0x47, 0xFD, 0xD8, 0x11, 0x4C, 0x4F, 0x63,
	0x54, 0x80, 0xAF, 0x26, 0x37, 0xAF, 0xF2, 0x2C, 0x72, 0x9B, 0x04, 0xB0,
	0x01, 0x0E, 0x63, 0xDA, 0xF6, 0xC3, 0xA7, 0x3A, 0xC1, 0xE7, 0xC2, 0x3C,
	0x8C, 0x04, 0xC4, 0x84, 0x2D, 0x53, 0x6A, 0x40, 0x12, 0xCB, 0x04, 0x36,
	0xA2, 0x82, 0x34, 0x77, 0x98, 0x02, 0x6C, 0x6D, 0x45, 0x24, 0xAD, 0x8F,
	0x67, 0xB4, 0x01, 0x7F, 0x72, 0x1C, 0x80, 0x12, 0x34, 0x07, 0xE0, 0x91,
	0x02, 0xA8, 0xC0, 0x8A, 0x3F, 0xBB, 0xF0, 0xA7, 0x62, 0xE1, 0x8F, 0x46,
	0x78, 0x19, 0xE9, 0x22, 0x85, 0x38, 0xAC, 0x01, 0xD8, 0x87, 0x9E, 0x6A,
	0x0B, 0xDE, 0x91, 0x17, 0x20, 0x3E, 0x85, 0x6E, 0xB3, 0x36, 0x6E, 0xB1,
	0x5A, 0x42, 0xF2, 0x10, 0x52, 0xF5, 0x90, 0x67, 0xE0, 0xF7, 0xE4, 0x1E,
	0xF4, 0x91, 0xC5, 0xE6, 0x00, 0x2C, 0x84, 0x75, 0x74, 0xC5, 0x9F, 0x13,
	0x3C, 0x20, 0x08, 0x92, 0x37, 0x67, 0x8E, 0x93, 0x42, 0xEC, 0x63, 0x9B,
	0x08, 0x3C, 0xB9, 0x66, 0x41, 0x7F, 0x93, 0x60, 0x30, 0x1D, 0x3F, 0x84,
	0x5E, 0xC0, 0xFB, 0x1C, 0xF2, 0xCF, 0x9E, 0x6D, 0x6F, 0x6F, 0x3F, 0x79,
	0xDD, 0xFA, 0x02, 0xDD, 0xA6, 0x3D, 0x84, 0x02, 0x3E, 0xC1, 0x25, 0xB8,
	0xC9, 0x0C, 0x80, 0xDB, 0xE0, 0x8E, 0x9C, 0x0B, 0x6E, 0x01, 0x75, 0x75,
	0xC9, 0x01, 0xE1, 0xCD, 0x0D, 0xE3, 0x7C, 0x21, 0x1E, 0x16, 0x01, 0xEF,
	0x5E, 0xB8, 0x00, 0x0F, 0x97, 0x37, 0x53, 0x41, 0x88, 0xA0, 0xC7, 0xF8,
	0x75, 0x75, 0x77, 0x4C, 0x51, 0xC0, 0xEB, 0x25, 0x23, 0x13, 0xA8, 0x87,
	0x1D, 0xC1, 0x04, 0x70, 0x72, 0xB3, 0xC7, 0x13, 0x64, 0x06, 0xC0, 0x26,
	0xFC, 0xA9, 0x8A, 0x13, 0x32, 0x40, 0x2C, 0x88, 0x01, 0x21, 0xE3, 0x2E,
	0x5C, 0x88, 0x6B, 0x86, 0x01, 0xF0, 0x4A, 0x47, 0x07, 0x06, 0xBC, 0xBB,
	0x05, 0x3D, 0xA5, 0x82, 0x34, 0x7F, 0xF3, 0x01, 0xBF, 0xB6, 0x8E, 0x0E,
	0x06, 0xB0, 0xBB, 0xBB, 0xFB, 0x16, 0x9A, 0x51, 0x01, 0x7E, 0x78, 0xE2,
	0x98, 0xF5, 0xCC, 0xBA, 0x4D, 0x00, 0x18, 0x04, 0xFB, 0x90, 0xAB, 0x22,
	0x20, 0x9E, 0x04, 0xA5, 0x12, 0x84, 0xF0, 0x6F, 0x4D, 0xE2, 0xCA, 0x2D,
	0xD6, 0x7C, 0x01, 0xF0, 0xEE, 0xF3, 0xA7, 0x20, 0x48, 0xC2, 0xF0, 0x91,
	0xC0, 0xF4, 0x67, 0xB9, 0x70, 0x01, 0x03, 0xE6, 0xCB, 0x01, 0x1B, 0x2D,
	0x20, 0x28, 0xF8, 0x49, 0x80, 0x1F, 0x62, 0xD6, 0x79, 0x3C, 0x71, 0x73,
	0x1F, 0xB0, 0x16, 0x1E, 0x2D, 0x87, 0x19, 0x10, 0x42, 0x27, 0x41, 0x06,
	0x10, 0x04, 0x5D, 0x13, 0x08, 0xA1, 0xA1, 0xFC, 0x0E, 0x3C, 0x84, 0xEF,
	0xB6, 0xA3, 0x56, 0x10, 0xD4, 0xCA, 0x53, 0x5C, 0x7F, 0x9D, 0x12, 0x60,
	0xFB, 0xF5, 0x93, 0x27, 0x05, 0x40, 0x10, 0x1C, 0x63, 0xA7, 0x40, 0x00,
	0x1C, 0x70, 0x78, 0x3C, 0x47, 0xE7, 0x3E, 0xE0, 0x3E, 0x78, 0x73, 0x52,
	0x05, 0xF0, 0x29, 0xC7, 0x30, 0x84, 0x00, 0x42, 0x1E, 0x3E, 0xFD, 0xE3,
	0x31, 0xDC, 0xE2, 0xCD, 0xDB, 0xC2, 0x97, 0xE0, 0x10, 0x48, 0xE9, 0xF9,
	0x3D, 0xEF, 0xEC, 0xE4, 0xFD, 0xC2, 0x1E, 0xE6, 0x01, 0x7A, 0x73, 0x5B,
	0x77, 0x09, 0xFF, 0x74, 0xC2, 0x10, 0x1A, 0x65, 0x46, 0x30, 0x00, 0x7E,
	0x70, 0xC0, 0xA3, 0x82, 0x73, 0x1F, 0x30, 0x0A, 0xA6, 0x40, 0x17, 0xF0,
	0xE9, 0x8F, 0xE1, 0x09, 0x58, 0x0E, 0x3F, 0x06, 0xC1, 0xDB, 0x68, 0x0B,
	0x29, 0xC1, 0x29, 0xD4, 0x0A, 0x56, 0x6A, 0x3E, 0x08, 0x9A, 0xE6, 0x0B,
	0xD0, 0x9A, 0x07, 0xF7, 0xD5, 0xE1, 0xB7, 0x39, 0x10, 0x6A, 0x23, 0x80,
	0xF7, 0x1B, 0x9B, 0x67, 0xD8, 0x11, 0x0C, 0xD9, 0x7C, 0xC0, 0xB3, 0x2A,
	0x63, 0xCE, 0x03, 0x26, 0xC3, 0x2A, 0x1A, 0xA6, 0x40, 0xBD, 0x31, 0x0C,
	0xE5, 0x37, 0x33, 0xF3, 0x07, 0x2F, 0xD8, 0x9A, 0x37, 0x4D, 0x4A, 0x70,
	0x1C, 0x3D, 0x25, 0x61, 0xF9, 0xC8, 0x00, 0x26, 0x05, 0xD8, 0xD1, 0x86,
	0xE8, 0x2E, 0x0E, 0x8D, 0x13, 0xC0, 0xFB, 0x16, 0x24, 0x03, 0x7C, 0x42,
	0x00, 0x63, 0x60, 0x43, 0xBC, 0x7D, 0xCE, 0x03, 0x1E, 0x85, 0x1E, 0xF2,
	0x72, 0x42, 0x31, 0x86, 0xA9, 0xE0, 0x04, 0x28, 0x48, 0x82, 0x68, 0x08,
	0x00, 0x49, 0x23, 0xD6, 0x4C, 0x6B, 0x5E, 0x07, 0x29, 0x40, 0x0B, 0xA2,
	0xBB, 0x38, 0x10, 0x6C, 0xE3, 0x9F, 0xD0, 0x6A, 0xEE, 0x61, 0x46, 0x30,
	0xE4, 0x1E, 0x2C, 0x64, 0x92, 0xE7, 0x3C, 0x60, 0x2E, 0x9C, 0x24, 0xFC,
	0x29, 0x03, 0x64, 0x4A, 0x70, 0xC5, 0xD3, 0x9E, 0x1E, 0x0A, 0x08, 0x82,
	0x53, 0x58, 0xF0, 0x26, 0x6A, 0x6D, 0xD5, 0xE0, 0x6B, 0x45, 0x56, 0xE2,
	0x77, 0x9D, 0xF1, 0xEB, 0x99, 0x41, 0xFD, 0xE4, 0x01, 0xAD, 0x36, 0xC4,
	0x8C, 0x60, 0xC8, 0x4F, 0x08, 0xBA, 0xC8, 0x9C, 0x07, 0x5C, 0x4E, 0x9A,
	0xB0, 0x62, 0x0C, 0x0B, 0x82, 0x5D, 0x8F, 0xC7, 0xC6, 0x00, 0x90, 0x0A,
	0xA2, 0x16, 0x7E, 0x31, 0xDD, 0x0A, 0x51, 0xF0, 0x81, 0x5F, 0x17, 0xF1,
	0xEB, 0x78, 0x80, 0xE4, 0x7E, 0x3D, 0x63, 0x68, 0x88, 0x3C, 0x9F, 0x65,
	0x45, 0x93, 0x50, 0x80, 0x62, 0x0F, 0x26, 0x41, 0xC7, 0x3D, 0xCB, 0xE7,
	0x3C, 0x20, 0x5E, 0xC5, 0x74, 0x01, 0x9E, 0x46, 0x1B, 0x69, 0x1E, 0x1B,
	0x05, 0x40, 0xB9, 0x20, 0xAC, 0x92, 0xB1, 0x60, 0x17, 0x9C, 0xB6, 0xB4,
	0x92, 0x10, 0x3B, 0x92, 0x5F, 0x5B, 0x51, 0x37, 0xDF, 0x41, 0xF8, 0x09,
	0x90, 0xDE, 0x4D, 0x9A, 0x69, 0x26, 0x80, 0x2D, 0x79, 0xA3, 0x7C, 0x01,
	0x52, 0x40, 0x58, 0x4A, 0xEF, 0x98, 0xF3, 0x80, 0xB0, 0x91, 0xAB, 0x98,
	0xA0, 0x80, 0xB4, 0x04, 0x1F, 0xA2, 0x9F, 0x47, 0x01, 0x90, 0x11, 0x04,
	0x40, 0x2C, 0xB8, 0x02, 0x00, 0x21, 0xAD, 0x62, 0xC8, 0x3F, 0xA2, 0x90,
	0x0B, 0xA4, 0x00, 0xB7, 0x20, 0xEA, 0xC7, 0x1F, 0x23, 0x20, 0x2B, 0x01,
	0x9C, 0x18, 0x63, 0x5A, 0x08, 0x64, 0xF3, 0x6A, 0xCF, 0x1B, 0x13, 0x01,
	0xB2, 0xB3, 0x60, 0xD7, 0xCC, 0x24, 0x00, 0xB2, 0x82, 0x04, 0x10, 0x04,
	0x9F, 0xDF, 0xFE, 0x55, 0x95, 0x56, 0x94, 0x4F, 0xFC, 0xA6, 0xAC, 0x88,
	0xF7, 0xA3, 0xE7, 0x58, 0xA8, 0x8D, 0x3C, 0x61, 0xB9, 0x62, 0x86, 0x2D,
	0x40, 0x00, 0x9C, 0x35, 0x01, 0x60, 0x16, 0x06, 0x54, 0x97, 0x60, 0x33,
	0x6C, 0x1C, 0x7E, 0x16, 0x05, 0x67, 0x44, 0x41, 0x64, 0x9D, 0xC2, 0x82,
	0xCD, 0x1A, 0x80, 0xC8, 0x02, 0x7C, 0x78, 0x0D, 0x1D, 0x86, 0x18, 0x3F,
	0x00, 0x9C, 0xE9, 0x22, 0xCF, 0xF8, 0xAE, 0x98, 0x79, 0x26, 0x6B, 0x21,
	0xC2, 0x42, 0x70, 0x76, 0xCE, 0x03, 0xD6, 0xE1, 0x26, 0xA2, 0x2A, 0x41,
	0x34, 0x30, 0x09, 0x01, 0x41, 0x02, 0x28, 0x09, 0xA2, 0xF6, 0x29, 0x2C,
	0x88, 0xE0, 0xB8, 0x59, 0x61, 0x78, 0xBB, 0xB9, 0x83, 0xF7, 0x9B, 0xEA,
	0x47, 0xAC, 0x1F, 0x7C, 0x0B, 0xD4, 0x8F, 0x01, 0x9F, 0xF7, 0x48, 0x05,
	0x48, 0x2B, 0x70, 0xD6, 0x44, 0xCB, 0x18, 0x5A, 0x82, 0x5D, 0x8E, 0x7B,
	0x03, 0x5A, 0x82, 0x8E, 0xE7, 0x53, 0x10, 0x3C, 0xCB, 0xDD, 0x16, 0x03,
	0x74, 0x24, 0xA8, 0x05, 0xF3, 0x41, 0xF2, 0x4F, 0x22, 0xE0, 0xA3, 0x7E,
	0xF8, 0x18, 0x06, 0x59, 0xC0, 0x6F, 0x64, 0x62, 0x4C, 0x2A, 0x40, 0x0A,
	0xB8, 0xC3, 0x3C, 0x0B, 0x69, 0x2A, 0x38, 0x31, 0x36, 0x03, 0xA7, 0x27,
	0x02, 0xA0, 0x5C, 0x10, 0x6D, 0xC9, 0xC7, 0x46, 0xB7, 0xD0, 0x63, 0x9C,
	0xDB, 0xB2, 0xA0, 0x10, 0xD1, 0x2F, 0xFF, 0x6C, 0xF3, 0x63, 0x85, 0xDF,
	0x64, 0xEB, 0x10, 0x06, 0x44, 0x93, 0x4C, 0x01, 0x42, 0xE0, 0xCE, 0x52,
	0x81, 0x19, 0xB6, 0x72, 0x1F, 0x23, 0x19, 0xC0, 0xBC, 0x01, 0xB8, 0xF3,
	0xFD, 0x1C, 0x21, 0xD4, 0x33, 0x4A, 0x05, 0x31, 0x21, 0x0A, 0x39, 0x7B,
	0x36, 0x3F, 0x7F, 0x2A, 0x3F, 0xEF, 0xB1, 0x32, 0xB7, 0x9B, 0xF3, 0x05,
	0x3E, 0x38, 0xC5, 0x1A, 0x77, 0x28, 0xFC, 0x26, 0x7B, 0x26, 0xC0, 0xCF,
	0x82, 0x18, 0x3F, 0x61, 0x1D, 0x98, 0x3B, 0xE7, 0x01, 0xED, 0xFC, 0x61,
	0x02, 0x15, 0xCC, 0xC3, 0x77, 0x1D, 0x51, 0x5B, 0xBF, 0x65, 0x68, 0x02,
	0x21, 0x47, 0xCF, 0xA8, 0x54, 0x83, 0xE8, 0x79, 0xFB, 0x59, 0x2C, 0x48,
	0xBA, 0x04, 0x0B, 0x88, 0x6E, 0x4D, 0xF1, 0x7E, 0x70, 0x41, 0xBB, 0x05,
	0x29, 0xFC, 0x26, 0x47, 0x11, 0x3C, 0x1F, 0x3D, 0xEE, 0x50, 0x02, 0x3E,
	0x83, 0xF3, 0xAC, 0xF4, 0x39, 0x0F, 0x18, 0x4F, 0x8E, 0xB3, 0x68, 0xD0,
	0x4F, 0xAF, 0x00, 0x70, 0x34, 0x6F, 0xA4, 0x1F, 0x62, 0x09, 0x69, 0x06,
	0x44, 0x6C, 0x31, 0x83, 0x50, 0x2F, 0x1C, 0x90, 0x9E, 0x85, 0xE4, 0x3D,
	0xFE, 0x83, 0x84, 0x2A, 0x42, 0x77, 0x26, 0x7C, 0xC4, 0xAF, 0xBD, 0x1B,
	0x01, 0x1F, 0xF5, 0x83, 0x0C, 0x20, 0xCB, 0x08, 0x6C, 0x44, 0x94, 0x05,
	0x38, 0x10, 0x03, 0x37, 0xE6, 0xE6, 0x3C, 0xA0, 0x1B, 0xF6, 0x72, 0xEF,
	0x7E, 0x94, 0xFC, 0x1C, 0x4F, 0x9E, 0x10, 0xC1, 0xD6, 0x15, 0x2D, 0xFD,
	0xFD, 0xF0, 0x36, 0xB7, 0xEA, 0xFE, 0xB6, 0x15, 0x80, 0x88, 0x9A, 0x43,
	0xFA, 0x4F, 0x02, 0x20, 0x10, 0xF6, 0x22, 0xE8, 0xC7, 0x8A, 0xA0, 0x93,
	0x84, 0x0F, 0xFB, 0x41, 0xF2, 0x60, 0xFD, 0xCC, 0xF8, 0x0D, 0x38, 0x42,
	0x46, 0x86, 0x54, 0x23, 0x98, 0x1C, 0x49, 0xD7, 0xCF, 0x71, 0x40, 0x48,
	0xBA, 0x7C, 0x12, 0x74, 0x7C, 0x00, 0x40, 0x2C, 0x78, 0x0F, 0x06, 0x31,
	0x16, 0x84, 0xB3, 0x50, 0xFC, 0x86, 0xAD, 0xEE, 0xEB, 0xD7, 0xAF, 0x9F,
	0x24, 0x82, 0x61, 0xE0, 0x07, 0x61, 0x10, 0x1F, 0x4F, 0x48, 0x7C, 0x90,
	0x93, 0x21, 0x0E, 0x85, 0xDF, 0xC0, 0x68, 0x73, 0x98, 0x54, 0x80, 0x34,
	0x0E, 0xBC, 0x8A, 0x99, 0xFB, 0x80, 0x4E, 0xFC, 0x77, 0x25, 0x09, 0x7E,
	0x9B, 0xE1, 0xC7, 0xC2, 0x25, 0x08, 0x19, 0x45, 0x16, 0x2A, 0x08, 0xC1,
	0x82, 0x40, 0x68, 0x85, 0x45, 0x8A, 0x2A, 0xA8, 0xED, 0xAC, 0xC8, 0x07,
	0x7E, 0x27, 0x2D, 0x08, 0xF8, 0x24, 0x3F, 0x00, 0x84, 0x07, 0xDA, 0x26,
	0x1C, 0x2A, 0xBF, 0x57, 0x68, 0x95, 0x27, 0xDC, 0x04, 0x80, 0x19, 0x1B,
	0x61, 0x25, 0xF8, 0x90, 0xF8, 0x8D, 0x7D, 0xC0, 0x11, 0x06, 0xF1, 0x18,
	0x6A, 0xE3, 0x07, 0x71, 0xA3, 0x58, 0x83, 0x40, 0xD8, 0x06, 0x33, 0x62,
	0x8F, 0x1A, 0xB0, 0x1B, 0xF4, 0xF8, 0x00, 0xF2, 0xF5, 0x46, 0x24, 0xF3,
	0x1B, 0x20, 0x87, 0x58, 0x08, 0x89, 0xA7, 0x30, 0x34, 0x31, 0x78, 0x0A,
	0x34, 0x01, 0xA0, 0x37, 0x1D, 0xF7, 0x61, 0xC9, 0x8F, 0x0A, 0x8E, 0xA2,
	0xF1, 0x16, 0xB9, 0x60, 0xC9, 0xF5, 0xC6, 0x2E, 0x34, 0x83, 0x57, 0x34,
	0x0A, 0xC3, 0xC7, 0x13, 0xED, 0x32, 0x3E, 0x48, 0xF3, 0x0C, 0xF0, 0xC9,
	0xFD, 0x9E, 0x8D, 0xDD, 0x03, 0x3F, 0x11, 0x90, 0xAE, 0x02, 0x8F, 0x67,
	0x98, 0x01, 0x10, 0x9E, 0xF0, 0xDD, 0x88, 0x77, 0x73, 0xA3, 0x1F, 0x44,
	0x40, 0x41, 0x70, 0x00, 0xE5, 0xDD, 0x1A, 0xA1, 0x82, 0xF7, 0x43, 0x50,
	0xEB, 0x18, 0x49, 0x0F, 0x8B, 0x88, 0xC2, 0x18, 0xBE, 0x92, 0xEE, 0x10,
	0x07, 0x29, 0x3F, 0xEA, 0x07, 0xE5, 0xA7, 0x2A, 0xC0, 0x7B, 0x0E, 0xFC,
	0xDE, 0x7F, 0x13, 0x00, 0x92, 0xDD, 0xDC, 0xB9, 0xC8, 0x89, 0xC9, 0x0F,
	0x52, 0x00, 0x90, 0x08, 0x42, 0x11, 0xA2, 0x09, 0xFC, 0x86, 0xD5, 0xEA,
	0x6A, 0x6B, 0x5B, 0x17, 0xF0, 0xE1, 0x35, 0xA1, 0x60, 0x48, 0xF3, 0x47,
	0xB3, 0x8C, 0x8F, 0xDC, 0xC6, 0xB4, 0x20, 0x23, 0x3F, 0xC8, 0x66, 0xE8,
	0xC1, 0xE7, 0x4D, 0xF3, 0x78, 0xDB, 0x46, 0x57, 0xCF, 0x07, 0x1A, 0x2A,
	0xF8, 0x6C, 0xA0, 0x07, 0x09, 0x99, 0x19, 0x25, 0xDB, 0x12, 0x6A, 0x28,
	0x48, 0x8E, 0x21, 0x0B, 0xE0, 0x89, 0x7C, 0x25, 0xE0, 0x57, 0xD2, 0x88,
	0x46, 0x0D, 0xFD, 0x9E, 0x21, 0xB8, 0xA9, 0x69, 0x9E, 0x77, 0x2A, 0x2D,
	0xFE, 0x17, 0x34, 0x60, 0x4D, 0xC1, 0x7B, 0xF0, 0x50, 0x38, 0xD1, 0x20,
	0x5B, 0x63, 0x0D, 0x43, 0x47, 0xF3, 0x75, 0x8C, 0x27, 0xF1, 0xC1, 0x7F,
	0x1A, 0x9B, 0x7B, 0x08, 0x9F, 0xDA, 0x8F, 0x2D, 0xC0, 0x50, 0xB3, 0x00,
	0xC6, 0x2D, 0x9E, 0x5D, 0xE5, 0x18, 0x50, 0x0B, 0x8A, 0x84, 0x98, 0x42,
	0x41, 0x48, 0x15, 0x51, 0x18, 0xD5, 0xE3, 0xF9, 0x1A, 0x1B, 0x43, 0x1C,
	0x7C, 0xF9, 0x31, 0x7E, 0xAA, 0x02, 0x5C, 0x54, 0x6B, 0x9E, 0x37, 0x5C,
	0x7B, 0x3C, 0xAB, 0x1D, 0x3F, 0xE9, 0x0A, 0x12, 0x42, 0x5A, 0x85, 0x14,
	0x11, 0x82, 0x5E, 0x10, 0x3C, 0x80, 0x93, 0xF8, 0xAA, 0xAB, 0x2D, 0x88,
	0x96, 0x9F, 0xE8, 0xC7, 0x06, 0x3F, 0xDC, 0x16, 0xEC, 0x35, 0x0D, 0xE0,
	0x86, 0x59, 0x8F, 0x67, 0x09, 0x1D, 0xC4, 0xB4, 0x17, 0x63, 0x41, 0x5A,
	0x84, 0x92, 0x21, 0x55, 0x9C, 0xC9, 0xEB, 0x16, 0x53, 0x22, 0xF2, 0x35,
	0xDE, 0xEF, 0x47, 0x93, 0xF2, 0xF2, 0x53, 0xFB, 0x8D, 0xC2, 0x2D, 0xE1,
	0x1D, 0x6E, 0xB3, 0x00, 0x42, 0x32, 0x3D, 0x9E, 0xE3, 0x9B, 0x47, 0xB5,
	0x04, 0x69, 0x11, 0x52, 0x43, 0x8A, 0x38, 0x86, 0xAC, 0x3C, 0x1E, 0xE8,
	0x49, 0x7C, 0x90, 0xE6, 0x31, 0xE0, 0xD3, 0xF7, 0x7B, 0x85, 0x56, 0x7B,
	0x56, 0x6D, 0xF2, 0x9A, 0x08, 0xD0, 0xBD, 0x11, 0x04, 0x1D, 0xCF, 0xF4,
	0x04, 0x59, 0x42, 0x1A, 0xD8, 0xEF, 0x95, 0x10, 0x3B, 0xAC, 0x47, 0xF9,
	0xFA, 0xFB, 0x43, 0x1C, 0xCF, 0xE8, 0xF0, 0x55, 0xF9, 0x3D, 0x71, 0x40,
	0x07, 0x29, 0x34, 0xD7, 0x67, 0x67, 0x9D, 0x79, 0xE3, 0xF1, 0x1C, 0xA0,
	0x82, 0x74, 0x22, 0x64, 0x09, 0x49, 0x64, 0x7E, 0x6D, 0x02, 0x1D, 0xD1,
	0x13, 0xF9, 0x20, 0x16, 0x44, 0xCB, 0x0F, 0xFC, 0x14, 0xE9, 0x81, 0x4D,
	0xDC, 0xA2, 0xB5, 0x66, 0x02, 0x84, 0x1C, 0x59, 0x8D, 0x05, 0x5F, 0x7D,
	0xD0, 0x2A, 0x42, 0x4A, 0x08, 0x86, 0x42, 0x88, 0xDF, 0xAD, 0x46, 0x19,
	0x1E, 0xE8, 0x09, 0x7C, 0x70, 0x80, 0x8F, 0x06, 0x5E, 0xD1, 0xE1, 0xAB,
	0x48, 0x0C, 0x3C, 0xD7, 0x76, 0xFC, 0x88, 0xE9, 0x3E, 0x02, 0xF4, 0xF4,
	0x2A, 0x8F, 0x67, 0x1D, 0xD4, 0xA0, 0x5A, 0x90, 0x12, 0x32, 0x86, 0x50,
	0x7F, 0xD5, 0x7C, 0x1A, 0x09, 0x1E, 0xE5, 0xC3, 0x77, 0x90, 0x46, 0x69,
	0xF9, 0x29, 0x32, 0x0A, 0x7E, 0xB0, 0x04, 0x34, 0x19, 0x20, 0xA4, 0xC9,
	0x83, 0x6B, 0xF0, 0xDE, 0x07, 0x03, 0x42, 0x30, 0x24, 0x8A, 0x0E, 0x64,
	0xB9, 0xCF, 0xA6, 0x5F, 0xE4, 0x83, 0x84, 0x38, 0xC8, 0xEC, 0xA7, 0x53,
	0x7F, 0x9E, 0xA3, 0xA6, 0xFC, 0x20, 0xEE, 0x64, 0x10, 0x9C, 0x75, 0xC4,
	0xA8, 0x05, 0x59, 0x42, 0x08, 0xF8, 0xA1, 0x66, 0x2B, 0x8B, 0x47, 0xF9,
	0x70, 0x2C, 0x88, 0x96, 0x9F, 0xDA, 0x2F, 0xDC, 0x6D, 0x42, 0x40, 0x48,
	0xD4, 0x71, 0xBC, 0x9A, 0xD9, 0xFC, 0x4A, 0x8F, 0x90, 0x1A, 0x6E, 0x46,
	0x2F, 0xFA, 0xD5, 0x69, 0x11, 0xF9, 0xAC, 0x23, 0xF7, 0xD1, 0x33, 0x2D,
	0xBE, 0x27, 0x9B, 0x37, 0xC3, 0xBF, 0x23, 0x17, 0xFC, 0x4C, 0x08, 0x08,
	0xD9, 0x0E, 0x9D, 0xC4, 0xB3, 0x0E, 0xC5, 0xFC, 0xA4, 0x4B, 0x48, 0x32,
	0x89, 0xF2, 0x2C, 0x6A, 0x3B, 0xD0, 0x93, 0xF8, 0x4A, 0x8A, 0x5A, 0xC5,
	0x4A, 0x66, 0x8F, 0xB0, 0x96, 0x60, 0xBF, 0x5A, 0xF3, 0xFE, 0x85, 0x2C,
	0xA9, 0x8B, 0x41, 0xF0, 0x78, 0x8C, 0x43, 0x87, 0x90, 0x18, 0x0E, 0xB4,
	0xA2, 0x5B, 0x23, 0x2D, 0x34, 0xD4, 0x8E, 0xF2, 0x75, 0xFD, 0xF5, 0x97,
	0x43, 0xC5, 0xF7, 0x53, 0x0F, 0xDE, 0xC0, 0xAD, 0x4A, 0x76, 0x9B, 0xF9,
	0xAF, 0x04, 0x72, 0x27, 0x1F, 0xC7, 0x33, 0x61, 0x0C, 0x8A, 0x79, 0xA6,
	0x26, 0x84, 0xC0, 0xBD, 0x12, 0x14, 0x62, 0x1D, 0x51, 0x86, 0xEA, 0xB5,
	0x00, 0xDF, 0x5F, 0x90, 0xAE, 0xE6, 0x1E, 0x05, 0x5F, 0x0C, 0xC2, 0xE5,
	0xB7, 0xDA, 0x6E, 0xF6, 0xBF, 0x16, 0x2D, 0x22, 0xCB, 0x03, 0x39, 0xBE,
	0xCE, 0xE1, 0x88, 0xB9, 0xF7, 0x44, 0x61, 0x30, 0xE9, 0x80, 0x03, 0x56,
	0xAB, 0x55, 0x5F, 0xAF, 0xBF, 0xBA, 0x9F, 0xFF, 0x9C, 0xCF, 0xCA, 0xE7,
	0x07, 0x1C, 0xA3, 0xF2, 0xD3, 0x17, 0xA8, 0x6A, 0xE0, 0xF3, 0x14, 0xD4,
	0x7B, 0x4D, 0x0E, 0x08, 0xD9, 0xBE, 0xD8, 0x83, 0x33, 0xBB, 0x6E, 0x33,
	0x72, 0xC4, 0x8C, 0x0E, 0xF0, 0x7D, 0x77, 0x60, 0xD4, 0xD1, 0x8A, 0x7E,
	0xBD, 0xB3, 0xA7, 0xA5, 0xA4, 0xFA, 0x7E, 0xCB, 0x88, 0x55, 0xA1, 0x68,
	0xC5, 0x78, 0xF7, 0x4B, 0xAA, 0xDB, 0xBA, 0x08, 0xDF, 0xDE, 0xCB, 0x07,
	0x68, 0x3B, 0x02, 0xF8, 0xD1, 0xCD, 0x8E, 0x75, 0xA4, 0xB2, 0x33, 0xDD,
	0x5E, 0xF3, 0x03, 0x42, 0xCE, 0xD7, 0xAD, 0x22, 0x86, 0xC7, 0x67, 0x67,
	0x97, 0xC4, 0x38, 0x70, 0x10, 0xBC, 0x3B, 0x1D, 0x68, 0x08, 0xCF, 0xC1,
	0xFE, 0x92, 0x6A, 0x78, 0x6A, 0x57, 0x58, 0xB2, 0xB4, 0x90, 0x3B, 0xF0,
	0xD5, 0x25, 0xD5, 0x45, 0x7B, 0x84, 0xD7, 0xF7, 0x76, 0x01, 0x1F, 0x64,
	0xD5, 0x3A, 0xC7, 0xE6, 0x98, 0xD1, 0x18, 0xF8, 0x06, 0x4B, 0x0E, 0xE0,
	0xEF, 0xB7, 0xBA, 0x30, 0x7A, 0xFE, 0xFC, 0xFD, 0xC2, 0xBB, 0x9A, 0x36,
	0x42, 0xC9, 0xD0, 0x40, 0x67, 0xD9, 0xB3, 0x17, 0x84, 0x84, 0x74, 0xED,
	0xAD, 0x2C, 0x82, 0xF1, 0x5A, 0x02, 0x81, 0x82, 0x0C, 0x6B, 0x13, 0x5F,
	0x82, 0xB1, 0xBB, 0xA7, 0x75, 0x35, 0xC6, 0x0B, 0x5A, 0x84, 0x7F, 0xD3,
	0x81, 0x75, 0xEB, 0xD6, 0x1D, 0x58, 0xBD, 0x8A, 0x14, 0x74, 0xE1, 0x86,
	0x79, 0xF6, 0x57, 0x84, 0x47, 0x47, 0x05, 0xED, 0x60, 0x10, 0x67, 0x5B,
	0xF7, 0x54, 0x82, 0x94, 0x6E, 0xBA, 0xF6, 0x54, 0x56, 0xC2, 0xD8, 0x85,
	0xAC, 0x3E, 0x9A, 0xEA, 0x5D, 0x19, 0x0E, 0x6E, 0x62, 0x56, 0x2D, 0x0E,
	0xA5, 0x9F, 0x1D, 0x6D, 0x7E, 0x40, 0x9A, 0xB4, 0x78, 0x67, 0x66, 0x72,
	0x7A, 0x61, 0x61, 0x7A, 0xE1, 0x1B, 0xDE, 0x30, 0xE6, 0xF2, 0xDE, 0xBD,
	0x7B, 0xF7, 0xA8, 0x14, 0x2F, 0xEF, 0x01, 0xBC, 0x2E, 0x07, 0x3F, 0x74,
	0x17, 0x25, 0x9F, 0xE1, 0xD7, 0x44, 0x47, 0x67, 0x3D, 0x84, 0x33, 0x37,
	0xEA, 0x7B, 0xF8, 0xC7, 0x79, 0x09, 0x48, 0xE3, 0xDE, 0x9E, 0xBB, 0x5A,
	0x28, 0xC4, 0x25, 0xB7, 0x2F, 0x43, 0x29, 0x56, 0x12, 0x49, 0xF8, 0x2F,
	0xF8, 0xE5, 0x9E, 0xAE, 0xA7, 0x31, 0x07, 0x84, 0x57, 0xC3, 0xE5, 0xF7,
	0x2A, 0xB7, 0x9D, 0xDF, 0x1E, 0x57, 0x8F, 0x1B, 0xC7, 0x02, 0x20, 0x24,
	0xC3, 0x79, 0x74, 0x91, 0x47, 0xCC, 0xEA, 0x59, 0x98, 0xDF, 0x96, 0x2C,
	0x59, 0x02, 0x53, 0xDC, 0xAC, 0x34, 0x56, 0x67, 0x8F, 0x3A, 0xB5, 0x76,
	0x19, 0x0B, 0x80, 0x34, 0xBB, 0x42, 0x73, 0x17, 0x1D, 0xF7, 0x68, 0xE4,
	0xF8, 0xA2, 0xDC, 0xCC, 0x78, 0x2F, 0x64, 0x01, 0xD0, 0x30, 0xB5, 0xF1,
	0xF6, 0xE4, 0xF0, 0x82, 0x1D, 0x6F, 0x66, 0xC9, 0xD2, 0x6E, 0x76, 0xC7,
	0xF2, 0xF0, 0x74, 0x7B, 0x44, 0x9A, 0x17, 0xB2, 0x00, 0xF8, 0x1F, 0x64,
	0x01, 0x70, 0x01, 0x70, 0x21, 0xFE, 0x03, 0xA6, 0x1D, 0xC9, 0x4C, 0x4A,
	0x2C, 0xAD, 0xC2, 0xA9, 0xC9, 0xB1, 0xC5, 0x45, 0xEB, 0x4C, 0x56, 0xA9,
	0xCE, 0xD0, 0xA4, 0xA3, 0x35, 0xE4, 0xBA, 0xD2, 0xA3, 0xE9, 0x99, 0x4E,
	0xFD, 0xBD, 0x40, 0xF6, 0xA6, 0xE0, 0x43, 0xE2, 0x95, 0xA5, 0x35, 0x39,
	0xC9, 0x51, 0xCE, 0x6D, 0x73, 0x81, 0x67, 0x6D, 0xEA, 0x26, 0xE7, 0x56,
	0x88, 0xDD, 0xE9, 0xFC, 0xF6, 0x62, 0xB4, 0xBF, 0x80, 0xB5, 0x71, 0xE9,
	0xBB, 0x3F, 0xB3, 0x49, 0xB4, 0xAF, 0x54, 0xAE, 0xDB, 0x2E, 0x46, 0xE5,
	0xC0, 0x55, 0x8A, 0xD4, 0xD8, 0xB4, 0x5C, 0x32, 0x4E, 0x27, 0x7E, 0x56,
	0xA7, 0x34, 0x27, 0xB9, 0x46, 0xC8, 0x21, 0xA3, 0x27, 0x1B, 0xC4, 0x0B,
	0x13, 0x1B, 0x34, 0x72, 0xA2, 0x29, 0x34, 0xD8, 0x1E, 0xB7, 0xCB, 0xAD,
	0x75, 0x6E, 0x71, 0x42, 0x23, 0x70, 0xFD, 0x56, 0xFB, 0xF6, 0x23, 0x67,
	0xBC, 0xBE, 0xF3, 0xBD, 0xF3, 0x44, 0xE1, 0x3B, 0x26, 0xFB, 0x13, 0x4E,
	0xD8, 0xEB, 0x0D, 0x01, 0x33, 0xA2, 0x4A, 0x3F, 0x6B, 0xA4, 0x2A, 0x73,
	0xAD, 0x4C, 0xEF, 0xC8, 0xA1, 0xAA, 0xCF, 0x3A, 0x49, 0xAF, 0x57, 0x16,
	0x9F, 0x0D, 0xA0, 0x0D, 0x62, 0x70, 0x08, 0x95, 0x29, 0x5E, 0x67, 0xFB,
	0x5F, 0xFD, 0xD4, 0x05, 0x35, 0x38, 0x33, 0x94, 0x37, 0xB2, 0x3E, 0xFA,
	0x48, 0x78, 0x83, 0x5D, 0x77, 0x07, 0x13, 0x6D, 0x4F, 0x78, 0xA7, 0x1D,
	0xEE, 0x84, 0x73, 0xAD, 0x2F, 0x40, 0x27, 0xF0, 0x69, 0xA7, 0xD4, 0x29,
	0xF2, 0xD9, 0x4A, 0x7D, 0x61, 0xEC, 0xB4, 0xD5, 0x32, 0xDF, 0x10, 0xA8,
	0x0D, 0x63, 0xF3, 0xBD, 0x4B, 0x91, 0xFE, 0x7D, 0xFB, 0xA8, 0x97, 0x36,
	0x62, 0x43, 0x84, 0x11, 0x20, 0x9B, 0x86, 0x7D, 0x9A, 0xAB, 0xD1, 0x13,
	0xEF, 0x7C, 0x65, 0xFF, 0x89, 0x08, 0x3D, 0xC0, 0xEC, 0x74, 0x9F, 0x3F,
	0xA6, 0x9B, 0x9F, 0x20, 0x8D, 0x38, 0x6A, 0x96, 0xCA, 0x4E, 0xA0, 0x3F,
	0xFB, 0x93, 0x2A, 0x30, 0xD7, 0x4F, 0x9C, 0x34, 0x93, 0x9C, 0x01, 0x24,
	0x23, 0xC2, 0x33, 0x2C, 0xA0, 0x21, 0xE1, 0x2E, 0x55, 0xF5, 0x01, 0x9F,
	0x51, 0x12, 0xB4, 0x01, 0x23, 0x68, 0x69, 0x69, 0x26, 0xA7, 0xD6, 0x10,
	0x90, 0xA4, 0x34, 0xD5, 0x2B, 0x04, 0xFC, 0xFC, 0x8A, 0xD3, 0x17, 0x60,
	0x8E, 0x74, 0x15, 0x00, 0x1A, 0xE6, 0xAB, 0x54, 0x06, 0xD0, 0x30, 0xE1,
	0xDF, 0x7A, 0x99, 0x7C, 0xCB, 0xBD, 0x33, 0x0E, 0xA7, 0x09, 0x18, 0x81,
	0x47, 0x9B, 0xB1, 0x60, 0x9A, 0x1F, 0x15, 0x25, 0xF4, 0x92, 0xE0, 0xCF,
	0x7E, 0xA6, 0xD0, 0x57, 0x0B, 0xD9, 0x29, 0xD5, 0x29, 0x00, 0x1A, 0x27,
	0x77, 0x17, 0x03, 0x68, 0x9C, 0xAD, 0xF2, 0xF5, 0x07, 0x2D, 0xBF, 0x80,
	0x01, 0xE3, 0x19, 0xBF, 0xD2, 0xA4, 0x50, 0xFB, 0xB1, 0xF3, 0xCE, 0xD3,
	0xB6, 0x9A, 0x9D, 0x9F, 0x69, 0x92, 0x59, 0xC0, 0x9A, 0xA4, 0xCC, 0x60,
	0xB8, 0x2A, 0x0E, 0x2E, 0x4B, 0x64, 0x5A, 0xC5, 0x51, 0x32, 0xDA, 0xEB,
	0xE5, 0x5F, 0xAB, 0x39, 0x14, 0x15, 0x77, 0x11, 0xB2, 0x29, 0xCE, 0x19,
	0x9A, 0x5E, 0xA3, 0x14, 0xDC, 0xE5, 0x4F, 0x0B, 0xF1, 0x62, 0x40, 0xE3,
	0x04, 0xD5, 0x32, 0x80, 0xC6, 0xB1, 0xD3, 0x75, 0x0B, 0xED, 0x1D, 0x01,
	0x03, 0x46, 0x97, 0xCA, 0xF4, 0x32, 0xEB, 0x65, 0x15, 0x10, 0x2C, 0x7B,
	0xC5, 0x2E, 0x01, 0xD6, 0x64, 0xEE, 0x63, 0xD6, 0x36, 0xEE, 0x4D, 0x49,
	0x32, 0xEA, 0x60, 0x2F, 0x24, 0x49, 0xFA, 0xC7, 0xDD, 0x99, 0x8A, 0xF5,
	0xCD, 0xCA, 0xB8, 0xE4, 0x52, 0xB6, 0x8D, 0x18, 0xB7, 0x90, 0x7A, 0x00,
	0xF4, 0x2B, 0xC1, 0x2C, 0xA0, 0x71, 0xE2, 0xC5, 0x3F, 0x15, 0xF5, 0x0B,
	0x18, 0xD0, 0x9D, 0x48, 0x7F, 0xDA, 0x50, 0x46, 0x06, 0xC8, 0x6C, 0xF4,
	0xB5, 0x0D, 0x04, 0xB0, 0x26, 0x8A, 0x0A, 0xD3, 0x6C, 0xCB, 0xA1, 0xD7,
	0x65, 0x83, 0xBC, 0x04, 0x9A, 0xA3, 0xB9, 0x08, 0x8D, 0x48, 0xDE, 0xFD,
	0x79, 0x37, 0x6D, 0x23, 0x86, 0x2D, 0xC4, 0xEB, 0x2F, 0x60, 0xAE, 0x3B,
	0x40, 0xC0, 0x42, 0x37, 0x6F, 0xD0, 0xF0, 0xEE, 0x9F, 0x03, 0x06, 0xD3,
	0xB1, 0xA6, 0x61, 0x73, 0x9A, 0xAE, 0xF3, 0x00, 0xF0, 0xE8, 0x31, 0xBA,
	0x6A, 0xD5, 0xBB, 0x2E, 0x13, 0x1E, 0xE5, 0x10, 0x7F, 0x9D, 0xA4, 0x77,
	0x79, 0x76, 0x14, 0x6D, 0x10, 0xC6, 0x2D, 0x84, 0x02, 0x1A, 0x65, 0x13,
	0x0B, 0x68, 0x1C, 0xFE, 0xDF, 0xBE, 0x55, 0x83, 0xAA, 0x61, 0xAB, 0xF3,
	0xFC, 0xBE, 0xD4, 0xD4, 0x78, 0xD8, 0x92, 0x24, 0xEC, 0xF7, 0x01, 0xB8,
	0x6D, 0xB7, 0xE4, 0xA7, 0x59, 0x2D, 0x4E, 0xB1, 0x9A, 0x76, 0x46, 0xD4,
	0x6E, 0xF2, 0xF5, 0x14, 0x9B, 0x34, 0xE3, 0xA7, 0x49, 0x3F, 0x7A, 0x69,
	0x86, 0x8F, 0xDB, 0xC4, 0x46, 0x6D, 0x64, 0x83, 0x34, 0xAD, 0xD4, 0x2A,
	0x01, 0xB7, 0x47, 0xE3, 0xEC, 0xAA, 0xDF, 0xDE, 0xF4, 0x95, 0x02, 0xB0,
	0x49, 0x0B, 0xB0, 0x30, 0x9B, 0xCF, 0xB6, 0x78, 0x67, 0x53, 0xB8, 0xB2,
	0x04, 0xC9, 0x33, 0x8C, 0xEA, 0xD5, 0x8A, 0x73, 0x2D, 0xBB, 0x77, 0xB5,
	0x27, 0xE8, 0x00, 0xD2, 0xE9, 0xAA, 0x94, 0xFA, 0x31, 0x49, 0xA6, 0x25,
	0xE8, 0x33, 0xC9, 0xB4, 0x60, 0xAA, 0xFC, 0x59, 0x26, 0xD7, 0xD0, 0x36,
	0x62, 0xD4, 0x42, 0x94, 0x80, 0x9B, 0xE8, 0xFC, 0x63, 0xAF, 0x63, 0x5E,
	0x29, 0xD4, 0x04, 0xF4, 0xD2, 0x7C, 0xAD, 0xAC, 0x4D, 0x18, 0x75, 0x69,
	0xE5, 0x0A, 0xBE, 0xC2, 0x23, 0x5A, 0x8B, 0xEC, 0xAD, 0xE5, 0x5A, 0x80,
	0xA9, 0xD2, 0x3E, 0x62, 0x9F, 0xDE, 0xFD, 0x9F, 0x1A, 0xF1, 0x0A, 0xDF,
	0xB7, 0x0F, 0xB3, 0x45, 0xB6, 0x9C, 0x95, 0x62, 0x31, 0xC6, 0xF9, 0xBA,
	0xDE, 0x4E, 0xC7, 0xBC, 0x51, 0x0B, 0x51, 0x03, 0xD2, 0xD8, 0xD9, 0x49,
	0xD0, 0x00, 0x10, 0xE2, 0x54, 0x34, 0x62, 0xF5, 0x00, 0x3E, 0xF1, 0xB5,
	0x4E, 0x57, 0xFB, 0xB6, 0x50, 0x0D, 0x98, 0x6C, 0xDC, 0x0D, 0x9D, 0xE2,
	0x25, 0xA1, 0xFE, 0x6D, 0x5C, 0xAB, 0xCE, 0x7C, 0x16, 0xE2, 0xF3, 0x28,
	0x7E, 0x65, 0x95, 0xCF, 0x36, 0x72, 0x9E, 0xB6, 0x10, 0x9F, 0x80, 0xEE,
	0x70, 0x66, 0x3F, 0x62, 0x04, 0x08, 0x69, 0x60, 0x37, 0x24, 0xDE, 0xB5,
	0xFB, 0x59, 0xBF, 0x26, 0x3A, 0x71, 0xAB, 0x09, 0x1B, 0x14, 0x80, 0x6B,
	0xA5, 0x66, 0x98, 0xA1, 0xFF, 0xBB, 0xC4, 0x12, 0xAC, 0xD1, 0xD7, 0x60,
	0x8A, 0x59, 0xFA, 0xD9, 0x23, 0x7C, 0x5E, 0x2F, 0x75, 0xF8, 0x63, 0x5A,
	0xAF, 0xA6, 0x33, 0x4D, 0x46, 0x05, 0x48, 0x73, 0x82, 0x01, 0x74, 0x1B,
	0x03, 0x5E, 0x54, 0x4C, 0x82, 0x76, 0x45, 0xFD, 0xB9, 0x03, 0x38, 0x0F,
	0xA4, 0xD5, 0xA5, 0x73, 0xB0, 0xC4, 0xF6, 0xE9, 0x6C, 0xAF, 0xCF, 0x88,
	0x83, 0xCE, 0x6E, 0xD8, 0x60, 0x49, 0xEA, 0xC5, 0x91, 0x9E, 0xE3, 0xBB,
	0x85, 0x18, 0x00, 0xDA, 0x03, 0xAD, 0x40, 0xF7, 0x57, 0xCC, 0x86, 0xCE,
	0xCB, 0x9E, 0x5D, 0x71, 0x6B, 0xBD, 0x81, 0x00, 0x26, 0x49, 0x55, 0xE3,
	0x4F, 0x69, 0xC5, 0x79, 0x7D, 0xA6, 0x50, 0x9C, 0x0D, 0x76, 0x53, 0x19,
	0x5F, 0x91, 0x16, 0xA0, 0x1A, 0x67, 0x89, 0xA1, 0x74, 0x6A, 0x31, 0x00,
	0x74, 0x06, 0x36, 0x07, 0x42, 0x0A, 0xE5, 0x2F, 0x7E, 0x95, 0xCA, 0x16,
	0xE0, 0xB7, 0xDE, 0x40, 0x00, 0xDD, 0xFA, 0xF3, 0x10, 0x0D, 0xBD, 0x2A,
	0xD3, 0xEB, 0x33, 0x49, 0xA2, 0x5B, 0x8D, 0x7F, 0x25, 0xE8, 0xD4, 0x6F,
	0x23, 0xEE, 0x52, 0x8A, 0x1B, 0x48, 0x05, 0x06, 0x05, 0x08, 0x08, 0x61,
	0x5B, 0x48, 0xA1, 0x3B, 0x20, 0xC0, 0x54, 0xFF, 0x96, 0x28, 0x39, 0xCC,
	0x55, 0x86, 0x93, 0xDA, 0x51, 0x9B, 0xD4, 0xDA, 0xED, 0xBE, 0xFE, 0x3C,
	0xB5, 0xA2, 0x52, 0xA9, 0x5B, 0xB7, 0x85, 0xE4, 0x78, 0x8D, 0x00, 0x43,
	0xE5, 0xAF, 0x24, 0xFB, 0x03, 0x18, 0xC4, 0x54, 0x20, 0xBB, 0x89, 0x73,
	0x7A, 0x03, 0x01, 0x64, 0x6B, 0x40, 0x3F, 0x87, 0x34, 0xBA, 0xC8, 0x99,
	0x7D, 0x4E, 0xFB, 0xE9, 0x50, 0x9B, 0xED, 0x10, 0x4D, 0x8D, 0xE8, 0x11,
	0x27, 0xBB, 0x27, 0x10, 0xE7, 0xF6, 0xE3, 0xB4, 0x20, 0x4E, 0xB7, 0x85,
	0x1C, 0x33, 0x04, 0x2C, 0x94, 0xBF, 0xE2, 0xF4, 0x03, 0x30, 0x83, 0x29,
	0xC0, 0x20, 0xB6, 0x07, 0x47, 0x07, 0x06, 0x68, 0xF3, 0x6F, 0xAC, 0xD9,
	0x44, 0x19, 0xF1, 0x60, 0x1F, 0x1F, 0xC1, 0xE8, 0xA7, 0x0A, 0xFA, 0x36,
	0x4D, 0xA9, 0xED, 0x88, 0x9E, 0xE1, 0x52, 0xBD, 0x36, 0x72, 0x66, 0x27,
	0x6D, 0x21, 0x06, 0x80, 0xA9, 0x75, 0xF2, 0x29, 0x30, 0xCD, 0x00, 0x50,
	0xBD, 0x10, 0x4C, 0x50, 0x9C, 0x97, 0x06, 0x06, 0x98, 0x2E, 0x4D, 0xD5,
	0xA7, 0x7D, 0x25, 0x47, 0x1C, 0x91, 0xE4, 0x4F, 0x6C, 0x33, 0x3A, 0x3D,
	0xDC, 0xED, 0x75, 0x2A, 0x44, 0x73, 0x82, 0xE3, 0x35, 0x11, 0x73, 0x74,
	0xDA, 0x48, 0x28, 0x1D, 0x19, 0x06, 0x80, 0x19, 0x41, 0xEC, 0x4E, 0xCE,
	0x18, 0x70, 0x65, 0x10, 0xBB, 0x0E, 0x64, 0xD7, 0x80, 0x01, 0x02, 0x42,
	0xA5, 0x04, 0x94, 0x5A, 0x6F, 0x7D, 0xFA, 0x4E, 0xA3, 0x8B, 0xC0, 0xD9,
	0x9D, 0xA4, 0x56, 0x4D, 0xB4, 0xC5, 0xAD, 0xD4, 0x9D, 0xEA, 0x32, 0xF5,
	0x5A, 0x88, 0x6F, 0xC0, 0x68, 0x7B, 0x2E, 0x73, 0x26, 0xBD, 0xD2, 0x18,
	0x70, 0x65, 0xC3, 0x47, 0x26, 0x4D, 0xEC, 0x14, 0x18, 0x20, 0x60, 0x69,
	0x80, 0x80, 0xD9, 0xA1, 0x78, 0xE8, 0x1A, 0x03, 0x7A, 0x57, 0x1E, 0x15,
	0x7E, 0xFD, 0x65, 0x6C, 0x6C, 0x0A, 0x4E, 0x19, 0x49, 0x95, 0xAD, 0x9E,
	0x95, 0x4A, 0x29, 0xE6, 0x93, 0xE2, 0xD6, 0x6F, 0x21, 0x6A, 0xC0, 0xC4,
	0x74, 0x3E, 0xE1, 0xEC, 0x46, 0xB8, 0xEE, 0x88, 0xD7, 0x08, 0xD0, 0x7D,
	0x3E, 0x88, 0xF5, 0xFB, 0x8A, 0x05, 0x54, 0xAC, 0xE6, 0x9A, 0x34, 0xB2,
	0x55, 0x0E, 0x58, 0x15, 0x20, 0x60, 0xA2, 0x1F, 0xD7, 0xC4, 0x2E, 0x4E,
	0xF1, 0x82, 0x60, 0x0E, 0xB0, 0x9C, 0x3A, 0xF5, 0x49, 0x99, 0xEF, 0x62,
	0x43, 0xB3, 0xE5, 0xB3, 0xAB, 0xF8, 0x75, 0x27, 0x73, 0xCE, 0x50, 0x5C,
	0x56, 0x96, 0x92, 0x12, 0x0B, 0x2D, 0x84, 0x02, 0x1A, 0xA7, 0xCE, 0xE9,
	0xD5, 0x06, 0x0C, 0xDA, 0x2A, 0xA4, 0xA9, 0x01, 0xF8, 0xD8, 0x34, 0xB0,
	0x80, 0x8A, 0x03, 0x01, 0x9D, 0xDB, 0x4A, 0x14, 0xD0, 0xA0, 0x9E, 0x8C,
	0x23, 0xD5, 0x19, 0xA9, 0x31, 0x4C, 0xF6, 0x1D, 0x68, 0xF0, 0xFB, 0x97,
	0xE2, 0x4F, 0xDA, 0x29, 0x3E, 0x44, 0x09, 0xA3, 0x45, 0xE2, 0x52, 0x79,
	0x0B, 0x39, 0x25, 0x60, 0x97, 0xD5, 0x06, 0x00, 0xF8, 0x55, 0x84, 0x57,
	0x05, 0x68, 0x9C, 0x54, 0xF6, 0x56, 0x48, 0xAA, 0x11, 0xE0, 0x7F, 0xE1,
	0x7A, 0xA6, 0x80, 0xFF, 0x89, 0x59, 0x69, 0xBA, 0x2D, 0xCA, 0xB9, 0xEF,
	0x62, 0x7C, 0x7D, 0x7D, 0xB6, 0x90, 0x1C, 0x91, 0x48, 0x98, 0x6D, 0x6C,
	0xBA, 0x84, 0x51, 0xB4, 0xD8, 0xC4, 0xAF, 0x2D, 0xD5, 0x28, 0x4B, 0xBA,
	0xBF, 0xFC, 0x7E, 0xD1, 0x8E, 0x1D, 0x3B, 0x16, 0x7F, 0xB3, 0x31, 0x6B,
	0x99, 0xDE, 0x59, 0x74, 0x30, 0x60, 0x07, 0x0E, 0x78, 0xC2, 0xCB, 0x02,
	0x2A, 0x8E, 0xD6, 0x28, 0xDB, 0xB9, 0x2F, 0xEA, 0x96, 0xE5, 0xE5, 0xE5,
	0xBD, 0x7F, 0xFF, 0xFE, 0x9C, 0x1C, 0x70, 0xE7, 0x3F, 0xA2, 0x5B, 0x9C,
	0x92, 0x92, 0xE3, 0x5C, 0xAA, 0xB1, 0x13, 0x61, 0x00, 0x21, 0x69, 0xF6,
	0x2A, 0x1D, 0xC2, 0x1A, 0xF1, 0xEC, 0xE2, 0x88, 0xF8, 0x95, 0x64, 0x3A,
	0x4F, 0x95, 0x89, 0x5F, 0xDB, 0x46, 0x01, 0x67, 0xA5, 0x1C, 0x78, 0xF3,
	0xE6, 0x0D, 0xD1, 0xFC, 0x86, 0x7A, 0x06, 0x05, 0xE3, 0x9B, 0xC2, 0x81,
	0x03, 0x06, 0x65, 0x7B, 0xD9, 0x21, 0xAC, 0x38, 0x3F, 0x02, 0x34, 0x08,
	0x7A, 0x2F, 0xCF, 0x39, 0xAD, 0x21, 0xBC, 0xFB, 0xA2, 0x71, 0xF6, 0x55,
	0x2D, 0x4E, 0x21, 0xA3, 0xF4, 0xD3, 0x77, 0x39, 0xA0, 0xA7, 0x11, 0x5A,
	0x81, 0x34, 0xD9, 0xCE, 0x9C, 0x94, 0xEF, 0x34, 0x04, 0x63, 0xC5, 0x15,
	0x5B, 0x8A, 0xF0, 0x85, 0x32, 0xB7, 0xD4, 0x42, 0xC4, 0x6B, 0xAA, 0xBC,
	0x0C, 0xA0, 0x5E, 0xD6, 0xAD, 0x7B, 0xB3, 0x23, 0x7D, 0xC3, 0x3F, 0x01,
	0x0C, 0x4F, 0x85, 0x2B, 0xCF, 0x7D, 0xF1, 0xC5, 0xB9, 0x73, 0x75, 0x75,
	0x13, 0xCB, 0x96, 0x81, 0x96, 0xE2, 0xCC, 0x9D, 0xB2, 0xB1, 0x80, 0xEA,
	0x26, 0x92, 0xE1, 0x35, 0x4C, 0xD4, 0x27, 0x21, 0xA7, 0xEC, 0x7A, 0x67,
	0xCC, 0x0C, 0x20, 0x83, 0x18, 0x7B, 0x4A, 0x55, 0x83, 0x6E, 0xC5, 0xB7,
	0x3D, 0xA6, 0xFA, 0x36, 0x4E, 0x63, 0x40, 0xAA, 0x18, 0xC5, 0x9E, 0xF9,
	0xBD, 0xF1, 0x23, 0xDF, 0xA4, 0x62, 0x6A, 0x46, 0xC7, 0x19, 0x20, 0x60,
	0x0D, 0x3D, 0xB9, 0x33, 0xCC, 0xE2, 0x4F, 0x42, 0x74, 0xCF, 0x55, 0xA5,
	0xF1, 0xAA, 0xF9, 0xDC, 0x9C, 0x2D, 0x56, 0xA8, 0x44, 0x96, 0x67, 0x6D,
	0x31, 0x6D, 0x23, 0xB4, 0x85, 0xD0, 0x9A, 0xA4, 0x80, 0x06, 0x29, 0x74,
	0x07, 0x08, 0x18, 0x44, 0xB6, 0x6D, 0x76, 0x46, 0x67, 0x6B, 0x20, 0x80,
	0xEC, 0x96, 0xD3, 0x28, 0xDB, 0xA4, 0xC1, 0xA7, 0xBB, 0xB9, 0x8D, 0xA5,
	0x80, 0x9A, 0x59, 0x9A, 0x99, 0x22, 0x03, 0x14, 0x97, 0x7E, 0x39, 0x8A,
	0x36, 0x62, 0xA3, 0xB3, 0x22, 0x03, 0x68, 0x98, 0xC4, 0x80, 0x00, 0xBF,
	0x71, 0x7A, 0x49, 0x36, 0x31, 0x3A, 0x09, 0x81, 0x01, 0xD2, 0xBD, 0x70,
	0x94, 0x21, 0xA0, 0xFD, 0x93, 0x10, 0xFD, 0x4B, 0x8B, 0x0D, 0x00, 0x21,
	0x9B, 0x64, 0x84, 0xC2, 0x09, 0x42, 0xBC, 0x58, 0x98, 0x36, 0x65, 0x0B,
	0xD1, 0x05, 0x0C, 0x87, 0x87, 0x03, 0x13, 0x73, 0x77, 0x28, 0x05, 0x83,
	0xFD, 0x07, 0x0C, 0x72, 0xBA, 0xC5, 0xC2, 0x60, 0x74, 0xEA, 0x14, 0x8F,
	0xCB, 0x38, 0xF9, 0xE4, 0xE9, 0x01, 0x3A, 0xE9, 0x92, 0xDF, 0x20, 0xB4,
	0xC5, 0xEA, 0x3E, 0x9F, 0xB8, 0xF4, 0x93, 0x21, 0x20, 0xF8, 0x24, 0x4A,
	0x57, 0x25, 0x29, 0x0A, 0xB7, 0xCC, 0xAD, 0x68, 0x21, 0xBA, 0x80, 0xC2,
	0x7E, 0x21, 0xB5, 0x50, 0x31, 0x0F, 0xD6, 0xFB, 0x03, 0xF8, 0xFE, 0x23,
	0xFB, 0x38, 0x21, 0xC6, 0xA1, 0xD1, 0x7E, 0x7E, 0xB6, 0x4E, 0x0F, 0xB0,
	0x9E, 0x6C, 0x1D, 0x52, 0xA0, 0xB7, 0xD6, 0x1A, 0x01, 0x96, 0x8A, 0x3F,
	0xA6, 0x61, 0x8D, 0x02, 0xA0, 0x2F, 0xC1, 0xDD, 0xD2, 0x18, 0x56, 0xFE,
	0xBE, 0x63, 0x6C, 0x0B, 0x31, 0x02, 0x84, 0x38, 0xD7, 0x31, 0x5F, 0xFF,
	0x4A, 0x1B, 0xB0, 0x2E, 0x42, 0x4C, 0xFC, 0xB6, 0x6C, 0xD5, 0x04, 0xC4,
	0x31, 0x80, 0x4D, 0x81, 0x01, 0xBA, 0x63, 0x8B, 0x8B, 0x15, 0x7F, 0x5C,
	0xA3, 0x09, 0x2E, 0x56, 0xFF, 0x84, 0xDE, 0x10, 0x90, 0xE4, 0xA2, 0xD4,
	0xCD, 0xC5, 0x73, 0x55, 0xDA, 0x46, 0x98, 0x16, 0x62, 0x0C, 0x08, 0xF5,
	0x3A, 0xCB, 0x24, 0x4E, 0x13, 0xF0, 0xA3, 0xEF, 0xB9, 0x89, 0x01, 0xCC,
	0xFB, 0x77, 0x40, 0x80, 0xF4, 0x87, 0xAE, 0x32, 0x02, 0x4C, 0x31, 0xBA,
	0x70, 0x65, 0xB1, 0x31, 0x20, 0x89, 0x34, 0xC9, 0x65, 0x48, 0xB3, 0x03,
	0x6D, 0x23, 0x99, 0xB4, 0x85, 0x18, 0x02, 0x12, 0x29, 0xE6, 0x85, 0x8D,
	0xEE, 0xC0, 0x01, 0xCF, 0xBC, 0x67, 0xB2, 0x35, 0x30, 0xC0, 0x38, 0x69,
	0x93, 0x1F, 0xE1, 0x27, 0x60, 0xAC, 0xD1, 0x3A, 0x11, 0x62, 0x3C, 0x19,
	0x90, 0xD4, 0x2B, 0x1B, 0xBC, 0x4D, 0xD9, 0x42, 0x8C, 0x01, 0xD3, 0xD8,
	0x56, 0x62, 0x0F, 0x14, 0x10, 0xB2, 0x9F, 0x01, 0x44, 0xDB, 0xFC, 0x06,
	0x64, 0x7B, 0xDE, 0x67, 0xA3, 0x21, 0x6C, 0x30, 0x07, 0xA6, 0x95, 0x19,
	0x03, 0x2A, 0xAA, 0x7E, 0x97, 0x72, 0x01, 0x59, 0xE6, 0xDE, 0xF4, 0x89,
	0x0E, 0x67, 0x43, 0x40, 0x12, 0x27, 0xF3, 0xCA, 0x8E, 0xDA, 0xC0, 0x01,
	0xCF, 0xB3, 0x25, 0x58, 0x97, 0xE1, 0x3F, 0x20, 0x5D, 0x75, 0x41, 0x82,
	0x03, 0xA9, 0x1B, 0x75, 0x0E, 0x7D, 0x32, 0x06, 0xA4, 0x5C, 0x24, 0xD9,
	0x12, 0x82, 0xB4, 0xB2, 0xA1, 0x2D, 0xC4, 0x5F, 0x40, 0xF7, 0x37, 0x6C,
	0x09, 0x06, 0x0E, 0xE8, 0x26, 0x3C, 0x34, 0xFB, 0xD3, 0x02, 0x01, 0xCC,
	0x2E, 0x96, 0xE6, 0xF4, 0x08, 0xFF, 0x96, 0x31, 0xDA, 0xF7, 0x9F, 0xF6,
	0x9D, 0x32, 0x06, 0x54, 0x14, 0x7D, 0x31, 0xBD, 0x3D, 0x27, 0x7E, 0xA9,
	0x4A, 0x6A, 0x21, 0xB5, 0x06, 0x80, 0xBA, 0x25, 0xE8, 0x0E, 0x10, 0x10,
	0xF2, 0xED, 0x7B, 0x36, 0x1F, 0xBF, 0xF7, 0x1B, 0x10, 0x12, 0x4A, 0x0F,
	0x99, 0xEA, 0xFD, 0x5A, 0x48, 0x97, 0xAD, 0xD4, 0x7A, 0x90, 0x80, 0x10,
	0x18, 0x2D, 0x15, 0x49, 0x8E, 0x89, 0x57, 0xED, 0xD4, 0x38, 0xC0, 0xA2,
	0x2D, 0xC4, 0x08, 0x90, 0x66, 0x23, 0x5B, 0x82, 0x81, 0x03, 0xC2, 0x2C,
	0xC8, 0x26, 0x6F, 0x6B, 0x9A, 0xFF, 0x80, 0xB5, 0x29, 0x54, 0xF0, 0x88,
	0x8F, 0xBA, 0xA1, 0x3D, 0x22, 0x47, 0xC3, 0x8F, 0x7E, 0x13, 0x52, 0xCC,
	0x89, 0xA9, 0x5E, 0xBD, 0x64, 0x94, 0x69, 0x94, 0xF2, 0x06, 0xC5, 0x59,
	0xC3, 0xA9, 0xA5, 0x06, 0x80, 0xFA, 0x25, 0xB8, 0xD8, 0x1D, 0x38, 0xE0,
	0xB6, 0xBC, 0xF7, 0x4A, 0xC2, 0x26, 0xD9, 0x5D, 0xB0, 0x6C, 0xDD, 0x9D,
	0x08, 0x49, 0xBC, 0xEC, 0x0F, 0x7F, 0x28, 0x4D, 0x6F, 0x17, 0x2B, 0xAF,
	0xB0, 0x43, 0x6E, 0xE5, 0xF8, 0x2D, 0x53, 0x9D, 0xDC, 0x97, 0xEA, 0xDC,
	0x0F, 0x3E, 0x13, 0xAB, 0x46, 0xA2, 0xCB, 0x67, 0xDA, 0x42, 0x0C, 0x01,
	0xF5, 0x67, 0xC1, 0xC0, 0x01, 0x61, 0x10, 0xAB, 0x83, 0x3E, 0x72, 0x09,
	0x27, 0x4E, 0x34, 0x14, 0xBE, 0x5B, 0xA6, 0xB3, 0x17, 0x96, 0x12, 0xFC,
	0x89, 0xA6, 0x2C, 0x6A, 0xAD, 0x5A, 0x2F, 0xF4, 0xCB, 0xEF, 0x14, 0x3F,
	0x5F, 0x34, 0x63, 0x92, 0x2E, 0x6E, 0x2D, 0xD8, 0x63, 0xE7, 0xC4, 0xB8,
	0x5A, 0x55, 0x1D, 0xDB, 0x29, 0x75, 0x0D, 0xD3, 0x09, 0x3F, 0x31, 0x39,
	0x66, 0x04, 0xC8, 0xC4, 0xCE, 0xBC, 0xF8, 0x8D, 0x3B, 0x60, 0x40, 0x7A,
	0xA8, 0x65, 0x1C, 0x0A, 0xA8, 0x33, 0x03, 0x15, 0xD7, 0x44, 0xD1, 0xEA,
	0xCD, 0xDE, 0x67, 0xA7, 0xE7, 0xA1, 0xCC, 0x18, 0x3D, 0x22, 0xE0, 0xD4,
	0x9E, 0x4F, 0x14, 0x2B, 0x38, 0x31, 0x49, 0x75, 0x74, 0x5F, 0x9A, 0x79,
	0x24, 0x83, 0xB6, 0x8A, 0x8B, 0xC9, 0x32, 0xE2, 0x62, 0x76, 0x94, 0x32,
	0xF8, 0x65, 0xEE, 0x80, 0x00, 0xDD, 0x8B, 0x99, 0x57, 0x9D, 0x01, 0x03,
	0x42, 0x4E, 0x04, 0x0E, 0x28, 0xCB, 0x21, 0xA5, 0x4F, 0xD9, 0x97, 0xBB,
	0x77, 0xEF, 0xFE, 0x9C, 0xA2, 0x98, 0x99, 0x18, 0xC9, 0x53, 0xB1, 0x55,
	0x35, 0x35, 0x55, 0xB2, 0x4B, 0x52, 0x32, 0x28, 0x20, 0xA3, 0x91, 0x52,
	0x55, 0x03, 0x57, 0x7E, 0xA9, 0x18, 0xE6, 0x8A, 0x53, 0xD9, 0x4C, 0xF9,
	0x6B, 0x36, 0xAF, 0x11, 0xA0, 0x41, 0x09, 0x06, 0x0A, 0x08, 0xD9, 0x1A,
	0x28, 0xA0, 0x6A, 0x17, 0x61, 0x9C, 0x1C, 0x5F, 0x2F, 0x16, 0xEF, 0x82,
	0x95, 0x8E, 0x51, 0xF4, 0x8D, 0x32, 0x4E, 0xC9, 0xFE, 0xBF, 0xD9, 0x10,
	0x20, 0xA0, 0x7B, 0x07, 0x5B, 0x82, 0x81, 0x03, 0x42, 0x9C, 0x79, 0x01,
	0x03, 0xB2, 0x6D, 0xC0, 0x38, 0x1B, 0x6A, 0x7C, 0xF8, 0x45, 0x78, 0x03,
	0x01, 0xCC, 0xD4, 0xDB, 0x9F, 0xD0, 0x16, 0x62, 0x0C, 0x48, 0x13, 0xAC,
	0x28, 0xC1, 0xC0, 0x01, 0x21, 0xDB, 0xDE, 0xF9, 0xE3, 0x97, 0x47, 0x6F,
	0xAC, 0x33, 0xC9, 0x4E, 0x54, 0x4E, 0x75, 0xEA, 0x5B, 0xE2, 0x19, 0x6E,
	0xDD, 0x1A, 0x4C, 0x59, 0xEA, 0x0D, 0x00, 0xB0, 0xEC, 0xBC, 0xFE, 0x21,
	0x0D, 0x64, 0x7B, 0xC0, 0x80, 0xB5, 0x8A, 0x12, 0x0C, 0x0C, 0x90, 0xB6,
	0x38, 0xC3, 0x22, 0xFC, 0x68, 0x4F, 0xD3, 0x7D, 0xC3, 0xF5, 0xC5, 0xDD,
	0xBE, 0x08, 0xCB, 0x92, 0xC9, 0x32, 0x3B, 0xF8, 0x94, 0xD6, 0x8B, 0xA7,
	0x92, 0xD3, 0x98, 0xCD, 0x4A, 0x8E, 0xCF, 0x7A, 0x3E, 0x95, 0x94, 0xE1,
	0xF3, 0x9E, 0x4B, 0x99, 0x3B, 0x40, 0x40, 0x48, 0x94, 0xE2, 0x50, 0x26,
	0x20, 0x40, 0x9A, 0xB4, 0xAD, 0x75, 0xBE, 0x06, 0x6F, 0xD3, 0x2E, 0xDF,
	0x6F, 0xF9, 0x8F, 0xCF, 0x29, 0xD6, 0xFE, 0x89, 0x3F, 0xDB, 0xF6, 0x49,
	0x6B, 0x9A, 0xC2, 0x53, 0xEA, 0x96, 0x5C, 0xAF, 0xBA, 0x2F, 0x9C, 0x9A,
	0x59, 0x55, 0xAC, 0xF7, 0xFF, 0xC4, 0x52, 0x83, 0xBD, 0x62, 0xB2, 0xD7,
	0x18, 0xD0, 0xA0, 0x04, 0xB7, 0x07, 0x0C, 0x48, 0xDF, 0x93, 0xDF, 0xB0,
	0x4C, 0x73, 0xE4, 0x72, 0x5B, 0x53, 0xFD, 0xF8, 0xD0, 0x09, 0xF7, 0xF9,
	0xA4, 0x58, 0x16, 0xA8, 0xAC, 0x34, 0xE9, 0xD8, 0x4A, 0x76, 0x29, 0x6C,
	0xFB, 0xF2, 0x14, 0xB3, 0xEA, 0xC9, 0x96, 0xA6, 0x81, 0x7A, 0x21, 0xFC,
	0xF7, 0x4A, 0x3D, 0x9D, 0x13, 0x5B, 0xCC, 0x52, 0xC7, 0x26, 0x1D, 0x71,
	0x1B, 0x6C, 0x91, 0x69, 0x0B, 0x61, 0x5E, 0xAD, 0x97, 0x27, 0x4D, 0x43,
	0x98, 0xB9, 0x00, 0xDE, 0xC6, 0x24, 0x4B, 0xA0, 0x9F, 0x50, 0x06, 0x6F,
	0x4B, 0x3A, 0x97, 0x47, 0xE9, 0xBE, 0x28, 0x3F, 0xE1, 0xDC, 0xE5, 0xF6,
	0xFF, 0x63, 0x4F, 0x6A, 0xE3, 0xE3, 0x82, 0x6D, 0x87, 0x92, 0x92, 0x6C,
	0xA1, 0xA7, 0x9D, 0x17, 0xD3, 0xB4, 0x2F, 0x89, 0x70, 0x06, 0xDB, 0x92,
	0x92, 0x33, 0x4F, 0xC3, 0x07, 0x38, 0x18, 0x64, 0x65, 0x84, 0xF3, 0x74,
	0x66, 0x32, 0x7C, 0xB7, 0x28, 0xFB, 0x31, 0x9F, 0x9F, 0x16, 0xE6, 0xA4,
	0x2D, 0xE4, 0xFF, 0x45, 0xFE, 0xBD, 0x61, 0x1B, 0x4E, 0xB6, 0x7B, 0x8E,
	0x7C, 0x6E, 0x0C, 0x3D, 0x2E, 0x8B, 0x5B, 0xF8, 0xE0, 0x9D, 0x7F, 0x92,
	0xA5, 0xF4, 0x5E, 0xC8, 0x02, 0x60, 0x80, 0x61, 0x37, 0x43, 0xB6, 0x85,
	0x8F, 0x7E, 0xFA, 0x27, 0xA9, 0xA5, 0x2D, 0x64, 0x01, 0xF0, 0xFF, 0xDA,
	0x39, 0xBF, 0x97, 0xC4, 0xD2, 0x38, 0x8C, 0xC3, 0x36, 0xBF, 0xC8, 0x19,
	0x6A, 0x89, 0x9A, 0x66, 0x71, 0x63, 0x58, 0x91, 0x28, 0x7F, 0x5C, 0x38,
	0x28, 0x65, 0x89, 0x82, 0x56, 0x72, 0x24, 0x84, 0xE1, 0x80, 0x3A, 0x8D,
	0x29, 0x4C, 0x53, 0x44, 0x17, 0x12, 0xAF, 0x1C, 0x26, 0x49, 0x82, 0x96,
	0x61, 0x6F, 0x86, 0xB9, 0x89, 0x15, 0x96, 0xD8, 0xAB, 0xD8, 0xF6, 0xC2,
	0x8B, 0xFE, 0x98, 0xFE, 0x97, 0xE7, 0xAE, 0xBE, 0x7B, 0xCE, 0x7B, 0x8E,
	0xBD, 0xC8, 0xFB, 0x82, 0x1D, 0xDD, 0x99, 0xDD, 0xE0, 0x7C, 0xAE, 0x7A,
	0xC8, 0xEF, 0x7B, 0x1E, 0x3E, 0x1C, 0x5F, 0x45, 0xE5, 0x75, 0x81, 0xFC,
	0x71, 0xED, 0xA5, 0x77, 0xF8, 0xD8, 0x30, 0x88, 0xEF, 0xB6, 0xCE, 0x3D,
	0x81, 0xC3, 0xF0, 0xA5, 0xE7, 0x6F, 0xC7, 0x3B, 0xFE, 0x6E, 0x18, 0x4E,
	0xEF, 0xDE, 0x6F, 0xFF, 0xED, 0x09, 0x1C, 0x82, 0xEE, 0x85, 0xF8, 0xC9,
	0x9B, 0x27, 0xD0, 0x3D, 0x57, 0xB7, 0xE2, 0x47, 0x97, 0xDE, 0x09, 0x96,
	0xF7, 0xE7, 0xE4, 0xC0, 0x62, 0xF7, 0xD7, 0x3F, 0x6E, 0xEE, 0xF8, 0xF9,
	0xDA, 0x13, 0x78, 0x7F, 0x6E, 0xE5, 0x4F, 0x7D, 0xF6, 0xBD, 0x33, 0x54,
	0x47, 0x12, 0xF8, 0x97, 0x77, 0x08, 0xED, 0x48, 0x02, 0xF7, 0xBA, 0x9E,
	0xC0, 0x51, 0x04, 0x5E, 0x74, 0xBD, 0x63, 0x90, 0x47, 0x10, 0x18, 0x6F,
	0xAE, 0x78, 0xE7, 0x48, 0x0F, 0x2F, 0x30, 0x7E, 0xB1, 0xEB, 0x1D, 0xC4,
	0xED, 0x96, 0x8B, 0xDF, 0x6D, 0xFE, 0xDC, 0x69, 0xAE, 0x5E, 0x79, 0x27,
	0x99, 0x7B, 0x27, 0x99, 0x7B, 0x78, 0x02, 0x3D, 0x81, 0x9E, 0x40, 0x4F,
	0xA0, 0x87, 0x27, 0xF0, 0xBF, 0x15, 0x78, 0xEC, 0x5B, 0xA3, 0x7F, 0x8F,
	0xA6, 0xAF, 0x2A, 0xA5, 0x07, 0x83, 0x68, 0xED, 0x46, 0x60, 0x07, 0xDB,
	0x7D, 0x79, 0xDB, 0xDF, 0x95, 0xD2, 0xBD, 0x39, 0x60, 0xF9, 0x92, 0x94,
	0x1E, 0x0C, 0xA2, 0xF5, 0x28, 0x02, 0x2F, 0xB1, 0x21, 0xA5, 0x7B, 0x33,
	0x83, 0xB4, 0x94, 0x1E, 0x0E, 0xA2, 0xF5, 0x28, 0x02, 0x67, 0xB0, 0x21,
	0xA5, 0xFB, 0xB2, 0x80, 0x86, 0x94, 0x1E, 0x0E, 0xA2, 0xB5, 0x6B, 0x81,
	0xED, 0x7A, 0xDA, 0xB1, 0xF8, 0xD6, 0xD0, 0x50, 0x30, 0x0C, 0x23, 0xAC,
	0x48, 0x07, 0x07, 0x74, 0xDD, 0x9A, 0xA8, 0x0B, 0xDF, 0x5F, 0x0D, 0xA3,
	0xFF, 0x77, 0x70, 0x0D, 0xB4, 0x94, 0xA9, 0x9B, 0xAD, 0xA7, 0x37, 0xA9,
	0xC7, 0xDA, 0x97, 0x50, 0x3A, 0x7C, 0x97, 0x4A, 0xBB, 0xFE, 0x74, 0x61,
	0x9C, 0x4C, 0x56, 0x8C, 0xF0, 0xDD, 0x79, 0x15, 0x07, 0x52, 0xCF, 0x53,
	0x63, 0x9B, 0xE8, 0xFD, 0x7C, 0x28, 0xDD, 0x56, 0x75, 0x79, 0xB5, 0xEA,
	0x7F, 0x41, 0x5D, 0x63, 0x9F, 0x14, 0x74, 0xAB, 0xF5, 0x54, 0xE1, 0x5A,
	0x5A, 0x45, 0x9A, 0x13, 0xAD, 0x5D, 0x0A, 0x3C, 0xA8, 0x00, 0x60, 0x3F,
	0xF0, 0x94, 0x87, 0x8D, 0xA6, 0x48, 0x19, 0x5C, 0x35, 0x00, 0xB0, 0x24,
	0x39, 0xBC, 0x04, 0xB2, 0x44, 0x82, 0x34, 0x66, 0x94, 0xC9, 0xAF, 0xC1,
	0x24, 0x9A, 0xB5, 0xE5, 0x44, 0x74, 0x2B, 0x55, 0xD6, 0x89, 0x93, 0x2A,
	0xF3, 0x0B, 0xF8, 0x89, 0xE8, 0x73, 0x00, 0x06, 0x71, 0xEA, 0x28, 0x4A,
	0x3D, 0xC3, 0xC8, 0x51, 0x2A, 0x00, 0x20, 0x2E, 0x77, 0x19, 0x8F, 0x30,
	0xA0, 0xB6, 0xD3, 0x46, 0x8E, 0x64, 0x52, 0xFC, 0xEA, 0xF9, 0x25, 0x69,
	0x15, 0x69, 0x4E, 0xB4, 0x76, 0x27, 0x30, 0x5E, 0xF4, 0x57, 0x9B, 0x3A,
	0xA6, 0xAD, 0xF4, 0x24, 0xC6, 0xD0, 0x8C, 0xC5, 0x62, 0x87, 0x24, 0xA7,
	0x00, 0x6E, 0x2A, 0x4B, 0x67, 0x31, 0x1D, 0x75, 0xB5, 0xC0, 0x52, 0x9E,
	0x19, 0xAA, 0xB4, 0x5A, 0xCB, 0xC4, 0xDA, 0x67, 0x49, 0x16, 0x38, 0xB7,
	0xD2, 0x73, 0x44, 0xFD, 0xED, 0xA5, 0x38, 0x82, 0x64, 0x51, 0x65, 0xF9,
	0xD0, 0xD9, 0xD9, 0x13, 0x8D, 0x15, 0xCC, 0xB0, 0x87, 0x1D, 0xE2, 0xDC,
	0x20, 0x45, 0x12, 0x01, 0x96, 0xD5, 0xCB, 0x6F, 0xC6, 0xF6, 0x8E, 0xE4,
	0x2E, 0x97, 0x28, 0x87, 0x36, 0x53, 0xF9, 0x19, 0x2C, 0x2B, 0xFC, 0xD5,
	0x32, 0x2F, 0x8D, 0xB3, 0x31, 0xA6, 0x17, 0xA4, 0x55, 0xE4, 0x39, 0xDE,
	0xDA, 0xB5, 0xC0, 0x46, 0x89, 0x97, 0x3F, 0xB6, 0x33, 0x73, 0x76, 0x3D,
	0x39, 0x75, 0x10, 0xED, 0x12, 0x51, 0x0C, 0x0D, 0xB5, 0xC0, 0x39, 0xBC,
	0x51, 0xA5, 0xF1, 0x3C, 0xFC, 0x76, 0xDB, 0x84, 0x7D, 0x57, 0x2F, 0x58,
	0xCF, 0x7E, 0x1D, 0x5B, 0x56, 0xFA, 0xD1, 0xDE, 0xB1, 0x97, 0x2A, 0x96,
	0xB1, 0x17, 0x2C, 0x70, 0x6A, 0xA5, 0x70, 0x4D, 0x2B, 0x91, 0x44, 0x0E,
	0xD1, 0xF8, 0x2F, 0xCA, 0x2E, 0xDD, 0x0E, 0x26, 0xAD, 0xF1, 0x8C, 0x42,
	0x60, 0x49, 0xB3, 0xAF, 0x30, 0x86, 0x8A, 0xB4, 0x8A, 0x3C, 0xC7, 0x5B,
	0xBB, 0x16, 0xC8, 0x2F, 0x30, 0x8D, 0xE2, 0x60, 0x81, 0x73, 0x7C, 0x0B,
	0x03, 0x3B, 0x25, 0xCE, 0x56, 0x36, 0xCB, 0xFF, 0xB2, 0xD9, 0x28, 0x67,
	0xB6, 0x55, 0xA9, 0x85, 0xBC, 0xBD, 0x63, 0x32, 0xFD, 0x19, 0xDF, 0x86,
	0xF8, 0x86, 0x17, 0x45, 0x95, 0x4C, 0xDE, 0xE0, 0x37, 0x12, 0x24, 0xC0,
	0xEF, 0xF5, 0x0B, 0x8C, 0x91, 0x4C, 0x05, 0x81, 0x75, 0x75, 0x97, 0x02,
	0xCA, 0x64, 0x11, 0x51, 0x08, 0x5C, 0x82, 0xC6, 0xB7, 0xBF, 0x8F, 0x60,
	0x8F, 0xFB, 0x57, 0x91, 0xE6, 0x44, 0x6B, 0x97, 0x02, 0xF7, 0xED, 0x0B,
	0x35, 0x06, 0x0B, 0xCC, 0x92, 0x45, 0x19, 0x06, 0x29, 0x48, 0xE2, 0xB9,
	0x32, 0xCD, 0xE1, 0x26, 0xCB, 0xD1, 0xD0, 0x26, 0x8B, 0xFD, 0x77, 0xA1,
	0x89, 0x4F, 0x1A, 0x16, 0xF8, 0xF6, 0x08, 0x96, 0x48, 0xAD, 0x93, 0x43,
	0x8B, 0x6F, 0x46, 0xA5, 0xB2, 0xFE, 0x8A, 0xC7, 0xEB, 0x12, 0x87, 0x6C,
	0x16, 0x11, 0x21, 0x75, 0x97, 0x34, 0x8A, 0x3C, 0xD4, 0x15, 0x02, 0x9B,
	0xF0, 0x11, 0x47, 0x43, 0xB5, 0x7F, 0x15, 0x69, 0x4E, 0xB4, 0x76, 0x29,
	0xF0, 0xD5, 0x7D, 0x04, 0x0A, 0xD5, 0x94, 0x47, 0x95, 0x64, 0xAE, 0x32,
	0x9D, 0xF7, 0xCA, 0x74, 0x89, 0x1E, 0xDC, 0x59, 0xBB, 0x21, 0x82, 0xC9,
	0xCB, 0x00, 0x50, 0xCB, 0x1D, 0x39, 0x0F, 0x6E, 0x58, 0x4B, 0xA7, 0x91,
	0xE8, 0xDD, 0x3D, 0x9C, 0x8D, 0x9E, 0xC0, 0x43, 0x52, 0x77, 0x79, 0x82,
	0xA0, 0xF3, 0x78, 0x59, 0xE0, 0xF3, 0xDE, 0x73, 0x32, 0x8A, 0xD5, 0xFE,
	0x55, 0xE4, 0x39, 0xDE, 0xFA, 0xBB, 0x08, 0xCC, 0x92, 0x04, 0x7F, 0x32,
	0x2A, 0x53, 0x13, 0xC5, 0xBA, 0x83, 0x79, 0xA5, 0xF5, 0x32, 0x12, 0xAD,
	0xAD, 0x95, 0x52, 0xCE, 0x11, 0x48, 0xA7, 0xFE, 0x48, 0x1E, 0xD0, 0xCE,
	0x9D, 0x7B, 0xE1, 0x98, 0x68, 0x11, 0x2D, 0xE2, 0x14, 0x1A, 0x9C, 0x95,
	0x9E, 0xC0, 0x14, 0xA9, 0xBB, 0x84, 0xB0, 0xC8, 0xC3, 0xA4, 0x42, 0x60,
	0x52, 0x08, 0x9C, 0xEC, 0x5F, 0x45, 0x9E, 0xE3, 0xAD, 0xBF, 0xA9, 0x40,
	0xE7, 0x85, 0x0C, 0x6F, 0x49, 0xC2, 0x60, 0xF9, 0x67, 0xEA, 0x14, 0x42,
	0x85, 0x04, 0x73, 0xC8, 0x5D, 0x8B, 0xD7, 0x12, 0x87, 0xF3, 0x20, 0x82,
	0xCE, 0x96, 0xAF, 0x3F, 0x3A, 0x61, 0x39, 0xEA, 0x47, 0x08, 0x54, 0x77,
	0x99, 0x77, 0xBA, 0xCF, 0x29, 0x04, 0xCE, 0x21, 0xD8, 0x9B, 0xD8, 0xEC,
	0x5F, 0x45, 0x9A, 0x13, 0xAD, 0x47, 0x14, 0xF8, 0x98, 0x38, 0x52, 0xEA,
	0x60, 0x82, 0x4C, 0x4E, 0xA0, 0x97, 0x88, 0x33, 0x1B, 0x0A, 0xAD, 0x91,
	0xC3, 0x0C, 0xEA, 0xC4, 0x91, 0x52, 0x18, 0x01, 0xFB, 0xED, 0xF6, 0x06,
	0x99, 0xEC, 0x21, 0xC2, 0xBB, 0xC2, 0x11, 0x68, 0x2F, 0xFF, 0x15, 0x1A,
	0x71, 0x8E, 0x10, 0x4B, 0xE2, 0x70, 0xA0, 0xC0, 0xFE, 0x2E, 0x6F, 0xA1,
	0xF3, 0xBB, 0xB4, 0xC8, 0x45, 0xF4, 0x37, 0xCB, 0xA2, 0xC3, 0xDB, 0x1E,
	0x20, 0x53, 0xEA, 0x5F, 0x45, 0x9A, 0xE3, 0xAD, 0x47, 0x17, 0x18, 0x70,
	0x9E, 0xA0, 0x72, 0xEA, 0x20, 0x67, 0x75, 0x48, 0x22, 0x28, 0xBF, 0x8D,
	0x59, 0xB0, 0x6F, 0x2C, 0x65, 0x2A, 0xDA, 0x3B, 0x73, 0x55, 0x4F, 0x70,
	0x43, 0x15, 0x22, 0x3A, 0x5D, 0x0E, 0xE0, 0x29, 0x11, 0x3D, 0xD3, 0xB4,
	0x29, 0x32, 0xD9, 0x44, 0x91, 0x38, 0x6B, 0x99, 0xA8, 0xD6, 0x59, 0x19,
	0x20, 0x50, 0xEA, 0x12, 0xC5, 0x98, 0x55, 0xA7, 0x83, 0x65, 0xB9, 0x59,
	0xD4, 0x7E, 0xBD, 0x3E, 0x46, 0x44, 0x5E, 0x45, 0xCC, 0x89, 0xD6, 0x23,
	0x0B, 0x0C, 0x42, 0xFB, 0x90, 0x8C, 0x2C, 0xD6, 0xE5, 0x64, 0x5E, 0xA7,
	0x18, 0x9A, 0xDF, 0x63, 0x7A, 0x56, 0xAE, 0xD9, 0xC0, 0x12, 0x71, 0x14,
	0xC9, 0x08, 0xC0, 0x57, 0xAF, 0xEF, 0xE8, 0x6C, 0xDA, 0x0C, 0x6D, 0x86,
	0x48, 0xAA, 0x99, 0x4F, 0x1C, 0x23, 0xF8, 0x65, 0x9C, 0xE8, 0x16, 0x8D,
	0x4F, 0xF3, 0xFE, 0x23, 0x8D, 0x3D, 0x25, 0x9B, 0x08, 0xF0, 0x81, 0x06,
	0x08, 0x94, 0xBA, 0x4C, 0x32, 0xE4, 0x12, 0xB9, 0xCE, 0xA1, 0x4A, 0x60,
	0x55, 0x67, 0xB7, 0xEF, 0xEA, 0x3E, 0x68, 0xAF, 0xE5, 0x55, 0xC4, 0x9C,
	0x68, 0x3D, 0xB2, 0xC0, 0x93, 0x22, 0x4C, 0xB4, 0x69, 0x39, 0x75, 0x60,
	0xF8, 0x98, 0x19, 0xFC, 0x24, 0xD5, 0x4C, 0x89, 0x7D, 0x4E, 0x24, 0x61,
	0xB0, 0xC2, 0x00, 0x34, 0xEC, 0x7A, 0x13, 0x01, 0x40, 0xDF, 0x99, 0x3A,
	0xEB, 0x80, 0x4D, 0x11, 0x75, 0x93, 0x1D, 0x98, 0xE4, 0x7A, 0xFE, 0xC8,
	0x40, 0x2D, 0x3C, 0x48, 0xA0, 0xDC, 0xA5, 0xE5, 0x8B, 0xE6, 0x22, 0x2F,
	0x16, 0x50, 0x94, 0x05, 0x52, 0x76, 0xB9, 0x06, 0xE8, 0x89, 0x6D, 0xC5,
	0x2A, 0x62, 0x4E, 0xB4, 0x76, 0x2D, 0x50, 0x66, 0xBD, 0x3D, 0xFB, 0x59,
	0x95, 0x3A, 0xD8, 0xA6, 0x47, 0x85, 0xD9, 0x2E, 0xC9, 0x84, 0x5B, 0x5B,
	0x8A, 0x24, 0x78, 0xBF, 0x59, 0x78, 0x4D, 0x0E, 0x53, 0x9B, 0x05, 0x6B,
	0x37, 0x2C, 0x5D, 0xD9, 0x3B, 0xE3, 0xF5, 0x7E, 0x96, 0xFF, 0xCF, 0xA1,
	0x85, 0x0A, 0x0D, 0x46, 0xDD, 0x65, 0x1E, 0x8B, 0xA4, 0xE2, 0x75, 0xA1,
	0xBD, 0x42, 0x4A, 0xC4, 0x1C, 0x6F, 0x3D, 0xB2, 0xC0, 0xC1, 0xA5, 0xBF,
	0x39, 0x33, 0x98, 0x74, 0xDF, 0x65, 0x76, 0x62, 0x95, 0x4C, 0x92, 0xF8,
	0x40, 0x2E, 0x90, 0xE7, 0x1E, 0xBE, 0xC0, 0xEE, 0x18, 0x6E, 0x86, 0xE8,
	0x92, 0x46, 0xD9, 0x20, 0x2A, 0x04, 0x6A, 0xBB, 0xE4, 0x02, 0x69, 0xEE,
	0xC1, 0x0B, 0xFC, 0x98, 0x2B, 0x43, 0x3B, 0x19, 0xA2, 0xCB, 0x75, 0x02,
	0x2C, 0x1A, 0x65, 0x48, 0x92, 0x3B, 0xC4, 0xDC, 0x77, 0x11, 0xB8, 0xB8,
	0xBC, 0x45, 0xDF, 0x94, 0xB5, 0x78, 0x7C, 0xEF, 0xA7, 0xE1, 0xBA, 0x4C,
	0x1F, 0xDF, 0x54, 0x22, 0x0B, 0xE4, 0x0A, 0x31, 0xE7, 0x7D, 0xAD, 0xE9,
	0x7D, 0x2F, 0xEC, 0x09, 0xF4, 0x04, 0x7A, 0x78, 0x02, 0x3D, 0x81, 0xFF,
	0x6F, 0xFE, 0x01, 0xF0, 0xF9, 0x02, 0x13, 0x9B, 0x76, 0x45, 0xBF, 0x00,
	0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82
};

Scene_Logo::Scene_Logo() :
	frame_counter(0) {
	type = Scene::Logo;
}

void Scene_Logo::Start() {
	logo.reset(new Sprite());
	if (!Player::debug_flag) {
		logo_img = Bitmap::Create(easyrpg_logo, sizeof(easyrpg_logo), false);
		logo->SetBitmap(logo_img);
	}
}

void Scene_Logo::Update() {
	if (frame_counter == 0) {
		Player::CreateGameObjects();
	}

	++frame_counter;

	if (Player::debug_flag ||
		frame_counter == 60 ||
		Input::IsTriggered(Input::DECISION) ||
		Input::IsTriggered(Input::CANCEL)) {
		Scene::Push(EASYRPG_MAKE_SHARED<Scene_Title>(), true);
		if (Player::new_game_flag) {
			Player::SetupPlayerSpawn();
			Scene::Push(EASYRPG_MAKE_SHARED<Scene_Map>());
		}
		else if (Player::load_game_id > 0) {
			std::stringstream ss;
			ss << "Save" << (Player::load_game_id <= 9 ? "0" : "") << Player::load_game_id << ".lsd";

			std::string save_name = FileFinder::FindDefault(ss.str());
			Player::LoadSavegame(save_name);
			Scene::Push(EASYRPG_MAKE_SHARED<Scene_Map>(true));
		}
	}
}
