/***********************************************************
	TestString.cpp
	Test harness for String.h
	
	This is the only part of the test system which is unique 
	to testing String.

	Written by Ben Stanley 20000815 bstanley@uow.edu.au	

	Part of CUJ article on Exception Testing.
************************************************************/

#include "String.h"
#include "Counter.h"

class TestDefaultConstruct
{
public:
	static void DoTest() {
		String s;
		Counter::Test( s == "", "Correct string value" );	
	}
};

class TestConversionConstruct
{
public:
	static void DoTest() {
		String s("Hello");
		Counter::Test( s == "Hello", "Correct string value" );	
	}
};

class TestEquivalenceOp
{
public:
	static void DoTest() {
		String s1("What");
		String s2("Hello");
		String s3("Hallo");
		String s4;
		Counter::Test( s1 == "What", "Correct string value" );	
		Counter::Test( s2 == "Hello", "Correct string value" );	
		Counter::Test( s3 == "Hallo", "Correct string value" );	
		Counter::Test( s4 == "", "Correct string value" );	
		Counter::Test( !(s1 == "Where"), "Different string value" );	
		Counter::Test( !(s2 == "Where"), "Different string value" );	
		Counter::Test( !(s3 == "Where"), "Different string value" );	
		Counter::Test( !(s4 == "Where"), "Different string value" );	
	}
};

class TestCopyConstruct
{
public:
	static void DoTest() {
		String s1;
		String s2("Hello");
		{
			String s3 = s1;
			String s4 = s2;
			Counter::Test( s3 == "", "Correct string value" );
			Counter::Test( s4 == "Hello", "Correct string value" );
		}
		Counter::Test( s1 == "", "original string value" );
		Counter::Test( s2 == "Hello", "original string value" );
	}
};

class TestAssignOp
{
public:
	static void DoTest() {
		String s1;
		String s2("Hello");
		{
			String s3, s4;
			s3 = s1;
			s4 = s2;
			Counter::Test( s3 == "", "Correct string value" );
			Counter::Test( s4 == "Hello", "Correct string value" );
		}
		Counter::Test( s1 == "", "original string value" );
		Counter::Test( s2 == "Hello", "original string value" );
	}
};

class TestPlusOp
{
public:
	static void DoTest() {
		String s1("There");
		String s2("Hello");
		String s3, s4;
		s3 = s2 + " " + s1;
		s4 = s2 + " blah.";
		Counter::Test( s3 == "Hello There", "Correct string value" );	
		Counter::Test( s4 == "Hello blah.", "Correct string value" );	
	}
};

int main( int argc, char* argv[] )
{
	TestDriver<TestDefaultConstruct>();
	TestDriver<TestConversionConstruct>();
	TestDriver<TestEquivalenceOp>();
	TestDriver<TestCopyConstruct>();
	TestDriver<TestAssignOp>();
	TestDriver<TestPlusOp>();

	Counter::PrintTestSummary();

	return 0;
}

