/***********************************************************
	TestFunction.cpp
	Test harness for Function.cpp
	
	Tests all 3 normal paths of execution through the function
	EvaluateSalaryAndReturnName. Also tests all the exceptional
	paths, through the use of the TestDriver template function.
	
	This is the only part of the test system which is unique 
	to testing EvaluateSalaryAndReturnName.

	Written by Ben Stanley 20000815 bstanley@uow.edu.au	
************************************************************/

#include "Function.h"
#include "Counter.h"

using namespace std;

class TestPath1
{
public:
	static void DoTest() {
		// To test this properly would require capturing the output of cout...
		String s;
		s = EvaluateSalaryAndReturnName( 
			Employee(
			"Homer",
			"Simpson",
			"Nuclear Plant Controller",
			25000 ) 
			);
		Counter::Test( s == "Homer Simpson", "Correct return value" );	
	}
};

class TestPath2
{
public:
	static void DoTest() {
		// To test this properly would require capturing the output of cout...
		String s;
		s = EvaluateSalaryAndReturnName( 
			Employee(
			"John",
			"Doe",
			"CEO",
			50000 ) 
			);
		Counter::Test( s == "John Doe", "Correct return value" );	
	}
};

class TestPath3
{
public:
	static void DoTest() {
		// To test this properly would require capturing the output of cout...
		String s;
		s = EvaluateSalaryAndReturnName( 
			Employee(
			"Mr",
			"Burns",
			"CEO",
			200000 ) 
			);
		Counter::Test( s == "Mr Burns", "Correct return value" );	
	}
};

int main( int argc, char* argv[] )
{
	TestDriver<TestPath1>();
//	TestDriver<TestPath2>();
//	TestDriver<TestPath3>();

	Counter::PrintTestSummary();

	return 0;
}

