/**************************************************
	String.h
	Simple string class written to go with the
	EvaluateSalaryAndReturnName function.
	
	Written by Ben Stanley 20000815 bstanley@uow.edu.au
**************************************************/
#ifndef STRING_H
#define STRING_H

#include <cstring>
#include <iostream>

class String
{
public:
	String()
	: mData( new char[1] ) 
	{
		mData[0] = '\0';
	}

	String( const char* inString ) 
	: mData( new char[strlen(inString)+1])
	{
		std::strcpy( mData, inString );
	}

	String( const String& other ) 
	: mData( new char[strlen(other.mData)+1] ) 
	{
		std::strcpy( mData, other.mData );
	}

	~String() {
		delete [] mData;
	}
	
	String& operator=( const String& rhs ) {
		if( this != &rhs ) {
			char* tmp = new char[strlen(rhs.mData)+1];
			std::strcpy( tmp, rhs.mData );
			delete [] mData;
			mData = tmp;
		}
		return *this;
	}

	bool operator==( const char* other ) {
		return std::strcmp( mData, other ) == 0;
	}
	
	String operator+( const String& rhs ) {
		String lhs;
		char *tmp = new char[ strlen(this->mData) + strlen( rhs.mData ) + 1 ];
		std::strcpy( tmp, this->mData );
		std::strcat( tmp, rhs.mData );
		delete [] lhs.mData;
		lhs.mData = tmp;
		return lhs;
	}
	
	String operator+( const char* rhs ) {
		String lhs;
		char* tmp = new char[ strlen(this->mData) + strlen( rhs ) + 1 ];
		delete [] lhs.mData;
		lhs.mData = tmp;
		std::strcpy( lhs.mData, this->mData );
		std::strcat( lhs.mData, rhs );
		return lhs;
	}

	friend ostream& operator<<( std::ostream&, String );
private:
    char* mData;
};

inline std::ostream& operator<<( std::ostream& os, String s )
{
     return os << s.mData;
}

#endif // STRING_H
