/*****************************************************
TestClass.h
A class which can throw exceptions from any possible 
user defined function.

This class will throw exceptions from every possible 
place where user defined operators can throw 
exceptions from. It is designed this way for testing
template classes.

It is designed to be able to be used like an int.
It is not designed to act like a pointer or an array,
as that does not seem sensible for an int.

Thanks to Herb Sutter for comments on the contents 
of this file.

Copyright Ben Stanley 20000815 bstanley@uow.edu.au
Permission is hereby granted to re-use at your own risk.
No warranty is provided.
Original author must be acknowledged.

Modified 20001101 to include feedback from Herb Sutter.

Part of CUJ article on Exception Testing.
******************************************************/

#ifndef TESTCLASS_H
#define TESTCLASS_H

#include "Counter.h"

class TestClass {
public:
	TestClass( int inVal = 0 ) 
	:	mVal( inVal )
	{ 
		Counter::CouldThrow();
	}

	TestClass( const TestClass& other ) 
	:	mVal( other.mVal )
	{ 
		Counter::CouldThrow(); 
	}

	~TestClass() {}

	TestClass& operator=( const TestClass& other )
	{ 
		Counter::CouldThrow();
		mVal = other.mVal;
		return *this;
	}

	bool operator==( const TestClass& other ) { 
		Counter::CouldThrow();
		return other.mVal == this->mVal;
	}
	
	bool operator!=( const TestClass& other ) {
		Counter::CouldThrow();
		return other.mVal != this->mVal;
	}
		
	bool operator<( const TestClass& other ) {
		Counter::CouldThrow();
		return other.mVal < this->mVal; 
	}

	bool operator<=( const TestClass& other ) {
		Counter::CouldThrow();
		return other.mVal <= this->mVal;
	}

	bool operator>( const TestClass& other ) {
		Counter::CouldThrow();
		return other.mVal > this->mVal;
	}

	bool operator>=( const TestClass& other ) {
		Counter::CouldThrow();
		return other.mVal >= this->mVal;
	}
	
	TestClass operator++() {
		Counter::CouldThrow();
		return ++mVal;
	}

	TestClass operator++(int) {
		Counter::CouldThrow();
		return mVal++;
	}

	TestClass operator--() {
		Counter::CouldThrow();
		return --mVal;
	}

	TestClass operator--(int) {
		Counter::CouldThrow();
		return mVal--;
	}

	TestClass& operator+=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal += other.mVal;
		return *this;
	}

	TestClass& operator-=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal -= other.mVal;
		return *this;
	}

	TestClass& operator*=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal *= other.mVal;
		return *this;
	}

	TestClass& operator/=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal /= other.mVal;
		return *this;
	}

	TestClass& operator%=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal %= other.mVal;
		return *this;
	}

	TestClass& operator<<=( int ) {
		Counter::CouldThrow();
		mVal <<= other.mVal;
		return *this;
	}

	TestClass& operator>>=( int ) {
		Counter::CouldThrow();
		mVal >>= other.mVal;
		return *this;
	}

	TestClass operator+( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal+other.mVal;
	}

	TestClass operator-( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal-other.mVal;
	}

	TestClass operator*( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal*other.mVal;
	}

	TestClass operator/( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal/other.mVal;
	}

	TestClass operator%( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal%other.mVal;
	}

	TestClass operator<<( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal << other.mVal;
	}

	TestClass operator>>( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal >> other.mVal;
	}

	const TestClass* operator&() const {
		Counter::CouldThrow();
		return this;
	}

	TestClass* operator&() {
		Counter::CouldThrow();
		return this;
	}

	bool operator!() const {
		Counter::CouldThrow();
		return !mVal;
	}

	TestClass operator~() const {
		Counter::CouldThrow();
		return ~mVal;
	}

	TestClass& operator|=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal |= other.mVal;
		return *this;
	}

	TestClass& operator&=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal &= other.mVal;
		return *this;
	}

	TestClass& operator^=( const TestClass& other ) {
		Counter::CouldThrow();
		mVal ^= other.mVal;
		return *this;
	}

	TestClass operator|( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal | other.mVal;
	}

	TestClass operator&( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal & other.mVal;
	}

	TestClass operator^( const TestClass& other ) const {
		Counter::CouldThrow();
		return mVal ^ other.mVal;
	}

	// Don't need to overload class operator new,
	// because we already required that the global
	// operator new be overloaded to call 
	// Counter::CouldThrow().


	// remaining:
	// 
	// Pointer-like functions:
	// I recommend that if you need these you invent
	// a new version of this class which is designed 
	// to act like a pointer.
	// 
	// ->*
	// This does pointer to member selection by variable.
	// I suppose it could throw, but this is used on a
	// pointer-like variable, not an int.

	// -> Member selection
	// I suppose that could throw, but again the lhs is
	// usually a pointer-like variable.

	// * pointer dereference
	// This could throw, but it can't be used on a 
	// non-pointer.

	// () class function
	// ints can't do this. If you can think of a good reason
	// that you need it, then you should add in something like this:
	// TestClass operator()() const {
	// 	Counter::CouldThrow();
	// 	return mVal;
	// }


	// Array stuff.
	// This class is not designed to act or pretend to be an array.
	// 
	// [] array dereference
	// This would be useful if you were testing an array-like class.
	// However, this class makes no claims to be array-like.
	// Herb Sutter suggests the following kludge:
	// TestClass operator[]( size_t s ) const {
	// 	Counter::CouldThrow();
	// 	return mVal+s;
	// }
	// Note, however, that there is no equivalent kludge where
	// the array is used as an lvalue. I suggest that you
	// instrument a real array class, or better still, instantiate
	// a vector of TestClass if you need to test that kind 
	// of thing.
	
private:
	int mVal;
};

// I have considered that it is not really desireable to add any 
// more functionality to this class which might result in silent
// automatic conversions etc. If you need a particular method,
// you may wish to add it.


#endif // TESTCLASS_H
