#include <streambuf>

template <class Sequence>
class sequencebuf : public std::streambuf {
private:
  Sequence seq;

  enum { bufsize = 128 };
  char buf[bufsize];

public:
  sequencebuf(const Sequence& s);
  const Sequence& get_seq();

protected:
  int sync();
  int overflow(int c);
};

template <class Sequence>
sequencebuf<Sequence>::sequencebuf(const Sequence& s)
  : std::streambuf(), seq(s)
{
  setp(buf, buf + bufsize);
}

template <class Sequence>
const Sequence& sequencebuf<Sequence>::get_seq()
{
  sync();
  return seq;
}

template <class Sequence>
int sequencebuf<Sequence>::sync()
{
  seq.insert(seq.end(), pbase(), pptr());
  setp(buf, buf + bufsize);
  return 1;
}

template <class Sequence>
int sequencebuf<Sequence>::overflow(int c)
{
  sync();
  if (c != EOF) {
    *pptr() = static_cast<unsigned char>(c);
    pbump(1);
  }
  return 1;
}


