/********************************************************************************
*                                                                               *
*                                 Data Target Test                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* $Id: datatarget.cpp,v 1.5 2000/01/12 14:02:00 jeroen Exp $                    *
********************************************************************************/
#include "fx.h"


/*******************************************************************************/


// Mini application object
class DataTargetWindow : public FXMainWindow {
  FXDECLARE(DataTargetWindow)
protected:
  FXMenuBar*         menubar;
  FXMenuPane*        filemenu;
  FXMenuPane*        optionmenu;
  FXMatrix*          matrix;
  FXint              some_int;
  FXdouble           some_double;
  FXint              some_option;
  FXString           some_string;
  FXColor            some_color;
  FXint              some_progress;
  FXDataTarget*      int_target;
  FXDataTarget*      double_target;
  FXDataTarget*      string_target;
  FXDataTarget*      option_target;
  FXDataTarget*      color_target;
  FXDataTarget*      progress_target;
public:
  long onCmdTimer(FXObject*,FXSelector,void*);
public:
  DataTargetWindow(){}
public:
  enum {
    ID_TIMER=FXMainWindow::ID_LAST
    };
public:
  DataTargetWindow(FXApp *a);
  void create();
  };


  
/*******************************************************************************/
  
// Map
FXDEFMAP(DataTargetWindow) DataTargetWindowMap[]={
  FXMAPFUNC(SEL_TIMEOUT,DataTargetWindow::ID_TIMER,DataTargetWindow::onCmdTimer),
  };


// Object implementation
FXIMPLEMENT(DataTargetWindow,FXMainWindow,DataTargetWindowMap,ARRAYNUMBER(DataTargetWindowMap))
  


// Make some windows
DataTargetWindow::DataTargetWindow(FXApp* a):FXMainWindow(a,"Data Target Test",NULL,NULL,DECOR_ALL,0,0,0,0){
  
  // Initialize some simple variables
  some_int = 10;
  some_double = 3.1415927;
  some_string = "FOX";
  some_color = FXRGB(255,0,0);
  some_option = 1;
  some_progress = 0;
  
  
  // Make INTEGER target
  int_target = new FXDataTarget(some_int);
  
  // Make DOUBLE target
  double_target = new FXDataTarget(some_double);
  
  // Make STRING target
  string_target = new FXDataTarget(some_string);
  
  // Make COLOR target
  color_target = new FXDataTarget(some_color);
  
  // Make option target
  option_target = new FXDataTarget(some_option);
  
  // Make progress target
  progress_target = new FXDataTarget(some_progress);
  
  // Menubar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // File menu
  filemenu=new FXMenuPane(this);
    new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,getApp(),FXApp::ID_QUIT,0);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  
  // Option menu
  optionmenu=new FXMenuPane(this);
    new FXMenuCommand(optionmenu,"Option 1",NULL,option_target,FXDataTarget::ID_OPTION+1);
    new FXMenuCommand(optionmenu,"Option 2",NULL,option_target,FXDataTarget::ID_OPTION+2);
    new FXMenuCommand(optionmenu,"Option 3",NULL,option_target,FXDataTarget::ID_OPTION+3);
    new FXMenuCommand(optionmenu,"Option 4",NULL,option_target,FXDataTarget::ID_OPTION+4);
  new FXMenuTitle(menubar,"&Option",NULL,optionmenu);
  
  // Lone progress bar at the bottom
  new FXProgressBar(this,progress_target,FXDataTarget::ID_VALUE,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK);
  
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  
  new FXLabel(this,
    "FXDataTarget can be used to connect a Widget to an application variable without any of the\n"
    "tradional \"glue\" programming code.\n\n"
    "The widgets below are connected (via FXDataTarget) to an integer, real, string, option, and\n"
    "color variable, respectively.\n\n"
    "Changing one of them will cause all widgets connected to the same FXDataTarget to \n"
    "update so as to reflect the value of the application variable.\n\n"
    "The progress bar below shows a time-varying variable, demonstrating that widgets\n"
    "can be updated via FXDataTarget's regardless how the variables are changed.\n\n"
    "Note that the \"Option\" pulldown menu is also connected to the option variable!",  
    NULL,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|JUSTIFY_LEFT);
    
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  
  // Arange nicely
  matrix=new FXMatrix(this,7,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  // First row
  new FXLabel(matrix,"&Integer",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  new FXSlider(matrix,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH,0,0,100);
  new FXDial(matrix,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH|DIAL_HORIZONTAL|DIAL_HAS_NOTCH,0,0,100);
  new FXSpinner(matrix,5,int_target,FXDataTarget::ID_VALUE,FRAME_SUNKEN|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_FILL_ROW);
  new FXProgressBar(matrix,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK|PROGRESSBAR_PERCENTAGE|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Second row
  new FXLabel(matrix,"&Real",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  new FXSlider(matrix,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH,0,0,100);
  new FXDial(matrix,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH|DIAL_HORIZONTAL|DIAL_HAS_NOTCH,0,0,100);

  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Third row
  new FXLabel(matrix,"&String",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,string_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,string_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Fourth row
  new FXLabel(matrix,"&Option",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,option_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  new FXRadioButton(matrix,"Option &1",option_target,FXDataTarget::ID_OPTION+1,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
  new FXRadioButton(matrix,"Option &2",option_target,FXDataTarget::ID_OPTION+2,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
  new FXRadioButton(matrix,"Option &3",option_target,FXDataTarget::ID_OPTION+3,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
  new FXRadioButton(matrix,"Option &4",option_target,FXDataTarget::ID_OPTION+4,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Fifth
  new FXLabel(matrix,"&Color",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXColorWell(matrix,0,color_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW,0,0,0,0, 0,0,0,0);
  new FXColorWell(matrix,0,color_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW,0,0,0,0, 0,0,0,0);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Install an accelerator
  getAccelTable()->addAccel(fxparseaccel("Ctl-Q"),getApp(),MKUINT(FXApp::ID_QUIT,SEL_COMMAND));
  }


// Timer  
long DataTargetWindow::onCmdTimer(FXObject*,FXSelector,void*){
  
  // Increment modulo 100
  some_progress=(some_progress+1)%100;
  
  // Reset timer for next time
  getApp()->addTimeout(80,this,ID_TIMER);
  return 1;
  }


// Start
void DataTargetWindow::create(){
  
  // Create windows
  FXMainWindow::create();
  
  // Kick off the timer
  getApp()->addTimeout(80,this,ID_TIMER);
  
  // Show
  show();
  }


/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp* application=new FXApp("DataTarget","Test");
  
  // Open display
  application->init(argc,argv);
  
  // Main window
  new DataTargetWindow(application);
  
  // Create app
  application->create();
  
  // Run
  application->run();
  }
