/********************************************************************************
*                                                                               *
*                  U n d o / R e d o - a b l e   C o m m a n d                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXUndoList.cpp,v 1.3 2000/02/20 19:17:51 jeroen Exp $                    *
********************************************************************************/
#include "fxver.h"
#include "fxdefs.h"
#include "FXUndoList.h"

/*
  Notes:
  - Manages a simple undo/redo list.
  - Whenever adding a new command, the redo list is deleted.
  - When a command is undone, its moved to the redo list.
  - When a command is redone, its moved to the undo list.
*/

/*******************************************************************************/

// Make new empty undo list
FXUndoList::FXUndoList(){
  redolist=NULL;
  undolist=NULL;
  }

// Add new command, executing if if desired
FXbool FXUndoList::add(FXCommand* command,FXbool doit){
  register FXCommand *p;

  // Delete redo list
  while(redolist){
    p=redolist;
    redolist=redolist->next;
    delete p;
    }

  // Now empty
  redolist=NULL;

  // Add to undo list
  command->next=undolist;
  undolist=command;

  // Execute it right now
  if(doit) command->redo();

  return TRUE;
  }


// Undo last command
FXbool FXUndoList::undo(){
  register FXCommand *command=undolist;
  if(command){
    command->undo();
    undolist=undolist->next;
    command->next=redolist;
    redolist=command;
    return TRUE;
    }
  return FALSE;
  }


// Redo next command
FXbool FXUndoList::redo(){
  register FXCommand *command=redolist;
  if(command){
    command->redo();
    redolist=redolist->next;
    command->next=undolist;
    undolist=command;
    return TRUE;
    }
  return TRUE;
  }


// Clear list
void FXUndoList::clear(){
  register FXCommand *p;
  while(redolist){
    p=redolist;
    redolist=redolist->next;
    delete p;
    }
  while(undolist){
    p=undolist;
    undolist=undolist->next;
    delete p;
    }
  redolist=NULL;
  undolist=NULL;
  }



// Clean up
FXUndoList::~FXUndoList(){
  clear();
  }

