/********************************************************************************
*                                                                               *
*                         S c r o l l b a r   O b j e c t s                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXScrollbar.cpp,v 1.9 2000/02/28 17:26:37 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxkeys.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXScrollbar.h"


#define THUMB_MINIMUM  8
#define ARROW_BASE     9
#define ARROW_HALF     4

#define PRESSED_INC          1
#define PRESSED_DEC          2
#define PRESSED_PAGEINC      4
#define PRESSED_PAGEDEC      8
#define PRESSED_THUMB       16
#define PRESSED_FINETHUMB   32



/* 
  Notes:
  - Should increase/decrease, and slider get messages instead?
  - Scrollbar items should derive from FXWindow (as they are very simple).
  - If non-scrollable, but drawn anyway, don't draw thumb!
  - Need to fix this same as slider!!
*/


/*******************************************************************************/

// Map
FXDEFMAP(FXScrollbar) FXScrollbarMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXScrollbar::onPaint),
  FXMAPFUNC(SEL_MOTION,0,FXScrollbar::onMotion),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXScrollbar::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXScrollbar::onLeftBtnRelease),
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS,0,FXScrollbar::onMiddleBtnPress),
  FXMAPFUNC(SEL_MIDDLEBUTTONRELEASE,0,FXScrollbar::onMiddleBtnRelease),
  FXMAPFUNC(SEL_RIGHTBUTTONPRESS,0,FXScrollbar::onRightBtnPress),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE,0,FXScrollbar::onRightBtnRelease),
  FXMAPFUNC(SEL_UNGRABBED,0,FXScrollbar::onUngrabbed),
  FXMAPFUNC(SEL_TIMEOUT,FXScrollbar::ID_AUTOINC_PIX,FXScrollbar::onTimeIncPix),
  FXMAPFUNC(SEL_TIMEOUT,FXScrollbar::ID_AUTOINC_LINE,FXScrollbar::onTimeIncLine),
  FXMAPFUNC(SEL_TIMEOUT,FXScrollbar::ID_AUTOINC_PAGE,FXScrollbar::onTimeIncPage),
  FXMAPFUNC(SEL_TIMEOUT,FXScrollbar::ID_AUTODEC_PIX,FXScrollbar::onTimeDecPix),
  FXMAPFUNC(SEL_TIMEOUT,FXScrollbar::ID_AUTODEC_LINE,FXScrollbar::onTimeDecLine),
  FXMAPFUNC(SEL_TIMEOUT,FXScrollbar::ID_AUTODEC_PAGE,FXScrollbar::onTimeDecPage),
  };


// Object implementation
FXIMPLEMENT(FXScrollbar,FXWindow,FXScrollbarMap,ARRAYNUMBER(FXScrollbarMap))

  
// For deserialization
FXScrollbar::FXScrollbar(){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  timer=NULL;
  dragpoint=0;
  pressed=0;
  }


// Make a scrollbar
FXScrollbar::FXScrollbar(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXWindow(p,opts,x,y,w,h){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  barsize=getApp()->scrollbarWidth;
  backColor=getApp()->baseColor;
  hiliteColor=getApp()->hiliteColor;
  shadowColor=getApp()->shadowColor;
  borderColor=getApp()->borderColor;
  thumbpos=barsize;
  thumbsize=THUMB_MINIMUM;
  target=tgt;
  message=sel;
  timer=NULL;
  dragpoint=0;
  range=100;
  page=1;
  line=1;
  pos=0;
  pressed=0;
  }


// Get default size
FXint FXScrollbar::getDefaultWidth(){
  return (options&SCROLLBAR_HORIZONTAL) ? barsize+barsize+THUMB_MINIMUM : barsize;
  }


FXint FXScrollbar::getDefaultHeight(){
  return (options&SCROLLBAR_HORIZONTAL) ? barsize : barsize+barsize+THUMB_MINIMUM;
  }


// Pressed LEFT button in slider
// Note we don't move the focus to the scrollbar widget!
long FXScrollbar::onLeftBtnPress(FXObject*,FXSelector,void* ptr){
  register FXEvent *event=(FXEvent*)ptr;
  register FXint oldpos=pos;
  if(isEnabled()){
    
    // Capture the mouse
    grab();
    
    // Kill timer
    if(timer) timer=getApp()->removeTimeout(timer);
  
    // Bounce normal button press
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONPRESS),ptr)) return 1;
    
    // Horizontal scrollbar
    if(options&SCROLLBAR_HORIZONTAL){
      if(event->win_x<barsize){                   // Left arrow
        pressed=PRESSED_DEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_LINE);
        pos-=line;
        update();
        }
      else if(width-barsize<=event->win_x){       // Right arrow
        pressed=PRESSED_INC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_LINE);
        pos+=line;
        update();
        }
      else if(event->win_x<thumbpos){             // Page left
        pressed=PRESSED_PAGEDEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_PAGE);
        pos-=page;
        update();
        }
      else if(thumbpos+thumbsize<=event->win_x){  // Page right
        pressed=PRESSED_PAGEINC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_PAGE);
        pos+=page;
        update();
        }
      else{                                       // Grabbed the puck
        pressed=PRESSED_THUMB;
        dragpoint=event->win_x-thumbpos;
        flags|=FLAG_PRESSED;
        }
      }
    
    // Vertical scrollbar
    else{
      if(event->win_y<barsize){                   // Up arrow
        pressed=PRESSED_DEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_LINE);
        pos-=line;
        update();
        }
      else if(height-barsize<=event->win_y){      // Down arrow
        pressed=PRESSED_INC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_LINE);
        pos+=line;
        update();
        }
      else if(event->win_y<thumbpos){             // Page up
        pressed=PRESSED_PAGEDEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_PAGE);
        pos-=page;
        update();
        }
      else if(thumbpos+thumbsize<=event->win_y){  // Page down
        pressed=PRESSED_PAGEINC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_PAGE);
        pos+=page;
        update();
        }
      else{                                       // Grabbed the puck
        pressed=PRESSED_THUMB;
        if(event->state&(CONTROLMASK|SHIFTMASK|ALTMASK)) pressed=PRESSED_FINETHUMB;
        dragpoint=event->win_y-thumbpos;
        flags|=FLAG_PRESSED;
        }
      }
    if(pos<0) pos=0;
    if(pos>(range-page)) pos=range-page;
    if(oldpos!=pos){
      if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos); 
      flags|=FLAG_CHANGED;
      }
    flags&=~FLAG_UPDATE;
    return 1;
    }
  return 0;
  }


// Released LEFT button
long FXScrollbar::onLeftBtnRelease(FXObject*,FXSelector,void* ptr){
  FXuint flgs=flags;
  if(isEnabled()){
    
    // Uncapture the mouse
    ungrab();
    
    // Stop auto-scrolling movement
    if(timer) timer=getApp()->removeTimeout(timer);
    
    flags&=~FLAG_PRESSED;
    flags&=~FLAG_CHANGED;
    flags|=FLAG_UPDATE;
    pressed=0;
    update();
    
    // Bounce button release
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONRELEASE),ptr)) return 1;
    
    // Send command if changed
    if(flgs&FLAG_CHANGED){
      if(target) target->handle(this,MKUINT(message,SEL_COMMAND),(void*)pos);
      }
    return 1; 
    }
  return 0;
  }


// Pressed MIDDLE button in slider
long FXScrollbar::onMiddleBtnPress(FXObject*,FXSelector,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  register FXint oldpos=pos;
  register int travel;
  if(isEnabled()){
    
    // Capture the mouse
    grab();
    
    // Bounce button press
    if(target && target->handle(this,MKUINT(message,SEL_MIDDLEBUTTONPRESS),ptr)) return 1;
    
    dragpoint=thumbsize/2;
    if(options&SCROLLBAR_HORIZONTAL){
      thumbpos=event->win_x-dragpoint;
      if(thumbpos<barsize) thumbpos=barsize;
      if(thumbpos>(width-barsize-thumbsize)) thumbpos=width-barsize-thumbsize;
      travel=width-barsize-barsize-thumbsize;
      pos=0;
      if(travel>0){ pos=((thumbpos-barsize)*(range-page))/travel; }
      }
    else{
      thumbpos=event->win_y-dragpoint;
      if(thumbpos<barsize) thumbpos=barsize;
      if(thumbpos>(height-barsize-thumbsize)) thumbpos=height-barsize-thumbsize;
      travel=height-barsize-barsize-thumbsize;
      pos=0;
      if(travel>0){ pos=((thumbpos-barsize)*(range-page))/travel; }
      }
    pressed=PRESSED_THUMB;
    flags|=FLAG_PRESSED;
    if(pos!=oldpos){
      if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
      update();
      flags|=FLAG_CHANGED;
      }
    flags&=~FLAG_UPDATE;
    return 1;
    }
  return 0;
  }


// Released MIDDLE button
long FXScrollbar::onMiddleBtnRelease(FXObject*,FXSelector,void* ptr){
  FXuint flgs=flags;
  if(isEnabled()){
    ungrab();
    if(timer) timer=getApp()->removeTimeout(timer);
    flags&=~FLAG_PRESSED;
    flags&=~FLAG_CHANGED;
    flags|=FLAG_UPDATE;
    pressed=0;
    update();
    
    // Bounce button release
    if(target && target->handle(this,MKUINT(message,SEL_MIDDLEBUTTONRELEASE),ptr)) return 1;
    
    // Send command if changed
    if(flgs&FLAG_CHANGED){
      if(target) target->handle(this,MKUINT(message,SEL_COMMAND),(void*)pos);
      }
    return 1; 
    }
  return 0;
  }


// Pressed RIGHT button in slider
long FXScrollbar::onRightBtnPress(FXObject*,FXSelector,void* ptr){
  register FXEvent *event=(FXEvent*)ptr;
  register FXint oldpos=pos;
  if(isEnabled()){
    
    grab();
    
    // Kill timer
    if(timer) timer=getApp()->removeTimeout(timer);

    // Bounce normal button press
    if(target && target->handle(this,MKUINT(message,SEL_RIGHTBUTTONPRESS),ptr)) return 1;
    
    // Horizontal scrollbar
    if(options&SCROLLBAR_HORIZONTAL){
      if(event->win_x<barsize){                   // Left arrow
        pressed=PRESSED_DEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_PIX);
        pos-=1;
        update();
        }
      else if(width-barsize<=event->win_x){       // Right arrow
        pressed=PRESSED_INC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_PIX);
        pos+=1;
        update();
        }
      else if(event->win_x<thumbpos){             // Page left
        pressed=PRESSED_PAGEDEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_LINE);
        pos-=line;
        update();
        }
      else if(thumbpos+thumbsize<=event->win_x){  // Page right
        pressed=PRESSED_PAGEINC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_LINE);
        pos+=line;
        update();
        }
      else{                                       // Grabbed the puck
        pressed=PRESSED_FINETHUMB;
        dragpoint=event->win_x;
        flags|=FLAG_PRESSED;
        }
      }
    
    // Vertical scrollbar
    else{
      if(event->win_y<barsize){                   // Up arrow
        pressed=PRESSED_DEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_PIX);
        pos-=1;
        update();
        }
      else if(height-barsize<=event->win_y){      // Down arrow
        pressed=PRESSED_INC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_PIX);
        pos+=1;
        update();
        }
      else if(event->win_y<thumbpos){             // Page up
        pressed=PRESSED_PAGEDEC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTODEC_LINE);
        pos-=line;
        update();
        }
      else if(thumbpos+thumbsize<=event->win_y){  // Page down
        pressed=PRESSED_PAGEINC;
        timer=getApp()->addTimeout(getApp()->scrollDelay,this,ID_AUTOINC_LINE);
        pos+=line;
        update();
        }
      else{                                       // Grabbed the puck
        pressed=PRESSED_FINETHUMB;
        flags|=FLAG_PRESSED;
        }
      }
    if(pos<0) pos=0;
    if(pos>(range-page)) pos=range-page;
    if(oldpos!=pos){
      if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos); 
      flags|=FLAG_CHANGED;
      }
    flags&=~FLAG_UPDATE;
    return 1;
    }
  return 0;
  }


// Released RIGHT button
long FXScrollbar::onRightBtnRelease(FXObject*,FXSelector,void* ptr){
  FXuint flgs=flags;
  if(isEnabled()){
    ungrab();
    if(timer) timer=getApp()->removeTimeout(timer);
    flags&=~FLAG_PRESSED;
    flags&=~FLAG_CHANGED;
    flags|=FLAG_UPDATE;
    pressed=0;
    update();
    
    // Send button release
    if(target && target->handle(this,MKUINT(message,SEL_RIGHTBUTTONRELEASE),ptr)) return 1;
    
    // Send command if changed
    if(flgs&FLAG_CHANGED){
      if(target) target->handle(this,MKUINT(message,SEL_COMMAND),(void*)pos);
      }
    return 1; 
    }
  return 0;
  }


// The widget lost the grab for some reason
long FXScrollbar::onUngrabbed(FXObject* sender,FXSelector sel,void* ptr){
  FXWindow::onUngrabbed(sender,sel,ptr);
  if(timer) timer=getApp()->removeTimeout(timer);
  flags&=~FLAG_PRESSED;
  flags&=~FLAG_CHANGED;
  flags|=FLAG_UPDATE;
  pressed=0;
  return 1;
  }


// Moving 
long FXScrollbar::onMotion(FXObject*,FXSelector,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXint oldthumbpos=thumbpos;
  FXint oldpos=pos;
  FXint travel;
  FXint lo,hi;
  if(!isEnabled()) return 0;
  if(flags&FLAG_PRESSED){
    
    // Switch to fine thumb mode, maybe
    if(event->state&(CONTROLMASK|SHIFTMASK|ALTMASK)) pressed=PRESSED_FINETHUMB;
        
    // Coarse movements
    if(pressed==PRESSED_THUMB){
      if(options&SCROLLBAR_HORIZONTAL){
        thumbpos=event->win_x-dragpoint;
        if(thumbpos<barsize) thumbpos=barsize;
        if(thumbpos>(width-barsize-thumbsize)) thumbpos=width-barsize-thumbsize;
        travel=width-barsize-barsize-thumbsize;
        pos=0;
        if(travel>0){ pos=((thumbpos-barsize)*(range-page))/travel; }
        }
      else{
        thumbpos=event->win_y-dragpoint;
        if(thumbpos<barsize) thumbpos=barsize;
        if(thumbpos>(height-barsize-thumbsize)) thumbpos=height-barsize-thumbsize;
        travel=height-barsize-barsize-thumbsize;
        pos=0;
        if(travel>0){ pos=((thumbpos-barsize)*(range-page))/travel; }
        }
      }

    // Fine movements
    else if(pressed==PRESSED_FINETHUMB){
      if(options&SCROLLBAR_HORIZONTAL){
        travel=width-barsize-barsize-thumbsize;
        pos+=event->win_x-event->last_x;
        if(pos<0) pos=0;
        if(pos>(range-page)) pos=range-page;
        thumbpos=barsize;
        if(range>page){ thumbpos+=(pos*travel)/(range-page); }
        }
      else{
        travel=height-barsize-barsize-thumbsize;
        pos+=event->win_y-event->last_y;
        if(pos<0) pos=0;
        if(pos>(range-page)) pos=range-page;
        thumbpos=barsize;
        if(range>page){ thumbpos+=(pos*travel)/(range-page); }
        }
      }
    
    // Pass movement on to target
    if(pos!=oldpos){
      if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
      FXMINMAX(lo,hi,oldthumbpos,thumbpos);
      if(options&SCROLLBAR_HORIZONTAL){
        update(lo-1,0,hi+thumbsize+1-lo,height);
        }
      else{
        update(0,lo-1,width,hi+thumbsize+1-lo);
        }
      flags|=FLAG_CHANGED;
      return 1;
      }
    }
  return 0;
  }


// Increment pixel timeout
long FXScrollbar::onTimeIncPix(FXObject*,FXSelector,void*){
  FXint oldpos=pos;
  pos+=1;
  if(pos>(range-page)){
    pos=range-page;
    timer=NULL;
    }
  else{
    timer=getApp()->addTimeout(getApp()->scrollSpeed,this,ID_AUTOINC_PIX);
    }
  if(oldpos!=pos){
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
    update();
    flags|=FLAG_CHANGED;
    return 1;
    }
  return 0;
  }


// Increment line timeout
long FXScrollbar::onTimeIncLine(FXObject*,FXSelector,void*){
  FXint oldpos=pos;
  pos+=line;
  if(pos>(range-page)){
    pos=range-page;
    timer=NULL;
    }
  else{
    timer=getApp()->addTimeout(getApp()->scrollSpeed,this,ID_AUTOINC_LINE);
    }
  if(oldpos!=pos){
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
    update();
    flags|=FLAG_CHANGED;
    return 1;
    }
  return 0;
  }


// Increment page timeout
long FXScrollbar::onTimeIncPage(FXObject*,FXSelector,void*){
  FXint oldpos=pos;
  pos+=page;
  if(pos>(range-page)){
    pos=range-page;
    timer=NULL;
    }
  else{
    timer=getApp()->addTimeout(getApp()->scrollSpeed,this,ID_AUTOINC_PAGE);
    }
  if(oldpos!=pos){
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
    update();
    flags|=FLAG_CHANGED;
    return 1;
    }
  return 0;
  }


// Decrement pixel timeout
long FXScrollbar::onTimeDecPix(FXObject*,FXSelector,void*){
  FXint oldpos=pos;
  pos-=1;
  if(pos<0){
    pos=0;
    timer=NULL;
    }
  else{
    timer=getApp()->addTimeout(getApp()->scrollSpeed,this,ID_AUTODEC_PIX);
    }
  if(oldpos!=pos){
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
    update();
    flags|=FLAG_CHANGED;
    return 1;
    }
  return 0;
  }


// Decrement line timeout
long FXScrollbar::onTimeDecLine(FXObject*,FXSelector,void*){
  FXint oldpos=pos;
  pos-=line;
  if(pos<0){
    pos=0;
    timer=NULL;
    }
  else{
    timer=getApp()->addTimeout(getApp()->scrollSpeed,this,ID_AUTODEC_LINE);
    }
  if(oldpos!=pos){
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
    update();
    flags|=FLAG_CHANGED;
    return 1;
    }
  return 0;
  }


// Decrement page timeout
long FXScrollbar::onTimeDecPage(FXObject*,FXSelector,void*){
  FXint oldpos=pos;
  pos-=page;
  if(pos<0){
    pos=0;
    timer=NULL;
    }
  else{
    timer=getApp()->addTimeout(getApp()->scrollSpeed,this,ID_AUTODEC_PAGE);
    }
  if(oldpos!=pos){
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)pos);
    update();
    flags|=FLAG_CHANGED;
    return 1;
    }
  return 0;
  }


// Draw button in scrollbar; this is slightly different from a raised rectangle
void FXScrollbar::drawButton(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down){
  dc.setForeground(backColor);
  dc.fillRectangle(x+2,y+2,w-4,h-4);
  if(!down){
    dc.setForeground(backColor);
    dc.drawLine(x,y,x+w-2,y);
    dc.drawLine(x,y,x,y+h-2);
    dc.setForeground(hiliteColor);
    dc.drawLine(x+1,y+1,x+w-3,y+1);
    dc.drawLine(x+1,y+1,x+1,y+h-3);
    dc.setForeground(shadowColor);
    dc.drawLine(x+1,y+h-2,x+w-2,y+h-2);
    dc.drawLine(x+w-2,y+h-2,x+w-2,y+1);
    dc.setForeground(borderColor);
    dc.drawLine(x,y+h-1,x+w-1,y+h-1);
    dc.drawLine(x+w-1,y+h-1,x+w-1,y);
    }
  else{
    dc.setForeground(borderColor);
    dc.drawLine(x,y,x+w-2,y);
    dc.drawLine(x,y,x,y+h-2);
    dc.setForeground(shadowColor);
    dc.drawLine(x+1,y+1,x+w-3,y+1);
    dc.drawLine(x+1,y+1,x+1,y+h-3);
    dc.setForeground(hiliteColor);
    dc.drawLine(x,y+h-1,x+w-1,y+h-1);
    dc.drawLine(x+w-1,y+h-1,x+w-1,y+1);
    dc.setForeground(backColor);
    dc.drawLine(x+1,y+h-2,x+w-2,y+h-2);
    dc.drawLine(x+w-2,y+h-2,x+w-2,y+2);
    }
  }


// Draw left arrow
void FXScrollbar::drawLeftArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down){
  FXPoint points[3];
  x=x+(w-ARROW_HALF)/2;
  y=y+(h-ARROW_BASE)/2;
  if(down){ ++x; ++y; }
  dc.setForeground(borderColor);
  points[0].x=x+ARROW_HALF;
  points[0].y=y;
  points[1].x=x+ARROW_HALF;
  points[1].y=y+ARROW_BASE-1;
  points[2].x=x;
  points[2].y=(FXshort)(y+(ARROW_BASE>>1));
  dc.fillPolygon(points,3);
  }


// Draw right arrow
void FXScrollbar::drawRightArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down){
  FXPoint points[3];
  x=x+(w-ARROW_HALF)/2;
  y=y+(h-ARROW_BASE)/2;
  if(down){ ++x; ++y; }
  dc.setForeground(borderColor);
  points[0].x=x;
  points[0].y=y;
  points[1].x=x;
  points[1].y=y+ARROW_BASE-1;
  points[2].x=x+ARROW_HALF;
  points[2].y=(FXshort)(y+(ARROW_BASE>>1));
  dc.fillPolygon(points,3);
  }


// Draw up arrow
void FXScrollbar::drawUpArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down){
  FXPoint points[3];
  x=x+(w-ARROW_BASE)/2;
  y=y+(h-ARROW_HALF)/2;
  if(down){ ++x; ++y; }
  dc.setForeground(borderColor);
  points[0].x=(FXshort)(x+(ARROW_BASE>>1));
  points[0].y=y-1;
  points[1].x=x;
  points[1].y=y+ARROW_HALF;
  points[2].x=x+ARROW_BASE;
  points[2].y=y+ARROW_HALF;
  dc.fillPolygon(points,3);
  }


// Draw down arrow
void FXScrollbar::drawDownArrow(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXbool down){
  FXPoint points[3];
  x=x+(w-ARROW_BASE)/2;
  y=y+(h-ARROW_HALF)/2;
  if(down){ ++x; ++y; }
  dc.setForeground(borderColor);
  points[0].x=x+1;
  points[0].y=y;
  points[1].x=x+ARROW_BASE-1;
  points[1].y=y;
  points[2].x=(FXshort)(x+(ARROW_BASE>>1));
  points[2].y=y+ARROW_HALF;
  dc.fillPolygon(points,3);
  }


// Handle repaint 
long FXScrollbar::onPaint(FXObject*,FXSelector,void* ptr){
  register FXEvent *ev=(FXEvent*)ptr;
  register int total,travel;
  FXDCWindow dc(this,ev);
  if(options&SCROLLBAR_HORIZONTAL){
    drawButton(dc,0,0,barsize,barsize,(pressed&PRESSED_DEC));
    drawLeftArrow(dc,0,0,barsize,barsize,(pressed&PRESSED_DEC));
    drawButton(dc,width-barsize,0,barsize,barsize,(pressed&PRESSED_INC));
    drawRightArrow(dc,width-barsize,0,barsize,barsize,(pressed&PRESSED_INC));
    total=width-barsize-barsize;
    thumbsize=(total*page)/range;
    if(thumbsize<THUMB_MINIMUM) thumbsize=THUMB_MINIMUM;
    travel=total-thumbsize;
    thumbpos=barsize;
    if(range>page){ thumbpos+=(pos*travel)/(range-page); }
    if(thumbsize<total){                                    // Scrollable
      drawButton(dc,thumbpos,0,thumbsize,height,0);
      dc.setStipple(STIPPLE_GRAY);
      dc.setFillStyle(FILL_OPAQUESTIPPLED);
      if(pressed&PRESSED_PAGEDEC){
        dc.setForeground(backColor);
        dc.setBackground(shadowColor);
        }
      else{
        dc.setForeground(hiliteColor);
        dc.setBackground(backColor);
        }
      dc.fillRectangle(barsize,0,thumbpos-barsize,barsize);
      if(pressed&PRESSED_PAGEINC){
        dc.setForeground(backColor);
        dc.setBackground(shadowColor);
        }
      else{
        dc.setForeground(hiliteColor);
        dc.setBackground(backColor);
        }
      dc.fillRectangle(thumbpos+thumbsize,0,width-barsize-thumbpos-thumbsize,barsize);
      }
    else{                                                   // Non-scrollable
      dc.setStipple(STIPPLE_GRAY);
      dc.setFillStyle(FILL_OPAQUESTIPPLED);
      dc.setForeground(hiliteColor);
      dc.setBackground(backColor);
      dc.fillRectangle(barsize,0,total,barsize);
      }
    }
  else{
    drawButton(dc,0,0,barsize,barsize,(pressed&PRESSED_DEC));
    drawUpArrow(dc,0,0,barsize,barsize,(pressed&PRESSED_DEC));
    drawButton(dc,0,height-barsize,barsize,barsize,(pressed&PRESSED_INC));
    drawDownArrow(dc,0,height-barsize,barsize,barsize,(pressed&PRESSED_INC));
    total=height-barsize-barsize;
    thumbsize=(total*page)/range;
    if(thumbsize<THUMB_MINIMUM) thumbsize=THUMB_MINIMUM;
    travel=total-thumbsize;
    thumbpos=barsize;
    if(range>page){ thumbpos+=(pos*travel)/(range-page); }
    if(thumbsize<total){                                    // Scrollable
      drawButton(dc,0,thumbpos,width,thumbsize,0);
      dc.setStipple(STIPPLE_GRAY);
      dc.setFillStyle(FILL_OPAQUESTIPPLED);
      if(pressed&PRESSED_PAGEDEC){
        dc.setForeground(backColor);
        dc.setBackground(shadowColor);
        }
      else{
        dc.setForeground(hiliteColor);
        dc.setBackground(backColor);
        }
      dc.fillRectangle(0,barsize,barsize,thumbpos-barsize);
      if(pressed&PRESSED_PAGEINC){
        dc.setForeground(backColor);
        dc.setBackground(shadowColor);
        }
      else{
        dc.setForeground(hiliteColor);
        dc.setBackground(backColor);
        }
      dc.fillRectangle(0,thumbpos+thumbsize,barsize,height-barsize-thumbpos-thumbsize);
      }
    else{                                                   // Non-scrollable
      dc.setStipple(STIPPLE_GRAY);
      dc.setFillStyle(FILL_OPAQUESTIPPLED);
      dc.setForeground(hiliteColor);
      dc.setBackground(backColor);
      dc.fillRectangle(0,barsize,barsize,total);
      }
    }
  return 1;
  }
  

// Set range
void FXScrollbar::setRange(FXint r){
  FXint oldrange=range;
  FXint oldpage=page;
  FXint oldpos=pos;
  range=r; 
  if(range<1) range=1;
  if(page>range) page=range;
  if(pos>(range-page)) pos=range-page;
  if((oldrange!=range) || (oldpage!=page) || (oldpos!=pos)){
    update();
    }
  }


// Set page size
void FXScrollbar::setPage(FXint p){
  FXint oldrange=range;
  FXint oldpage=page;
  FXint oldpos=pos;
  page=p;
  if(page<1) page=1;
  if(page>range) page=range;
  if(pos>(range-page)) pos=range-page;
  if((oldrange!=range) || (oldpage!=page) || (oldpos!=pos)){
    update();
    }
  }


// Set line size
void FXScrollbar::setLine(FXint l){
  if(l<1) l=1;
  line=l;
  }


// Set position
void FXScrollbar::setPosition(FXint p){
  FXint oldpos=pos;
  pos=p;
  if(pos<0) pos=0;
  if(pos>(range-page)) pos=range-page;
  if(pos!=oldpos){
    update();
    }
  }


// Set highlight color
void FXScrollbar::setHiliteColor(FXColor clr){
  hiliteColor=clr;
  update();
  }


// Set shadow color
void FXScrollbar::setShadowColor(FXColor clr){
  shadowColor=clr;
  update();
  }


// Set border color
void FXScrollbar::setBorderColor(FXColor clr){
  borderColor=clr;
  update();
  }


// Save object to stream
void FXScrollbar::save(FXStream& store) const {
  FXWindow::save(store);
  store << hiliteColor;
  store << shadowColor;
  store << borderColor;
  store << barsize;
  store << thumbsize;
  store << thumbpos;
  store << range;
  store << page;
  store << line;
  store << pos;
  }


// Load object from stream
void FXScrollbar::load(FXStream& store){
  FXWindow::load(store);
  store >> hiliteColor;
  store >> shadowColor;
  store >> borderColor;
  store >> barsize;
  store >> thumbsize;
  store >> thumbpos;
  store >> range;
  store >> page;
  store >> line;
  store >> pos;
  }


// Delete
FXScrollbar::~FXScrollbar(){
  if(timer){getApp()->removeTimeout(timer);}
  timer=(FXTimer*)-1;
  }


/*******************************************************************************/

// Map
FXDEFMAP(FXScrollCorner) FXScrollCornerMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXScrollCorner::onPaint),
  };


// Object implementation
FXIMPLEMENT(FXScrollCorner,FXWindow,FXScrollCornerMap,ARRAYNUMBER(FXScrollCornerMap))

  
// Deserialization
FXScrollCorner::FXScrollCorner(){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  }

  
// Construct and init
FXScrollCorner::FXScrollCorner(FXComposite* p):FXWindow(p){
  backColor=getApp()->baseColor;
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  }


// Slightly different from Frame border
long FXScrollCorner::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  return 1;
  }


void FXScrollCorner::enable(){ }


void FXScrollCorner::disable(){ }

