/********************************************************************************
*                                                                               *
*                     S c r o l l W i n d o w   W i d g e t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXScrollWindow.cpp,v 1.8 2000/02/28 17:26:37 jeroen Exp $                *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXCanvas.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXScrollbar.h"
#include "FXScrollArea.h"
#include "FXScrollWindow.h"


/*
  Notes:
  - Perhaps scroll windows should observe FRAME_SUNKEN etc.
  - Perhaps need clip-window to be a parent of the content window.
  - Need margins [and item spacing]
*/



/*******************************************************************************/



// Object implementation
FXIMPLEMENT(FXScrollWindow,FXScrollArea,NULL,0)


// Construct and init
FXScrollWindow::FXScrollWindow(FXComposite* p,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXScrollArea(p,opts,x,y,w,h){
  }


// Get content window; may be NULL
FXWindow* FXScrollWindow::contentWindow() const { 
  return corner->getNext(); 
  }


// Determine content width of scroll area
FXint FXScrollWindow::getContentWidth(){ 
  return contentWindow() ? contentWindow()->getDefaultWidth() : 1;
  }


// Determine content height of scroll area
FXint FXScrollWindow::getContentHeight(){ 
  return contentWindow() ? contentWindow()->getDefaultHeight() : 1;
  }


// Move contents; moves child window
void FXScrollWindow::moveContents(FXint x,FXint y){
  FXWindow* contents=contentWindow();
  if(contents) contents->move(x,y);
  pos_x=x;
  pos_y=y;
  }


// Recalculate layout
void FXScrollWindow::layout(){

  // Layout scroll bars and viewport
  FXScrollArea::layout();

  // Resize contents
  if(contentWindow()){
    
    // Reposition content window
    contentWindow()->position(pos_x,pos_y,content_w,content_h);
    
    // Make sure its under the scroll bars
    contentWindow()->lower();
    }
  flags&=~FLAG_DIRTY;
  }
