/********************************************************************************
*                                                                               *
*                    Q u a t e r n i o n   F u n c t i o n s                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 1994 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXQuat.cpp,v 1.6 2000/05/01 15:37:16 gui Exp $                        *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXObject.h"
#include "FXVec.h"
#include "FXHVec.h"
#include "FXQuat.h"

/* Return the value val with the sign of s */
#define SIGN(val,s) (((s)<0)?-(val):(val))


/*******************************************************************************/


FXQuat::FXQuat(const FXVec& axis,FXfloat phi){
  register FXdouble a=0.5*phi;
  register FXdouble s=sin(a)/len(axis);
  v[0]=(FXfloat)(axis[0]*s); 
  v[1]=(FXfloat)(axis[1]*s); 
  v[2]=(FXfloat)(axis[2]*s); 
  v[3]=(FXfloat)cos(a);
  }


FXQuat::FXQuat(FXfloat roll,FXfloat pitch,FXfloat yaw){
  register FXdouble r,p,y,sr,cr,sp,cp,sy,cy;
  r=0.5f*roll;
  p=0.5f*pitch;
  y=0.5f*yaw;
  sr=sin(r); cr=cos(r);
  sp=sin(p); cp=cos(p);
  sy=sin(y); cy=cos(y);
  v[0]=(FXfloat)(sr*cp*cy-cr*sp*sy);
  v[1]=(FXfloat)(cr*sp*cy+sr*cp*sy);
  v[2]=(FXfloat)(cr*cp*sy-sr*sp*cy);
  v[3]=(FXfloat)(cr*cp*cy+sr*sp*sy);
  }


FXQuat& FXQuat::adjust(){
  register FXfloat len=v[0]*v[0]+v[1]*v[1]+v[2]*v[2]+v[3]*v[3];
  register FXfloat f;
  if(len>0.0f){
    f=(FXfloat)(1.0/sqrt((FXdouble)len));
    v[0]*=f;
    v[1]*=f;
    v[2]*=f;
    v[3]*=f;
    }
  return *this;
  }


FXQuat exp(const FXQuat& q){
  register FXfloat theta=(FXfloat)sqrt(q[0]*q[0]+q[1]*q[1]+q[2]);
  register FXfloat scale=1.0f;
  FXQuat result;
  if(theta>0.000001f) scale=(FXfloat)(sin(theta)/theta);
  result[0]=scale*q[0];
  result[1]=scale*q[1];
  result[2]=scale*q[2];
  result[3]=(FXfloat)cos(theta);
  return result;
  }


FXQuat log(const FXQuat& q){
  register FXfloat scale=(FXfloat)sqrt(q[0]*q[0]+q[1]*q[1]+q[2]);
  register FXfloat theta=(FXfloat)atan2(scale,q[3]);
  FXQuat result;
  if(scale>0.0) scale=theta/scale;
  result[0]=scale*q[0];
  result[1]=scale*q[1];
  result[2]=scale*q[2];
  result[3]=0.0f;
  return result;
  }


FXQuat invert(const FXQuat& q){
  FXfloat n=q[0]*q[0]+q[1]*q[1]+q[2]*q[2]+q[3]*q[3];
  FXASSERT(n>0.0f);
  return FXQuat(-q[0]/n,-q[1]/n,-q[2]/n,-q[3]/n);
  }


FXQuat conj(const FXQuat& q){
  return FXQuat(-q[0],-q[1],-q[2],q[3]);
  }


FXQuat operator*(const FXQuat& p,const FXQuat& q){
  return FXQuat(p[3]*q[0]+p[0]*q[3]+p[1]*q[2]-p[2]*q[1],
                p[3]*q[1]+p[1]*q[3]+p[2]*q[0]-p[0]*q[2],
                p[3]*q[2]+p[2]*q[3]+p[0]*q[1]-p[1]*q[0],
                p[3]*q[3]-p[0]*q[0]-p[1]*q[1]-p[2]*q[2]);
  }


FXQuat arc(const FXVec& f,const FXVec& t){
  FXQuat q;
  q.v[0] = f[1]*t[2]-f[2]*t[1];
  q.v[1] = f[2]*t[0]-f[0]*t[2];
  q.v[2] = f[0]*t[1]-f[1]*t[0];
  q.v[3] = f[0]*t[0]+f[1]*t[1]+f[2]*t[2];
  return q;
  }


FXQuat lerp(const FXQuat& u,const FXQuat& v,FXfloat f){
  register FXdouble alpha,beta,theta,sin_t,cos_t;
  register FXint flip=0;
  cos_t = u[0]*v[0]+u[1]*v[1]+u[2]*v[2]+u[3]*v[3];
  if(cos_t<0.0){ cos_t = -cos_t; flip=1; }
  if((1.0-cos_t)<0.000001){
    beta = 1.0-f;
    alpha = f;
    }
  else{
    theta = acos(cos_t);
    sin_t = sin(theta);
    beta = sin(theta-f*theta)/sin_t;
    alpha = sin(f*theta)/sin_t;
    }
  if(flip) alpha = -alpha;
  return FXQuat((FXfloat)(beta*u[0]+alpha*v[0]),(FXfloat)(beta*u[1]+alpha*v[1]),(FXfloat)(beta*u[2]+alpha*v[2]),(FXfloat)(beta*u[3]+alpha*v[3]));
  }

