/********************************************************************************
*                                                                               *
*                             O p t i o n   M e n u                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOptionMenu.cpp,v 1.11 2000/03/16 23:22:55 jeroen Exp $                 *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXButton.h"
#include "FXMenuButton.h"
#include "FXTooltip.h"
#include "FXOptionMenu.h"

/*
  Notes:
  - Need API to inquire whether an FXOption is selected or not.
  - Should it grab first before POST?
  - FXOptionMenu should send the message, SEL_CHANGED when changing,
    SEL_COMMAND at the end, and SEL_UPDATE during gui update.
  - FXOptionMenu should understand ID_SETINTVALUE and ID_GETINTVALUE
    so you may substitute FXOptionMenu for a slider or dial.
*/


#define MENUGLYPH_WIDTH  10
#define MENUGLYPH_HEIGHT 5

/*******************************************************************************/

// Map
FXDEFMAP(FXOption) FXOptionMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXOption::onPaint),
  FXMAPFUNC(SEL_ENTER,0,FXOption::onEnter),
  FXMAPFUNC(SEL_LEAVE,0,FXOption::onLeave),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXOption::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXOption::onLeftBtnRelease),
  FXMAPFUNC(SEL_KEYPRESS,0,FXOption::onKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXOption::onKeyRelease),
  FXMAPFUNC(SEL_KEYPRESS,FXWindow::ID_HOTKEY,FXOption::onHotKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,FXWindow::ID_HOTKEY,FXOption::onHotKeyRelease),
  };


// Object implementation
FXIMPLEMENT(FXOption,FXLabel,FXOptionMap,ARRAYNUMBER(FXOptionMap))

  
// Make option menu entry
FXOption::FXOption(FXComposite* p,const FXString& text,FXIcon* ic,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXLabel(p,text,ic,opts,x,y,w,h,pl,pr,pt,pb){
  target=tgt;
  message=sel;
  flags|=FLAG_ENABLED;
  defaultCursor=getApp()->rarrowCursor;
  }


// If window can have focus
FXbool FXOption::canFocus() const { return 1; }


// Get default width
FXint FXOption::getDefaultWidth(){
  FXint tw=0,iw=MENUGLYPH_WIDTH,s=0,w;
  if(!label.empty()){ 
    tw=labelWidth(label); 
    }
  if(icon){ 
    iw=icon->getWidth(); 
    }
  if(iw && tw) s=4;
  if(!(options&(ICON_AFTER_TEXT|ICON_BEFORE_TEXT))) w=FXMAX(tw,iw); else w=tw+iw+s;
  return padleft+padright+(border<<1)+w;
  }


// Get default height
FXint FXOption::getDefaultHeight(){
  FXint th=0,ih=MENUGLYPH_HEIGHT,h;
  if(!label.empty()){ 
    th=labelHeight(label); 
    }
  if(icon){ 
    ih=icon->getHeight(); 
    }
  if(!(options&(ICON_ABOVE_TEXT|ICON_BELOW_TEXT))) h=FXMAX(th,ih); else h=th+ih;
  return padtop+padbottom+(border<<1)+h;
  }



// Handle repaint 
long FXOption::onPaint(FXObject*,FXSelector,void* ptr){
  FXint tw=0,th=0,iw=MENUGLYPH_WIDTH,ih=MENUGLYPH_HEIGHT,tx,ty,ix,iy;
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  if(!label.empty()){
    tw=labelWidth(label);
    th=labelHeight(label);
    }
  if(icon){
    iw=icon->getWidth();
    ih=icon->getHeight();
    }
  just_x(tx,ix,tw,iw);
  just_y(ty,iy,th,ih);
  if(isActive()){
    dc.setForeground(hiliteColor);
    dc.fillRectangle(border,border,width-border*2,height-border*2);
    dc.drawLine(border,border,width-border-1,border);
    }
  else{
    dc.setForeground(backColor);
    dc.fillRectangle(border,border,width-border*2,height-border*2);
    }
  if(icon){
    dc.drawIcon(icon,ix,iy);
    }
  else if(isActive()){
    drawDoubleRaisedRectangle(dc,ix,iy,MENUGLYPH_WIDTH,MENUGLYPH_HEIGHT);
    }
  if(!label.empty()){
    dc.setTextFont(font);
    if(isEnabled()){
      dc.setForeground(textColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      }
    else{
      dc.setForeground(hiliteColor);
      drawLabel(dc,label,hotoff,tx+1,ty+1,tw,th);
      dc.setForeground(shadowColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      }
    }
  drawFrame(dc,0,0,width,height);
  return 1;
  }


// Enter
long FXOption::onEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onEnter(sender,sel,ptr);
  if(isEnabled() && canFocus()) setFocus();
  //////////// Should this generate an SEL_FOCUS_SELF ?
  return 1;
  }


// Leave
long FXOption::onLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onLeave(sender,sel,ptr);
  if(isEnabled() && canFocus()) killFocus();
  return 1;
  }


// Pressed left button; always unposts menu
long FXOption::onLeftBtnPress(FXObject*,FXSelector,void* ptr){
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONPRESS),ptr)) return 1;
    getParent()->handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),this);
    if(target) target->handle(this,MKUINT(message,SEL_COMMAND),ptr);
    return 1;
    }
  return 0;
  }


// Released left button; unpost menu if cursor has moved
long FXOption::onLeftBtnRelease(FXObject*,FXSelector,void* ptr){
  FXEvent* ev=(FXEvent*)ptr;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONRELEASE),ptr)) return 1;
    if(ev->moved){ 
      getParent()->handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),this);
      if(target) target->handle(this,MKUINT(message,SEL_COMMAND),ptr);
      }
    return 1;
    }
  return 0;
  }


// Keyboard press; forward to menu pane
long FXOption::onKeyPress(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_KEYPRESS),ptr)) return 1;
    switch(event->code){
      case KEY_KP_Enter:
      case KEY_Return:
      case KEY_space:
      case KEY_KP_Space:
        return 1;
      }
    }
  return 0;
  }


// Keyboard release; forward to menu pane
long FXOption::onKeyRelease(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_KEYRELEASE),ptr)) return 1;
    switch(event->code){
      case KEY_KP_Enter:
      case KEY_Return:
      case KEY_space:
      case KEY_KP_Space:
        getParent()->handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),this);
        if(target) target->handle(this,MKUINT(message,SEL_COMMAND),ptr);
        return 1;
      }
    }
  return 0;
  }


// Hot key combination pressed
long FXOption::onHotKeyPress(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyPress %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    handle(this,MKUINT(0,SEL_ACTIVATE),ptr);
    }
  return 1;
  }


// Hot key combination released
long FXOption::onHotKeyRelease(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyRelease %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){ 
    handle(this,MKUINT(0,SEL_DEACTIVATE),ptr); 
    }
  return 1;
  }


// Into focus chain
void FXOption::setFocus(){
  FXLabel::setFocus();
  flags|=FLAG_ACTIVE;
  flags&=~FLAG_UPDATE;
  update();
  }



// Out of focus chain
void FXOption::killFocus(){
  FXLabel::killFocus();
  flags&=~FLAG_ACTIVE;
  flags|=FLAG_UPDATE;
  update();
  }


// Delete
FXOption::~FXOption(){
  }


/*******************************************************************************/


// Map
FXDEFMAP(FXOptionMenu) FXOptionMenuMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXOptionMenu::onPaint),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXOptionMenu::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXOptionMenu::onLeftBtnRelease),
  FXMAPFUNC(SEL_FOCUSIN,0,FXOptionMenu::onFocusIn),
  FXMAPFUNC(SEL_FOCUSOUT,0,FXOptionMenu::onFocusOut),
  FXMAPFUNC(SEL_MOTION,0,FXOptionMenu::onMotion),
  FXMAPFUNC(SEL_KEYPRESS,0,FXOptionMenu::onKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXOptionMenu::onKeyRelease),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_POST,FXOptionMenu::onCmdPost),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_UNPOST,FXOptionMenu::onCmdUnpost),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_TIP,FXOptionMenu::onQueryTip),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_HELP,FXOptionMenu::onQueryHelp),
  };


// Object implementation
FXIMPLEMENT(FXOptionMenu,FXLabel,FXOptionMenuMap,ARRAYNUMBER(FXOptionMenuMap))



// Make a option menu button
FXOptionMenu::FXOptionMenu(FXComposite* p,FXPopup* pup,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXLabel(p,NULL,NULL,opts,x,y,w,h,pl,pr,pt,pb){
  flags|=FLAG_ENABLED;
  dragCursor=getApp()->rarrowCursor;
  pane=pup;
  current=NULL;
  if(pane){
    current=(FXOption*)pane->getFirst();
    if(current){
      label=current->getText();
      icon=current->getIcon();
      }
    }
  }


// Create window
void FXOptionMenu::create(){
  FXLabel::create();
  if(pane) pane->create();
  }


// Detach window
void FXOptionMenu::detach(){
  FXLabel::detach();
  if(pane) pane->detach();
  }


// Destroy window
void FXOptionMenu::destroy(){
  FXLabel::destroy();
  }


// Get default width
FXint FXOptionMenu::getDefaultWidth(){
  FXint w=0;
  if(pane){ w=pane->getDefaultWidth(); }
  return (border<<1)+w;
  }


// Get default height
FXint FXOptionMenu::getDefaultHeight(){
  FXint h=0;
  if(pane && pane->getFirst()){
    h=pane->getFirst()->getDefaultHeight();
    }
  return (border<<1)+h;
  }


// Gained focus
long FXOptionMenu::onFocusIn(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusIn(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }

  
// Lost focus
long FXOptionMenu::onFocusOut(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusOut(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }


// Handle repaint 
long FXOptionMenu::onPaint(FXObject*,FXSelector,void* ptr){
  FXint tw=0,th=0,iw=MENUGLYPH_WIDTH,ih=MENUGLYPH_HEIGHT,tx,ty,ix,iy;
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  
  drawFrame(dc,0,0,width,height);
  
  // Draw background
  dc.setForeground(backColor);
  dc.fillRectangle(border,border,width-border*2,height-border*2);
  
  // Position text & icon
  if(!label.empty()){
    tw=labelWidth(label);
    th=labelHeight(label);
    }
  if(icon){
    iw=icon->getWidth();
    ih=icon->getHeight();
    }
  
  // Keep some room for the arrow!
  just_x(tx,ix,tw,iw);
  just_y(ty,iy,th,ih);

  // Draw icon
  if(icon){
    dc.drawIcon(icon,ix,iy);
    }
  
  // Or draw rectangle
  else{
    drawDoubleRaisedRectangle(dc,ix,iy,MENUGLYPH_WIDTH,MENUGLYPH_HEIGHT);
    }

  // Draw text
  if(!label.empty()){
    dc.setTextFont(font);
    if(isEnabled()){
      dc.setForeground(textColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      if(hasFocus()){ 
        drawFocusRectangle(dc,border+2,border+2,width-2*border-4,height-2*border-4); 
        }
      }
    else{
      dc.setForeground(hiliteColor);
      drawLabel(dc,label,hotoff,tx+1,ty+1,tw,th);
      dc.setForeground(shadowColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      }
    }
  return 1;
  }



// Keyboard press; forward to menu pane
long FXOptionMenu::onKeyPress(FXObject*,FXSelector sel,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  flags&=~FLAG_TIP;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_KEYPRESS),ptr)) return 1;
    if(pane && pane->shown() && pane->handle(pane,sel,ptr)) return 1;
    switch(event->code){
      case KEY_space:
      case KEY_KP_Space:
        return 1;
      }
    }
  return 0;
  }


// Keyboard release; forward to menu pane
long FXOptionMenu::onKeyRelease(FXObject*,FXSelector sel,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_KEYRELEASE),ptr)) return 1;
    if(pane && pane->shown() && pane->handle(pane,sel,ptr)) return 1;
    switch(event->code){
      case KEY_space:
      case KEY_KP_Space:
        if(pane){
          if(pane->shown()){
            handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),NULL);
            }
          else{
            handle(this,MKUINT(ID_POST,SEL_COMMAND),NULL);
            }
          }
        return 1;
      }
    }
  return 0;
  }


// Pressed left button
long FXOptionMenu::onLeftBtnPress(FXObject*,FXSelector,void* ptr){
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONPRESS),ptr)) return 1;
    if(pane){
      if(pane->shown()){
        handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),NULL);
        }
      else{
        handle(this,MKUINT(ID_POST,SEL_COMMAND),NULL);
        }
      }
    return 1;
    }
  return 0;
  }


// Released left button
long FXOptionMenu::onLeftBtnRelease(FXObject*,FXSelector,void* ptr){
  FXEvent* ev=(FXEvent*)ptr;
  flags&=~FLAG_TIP;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONRELEASE),ptr)) return 1;
    if(pane){
      if(ev->moved){ handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),NULL); }
      }
    return 1;
    }
  return 0;
  }


// If we moved over the pane, we'll ungrab again, or re-grab
// when outside of the plane
long FXOptionMenu::onMotion(FXObject*,FXSelector,void* ptr){
  FXEvent* ev=(FXEvent*)ptr;
  if(pane && pane->shown()){
    flags&=~FLAG_TIP;
    if(pane->contains(ev->root_x,ev->root_y)){
      if(grabbed()) ungrab(); 
      }
    else{
      if(!grabbed()) grab();
      }
    return 1;
    }
  return 0;
  }


// Post the menu
long FXOptionMenu::onCmdPost(FXObject*,FXSelector,void*){
  if(pane && !pane->shown()){
    FXint x,y;
    if(!current) current=(FXOption*)pane->getFirst();
    if(!current) return 1;
    translateCoordinatesTo(x,y,getRoot(),0,0);
    pane->position(x,y,width,pane->getDefaultHeight());
    y+=2-current->getY();
    pane->popup(this,x,y,width,pane->getDefaultHeight());
    current->setFocus();
    flags&=~FLAG_UPDATE;
    if(!grabbed()) grab();
    }
  return 1;
  }


// Unpost the menu
// Sender was the original option that sent the message
long FXOptionMenu::onCmdUnpost(FXObject*,FXSelector,void* ptr){
  if(pane && pane->shown()){
    pane->popdown();
    if(grabbed()) ungrab();
    if(ptr) setCurrent((FXOption*)ptr);
    }
  flags|=FLAG_UPDATE;
  return 1;
  }


// Layout
void FXOptionMenu::layout(){
  FXLabel::layout();
  if(!current && pane && pane->getFirst()){
    setCurrent((FXOption*)pane->getFirst());
    }
  flags&=~FLAG_DIRTY;
  }


// Logically inside pane
FXbool FXOptionMenu::contains(FXint parentx,FXint parenty) const {
  if(pane && pane->shown() && pane->contains(parentx,parenty)) return 1;
  return 0;
  }


// Out of focus chain
void FXOptionMenu::killFocus(){
  FXLabel::killFocus();
  handle(current,MKUINT(ID_UNPOST,SEL_COMMAND),NULL);
  }


// If window can have focus
FXbool FXOptionMenu::canFocus() const { return 1; }


// Set current selection
void FXOptionMenu::setCurrent(FXOption *win){
  if(win==NULL){ fxerror("%s::setCurrent: NULL window passed.\n",getClassName()); }
  if(win->getParent()!=pane){ fxerror("%s::setCurrent: expected parent of window to be the pane.\n",getClassName()); }
  if(current!=win){
    current=win;
    setText(current->getText());
    setIcon(current->getIcon());
    FXTRACE((200,"new option = %s\n",current->getText().text()));
    }
  }


// Set current option
void FXOptionMenu::setCurrentNo(FXint no){
  register FXint i=0;
  if(pane){
    FXOption *win=(FXOption*)pane->getFirst();
    while(win && i!=no){
      win=(FXOption*)win->getNext();
      i++;
      }
    if(win) setCurrent(win);
    }
  }


// Get current option
FXint FXOptionMenu::getCurrentNo() const {
  register FXint i=0;
  if(pane){
    FXOption *win=(FXOption*)pane->getFirst();
    while(win && win!=current){
      win=(FXOption*)win->getNext();
      i++;
      }
    }
  return i;
  }


// Change popup
void FXOptionMenu::setPopup(FXPopup *pup){
  FXOption *win;
  pane=pup;
  if(pane){
    win=(FXOption*)pane->getFirst();
    if(win){
      setText(win->getText());
      setIcon(win->getIcon());
      }
    current=win;
    }
  }


// The current option's help is returned, unless there is no help,
// in which case the option menu's help is returned
long FXOptionMenu::onQueryHelp(FXObject* sender,FXSelector,void*){
  if(flags&FLAG_HELP){
    if(current){
      FXString optionhelp=current->getHelpText();
      if(!optionhelp.empty()){
        sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&optionhelp);
        return 1;
        }
      }
    if(!help.empty()){
      sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&help);
      return 1;
      }
    }
  return 0;
  }


// The current option's tip is returned, unless there is no tip,
// in which case the option menu's tip is returned
long FXOptionMenu::onQueryTip(FXObject* sender,FXSelector,void*){
  if(flags&FLAG_TIP){
    if(current){
      FXString optiontip=current->getTipText();
      if(!optiontip.empty()){
        sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&optiontip);
        return 1;
        }
      }
    if(!tip.empty()){
      sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&tip);
      return 1;
      }
    }
  return 0;
  }


// True if popped up
FXbool FXOptionMenu::isPopped() const {
  return pane && pane->shown();
  }


// Save object to stream
void FXOptionMenu::save(FXStream& store) const {
  FXLabel::save(store);
  store << pane;
  store << current;
  }


// Load object from stream
void FXOptionMenu::load(FXStream& store){
  FXLabel::load(store);
  store >> pane;
  store >> current;
  }  


// Delete it
FXOptionMenu::~FXOptionMenu(){
  pane=(FXPopup*)-1;
  current=(FXOption*)-1;
  }

