/********************************************************************************
*                                                                               *
*                    M e n u   S e p a r a t o r   W i d g e t                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuSeparator.cpp,v 1.5 2000/02/28 17:26:37 jeroen Exp $               *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXMenuSeparator.h"

/*
  Notes:
  - Accelerators.
  - Help text from constructor is third part; second part should be
    accelerator key combination.
  - When menu label changes, hotkey might have to be adjusted.
  - Fix it so menu stays up when after Alt-F, you press Alt-E.
  - MenuItems should be derived from FXLabel.
  - FXMenuCascade should send ID_POST/IDUNPOST to self.
  - Look into SEL_FOCUS_SELF some more...
*/


#define LEADSPACE   22
#define TRAILSPACE  16

/*******************************************************************************/

// Map
FXDEFMAP(FXMenuSeparator) FXMenuSeparatorMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMenuSeparator::onPaint),
  };


// Object implementation
FXIMPLEMENT(FXMenuSeparator,FXFrame,FXMenuSeparatorMap,ARRAYNUMBER(FXMenuSeparatorMap))


// Separator item
FXMenuSeparator::FXMenuSeparator(FXComposite* p,FXuint opts):
  FXFrame(p,opts,0,0,0,0){ 
  defaultCursor=getApp()->rarrowCursor;
  }


// Handle repaint 
long FXMenuSeparator::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  dc.setForeground(shadowColor);
  dc.drawLine(1,0,width-1,0);
  dc.setForeground(hiliteColor);
  dc.drawLine(1,1,width-1,1);
  return 1;
  }


// Get default size
FXint FXMenuSeparator::getDefaultWidth(){ 
  return LEADSPACE+TRAILSPACE;
  }


FXint FXMenuSeparator::getDefaultHeight(){ 
  return 2; 
  }


