/********************************************************************************
*                                                                               *
*                       M e n u   C a p t i o n   W i d g e t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuCaption.cpp,v 1.6 2000/02/28 17:26:37 jeroen Exp $                 *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXMenuCaption.h"

/*
  Notes:
  - Accelerators.
  - Help text from constructor is third part; second part should be
    accelerator key combination.
  - When menu label changes, hotkey might have to be adjusted.
  - Fix it so menu stays up when after Alt-F, you press Alt-E.
  - MenuItems should be derived from FXLabel.
  - FXMenuCascade should send ID_POST/IDUNPOST to self.
  - Look into SEL_FOCUS_SELF some more...
*/


#define LEADSPACE   22
#define TRAILSPACE  16

/*******************************************************************************/


// Map
FXDEFMAP(FXMenuCaption) FXMenuCaptionMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMenuCaption::onPaint),
  FXMAPFUNC(SEL_UPDATE,0,FXMenuCaption::onUpdate),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_HELP,FXMenuCaption::onQueryHelp),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXMenuCaption::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXMenuCaption::onCmdGetStringValue),
  };


// Object implementation
FXIMPLEMENT(FXMenuCaption,FXFrame,FXMenuCaptionMap,ARRAYNUMBER(FXMenuCaptionMap))



// Menu entry
FXMenuCaption::FXMenuCaption(FXComposite* p,const FXString& text,FXIcon* ic,FXuint opts):
  FXFrame(p,opts,0,0,0,0){
  label=text.extract(0,'\t','&');
  help=text.extract(2,'\t');
  icon=ic;
  font=getApp()->getNormalFont();
  hotkey=fxparsehotkey(text.text());
  hotoff=fxfindhotkeyoffset(text.text());
  addHotKey(hotkey);
  textColor=getApp()->foreColor;
  seltextColor=getApp()->selforeColor;
  selbackColor=getApp()->selbackColor;
  }


// Create Window
void FXMenuCaption::create(){
  FXFrame::create();
  font->create();
  if(icon) icon->create();
  }


// Detach Window
void FXMenuCaption::detach(){
  FXFrame::detach();
  font->detach();
  if(icon) icon->detach();
  }

  
// Enable the menu entry
void FXMenuCaption::enable(){
  if(!(flags&FLAG_ENABLED)){
    FXFrame::enable();
    update();
    }
  }


// Disable the menu entry
void FXMenuCaption::disable(){
  if(flags&FLAG_ENABLED){
    FXFrame::disable();
    update();
    }
  }


// Get default width
FXint FXMenuCaption::getDefaultWidth(){
  FXint tw,iw;
  tw=iw=0;
  if(!label.empty()) tw=font->getTextWidth(label.text(),label.length());
  if(icon) iw=icon->getWidth()+5;
  return FXMAX(iw,LEADSPACE)+tw+TRAILSPACE;
  }


// Get default height
FXint FXMenuCaption::getDefaultHeight(){
  FXint th,ih,h;
  th=ih=h=0;
  if(!label.empty()) th=font->getFontHeight()+5;
  if(icon) ih=icon->getHeight()+5;
  h=FXMAX(th,ih);
  return h;
  }


// We were asked about status text
long FXMenuCaption::onQueryHelp(FXObject* sender,FXSelector,void*){
  if(!help.empty() && (flags&FLAG_HELP)){
    sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&help);
    return 1;
    }
  return 0;
  }


// Implement auto-hide or auto-gray modes
long FXMenuCaption::onUpdate(FXObject* sender,FXSelector sel,void* ptr){
  if(!FXFrame::onUpdate(sender,sel,ptr)){
    if(options&MENU_AUTOHIDE){if(shown()){hide();recalc();}}
    if(options&MENU_AUTOGRAY){disable();}
    }
  return 1;
  }


// Handle repaint 
long FXMenuCaption::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXint yy;
  dc.setForeground(backColor);
  dc.fillRectangle(0,0,width,height);
  if(icon){
    dc.drawIcon(icon,3,(height-icon->getHeight())/2);
    }
  if(!label.empty()){
    dc.setTextFont(font);
    dc.setForeground(textColor);
    yy=font->getFontAscent()+(height-font->getFontHeight())/2;
    dc.drawText(LEADSPACE,yy,label.text(),label.length());
    if(0<=hotoff){
      dc.drawLine(LEADSPACE+1+font->getTextWidth(label.text(),hotoff),yy+1,LEADSPACE+font->getTextWidth(label.text(),hotoff+1),yy+1);
      }
    }
  return 1;
  }


// Update value from a message
long FXMenuCaption::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setText(*((FXString*)ptr));
  return 1;
  }


// Obtain value from text field
long FXMenuCaption::onCmdGetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetStringValue: NULL pointer.\n",getClassName()); }
  *((FXString*)ptr)=getText();
  return 1;
  }


// Change help text
void FXMenuCaption::setHelpText(const FXString& text){
  help=text;
  }


// Change text; the old hot key remains in effect, but the `_' disappears
void FXMenuCaption::setText(const FXString& text){
  FXString str=text.extract(0,'\t','&');
  if(label!=str){
    remHotKey(hotkey);
    hotkey=fxparsehotkey(text.text());
    hotoff=fxfindhotkeyoffset(text.text());
    addHotKey(hotkey);
    label=str;
    recalc();
    update();
    }
  }


// Change icon
void FXMenuCaption::setIcon(FXIcon* ic){
  if(icon!=ic){
    icon=ic;
    recalc();
    update();
    }
  }


// Change font
void FXMenuCaption::setFont(FXFont* fnt){
  if(!fnt){ fxerror("%s::setFont: NULL font specified.\n",getClassName()); }
  if(font!=fnt){
    font=fnt;
    recalc();
    update();
    }
  }


// Set text color
void FXMenuCaption::setTextColor(FXColor clr){
  textColor=clr;
  update();
  }


// Set select background color
void FXMenuCaption::setSelBackColor(FXColor clr){
  selbackColor=clr;
  update();
  }


// Set selected text color
void FXMenuCaption::setSelTextColor(FXColor clr){
  seltextColor=clr;
  update();
  }


// Save object to stream
void FXMenuCaption::save(FXStream& store) const {
  FXFrame::save(store);
  store << label;
  store << help;
  store << icon;
  store << font;
  store << hotoff;
  store << hotkey;
  store << textColor;
  store << selbackColor;
  store << seltextColor;
  }


// Load object from stream
void FXMenuCaption::load(FXStream& store){
  FXFrame::load(store);
  store >> label;
  store >> help;
  store >> icon;
  store >> font;
  store >> hotoff;
  store >> hotkey;
  store >> textColor;
  store >> selbackColor;
  store >> seltextColor;
  }  


// Zap it
FXMenuCaption::~FXMenuCaption(){
  remHotKey(hotkey);
  font=(FXFont*)-1;
  icon=(FXIcon*)-1;
  }


