/********************************************************************************
*                                                                               *
*                      J P E G   I m a g e   O b j e c t                        *
*                                                                               *
*********************************************************************************
* Author: David Tyree   Email: celer@ipro.lug.usf.edu                           *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXJPEGImage.cpp,v 1.8 2000/02/28 17:26:37 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXJPEGImage.h"



/*
  Notes:
  - Requires JPEG library
*/


/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXJPEGImage,FXImage,NULL,0)


// Initialize
FXJPEGImage::FXJPEGImage(FXApp* a,const void *pix,FXuint opts,FXint w,FXint h):
  FXImage(a,NULL,opts&~IMAGE_ALPHA,w,h){
  quality=75;
  if(pix){     
    FXMemoryStream ms;
    FXColor clearcolor;
    ms.open((FXuchar*)pix,FXStreamLoad);
    fxloadJPEG(ms,data,clearcolor,width,height,quality);   
    options|=IMAGE_OWNED;
    ms.close();   
    }
  }    


// Save the pixels only
void FXJPEGImage::savePixels(FXStream& store) const {
  FXColor clearcolor=FXRGB(192,192,192);
  FXASSERT(!(options&IMAGE_ALPHA));
  fxsaveJPEG(store,data,clearcolor,width,height,quality);    
  }



// Load pixels only
void FXJPEGImage::loadPixels(FXStream& store){
  FXColor clearcolor;
  if(options&IMAGE_OWNED){FXFREE(&data);}
  fxloadJPEG(store,data,clearcolor,width,height,quality);   
  options&=~IMAGE_ALPHA;
  options|=IMAGE_OWNED;
  }    


// Clean up
FXJPEGImage::~FXJPEGImage(){
  }
