/********************************************************************************
*                                                                               *
*                      O p e n G L   S h a p e   O b j e c t                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* Contributed by: Angel-Ventura Mendo Gomez <ventura@labri.u-bordeaux.fr>       *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLShape.cpp,v 1.6 2000/02/20 19:17:50 jeroen Exp $                     *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXVec.h"
#include "FXHVec.h"
#include "FXQuat.h"
#include "FXHMat.h"
#include "FXRange.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXCursor.h"
#include "FXGLCanvas.h"
#include "FXDC.h"
#include "FXDCPrint.h"
#include "FXGLViewer.h"
#include "FXGLObject.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXTooltip.h"
#include "FXGLShape.h"


#define FACTOR  0.5f
#define BIAS    0.002f


/*******************************************************************************/

// Drop
FXDEFMAP(FXGLShape) FXGLShapeMap[]={
  FXMAPFUNC(SEL_DND_DROP,0,FXGLShape::onDNDDrop),
  FXMAPFUNC(SEL_DND_MOTION,0,FXGLShape::onDNDMotion),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_TIP,FXGLShape::onQueryTip),
  FXMAPFUNC(SEL_COMMAND,FXGLShape::ID_SHADEOFF,FXGLShape::onCmdShadeOff),
  FXMAPFUNC(SEL_COMMAND,FXGLShape::ID_SHADEON,FXGLShape::onCmdShadeOn),
  FXMAPFUNC(SEL_COMMAND,FXGLShape::ID_SHADESMOOTH,FXGLShape::onCmdShadeSmooth),
  FXMAPFUNC(SEL_UPDATE,FXGLShape::ID_SHADEOFF,FXGLShape::onUpdShadeOff),
  FXMAPFUNC(SEL_UPDATE,FXGLShape::ID_SHADEON,FXGLShape::onUpdShadeOn),
  FXMAPFUNC(SEL_UPDATE,FXGLShape::ID_SHADESMOOTH,FXGLShape::onUpdShadeSmooth),
  FXMAPFUNC(SEL_COMMAND,FXGLShape::ID_FRONT_MATERIAL,FXGLShape::onCmdFrontMaterial),
  FXMAPFUNC(SEL_UPDATE,FXGLShape::ID_FRONT_MATERIAL,FXGLShape::onUpdFrontMaterial),
  FXMAPFUNC(SEL_COMMAND,FXGLShape::ID_BACK_MATERIAL,FXGLShape::onCmdBackMaterial),
  FXMAPFUNC(SEL_UPDATE,FXGLShape::ID_BACK_MATERIAL,FXGLShape::onUpdBackMaterial),
  FXMAPFUNCS(SEL_COMMAND,FXGLShape::ID_STYLE_POINTS,FXGLShape::ID_STYLE_BOUNDINGBOX,FXGLShape::onCmdDrawingStyle),
  FXMAPFUNCS(SEL_UPDATE,FXGLShape::ID_STYLE_POINTS,FXGLShape::ID_STYLE_BOUNDINGBOX,FXGLShape::onUpdDrawingStyle)
  };

  
// Object implementation
FXIMPLEMENT_ABSTRACT(FXGLShape,FXGLObject,FXGLShapeMap,ARRAYNUMBER(FXGLShapeMap))

 

// Serialization
FXGLShape::FXGLShape(){
  
  position=FXVec(0.0,0.0,0.0);
  
  material[0].ambient=FXHVec(0.2f,0.2f,0.2f,1.0);      // Front facing material
  material[0].diffuse=FXHVec(0.8f,0.8f,0.8f,1.0);
  material[0].specular=FXHVec(1.0,1.0,1.0,1.0);
  material[0].emission=FXHVec(0.0,0.0,0.0,1.0);
  material[0].shininess=30.0;
  
  material[1].ambient=FXHVec(0.2f,0.2f,0.2f,1.0);      // Back facing material
  material[1].diffuse=FXHVec(0.8f,0.8f,0.8f,1.0);
  material[1].specular=FXHVec(1.0,1.0,1.0,1.0);
  material[1].emission=FXHVec(0.0,0.0,0.0,1.0);
  material[1].shininess=30.0;
  
  range=FXRange(-1.0,1.0,-1.0,1.0,-1.0,1.0);       // Ample bounding box
  
  options=SHADING_SMOOTH|STYLE_SURFACE;
  }


// Create initialized shape
FXGLShape::FXGLShape(FXfloat x,FXfloat y,FXfloat z,FXuint opts){
  position[0]=x;
  position[1]=y;
  position[2]=z;
  material[0].ambient=FXHVec(0.2f,0.2f,0.2f,1.0);
  material[0].diffuse=FXHVec(0.8f,0.8f,0.8f,1.0);
  material[0].specular=FXHVec(1.0,1.0,1.0,1.0);
  material[0].emission=FXHVec(0.0,0.0,0.0,1.0);
  material[0].shininess=30.0;
  material[1].ambient=FXHVec(0.2f,0.2f,0.2f,1.0);
  material[1].diffuse=FXHVec(0.8f,0.8f,0.8f,1.0);
  material[1].specular=FXHVec(1.0,1.0,1.0,1.0);
  material[1].emission=FXHVec(0.0,0.0,0.0,1.0);
  material[1].shininess=30.0;
  range=FXRange(-1.0,1.0,-1.0,1.0,-1.0,1.0);
  options=opts;
  }


// Create initialized shape
FXGLShape::FXGLShape(FXfloat x,FXfloat y,FXfloat z,FXuint opts,const FXMaterial& front,const FXMaterial& back){
  position[0]=x;
  position[1]=y;
  position[2]=z;
  material[0]=front;
  material[1]=back;
  range=FXRange(-1.0,1.0,-1.0,1.0,-1.0,1.0);
  options=opts;
  }


// Return true if it can be dragged
FXbool FXGLShape::canDrag() const { return TRUE; }


// Object may be deleted
FXbool FXGLShape::canDelete() const { return TRUE; }


// Handle drag-and-drop drop
long FXGLShape::onDNDDrop(FXObject* sender,FXSelector,void*){
  FXuchar *data; FXuint len,r,g,b,a;
  FXHVec color;
  if(((FXWindow*)sender)->offeredDNDType(FROM_DRAGNDROP,FXWindow::colorType)){
    if(((FXWindow*)sender)->getDNDData(FROM_DRAGNDROP,FXWindow::colorType,data,len)){
      sscanf((char*)data,"#%02x%02x%02x%02x",&r,&g,&b,&a);
      color[0]=r*0.0039215686f;
      color[1]=g*0.0039215686f;
      color[2]=b*0.0039215686f;
      color[3]=a*0.0039215686f;
      material[0].ambient=color;
      material[0].diffuse=color;
      material[1].ambient=color;
      material[1].diffuse=color;
      FXFREE(&data);
      return 1;
      }
    }
  return 0;
  }


// Cursor got dragged over here.
long FXGLShape::onDNDMotion(FXObject*,FXSelector,void*){
  return 1;
  }


// We were asked about tip text
long FXGLShape::onQueryTip(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&tip);
  return 1;
  }


// Shading off
long FXGLShape::onCmdShadeOff(FXObject*,FXSelector,void*){
  options&=~(SHADING_SMOOTH|SHADING_FLAT);
  return 1;
  }


// Shading on [flat]
long FXGLShape::onCmdShadeOn(FXObject*,FXSelector,void*){
  options&=~SHADING_SMOOTH;
  options|=SHADING_FLAT;
  return 1;
  }


// Shading on [smoooooooooth]
long FXGLShape::onCmdShadeSmooth(FXObject*,FXSelector,void*){
  options&=~SHADING_FLAT;
  options|=SHADING_SMOOTH;
  return 1;
  }

// Update shading off button
long FXGLShape::onUpdShadeOff(FXObject* sender,FXSelector,void* ptr){
  FXuint msg = (options&(SHADING_FLAT|SHADING_SMOOTH))? FXWindow::ID_UNCHECK : FXWindow::ID_CHECK;
  sender->handle(this,MKUINT(FXWindow::ID_ENABLE,SEL_COMMAND),ptr);
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }

// Update shading on button
long FXGLShape::onUpdShadeOn(FXObject* sender,FXSelector,void* ptr){
  FXuint msg = (options&SHADING_FLAT)? FXWindow::ID_CHECK : FXWindow::ID_UNCHECK;
  sender->handle(this,MKUINT(FXWindow::ID_ENABLE,SEL_COMMAND),ptr);
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }

// Update shading smooth button
long FXGLShape::onUpdShadeSmooth(FXObject* sender,FXSelector,void* ptr){
  FXuint msg = (options&SHADING_SMOOTH)? FXWindow::ID_CHECK : FXWindow::ID_UNCHECK;
  sender->handle(this,MKUINT(FXWindow::ID_ENABLE,SEL_COMMAND),ptr);
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Drag shape around
FXbool FXGLShape::drag(FXGLViewer* viewer,FXint fx,FXint fy,FXint tx,FXint ty){
  FXfloat zz=viewer->worldToEyeZ(position);
  FXVec wf=viewer->eyeToWorld(viewer->screenToEye(fx,fy,zz));
  FXVec wt=viewer->eyeToWorld(viewer->screenToEye(tx,ty,zz));
  position+=wt-wf;
  return TRUE;
  }


// Draw
void FXGLShape::draw(FXGLViewer* viewer){
#ifdef HAVE_OPENGL

  // Save attributes and matrix
  glPushAttrib(GL_CURRENT_BIT|GL_LIGHTING_BIT|GL_POINT_BIT|GL_LINE_BIT);
  glPushMatrix();

  // Object position
  glTranslatef(position[0],position[1],position[2]);
  
  // Draw full object
  if(!viewer->doesTurbo()){

    // Shading
    if(options&(SHADING_SMOOTH|SHADING_FLAT)){
      glEnable(GL_LIGHTING);
      if(options&SHADING_SMOOTH){
        glEnable(GL_AUTO_NORMAL);
        glShadeModel(GL_SMOOTH); 
        }
      else{
        glDisable(GL_AUTO_NORMAL);
        glShadeModel(GL_FLAT); 
        }
      }
    else{
      glDisable(GL_LIGHTING);
      }

    // Material
    if(options&SURFACE_DUALSIDED){
      glMaterialfv(GL_FRONT,GL_AMBIENT,material[0].ambient);
      glMaterialfv(GL_FRONT,GL_DIFFUSE,material[0].diffuse);
      glMaterialfv(GL_FRONT,GL_SPECULAR,material[0].specular);
      glMaterialfv(GL_FRONT,GL_EMISSION,material[0].emission);
      glMaterialf(GL_FRONT,GL_SHININESS,material[0].shininess);
      glMaterialfv(GL_BACK,GL_AMBIENT,material[1].ambient);
      glMaterialfv(GL_BACK,GL_DIFFUSE,material[1].diffuse);
      glMaterialfv(GL_BACK,GL_SPECULAR,material[1].specular);
      glMaterialfv(GL_BACK,GL_EMISSION,material[1].emission);
      glMaterialf(GL_BACK,GL_SHININESS,material[1].shininess);
      }
    else{
      glMaterialfv(GL_FRONT_AND_BACK,GL_AMBIENT,material[0].ambient);
      glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,material[0].diffuse);
      glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,material[0].specular);
      glMaterialfv(GL_FRONT_AND_BACK,GL_EMISSION,material[0].emission);
      glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,material[0].shininess);
      }

    // Surface
    if(options&STYLE_SURFACE){
      glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
      if(options&FACECULLING_ON)
        glEnable(GL_CULL_FACE);
      else
        glDisable(GL_CULL_FACE);
      drawshape(viewer);
      }

    // Wire frame
    if(options&STYLE_WIREFRAME){
      glDisable(GL_LIGHTING);
      glShadeModel(GL_FLAT); 
      glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
      if(options&STYLE_SURFACE){                  // Wires over surface
#if GL_EXT_polygon_offset
        glEnable(GL_POLYGON_OFFSET_EXT);
        glPolygonOffsetEXT(FACTOR, BIAS);
        drawshape(viewer);
        glDisable(GL_POLYGON_OFFSET_EXT);
#elif GLU_VERSION_1_1
        glEnable(GL_POLYGON_OFFSET_LINE);
#if !defined(__CYGWIN__) && !defined(__MINGW32__) /* glPolygonOffset is missing from their import library */
        glPolygonOffset(FACTOR, BIAS);
#endif
        drawshape(viewer);
        glDisable(GL_POLYGON_OFFSET_LINE);
#endif
        }
      else{                                       // Wires by themselves
        glDisable(GL_CULL_FACE);
        drawshape(viewer);
        }
      }

    // Points
    if(options&STYLE_POINTS){
      glDisable(GL_LIGHTING);
      glShadeModel(GL_FLAT); 
      glPolygonMode(GL_FRONT_AND_BACK,GL_POINT);
      if(options&STYLE_SURFACE){                  // Points over surface
#if GL_EXT_polygon_offset
        glEnable(GL_POLYGON_OFFSET_EXT);
        glPolygonOffsetEXT(FACTOR, BIAS);
        drawshape(viewer);
        glDisable(GL_POLYGON_OFFSET_EXT);
#elif GLU_VERSION_1_1
        glEnable(GL_POLYGON_OFFSET_POINT);
#if !defined(__CYGWIN__) && !defined(__MINGW32__) /* glPolygonOffset is missing from their import library */
        glPolygonOffset(FACTOR, BIAS);
#endif
        drawshape(viewer);
        glDisable(GL_POLYGON_OFFSET_POINT);
#endif
        }
      else{
        glDisable(GL_CULL_FACE);
        drawshape(viewer);
        }
      }
    }
  
  // Box
  if((options&STYLE_BOUNDBOX) || (viewer->getSelection()==this)){
    glDisable(GL_LIGHTING);
    glShadeModel(GL_FLAT);
    if(viewer->getSelection()==this){
      glColor3f(0.0,1.0,0.0);
      drawbox();
      glPointSize(4.0);
      drawhandles();
      }
    else{
      glColor3f(0.7f,0.7f,0.7f);
      drawbox();
      }
    }

  // Restore attributes and matrix
  glPopMatrix();  
  glPopAttrib();
#endif
  }


// Draw for hit
void FXGLShape::hit(FXGLViewer* viewer){
  draw(viewer);
  }


// Get bounding box
void FXGLShape::bounds(FXRange& box){
  box[0][0]=position[0]+range[0][0]; box[0][1]=position[0]+range[0][1];
  box[1][0]=position[1]+range[1][0]; box[1][1]=position[1]+range[1][1];
  box[2][0]=position[2]+range[2][0]; box[2][1]=position[2]+range[2][1];
  }


// Draw a box
void FXGLShape::drawbox(){
#ifdef HAVE_OPENGL
  glBegin(GL_LINE_LOOP);
  glVertex3f(range[0][1], range[1][0], range[2][0]);
  glVertex3f(range[0][1], range[1][0], range[2][1]);
  glVertex3f(range[0][0], range[1][0], range[2][1]);
  glVertex3f(range[0][0], range[1][1], range[2][1]);
  glVertex3f(range[0][1], range[1][1], range[2][1]);
  glVertex3f(range[0][1], range[1][1], range[2][0]);
  glVertex3f(range[0][0], range[1][1], range[2][0]);
  glVertex3f(range[0][0], range[1][0], range[2][0]);
  glEnd();
  glBegin(GL_LINES);
  glVertex3f(range[0][0], range[1][0], range[2][0]);
  glVertex3f(range[0][0], range[1][0], range[2][1]);
  glVertex3f(range[0][0], range[1][1], range[2][0]);
  glVertex3f(range[0][0], range[1][1], range[2][1]);
  glVertex3f(range[0][1], range[1][0], range[2][0]);
  glVertex3f(range[0][1], range[1][1], range[2][0]);
  glVertex3f(range[0][1], range[1][0], range[2][1]);
  glVertex3f(range[0][1], range[1][1], range[2][1]);
  glEnd();
#endif
  }


// Draw handles
void FXGLShape::drawhandles(){
#ifdef HAVE_OPENGL
  glBegin(GL_POINTS);
  glVertex3f(range[0][0], range[1][0], range[2][0]);
  glVertex3f(range[0][0], range[1][0], range[2][1]);
  glVertex3f(range[0][0], range[1][1], range[2][0]);
  glVertex3f(range[0][0], range[1][1], range[2][1]);
  glVertex3f(range[0][1], range[1][0], range[2][0]);
  glVertex3f(range[0][1], range[1][0], range[2][1]);
  glVertex3f(range[0][1], range[1][1], range[2][0]);
  glVertex3f(range[0][1], range[1][1], range[2][1]);
  glEnd();
#endif
  }


// Command from material editor
long FXGLShape::onCmdFrontMaterial(FXObject*,FXSelector,void *ptr){
  setMaterial(0,*((FXMaterial*)ptr));
  return 1;
  }


// Update material editor
long FXGLShape::onUpdFrontMaterial(FXObject *sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETVALUE,SEL_COMMAND),(void *)&material[0]);
  return 1;
  }


// Command from material editor
long FXGLShape::onCmdBackMaterial(FXObject*,FXSelector,void *ptr){
  setMaterial(1,*((FXMaterial*)ptr));
  return 1;
  }


// Update material editor
long FXGLShape::onUpdBackMaterial(FXObject *sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETVALUE,SEL_COMMAND),(void *)&material[1]);
  return 1;
  }


// Change material of side of surface
void FXGLShape::setMaterial(FXint side,const FXMaterial& mtl){
  material[side]=mtl;
  }


// Obtain material of surface
void FXGLShape::getMaterial(FXint side,FXMaterial& mtl) const {
  mtl=material[side];
  }


// Drawing style toggles
long FXGLShape::onCmdDrawingStyle(FXObject*,FXSelector sel,void*){
  FXuint sid=SELID(sel);
  switch(sid){
    case ID_STYLE_SURFACE: options^=STYLE_SURFACE; break;
    case ID_STYLE_POINTS: options^=STYLE_POINTS; break;
    case ID_STYLE_WIREFRAME: options^=STYLE_WIREFRAME; break;
    case ID_STYLE_BOUNDINGBOX: options^=STYLE_BOUNDBOX; break;
    }
  return 1;
  }


// Update drawing style toggles
long FXGLShape::onUpdDrawingStyle(FXObject *sender,FXSelector sel,void*){
  FXuint msg=FXWindow::ID_UNCHECK;
  FXuint sid=SELID(sel);
  switch(sid){
    case ID_STYLE_SURFACE: if(options&STYLE_SURFACE) msg=FXWindow::ID_CHECK; break;
    case ID_STYLE_POINTS: if(options&STYLE_POINTS) msg=FXWindow::ID_CHECK; break;
    case ID_STYLE_WIREFRAME: if(options&STYLE_WIREFRAME) msg=FXWindow::ID_CHECK; break;
    case ID_STYLE_BOUNDINGBOX: if(options&STYLE_BOUNDBOX) msg=FXWindow::ID_CHECK; break;
    }
  sender->handle(this,MKUINT(msg,SEL_COMMAND),NULL);
  sender->handle(this,MKUINT(FXWindow::ID_ENABLE,SEL_COMMAND),NULL);
  return 1;
  }


// Save object to stream
void FXGLShape::save(FXStream& store) const {
  FXGLObject::save(store);
  store << position;
  store << material[0].ambient;
  store << material[0].diffuse;
  store << material[0].specular;
  store << material[0].emission;
  store << material[0].shininess;
  store << material[1].ambient;
  store << material[1].diffuse;
  store << material[1].specular;
  store << material[1].emission;
  store << material[1].shininess;
  store << range;
  store << options;
  store << tip;
  }


// Load object from stream
void FXGLShape::load(FXStream& store){
  FXGLObject::load(store);
  store >> position;
  store >> material[0].ambient;
  store >> material[0].diffuse;
  store >> material[0].specular;
  store >> material[0].emission;
  store >> material[0].shininess;
  store >> material[1].ambient;
  store >> material[1].diffuse;
  store >> material[1].specular;
  store >> material[1].emission;
  store >> material[1].shininess;
  store >> range;
  store >> options;
  store >> tip;
  }
