/********************************************************************************
*                                                                               *
*                      O p e n G L   C y l i n d e r   O b j e c t              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* Contributed by: Angel-Ventura Mendo Gomez <ventura@labri.u-bordeaux.fr>       *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLCylinder.cpp,v 1.3 2000/02/20 19:17:50 jeroen Exp $                  *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXVec.h"
#include "FXHVec.h"
#include "FXQuat.h"
#include "FXHMat.h"
#include "FXRange.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXCursor.h"
#include "FXGLCanvas.h"
#include "FXDC.h"
#include "FXDCPrint.h"
#include "FXGLViewer.h"
#include "FXGLObject.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXTooltip.h"
#include "FXGLShape.h"
#include "FXGLCylinder.h"


// GLU versions prior to 1.1 have GLUquadric
#if !defined(GLU_VERSION_1_1) && !defined(GLU_VERSION_1_2) && !defined(GLU_VERSION_1_3)
#define GLUquadricObj GLUquadric
#endif


// Cylinder fidelity
#define FXGLCYLINDER_SLICES_NUMBER		20
#define FXGLCYLINDER_STACKS_NUMBER		20
#define FXGLCYLINDER_LOOPS			4

/*******************************************************************************/

  
// Object implementation
FXIMPLEMENT(FXGLCylinder,FXGLShape,NULL,0)


// Create cylinder
FXGLCylinder::FXGLCylinder():height(1.0),radius(1.0){ 
  range[0][0]=-radius; range[0][1]=+radius;
  range[1][0]=0;       range[1][1]=height;
  range[2][0]=-radius; range[2][1]=+radius;
  }


// Create initialized cylinder
FXGLCylinder::FXGLCylinder(FXfloat x,FXfloat y,FXfloat z,FXfloat h,FXfloat r):
  FXGLShape(x,y,z,SHADING_SMOOTH|STYLE_SURFACE),height(h),radius(r){
  range[0][0]=-radius; range[0][1]=+radius;
  range[1][0]=0;       range[1][1]=height;
  range[2][0]=-radius; range[2][1]=+radius;
  }


// Create initialized cylinder
FXGLCylinder::FXGLCylinder(FXfloat x,FXfloat y,FXfloat z,FXfloat h,FXfloat r,const FXMaterial& mtl):
  FXGLShape(x,y,z,SHADING_SMOOTH|STYLE_SURFACE,mtl,mtl),height(h),radius(r){
  range[0][0]=-radius; range[0][1]=+radius;
  range[1][0]=0;       range[1][1]=height;
  range[2][0]=-radius; range[2][1]=+radius;
  }



// Draw
void FXGLCylinder::drawshape(FXGLViewer*){
#ifdef HAVE_OPENGL
  GLUquadricObj* quad=gluNewQuadric();
  gluQuadricDrawStyle(quad,(GLenum)GLU_FILL);
  /*
    gluQuadricNormals(quad,GLU_SMOOTH);
    gluQuadricOrientation(quad,GLU_OUTSIDE);
  */
  glPushMatrix();
  glRotatef(-90,1,0,0);
  gluCylinder(quad,radius,radius,height,FXGLCYLINDER_SLICES_NUMBER,FXGLCYLINDER_STACKS_NUMBER);
  
  gluQuadricOrientation(quad,(GLenum)GLU_INSIDE);
  gluDisk(quad,0,radius,FXGLCYLINDER_SLICES_NUMBER,FXGLCYLINDER_LOOPS);

  glTranslatef(0,0,height);
  gluQuadricOrientation(quad,(GLenum)GLU_OUTSIDE);
  gluDisk(quad,0,radius,FXGLCYLINDER_SLICES_NUMBER,FXGLCYLINDER_LOOPS);
  glPopMatrix();
  gluDeleteQuadric(quad);
#endif
  }

// Save object to stream
void FXGLCylinder::save(FXStream& store) const {
  FXGLShape::save(store);
  store << height << radius;
  }

      
// Load object from stream
void FXGLCylinder::load(FXStream& store){
  FXGLShape::load(store);
  store >> height >> radius;
  }

