/********************************************************************************
*                                                                               *
*                        F i l e    L i s t   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileList.cpp,v 1.27 2000/03/17 07:09:53 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXFile.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXComposite.h"
#include "FXCanvas.h"
#include "FXShell.h"
#include "FXScrollbar.h"
#include "FXScrollArea.h"
#include "FXFileDict.h"
#include "FXHeader.h"
#include "FXIconList.h"
#include "FXFileList.h"
#ifdef WIN32
#include <shellapi.h>
#if defined(__CYGWIN32__) || defined(__MINGW32__)
#ifdef UNICODE
#define SHGetFileInfo SHGetFileInfoW /* wasn't defined in w32api headers */
#else
#define SHGetFileInfo SHGetFileInfoA /* wasn't defined in w32api headers */
#endif
#endif
#endif


/*
  Notes:
  - Fix (at least) hard-wired icons 
  - When an item is selected, we should acquire selection; so if another
    application does a paste, it will get the full pathname.
  - Of course, vice versa a paste of a dirname in the FXFileList should
    switch it to the directory...
  - Instead of FXIconItems, callbacks should pass filename.
  - Translate onClicked etc into opened/launched, etc messages
  - ID_SETSTRINGVALUE etc messages so we can connect text fields with
    FXFileList...
  - Clipboard of filenames.
  - Clipboard, DND, etc. support.
  - Current item is index, should be name!
*/


#define REFRESHINTERVAL     1000
#define REFRESHINTERVALLONG 15000

#define HASH1(x,n) (((unsigned int)(x)*13)%(n))           // Probe Position [0..n-1]
#define HASH2(x,n) (1|(((unsigned int)(x)*17)%((n)-1)))   // Probe Distance [1..n-1]

/*******************************************************************************/

/* Generated by reswrap from file bigapp.gif */
const unsigned char bigapp[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x80,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0x82,0x08,0xba,0xdc,0xfe,0x2c,0xc8,0x49,0xab,0xbd,0x53,0x84,0xc1,0xbb,0xff,0x60,
  0x38,0x04,0xda,0x40,0x9c,0x68,0xaa,0xae,0x2c,0xb9,0xb1,0x70,0xca,0x09,0xf3,0xec,
  0x9a,0x71,0x5c,0x0f,0x34,0x7f,0xe7,0x31,0x81,0x70,0x38,0xbc,0x89,0x8e,0xc8,0x51,
  0x09,0xc3,0x6c,0x2a,0x37,0x81,0x82,0x74,0x4a,0xad,0x5a,0xab,0xcf,0xd1,0x75,0xcb,
  0x95,0x66,0xa3,0xdd,0x30,0xf5,0x2b,0x2e,0x17,0xc8,0xe6,0x30,0x3a,0xcd,0x5d,0xb3,
  0xaf,0xee,0x37,0xf6,0x06,0x96,0x5b,0xe3,0x76,0x2f,0x3d,0x7f,0xdf,0xf3,0xc7,0x7e,
  0x7f,0x7a,0x4b,0x82,0x53,0x78,0x79,0x87,0x76,0x89,0x72,0x8b,0x6f,0x59,0x49,0x90,
  0x1f,0x2e,0x4d,0x94,0x4c,0x44,0x97,0x98,0x99,0x9a,0x43,0x10,0x9d,0x9e,0x9f,0xa0,
  0xa1,0x00,0x09,0x00,0x3b
  };

/* Generated by reswrap from file miniapp.gif */
const unsigned char miniapp[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x38,0x08,0xba,0xdc,0x10,0x30,0xca,0x09,0x85,0xbd,0xf8,0x86,0x11,0x44,0xf9,0x60,
  0xf8,0x6d,0x9d,0x58,0x10,0x03,0x8a,0x92,0x02,0xe5,0x72,0x02,0x21,0xcf,0xb4,0xcc,
  0xd6,0x38,0x71,0xe7,0xf4,0xce,0xdb,0xb0,0xdf,0xcc,0xf7,0x23,0xf2,0x48,0xae,0xd7,
  0x60,0xc9,0x6c,0x3a,0x07,0x8e,0xe8,0x22,0x01,0x00,0x3b
  };

/* Generated by reswrap from file bigdoc.gif */
const unsigned char bigdoc[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xbf,0xbf,0xbf,
  0x80,0x80,0x80,0xff,0xff,0xff,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0x79,0x08,0x0a,0xd1,0xfe,0xf0,0xad,0x49,0x99,0xb8,0x38,0xeb,0x1b,0x46,0xad,0xc1,
  0x26,0x66,0x8d,0xf7,0x2d,0xe1,0x38,0x06,0x44,0x77,0x2a,0xa9,0xba,0x85,0xad,0xf9,
  0xc5,0x32,0x79,0xd5,0x27,0x9e,0x73,0x83,0xa0,0xf0,0xf6,0x93,0x11,0x6c,0x13,0x5f,
  0x31,0x73,0x24,0x2e,0x45,0x4d,0xd0,0x13,0x8a,0x44,0x4d,0x37,0x51,0x8a,0x72,0x9a,
  0x4d,0x5e,0x35,0x5d,0xeb,0x17,0x13,0x86,0x8d,0xc9,0x55,0xf3,0x59,0x50,0xb6,0xac,
  0xdb,0xdb,0x27,0x7c,0xcd,0x4e,0xbb,0xcf,0xf3,0xb7,0x3d,0xbe,0xcc,0xe3,0xf7,0x74,
  0x7e,0x63,0x82,0x5f,0x84,0x57,0x86,0x5c,0x80,0x7a,0x37,0x04,0x8d,0x8e,0x8f,0x90,
  0x91,0x8d,0x76,0x42,0x95,0x96,0x97,0x98,0x0b,0x09,0x00,0x3b
  };
  
  
/* Generated by reswrap from file minidoc.gif */
const unsigned char minidoc[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xbf,0xbf,0xbf,
  0x80,0x80,0x80,0xff,0xff,0xff,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x36,0x08,0x10,0xdc,0xae,0x70,0x89,0x49,0xe7,0x08,0x51,0x56,0x3a,0x04,0x86,0xc1,
  0x46,0x11,0x24,0x01,0x8a,0xd5,0x60,0x2a,0x21,0x6a,0xad,0x9a,0xab,0x9e,0xae,0x30,
  0xb3,0xb5,0x0d,0xb7,0xf2,0x9e,0xdf,0x31,0x14,0x90,0x27,0xf4,0xd5,0x86,0x83,0xa4,
  0x72,0x09,0x2c,0x39,0x9f,0xa6,0x04,0x00,0x3b
  };

  
/* Generated by reswrap from file bigfolder.gif */
const unsigned char bigfolder[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xff,0xff,0xff,0xff,0xff,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x80,
  0x80,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0x83,0x08,0xba,0xdc,0xfe,0x30,0xca,0x49,0x6b,0x0c,0x38,0x67,0x0b,0x83,0xf8,0x20,
  0x18,0x70,0x8d,0x37,0x10,0x67,0x8a,0x12,0x23,0x09,0x98,0xab,0xaa,0xb6,0x56,0x40,
  0xdc,0x78,0xae,0x6b,0x3c,0x5f,0xbc,0xa1,0xa0,0x70,0x38,0x2c,0x14,0x60,0xb2,0x98,
  0x32,0x99,0x34,0x1c,0x05,0xcb,0x28,0x53,0xea,0x44,0x4a,0xaf,0xd3,0x2a,0x74,0xca,
  0xc5,0x6a,0xbb,0xe0,0xa8,0x16,0x4b,0x66,0x7e,0xcb,0xe8,0xd3,0x38,0xcc,0x46,0x9d,
  0xdb,0xe1,0x75,0xba,0xfc,0x9e,0x77,0xe5,0x70,0xef,0x33,0x1f,0x7f,0xda,0xe9,0x7b,
  0x7f,0x77,0x7e,0x7c,0x7a,0x56,0x85,0x4d,0x84,0x82,0x54,0x81,0x88,0x62,0x47,0x06,
  0x91,0x92,0x93,0x94,0x95,0x96,0x91,0x3f,0x46,0x9a,0x9b,0x9c,0x9d,0x9e,0x9a,0x2e,
  0xa1,0xa2,0x13,0x09,0x00,0x3b
  };
  
  

/* Generated by reswrap from file bigofolder.gif */
const unsigned char bigfolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x77,0x77,0x77,0xff,0xff,0xff,0xff,0xff,0x00,0xbb,0xbb,0xbb,0x00,0x00,0x00,0x80,
  0x80,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0xa1,0x08,0xba,0x10,0xfe,0x8f,0xc9,0x49,0x83,0xb8,0x18,0x07,0xca,0xa5,0x1d,0x04,
  0x28,0x86,0xc4,0xd6,0x71,0x1f,0x39,0x8e,0xe6,0xc9,0xa4,0xab,0x4a,0x42,0xb4,0xe3,
  0x09,0x72,0x2c,0x66,0xfc,0x55,0xbc,0x02,0x5d,0x6e,0xb8,0x32,0xfc,0x14,0x16,0xa2,
  0x52,0x68,0x5c,0xc0,0x96,0xd0,0x41,0xd3,0x41,0xa8,0x5a,0xaf,0xd8,0xec,0x15,0x64,
  0xb4,0xf4,0xbe,0xe0,0x4c,0x21,0x20,0x1d,0x0b,0xcf,0xca,0x40,0x81,0xd0,0x8d,0xba,
  0x07,0xea,0x32,0xf9,0x1d,0x1d,0xb7,0xd1,0x78,0x99,0xfd,0x17,0xa0,0xe3,0xd5,0x53,
  0x79,0x82,0x25,0x05,0x53,0x7e,0x50,0x85,0x7c,0x83,0x82,0x89,0x48,0x8b,0x50,0x6a,
  0x47,0x7d,0x8f,0x67,0x91,0x8e,0x87,0x42,0x04,0x05,0x92,0x98,0x4a,0x9b,0x4e,0x9d,
  0x3a,0x4d,0x97,0x94,0x43,0xa3,0x0d,0x06,0xa9,0xaa,0xab,0xac,0xad,0xad,0x47,0x0a,
  0x9b,0xb2,0xb3,0xb4,0xb5,0xb6,0x2e,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,0xc0,
  0x13,0x09,0x00,0x3b
  };

/* Generated by reswrap from file minifolder.gif */
const unsigned char minifolder[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x3b,0x08,0xba,0xdc,0x1b,0x10,0x3a,0x16,0xc4,0xb0,0x22,0x4c,0x50,0xaf,0xcf,0x91,
  0xc4,0x15,0x64,0x69,0x92,0x01,0x31,0x7e,0xac,0x95,0x8e,0x58,0x7b,0xbd,0x41,0x21,
  0xc7,0x74,0x11,0xef,0xb3,0x5a,0xdf,0x9e,0x1c,0x6f,0x97,0x03,0xba,0x7c,0xa1,0x64,
  0x48,0x05,0x20,0x38,0x9f,0x50,0xe8,0x66,0x4a,0x75,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderopen.gif */
const unsigned char minifolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x7f,0x7f,0x7f,0xff,0xff,0xff,0xd9,0xd9,0xd9,0xff,0xff,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xdc,0x2c,0x10,0xba,0x37,0x6a,0x15,0x13,0x88,0x41,0x4a,0x27,0x43,
  0x14,0x29,0x9b,0x67,0x82,0x56,0x18,0x68,0xdc,0xe9,0x12,0x42,0x20,0xce,0x62,0x11,
  0x6f,0x69,0x1e,0xc3,0x72,0xfb,0xb9,0xb2,0x18,0xeb,0x47,0xbc,0xad,0x4a,0xc4,0x93,
  0x6c,0xc5,0x7a,0x99,0x62,0x4c,0x1a,0x2d,0xc0,0x04,0x50,0xaf,0x58,0x6c,0x66,0xcb,
  0x6d,0x24,0x00,0x00,0x3b
  };

  

/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXFileItem,FXIconItem,NULL,0)
  
  

/*******************************************************************************/

// Map
FXDEFMAP(FXFileList) FXFileListMap[]={
  FXMAPFUNC(SEL_DRAGGED,0,FXFileList::onDragged),
  FXMAPFUNC(SEL_TIMEOUT,FXFileList::ID_REFRESH,FXFileList::onRefresh),
  FXMAPFUNC(SEL_DND_ENTER,0,FXFileList::onDNDEnter),
  FXMAPFUNC(SEL_DND_LEAVE,0,FXFileList::onDNDLeave),
  FXMAPFUNC(SEL_DND_DROP,0,FXFileList::onDNDDrop),
  FXMAPFUNC(SEL_DND_MOTION,0,FXFileList::onDNDMotion),
  FXMAPFUNC(SEL_DND_REQUEST,0,FXFileList::onDNDRequest),
  FXMAPFUNC(SEL_BEGINDRAG,0,FXFileList::onBeginDrag),
  FXMAPFUNC(SEL_ENDDRAG,0,FXFileList::onEndDrag),
  FXMAPFUNC(SEL_SELECTION_REQUEST,0,FXFileList::onSelectionRequest),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_DIRECTORY_UP,FXFileList::onUpdDirectoryUp),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_DIRECTORY_NEW,FXFileList::onUpdDirectoryNew),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SORT_BY_NAME,FXFileList::onUpdSortByName),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SORT_BY_TYPE,FXFileList::onUpdSortByType),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SORT_BY_SIZE,FXFileList::onUpdSortBySize),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SORT_BY_TIME,FXFileList::onUpdSortByTime),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SORT_BY_USER,FXFileList::onUpdSortByUser),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SORT_BY_GROUP,FXFileList::onUpdSortByGroup),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SORT_REVERSE,FXFileList::onUpdSortReverse),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SET_PATTERN,FXFileList::onUpdSetPattern),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SET_DIRECTORY,FXFileList::onUpdSetDirectory),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_SHOW_HIDDEN,FXFileList::onUpdShowHidden),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_HIDE_HIDDEN,FXFileList::onUpdHideHidden),
  FXMAPFUNC(SEL_UPDATE,FXFileList::ID_TOGGLE_HIDDEN,FXFileList::onUpdToggleHidden),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_DIRECTORY_UP,FXFileList::onCmdDirectoryUp),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_DIRECTORY_NEW,FXFileList::onCmdDirectoryNew),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SORT_BY_NAME,FXFileList::onCmdSortByName),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SORT_BY_TYPE,FXFileList::onCmdSortByType),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SORT_BY_SIZE,FXFileList::onCmdSortBySize),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SORT_BY_TIME,FXFileList::onCmdSortByTime),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SORT_BY_USER,FXFileList::onCmdSortByUser),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SORT_BY_GROUP,FXFileList::onCmdSortByGroup),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SORT_REVERSE,FXFileList::onCmdSortReverse),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SET_PATTERN,FXFileList::onCmdSetPattern),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SET_DIRECTORY,FXFileList::onCmdSetDirectory),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXFileList::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXFileList::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXFileList::onCmdGetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_SHOW_HIDDEN,FXFileList::onCmdShowHidden),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_HIDE_HIDDEN,FXFileList::onCmdHideHidden),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_TOGGLE_HIDDEN,FXFileList::onCmdToggleHidden),
  FXMAPFUNC(SEL_COMMAND,FXFileList::ID_HEADER_CHANGE,FXFileList::onCmdHeader),
  };


// Object implementation
FXIMPLEMENT(FXFileList,FXIconList,FXFileListMap,ARRAYNUMBER(FXFileListMap))


// For serialization
FXFileList::FXFileList(){
  refresh=NULL;
  timestamp=0;
  sortfunc=cmpFName;
  associations=NULL;
  };
  
  
// File List
FXFileList::FXFileList(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXIconList(p,tgt,sel,opts,x,y,w,h),directory(PATHSEPSTRING),pattern("*"){
  associations=NULL;
  appendHeader("Name",NULL,200);
  appendHeader("Type",NULL,100);
  appendHeader("Size",NULL,60);
  appendHeader("Modified Date",NULL,150);
  appendHeader("User",NULL,50);
  appendHeader("Group",NULL,50);
  appendHeader("Attributes",NULL,100);
  big_folder=new FXGIFIcon(getApp(),bigfolder);
  mini_folder=new FXGIFIcon(getApp(),minifolder);
  big_doc=new FXGIFIcon(getApp(),bigdoc);
  mini_doc=new FXGIFIcon(getApp(),minidoc);
  big_app=new FXGIFIcon(getApp(),bigapp);
  mini_app=new FXGIFIcon(getApp(),miniapp);
  matchmode=FILEMATCH_FILE_NAME|FILEMATCH_NOESCAPE;
#ifdef WIN32
  matchmode|=FILEMATCH_CASEFOLD;
#endif
  if(!(options&FILELIST_NO_OWN_ASSOC)) associations=new FXFileDict(getApp());
  sortfunc=cmpFName;
  refresh=NULL;
  timestamp=0;
  }


// Starts the timer
void FXFileList::create(){
  FXIconList::create();
  if(!deleteType){deleteType=getApp()->registerDragType(deleteTypeName);}
  if(!textType){textType=getApp()->registerDragType(textTypeName);}
  if(!refresh) refresh=getApp()->addTimeout(REFRESHINTERVAL,this,ID_REFRESH);
  big_folder->create();
  mini_folder->create();
  big_doc->create();
  mini_doc->create();
  big_app->create();
  mini_app->create();
  listDirectory();    // Do we have to do this here?
  sortItems();
  dropEnable();
  }


// Detach disconnects the icons
void FXFileList::detach(){
  FXIconList::detach();
  if(refresh) refresh=getApp()->removeTimeout(refresh);
  //// We may need to do something with associations here...
  big_folder->detach();
  mini_folder->detach();
  big_doc->detach();
  mini_doc->detach();
  big_app->detach();
  mini_app->detach();  
  deleteType=0;
  textType=0;
  }


// Destroy zaps the icons
void FXFileList::destroy(){
  FXIconList::destroy();
  if(refresh) refresh=getApp()->removeTimeout(refresh);
  big_folder->destroy();
  mini_folder->destroy();
  big_doc->destroy();
  mini_doc->destroy();
  big_app->destroy();
  mini_app->destroy();  
  }



// Somebody wants our selection
long FXFileList::onSelectionRequest(FXObject* sender,FXSelector sel,void* ptr){
//  FXEvent *event=(FXEvent*)ptr;
//  FXchar name[MAXPATHLEN+1],*p;
//  FXuchar *data; 
  
  // Try handle through base class first
  if(FXIconList::onSelectionRequest(sender,sel,ptr)) return 1;

//   // Otherwise (most likely) its the string from this text we return
//   // Strictly speaking, we should return ALL selected items, not just the current one
//   if(event->target==stringType){
//     FXTRACE((100,"%s: Get selection string\n",getClassName()));
//     if(0<=current && isItemSelected(current)){
//       FXCALLOC(&data,FXuchar,MAXPATHLEN+1);
//       strcpy(name,items[current]->label.text());
//       if((p=strchr(name,'\t'))) *p=0;
//       fxpathname((FXchar*)data,directory.text(),name);
//       setDNDData(event->origin,stringType,data,strlen((FXchar*)data)+1);
//       return 1;
//       }
//     }

  return 0;
  }


/*******************************************************************************/


// Handle drag-and-drop enter
long FXFileList::onDNDEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXIconList::onDNDEnter(sender,sel,ptr);
//   FXuchar *data;
//   FXuint   len;
//   if(getDNDData(FROM_DRAGNDROP,FXFileList::targetType,data,len)){
// for(int i=0; i<len; i+=4){ FXTRACE((10,"type=%08x\n",*((FXDragType*)&data[i]))); }
// //     if(*((FXDragType*)data) == FXColorWell::colorType){
// //       acceptDrop(DRAG_COPY);
// //       return 1;
// //       }
//     }
  return 1;
  }


// Handle drag-and-drop leave
long FXFileList::onDNDLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXIconList::onDNDLeave(sender,sel,ptr);
  stopAutoScroll();
  return 1;
  }


// Handle drag-and-drop motion
long FXFileList::onDNDMotion(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  if(startAutoScroll(event->win_x,event->win_y,FALSE)) return 1;
  if(FXIconList::onDNDMotion(sender,sel,ptr)) return 1;
  
//   // No more messages while inside
//   setDragRectangle(0,0,width,height,FALSE);
//   
//       
//   // Is it a color being dropped?
//   if(offeredDNDType(FXColorWell::colorType)){
//     acceptDrop(DRAG_COPY);
//     return 1;
//     }
  return 1;
  }


// Handle drag-and-drop drop
long FXFileList::onDNDDrop(FXObject* sender,FXSelector sel,void* ptr){
  // Try handling it in base class first
  if(FXIconList::onDNDDrop(sender,sel,ptr)) return 1;
  
//   // Try handle here
//   if(getDNDData(FROM_DRAGNDROP,colorType,data,len)){
//     sscanf((char*)data,"#%02x%02x%02x%02x",&r,&g,&b,&a);
//     setRGBA(FXRGBA(r,g,b,a));
//     FXFREE(&data);
//     if(target) target->handle(this,MKUINT(message,SEL_COMMAND),(void*)rgba); 
//     return 1;
//     }
  return 1;
  }


// Somebody wants our dragged data
long FXFileList::onDNDRequest(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handle through base class first
  if(FXIconList::onDNDRequest(sender,sel,ptr)) return 1;

  // Find what type they wanted
  return 0;
  }



// Start a drag operation
long FXFileList::onBeginDrag(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXIconList::onBeginDrag(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onBeginDrag %08x\n",getClassName(),this));
  return 1;
  }


// End drag operation
long FXFileList::onEndDrag(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXIconList::onEndDrag(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onEndDrag %08x\n",getClassName(),this));
  return 1;
  }


// Dragged stuff around
long FXFileList::onDragged(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXIconList::onDragged(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onDragged %08x\n",getClassName(),this));
//     // Change cursor
//     action=DRAG_COPY;
//     if(isDropTarget()) action=DRAG_MOVE;
//     if(event->state&CONTROLMASK) action=DRAG_COPY;
//     if(event->state&SHIFTMASK) action=DRAG_MOVE;
//     if(event->state&ALTMASK) action=DRAG_LINK;
//     handleDrag(event->root_x,event->root_y,action);
//     if(didAccept()!=DRAG_REJECT){
//       if(action==DRAG_MOVE)
//         setDragCursor(getApp()->dndMoveCursor);
//       else if(action==DRAG_LINK)
//         setDragCursor(getApp()->dndLinkCursor);
//       else
//         setDragCursor(getApp()->dndCopyCursor);
//       }
//     else{
//       setDragCursor(getApp()->dontdropCursor);
//       }
  return 1;
  }


/*******************************************************************************/


// Set value from a message
long FXFileList::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  if(ptr){ setCurrentFile((const FXchar*)ptr); }
  return 1;
  }


// Set current directory from dir part of filename
long FXFileList::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setCurrentFile(*((FXString*)ptr));
  return 1;
  }


// Get current file name (NULL if no current file)
long FXFileList::onCmdGetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetStringValue: NULL pointer.\n",getClassName()); }
  *((FXString*)ptr)=getCurrentFile();
  return 1;
  }


// Toggle hidden files display
long FXFileList::onCmdToggleHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(!showHiddenFiles());
  return 1;
  }


// Update toggle hidden files widget
long FXFileList::onUpdToggleHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Show hidden files
long FXFileList::onCmdShowHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(TRUE);
  return 1;
  }


// Update show hidden files widget
long FXFileList::onUpdShowHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Hide hidden files
long FXFileList::onCmdHideHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(FALSE);
  return 1;
  }


// Update hide hidden files widget
long FXFileList::onUpdHideHidden(FXObject* sender,FXSelector,void*){
  if(!showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Move up one level
long FXFileList::onCmdDirectoryUp(FXObject*,FXSelector,void*){
  setDirectory(FXFile::upLevel(directory));
  return 1;
  }


// Determine if we can still go up more
long FXFileList::onUpdDirectoryUp(FXObject* sender,FXSelector,void* ptr){
  FXuint msg = FXFile::isTopDirectory(directory) ? ID_DISABLE : ID_ENABLE;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Create new directory
long FXFileList::onCmdDirectoryNew(FXObject*,FXSelector,void*){
  return 1;
  }


// Currently not yet implemented
long FXFileList::onUpdDirectoryNew(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=ID_DISABLE;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Change pattern
long FXFileList::onCmdSetPattern(FXObject*,FXSelector,void* ptr){
  if(!ptr) return 0;
  setPattern((const char*)ptr);
  return 1;
  }


// Update pattern
long FXFileList::onUpdSetPattern(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETVALUE,SEL_COMMAND),(void*)pattern.text());
  return 1;
  }


// Change directory
long FXFileList::onCmdSetDirectory(FXObject*,FXSelector,void* ptr){
  if(!ptr) return 0;
  setDirectory((const char*)ptr);
  return 1;
  }


// Update directory
long FXFileList::onUpdSetDirectory(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETVALUE,SEL_COMMAND),(void*)directory.text());
  return 1;
  }


// Sort by name
long FXFileList::onCmdSortByName(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFName) ? cmpRName : cmpFName;
  sortItems();
  return 1;
  }


// Update sender
long FXFileList::onUpdSortByName(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFName || sortfunc==cmpRName) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by type
long FXFileList::onCmdSortByType(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFType) ? cmpRType : cmpFType;
  sortItems();
  return 1;
  }


// Update sender
long FXFileList::onUpdSortByType(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFType || sortfunc==cmpRType) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by size
long FXFileList::onCmdSortBySize(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFSize) ? cmpRSize : cmpFSize;
  sortItems();
  return 1;
  }


// Update sender
long FXFileList::onUpdSortBySize(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFSize || sortfunc==cmpRSize) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by time
long FXFileList::onCmdSortByTime(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFTime) ? cmpRTime : cmpFTime;
  sortItems();
  return 1;
  }


// Update sender
long FXFileList::onUpdSortByTime(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFTime || sortfunc==cmpRTime) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by user
long FXFileList::onCmdSortByUser(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFUser) ? cmpRUser : cmpFUser;
  sortItems();
  return 1;
  }


// Update sender
long FXFileList::onUpdSortByUser(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFUser || sortfunc==cmpRUser) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by group
long FXFileList::onCmdSortByGroup(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFGroup) ? cmpRGroup : cmpFGroup;
  sortItems();
  return 1;
  }


// Update sender
long FXFileList::onUpdSortByGroup(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFGroup || sortfunc==cmpRGroup) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Reverse sort order
long FXFileList::onCmdSortReverse(FXObject*,FXSelector,void*){
  if(sortfunc==cmpFName) sortfunc=cmpRName; 
  else if(sortfunc==cmpRName) sortfunc=cmpFName;
  else if(sortfunc==cmpFType) sortfunc=cmpRType; 
  else if(sortfunc==cmpRType) sortfunc=cmpFType;
  else if(sortfunc==cmpFSize) sortfunc=cmpRSize; 
  else if(sortfunc==cmpRSize) sortfunc=cmpFSize;
  else if(sortfunc==cmpFTime) sortfunc=cmpRTime; 
  else if(sortfunc==cmpRTime) sortfunc=cmpFTime;
  else if(sortfunc==cmpFUser) sortfunc=cmpRUser; 
  else if(sortfunc==cmpRUser) sortfunc=cmpFUser;
  else if(sortfunc==cmpFGroup) sortfunc=cmpRGroup; 
  else if(sortfunc==cmpRGroup) sortfunc=cmpFGroup;
  sortItems();
  return 1;
  }


// Update sender
long FXFileList::onUpdSortReverse(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=ID_UNCHECK;
  if(sortfunc==cmpRName) msg=ID_CHECK;
  if(sortfunc==cmpRType) msg=ID_CHECK;
  if(sortfunc==cmpRSize) msg=ID_CHECK;
  if(sortfunc==cmpRTime) msg=ID_CHECK;
  if(sortfunc==cmpRUser) msg=ID_CHECK;
  if(sortfunc==cmpRGroup) msg=ID_CHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Clicked header button
long FXFileList::onCmdHeader(FXObject*,FXSelector,void* ptr){
  FXuint which=ID_SORT_BY_NAME+(FXuint)(long)ptr;
  FXTRACE((100,"Hit header item %d\n",(FXuint)(long)ptr));
  handle(this,MKUINT(which,SEL_COMMAND),NULL);
  return 1;
  }


/*******************************************************************************/

// Compare file names
FXint FXFileList::cmpFName(const FXIconItem* pa,const FXIconItem* pb){
  register const FXFileItem *a=(FXFileItem*)pa;
  register const FXFileItem *b=(FXFileItem*)pb;
  register FXint diff=(FXint)b->isDirectory() - (FXint)a->isDirectory();
  if(diff) return diff;
  register const char *p=a->label.text();
  register const char *q=b->label.text();
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return -1;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Compare file types
FXint FXFileList::cmpFType(const FXIconItem* pa,const FXIconItem* pb){
  register const FXFileItem *a=(FXFileItem*)pa;
  register const FXFileItem *b=(FXFileItem*)pb;
  register FXint diff=(FXint)b->isDirectory() - (FXint)a->isDirectory();
  if(diff) return diff;
  register const char *p=strchr(a->label.text(),'\t')+1;
  register const char *q=strchr(b->label.text(),'\t')+1;
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return -1;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Compare file size
FXint FXFileList::cmpFSize(const FXIconItem* pa,const FXIconItem* pb){
  register const FXFileItem *a=(FXFileItem*)pa;
  register const FXFileItem *b=(FXFileItem*)pb;
  register FXint diff=(FXint)b->isDirectory() - (FXint)a->isDirectory();
  if(diff) return diff;
  return (long)a->size - (long)b->size;
  }


// Compare file time
FXint FXFileList::cmpFTime(const FXIconItem* pa,const FXIconItem* pb){
  register const FXFileItem *a=(FXFileItem*)pa;
  register const FXFileItem *b=(FXFileItem*)pb;
  register FXint diff=(FXint)b->isDirectory() - (FXint)a->isDirectory();
  if(diff) return diff;
  return (long)a->date - (long)b->date;
  }


// Compare file user
FXint FXFileList::cmpFUser(const FXIconItem* pa,const FXIconItem* pb){
  register const FXFileItem *a=(FXFileItem*)pa;
  register const FXFileItem *b=(FXFileItem*)pb;
  register const char *p,*q; 
  register int i;
  FXint diff=(FXint)b->isDirectory() - (FXint)a->isDirectory();
  if(diff) return diff;
  for(p=a->label.text(),i=4; *p && i; i-=(*p++=='\t')); 
  for(q=b->label.text(),i=4; *q && i; i-=(*q++=='\t')); 
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return -1;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Compare file group
FXint FXFileList::cmpFGroup(const FXIconItem* pa,const FXIconItem* pb){
  register const FXFileItem *a=(FXFileItem*)pa;
  register const FXFileItem *b=(FXFileItem*)pb;
  register const char *p,*q; 
  register int i;
  register FXint diff=(FXint)b->isDirectory() - (FXint)a->isDirectory();
  if(diff) return diff;
  for(p=a->label.text(),i=5; *p && i; i-=(*p++=='\t')); 
  for(q=b->label.text(),i=5; *q && i; i-=(*q++=='\t')); 
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return -1;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }

// Reversed compare file name
FXint FXFileList::cmpRName(const FXIconItem* pa,const FXIconItem* pb){
  return -FXFileList::cmpFName(pa,pb);
  }


// Reversed compare file type
FXint FXFileList::cmpRType(const FXIconItem* pa,const FXIconItem* pb){
  return -FXFileList::cmpFType(pa,pb);
  }


// Reversed compare file size
FXint FXFileList::cmpRSize(const FXIconItem* pa,const FXIconItem* pb){
  return -FXFileList::cmpFSize(pa,pb);
  }


// Reversed compare file time
FXint FXFileList::cmpRTime(const FXIconItem* pa,const FXIconItem* pb){
  return -FXFileList::cmpFTime(pa,pb);
  }


// Reversed compare file user
FXint FXFileList::cmpRUser(const FXIconItem* pa,const FXIconItem* pb){
  return -FXFileList::cmpFUser(pa,pb);
  }


// Reversed compare file group
FXint FXFileList::cmpRGroup(const FXIconItem* pa,const FXIconItem* pb){
  return -FXFileList::cmpFGroup(pa,pb);
  }


/*******************************************************************************/


// Got refresh timeout
long FXFileList::onRefresh(FXObject*,FXSelector,void*){
  FXuint interval=REFRESHINTERVAL;
  struct stat info;
  long changetime;

  // Only update if user is not interacting with the file list
  if(flags&FLAG_UPDATE){

    // Test if a change has occurred
    if(FXFile::info(directory,info)){
      changetime=FXMAX(info.st_mtime,info.st_ctime);
      if((timestamp!=changetime) || (changetime==0)){

        // File system does not support mod-time on directory:- we schedule 
        // next refresh in REFRESHINTERVALLONG ms instead of REFRESHINTERVAL ms
        if(changetime==0) interval=REFRESHINTERVALLONG;

        // Refresh contents
        listDirectory();
        sortItems();
        
        // Last time checked
        timestamp=changetime;
        }
      }

    // Move to higher directory
    else{
      setDirectory(FXFile::upLevel(directory));
      }
    }

  // Reset timer again
  refresh=getApp()->addTimeout(interval,this,ID_REFRESH);

  return 0;
  }


// Set current filename
void FXFileList::setCurrentFile(const FXString& pathname){
  if(!pathname.empty()){
    FXTRACE((100,"%s::setCurrentFile(%s)\n",getClassName(),pathname.text()));
    FXString path=FXFile::absolute(directory,pathname);
    FXString file="";
    while(!FXFile::isTopDirectory(path) && !FXFile::exists(path)){
      path=FXFile::upLevel(path);
      }
    if(FXFile::isFile(path)){
      file=FXFile::name(path);
      path=FXFile::directory(path);
      }
    if(directory!=path){
      directory=path;
      clearItems();
      listDirectory();
      sortItems();
      }
    if(!file.empty()){
      setCurrentItem(getFilenameItem(file));
      }
    else{
      setCurrentItem(-1);
      }
    }
  }


// Get pathname to current file, if any
FXString FXFileList::getCurrentFile() const {
  if(0<=current) return getItemPathname(current);
  return FXString("");
  }


// Set directory being displayed
void FXFileList::setDirectory(const FXString& pathname){
  if(!pathname.empty()){
    FXTRACE((100,"%s::setDirectory(%s)\n",getClassName(),pathname.text()));
    FXString path=FXFile::absolute(directory,pathname);
    while(!FXFile::isTopDirectory(path) && !FXFile::isDirectory(path)){
      path=FXFile::upLevel(path);
      }
    if(directory!=path){
      directory=path;
      clearItems();
      listDirectory();
      sortItems();
      }
    }
  }


// Set the pattern to filter
void FXFileList::setPattern(const FXString& ptrn){
  if(ptrn.empty()) return;
  if(pattern!=ptrn){
    pattern=ptrn;
    listDirectory();
    sortItems();
    }
  }


// Change file match mode
void FXFileList::setMatchMode(FXuint mode){
  if(matchmode!=mode){
    matchmode=mode;
    listDirectory();
    sortItems();
    }
  }


// Return TRUE if showing hidden files
FXbool FXFileList::showHiddenFiles() const {
  return (options&FILELIST_SHOWHIDDEN)!=0;
  }


// Change show hidden files mode
void FXFileList::showHiddenFiles(FXbool shown){
  FXuint opts=shown ? (options|FILELIST_SHOWHIDDEN) : (options&~FILELIST_SHOWHIDDEN);
  if(opts!=options){
    options=opts;
    listDirectory();
    sortItems();
    }
  }


// Return TRUE if showing directories only
FXbool FXFileList::showOnlyDirectories() const {
  return (options&FILELIST_SHOWDIRS)!=0;
  }


// Change show directories only mode
void FXFileList::showOnlyDirectories(FXbool shown){
  FXuint opts=shown ? (options|FILELIST_SHOWDIRS) : (options&~FILELIST_SHOWDIRS);
  if(opts!=options){
    options=opts;
    listDirectory();
    sortItems();
    }
  }


// Compare till '\t' or '\0'
static FXbool fileequal(const FXchar* a,const FXchar* b){
  register FXchar c1,c2;
  do{ c1=*a++; c2=*b++; }while(c1!='\0' && c1!='\t' && c1==c2);
  return (c1=='\0' || c1=='\t') && ((c2=='\0' || c2=='\t'));
  }


// Get item from file name
FXint FXFileList::getFilenameItem(const FXString& filename) const {
  register FXFileItem *item;
  register FXint i;
  for(i=0; i<nitems; i++){
    item=(FXFileItem*)items[i];
    if(fileequal(filename.text(),item->label.text())) return i;
    }
  return -1;
  }


// Hash till '\t' or '\0'
static FXint hash(const FXchar* str){
  register FXint h=0;
  register FXint g;
  while(*str!='\0' && *str!='\t') {
    h=(h<<4)+*str++;
    g=h&0xF0000000;
    if(g) h^=g>>24;
    h&=0x0fffffff;
    }
  return h;
  }


// Create custom item
FXIconItem *FXFileList::createItem(const FXString& text,FXIcon *big,FXIcon* mini,void* ptr){
  return new FXFileItem(text,big,mini,ptr);
  }


/*******************************************************************************/

// List directory
void FXFileList::listDirectory(){
  FXchar grpid[64],usrid[64],atts[16],mod[32];
  FXchar pathname[MAXPATHLEN];
  FXFileItem *item;
  FXchar *pathtail,*name,*ext;
  FXFileAssoc *fileassoc;
  const FXchar *extension;
  FXIcon *big,*mini;
  FXFileItem **hashlist;
  int nhashlist,i,x,p,h;
  long filetime,modtime;
  struct stat info;
#ifndef WIN32
  struct dirent *dp;
  DIR *dirp;
  int islink;
#else
  const char *month[]={NULL,"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
  WIN32_FIND_DATA ffData;
  HANDLE hFindFile;
  FXdouble tmp;
  SHFILEINFO sfi;
  FILETIME localfiletime;
  SYSTEMTIME systemfiletime;
#endif
 
  // Unfocus
  if(hasFocus() && 0<=current){ ((FXFileItem*)items[current])->state&=~FXFileItem::FOCUS; }

  // Place existing items into a hash table
  for(nhashlist=32; nhashlist<=nitems; nhashlist<<=1);
  FXCALLOC(&hashlist,FXFileItem**,nhashlist);
  for(i=0; i<nitems; i++){
    item=(FXFileItem*)items[i];
    h=hash(item->label.text());
    for(p=HASH1(h,nhashlist),x=HASH2(h,nhashlist); hashlist[p]; p=(p+x)%nhashlist);
    hashlist[p]=item;
    }

  // Start inserting
  nitems=0;

  // Get info about directory
  if(stat(directory.text(),&info)==0){

    // Need latest change no matter what actually changed!
    timestamp=FXMAX(info.st_mtime,info.st_ctime);

    // Set path to stat with
    strcpy(pathname,directory.text());
    pathtail=pathname+strlen(pathname)-1;
    if(*pathtail!=PATHSEP) *++pathtail=PATHSEP;
    ++pathtail;

    FXTRACE((190,"Rescanning directory: %s\n",directory.text()));

#ifndef WIN32

    // Get directory stream pointer
    dirp=opendir(directory.text());

    // Managed to open directory
    if(dirp){

      // Loop over directory entries
      while((dp=readdir(dirp))!=NULL){
        name=dp->d_name;

        // A dot special file?
        if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

        // Hidden file or directory normally not shown
        if(name[0]=='.' && !(options&FILELIST_SHOWHIDDEN)) continue;

        // Build full pathname
        strcpy(pathtail,name);

        // Get file/link info
        if(lstat(pathname,&info)!=0) continue;

        // If its a link, get the info on file itself
        islink=S_ISLNK(info.st_mode);
        if(islink && stat(pathname,&info)!=0) continue;

        // If not a directory and we want only directories, skip it
        if(!S_ISDIR(info.st_mode) && (options&FILELIST_SHOWDIRS)) continue;
 
        // Is it a directory or does it match the pattern?
        if(!S_ISDIR(info.st_mode) && !fxfilematch(pattern.text(),name,matchmode)) continue;
 
        // Anything about file has changed
        filetime=FXMAX3(info.st_mtime,info.st_ctime,info.st_atime);

        // File mod time
        modtime=info.st_mtime;
#else

    // Get file find handle and first file's info
    strcpy(pathtail,"*");
    hFindFile=FindFirstFile(pathname,&ffData);

    // No directory, so no files shown
    if(hFindFile!=INVALID_HANDLE_VALUE){

      // Loop over directory entries
      do{
        name=ffData.cFileName;

        // A dot special file?
        if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

        // Hidden file or directory normally not shown
        if((ffData.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN) && !(options&FILELIST_SHOWHIDDEN)) continue;

        // If not a directory and we want only directories, skip it
        if(!(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) && (options&FILELIST_SHOWDIRS)) continue;

        // Build full pathname
        strcpy(pathtail,name);

        // Is it a directory or does it match the pattern?
        if(!(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) && !fxfilematch(pattern.text(),name,matchmode)) continue;
 
        // FIX ME:- a year is a bit more than 365*24*3600=31536000 seconds

        // Convert to seconds since Jan 1, 1601
        tmp=(FXdouble)ffData.ftLastWriteTime.dwLowDateTime*1.0E-7 + (FXdouble)ffData.ftLastWriteTime.dwHighDateTime*429.4967296;
 
        // Subtract #seconds between Jan 1, 1601 and Jan 1, 1970
        tmp = tmp-11636784000.0;

        // Convert to long
        filetime=(long)tmp;

        // File mod time
        modtime=filetime;
//   void UnixTimeToFileTime(time_t t, LPFILETIME pft)   {
//       // Note that LONGLONG is a 64-bit value     LONGLONG ll;
//       ll = Int32x32To64(t, 10000000) + 116444736000000000;
//       pft->dwLowDateTime = (DWORD)ll;     pft->dwHighDateTime = ll >> 32;   }

#endif

        // Take item from hash table if found
        h=hash(name);
        for(p=HASH1(h,nhashlist),x=HASH2(h,nhashlist); hashlist[p]; p=(p+x)%nhashlist){
          item=hashlist[p];
          if((item!=(FXFileItem*)-1) && fileequal(name,item->label.text())){
            hashlist[p]=(FXFileItem*)-1;
            goto fnd;
            }
          }
 
        // Make new item if we have to
        item=(FXFileItem*)createItem(NULL,NULL,NULL,NULL);
 
        // Append item in list
fnd:    FXRESIZE(&items,FXIconItem*,nitems+1);
        items[nitems]=item;
        nitems++;

#ifndef WIN32
    
        // Anything about the file changed?
        if((item->date!=modtime) || (timestamp<filetime) || (filetime==0)){

          // Obtain user name
          fxgetusername(usrid,info.st_uid);

          // Obtain group name
          fxgetgroupname(grpid,info.st_gid);

          // Permissions
          fxgetpermissions(atts,info.st_mode);

          // Mod time
          strncpy(mod,ctime(&info.st_mtime)+4,20);
          mod[20]=0;

          // Item flags
          if(S_ISDIR(info.st_mode)) item->state|=FXFileItem::FOLDER; else item->state&=~FXFileItem::FOLDER;
          if(S_ISLNK(info.st_mode)) item->state|=FXFileItem::SYMLINK; else item->state&=~FXFileItem::SYMLINK;
          if(S_ISCHR(info.st_mode)) item->state|=FXFileItem::CHARDEV; else item->state&=~FXFileItem::CHARDEV;
          if(S_ISBLK(info.st_mode)) item->state|=FXFileItem::BLOCKDEV; else item->state&=~FXFileItem::BLOCKDEV;
          if(S_ISFIFO(info.st_mode)) item->state|=FXFileItem::FIFO; else item->state&=~FXFileItem::FIFO;
          if(S_ISSOCK(info.st_mode)) item->state|=FXFileItem::SOCK; else item->state&=~FXFileItem::SOCK;
          if((info.st_mode&(S_IXUSR|S_IXGRP|S_IXOTH)) && !(S_ISDIR(info.st_mode)||S_ISCHR(info.st_mode)||S_ISBLK(info.st_mode)||S_ISFIFO(info.st_mode)||S_ISSOCK(info.st_mode))){
            item->state|=FXFileItem::EXECUTABLE; 
            }
          else{
            item->state&=~FXFileItem::EXECUTABLE;
            }

          // Assume no associations
          fileassoc=NULL;

          // Is it a directory?
          if(item->state&FXFileItem::FOLDER){
            big=big_folder;
            mini=mini_folder;
            extension="Folder";
            }

          // Some sort of document
          else{

            // Is it an executable?
            if(item->state&FXFileItem::EXECUTABLE){
              big=big_app;
              mini=mini_app;
              extension="Application";
              }
            else{
              big=big_doc;
              mini=mini_doc;
              extension="Document";
              }

            // Try use association table
            if(associations){

              // Try find association for this file, starting with the 
              // whole filename, then successively smaller extensions.
              fileassoc=associations->associate(name);
              if(!fileassoc){
                ext=strchr(name,'.');
                while(ext){
                  fileassoc=associations->associate(ext+1);
                  if(fileassoc) break;
                  ext=strchr(ext+1,'.');
                  }
                }

              // If we still have no extension, use the default extention's association
              if(!fileassoc && !(item->state&FXFileItem::EXECUTABLE)){
                fileassoc=associations->associate("defext");
                }

              // If we have an association, grab the file type & icons
              if(fileassoc){
                extension=fileassoc->extension.text();
  //               if(fileassoc->mimetype.text()){ 
  //                 if(fileassoc->dragtype==0){
  //                   fileassoc->dragtype=getApp()->registerDragType(fileassoc->mimetype.text()); 
  //                   }
  //                 }
                if(fileassoc->bigicon) big=fileassoc->bigicon;
                if(fileassoc->miniicon) mini=fileassoc->miniicon;
                }
              }
            }

          // Update item information
          item->label.format("%s\t%s\t%d\t%s\t%s\t%s\t%s",name,extension,info.st_size,mod,usrid,grpid,atts);
          item->bigIcon=big;
          item->miniIcon=mini;
          item->size=info.st_size;
          item->assoc=fileassoc;
          item->date=modtime;

          // Create item
          if(id()) item->create();
          }

#else
 
        // Anything about the file changed?
        if((item->date!=modtime) || (timestamp<filetime) || (filetime==0)){

          // Obtain user name (no Win95 equivalent?)
          strcpy(usrid,"user");

          // Obtain group name (no Win95 equivalent?)
          strcpy(grpid,"group");

          // Permissions
          strcpy(atts, "-rwxrwxrwx");

          // Is it a directory?
          if(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY){
            atts[0]='d';
            }

          // Check if file is read-only
          if(ffData.dwFileAttributes&FILE_ATTRIBUTE_READONLY){
            atts[2]='-'; atts[5]='-'; atts[8]='-';
            }

          // Is it an executable file?
          // GetBinaryType() is not supported for Win95/98! Try SHGetFileInfo() instead.
          if(SHGetFileInfo(pathname,0,&sfi,sizeof(SHFILEINFO),SHGFI_EXETYPE)==0){
            atts[3]='-'; atts[6]='-'; atts[9]='-';
            item->state&=~FXFileItem::EXECUTABLE;
            }
          else{
            item->state|=FXFileItem::EXECUTABLE;
            }

          // Mod time
          FileTimeToLocalFileTime(&ffData.ftLastWriteTime,&localfiletime);  // To local time zone's time
          FileTimeToSystemTime(&localfiletime,&systemfiletime);             // To system time, broken down
          sprintf(mod,"%s %2d %2d:%2d:%2d %4d",month[systemfiletime.wMonth],systemfiletime.wDay,systemfiletime.wHour,systemfiletime.wMinute,systemfiletime.wSecond,systemfiletime.wYear);

          // Flags
          if(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) item->state|=FXFileItem::FOLDER; else item->state&=~FXFileItem::FOLDER;

          // Assume no associations
          fileassoc=NULL;

          // Is it a directory?
          if(item->state&FXFileItem::FOLDER){
            big=big_folder;
            mini=mini_folder;
            extension="Folder";
            }

          // Some sort of document
          else{

            // Is it an executable?
            if(item->state&FXFileItem::EXECUTABLE){
              big=big_app;
              mini=mini_app;
              extension="Application";
              }
            else{
              big=big_doc;
              mini=mini_doc;
              extension="Document";
              }

            // Try use association table
            if(associations){

              // Try find association for this file, starting with the 
              // whole filename, then try the extension only.
              fileassoc=associations->associate(name);
              if(!fileassoc){
                ext=strchr(name,'.');
                if(ext){
                  fileassoc=associations->associate(ext+1);
                  }
                }

              // If we still have no extension, use the default extention's association
              if(!fileassoc && !(item->state&FXFileItem::EXECUTABLE)){
                fileassoc=associations->associate("defext");
                }

              // If we have an association, grab the file type & icons
              if(fileassoc){
                extension=fileassoc->extension.text();
  //               if(fileassoc->mimetype.text()){ 
  //                 if(fileassoc->dragtype==0) fileassoc->dragtype=getApp()->registerDragType(fileassoc->mimetype.text()); 
  //                 }
                if(fileassoc->bigicon) big=fileassoc->bigicon;
                if(fileassoc->miniicon) mini=fileassoc->miniicon;
                }
              }
            }

          // Update item information
          item->label.format("%s\t%s\t%d\t%s\t%s\t%s\t%s",name,extension,ffData.nFileSizeLow,mod,usrid,grpid,atts);
          item->bigIcon=big;
          item->miniIcon=mini;
          item->size=ffData.nFileSizeLow;
          item->assoc=fileassoc;
          item->date=modtime;

          // Create item
          if(id()) item->create();
          }
#endif
        } 
#ifdef WIN32
      while(FindNextFile(hFindFile,&ffData));
#endif
#ifndef WIN32
      closedir(dirp);
#else
      FindClose(hFindFile);
#endif
      }
    }

  // Wipe remaining items from list
  for(i=0; i<nhashlist; i++){
    if((hashlist[i]!=NULL) && (hashlist[i]!=(FXFileItem*)-1)){
      delete hashlist[i];
      }
    }
  FXFREE(&hashlist);

  // Validate 
  if(current>=nitems) current=-1;
  if(anchor>=nitems) anchor=-1;
  if(extent>=nitems) extent=-1;

  // Refocus
  if(hasFocus() && 0<=current){ ((FXFileItem*)items[current])->state|=FXFileItem::FOCUS; }

  // Gotta recalc size of content
  recalc();
  }


// Is directory
FXbool FXFileList::isItemDirectory(FXint index) const {
  if(index<0 || nitems<=index){ fxerror("%s::isItemDirectory: index out of range.\n",getClassName()); } 
  return (((FXFileItem*)items[index])->state&FXFileItem::FOLDER)!=0;
  }


// Is file
FXbool FXFileList::isItemFile(FXint index) const {
  if(index<0 || nitems<=index){ fxerror("%s::isItemFile: index out of range.\n",getClassName()); } 
  return (((FXFileItem*)items[index])->state&(FXFileItem::FOLDER|FXFileItem::CHARDEV|FXFileItem::BLOCKDEV|FXFileItem::FIFO|FXFileItem::SOCK))==0;
  }


// Is executable
FXbool FXFileList::isItemExecutable(FXint index) const {
  if(index<0 || nitems<=index){ fxerror("%s::isItemExecutable: index out of range.\n",getClassName()); } 
  return (((FXFileItem*)items[index])->state&FXFileItem::EXECUTABLE)!=0;
  }


// Get file name from item
FXString FXFileList::getItemFilename(FXint index) const {
  if(index<0 || nitems<=index){ fxerror("%s::getItemFilename: index out of range.\n",getClassName()); } 
  return getItemText(index).extract(0,'\t');
  }


// Get full pathname to item
FXString FXFileList::getItemPathname(FXint index) const {
  if(index<0 || nitems<=index){ fxerror("%s::getItemPathname: index out of range.\n",getClassName()); } 
  return FXFile::absolute(directory,getItemText(index).extract(0,'\t'));
  }


// Get associations (if any) from the file
FXFileAssoc* FXFileList::getItemAssoc(FXint index) const {
  if(index<0 || nitems<=index){ fxerror("%s::getItemAssoc: index out of range.\n",getClassName()); } 
  return ((FXFileItem*)items[index])->assoc;
  }


// Change associations table
void FXFileList::setAssociations(FXFileDict* assocs){
  if(associations!=assocs){
    associations=assocs;
    clearItems();
    listDirectory();
    sortItems();
    }
  }


// Save data
void FXFileList::save(FXStream& store) const {
  FXIconList::save(store);
  store << directory;
  store << associations;
  store << pattern;
  store << matchmode;
  store << big_folder;
  store << mini_folder;
  store << big_doc;
  store << mini_doc;
  store << big_app;
  store << mini_app;
  }


// Load data
void FXFileList::load(FXStream& store){ 
  FXIconList::load(store);
  store >> directory;   
  store >> associations;
  store >> pattern;     
  store >> matchmode;   
  store >> big_folder;  
  store >> mini_folder; 
  store >> big_doc;     
  store >> mini_doc;    
  store >> big_app;     
  store >> mini_app;    
  }


// Cleanup
FXFileList::~FXFileList(){
  if(refresh) getApp()->removeTimeout(refresh);
  if(!(options&FILELIST_NO_OWN_ASSOC)) delete associations;
  delete big_folder;
  delete mini_folder;
  delete big_doc;
  delete mini_doc;
  delete big_app;
  delete mini_app;
  associations=(FXFileDict*)-1;
  big_folder=(FXGIFIcon*)-1;
  mini_folder=(FXGIFIcon*)-1;
  big_doc=(FXGIFIcon*)-1;
  mini_doc=(FXGIFIcon*)-1;
  big_app=(FXGIFIcon*)-1;
  mini_app=(FXGIFIcon*)-1;
  refresh=(FXTimer*)-1;
  }


