/********************************************************************************
*                                                                               *
*                    F i l e   S e l e c t i o n   D i a l o g                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileDialog.cpp,v 1.7 2000/02/20 19:17:50 jeroen Exp $                  *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXObjectList.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXMenuButton.h"
#include "FXComposite.h"
#include "FXPacker.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXTopWindow.h"
#include "FXDialogBox.h"
#include "FXScrollbar.h"
#include "FXTextField.h"
#include "FXScrollArea.h"
#include "FXList.h"
#include "FXTreeList.h"
#include "FXComboBox.h"
#include "FXTreeListBox.h"
#include "FXDirBox.h"
#include "FXHeader.h"
#include "FXIconList.h"
#include "FXFileList.h"
#include "FXFileSelector.h"
#include "FXFileDialog.h"



/*
  To do:
*/


/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXFileDialog,FXDialogBox,NULL,0)


// File Open Dialog
FXFileDialog::FXFileDialog(FXWindow* owner,const FXString& name,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXDialogBox(owner,name,opts|DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE,x,y,w,h,4,4){
  filebox=new FXFileSelector(this,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  filebox->acceptButton()->setTarget(this);
  filebox->acceptButton()->setSelector(FXDialogBox::ID_ACCEPT);
  filebox->cancelButton()->setTarget(this);
  filebox->cancelButton()->setSelector(FXDialogBox::ID_CANCEL);
  }


// Set file name
void FXFileDialog::setFilename(const FXString& path){
  filebox->setFilename(path);
  }


// Get filename
FXString FXFileDialog::getFilename() const {
  return filebox->getFilename();
  }


// Set pattern
void FXFileDialog::setPattern(const FXString& ptrn){
  filebox->setPattern(ptrn);
  }


// Get pattern
FXString FXFileDialog::getPattern() const {
  return filebox->getPattern();
  }


// Set directory
void FXFileDialog::setDirectory(const FXString& path){
  filebox->setDirectory(path);
  }


// Get directory
FXString FXFileDialog::getDirectory() const {
  return filebox->getDirectory();
  }


// Set current file pattern from the list
void FXFileDialog::setCurrentPattern(FXint n){
  filebox->setCurrentPattern(n);
  }


// Return current pattern
FXint FXFileDialog::getCurrentPattern() const {
  return filebox->getCurrentPattern();
  }

FXString FXFileDialog::getPatternText(FXint patno) const {
  return filebox->getPatternText(patno);
  }


void FXFileDialog::setPatternText(FXint patno,const FXString& text){
  filebox->setPatternText(patno,text);
  }


// Set list of patterns
void FXFileDialog::setPatternList(const FXchar **ptrns){
  filebox->setPatternList(ptrns);
  }


// Change space for item
void FXFileDialog::setItemSpace(FXint s){
  filebox->setItemSpace(s);
  }


// Get space for item
FXint FXFileDialog::getItemSpace() const {
  return filebox->getItemSpace();
  }


// Change File List style
void FXFileDialog::setFileBoxStyle(FXuint style){
  filebox->setFileBoxStyle(style);
  }


// Return File List style
FXuint FXFileDialog::getFileBoxStyle() const {
  return filebox->getFileBoxStyle();
  }


// Save data
void FXFileDialog::save(FXStream& store) const {
  FXDialogBox::save(store);
  store << filebox;
  }


// Load data
void FXFileDialog::load(FXStream& store){ 
  FXDialogBox::load(store);
  store >> filebox;   
  }


// Cleanup
FXFileDialog::~FXFileDialog(){
  filebox=(FXFileSelector*)-1;
  }


