/********************************************************************************
*                                                                               *
*                             D r a w a b l e   A r e a                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* Major Contributions for Windows NT by Lyle Johnson                            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDrawable.cpp,v 1.6 2000/02/28 17:26:36 jeroen Exp $                    *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXVisual.h"
#include "FXDrawable.h"

/*
  Notes:
  
  - Abstract drawable surface.
*/


/*******************************************************************************/

// Object implementation
FXIMPLEMENT_ABSTRACT(FXDrawable,FXId,NULL,0)


// For deserialization
FXDrawable::FXDrawable(){
  visual=(FXVisual*)-1;
  width=1;
  height=1;
  }


// Initialize nicely
FXDrawable::FXDrawable(FXApp* a,FXint w,FXint h):FXId(a,0){
  visual=NULL;
  width=FXMAX(w,1);
  height=FXMAX(h,1);
  }


// Change visual
void FXDrawable::setVisual(FXVisual* vis){
  if(!vis){ fxerror("%s::setVisual: NULL visual\n",getClassName()); }
  if(xid){ fxerror("%s::setVisual: visual should be set before calling create()\n",getClassName()); }
  visual=vis;
  }


// Create drawable surface
void FXDrawable::create(){ }
 

// Detach drawable surface
void FXDrawable::detach(){ }


// Destroy drawable surface
void FXDrawable::destroy(){ }


// Resize drawable to the specified width and height 
void FXDrawable::resize(FXint w,FXint h){
  width=FXMAX(w,1);
  height=FXMAX(h,1);
  }


// Save data
void FXDrawable::save(FXStream& store) const {
  FXId::save(store);
  store << visual;
  store << width;
  store << height;
  }


// Load data
void FXDrawable::load(FXStream& store){ 
  FXId::load(store);
  store >> visual;
  store >> width;
  store >> height;
  }


// Clean up
FXDrawable::~FXDrawable(){
  visual=(FXVisual*)-1;
  xid=0;
  }
  

