/********************************************************************************
*                                                                               *
*                       D e l e g a t o r   T a r g e t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDelegator.cpp,v 1.2 2000/03/03 22:59:45 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXObject.h"
#include "FXDelegator.h"

/*

  Notes:
  - A delegator forwards messages to another target.
  - A delegator does not itself understand any message; it is mainly used
    to provide a single point at which the actual object receiving the messages
    from the controls can be switched around to another.
*/


/*******************************************************************************/



// Object implementation
FXIMPLEMENT(FXDelegator,FXObject,NULL,0)


// Handle message
long FXDelegator::handle(FXObject* sender,FXSelector key,void* data){
  return delegate && delegate->handle(sender,key,data);
  }


