/********************************************************************************
*                                                                               *
*                C o m p o s i t e   W i n d o w   O b j e c t                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXComposite.cpp,v 1.8 2000/02/28 17:26:36 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXComposite.h"
#include "FXShell.h"

  
/*
  Notes:
  - Rather a slim class.
*/

/*******************************************************************************/

// Map
FXDEFMAP(FXComposite) FXCompositeMap[]={
  FXMAPFUNC(SEL_FOCUS_NEXT,0,FXComposite::onFocusNext),
  FXMAPFUNC(SEL_FOCUS_PREV,0,FXComposite::onFocusPrev),
  FXMAPFUNC(SEL_FOCUS_UP,0,FXComposite::onFocusPrev),
  FXMAPFUNC(SEL_FOCUS_DOWN,0,FXComposite::onFocusNext),
  FXMAPFUNC(SEL_FOCUS_LEFT,0,FXComposite::onFocusPrev),
  FXMAPFUNC(SEL_FOCUS_RIGHT,0,FXComposite::onFocusNext),
  FXMAPFUNC(SEL_COMMAND,FXComposite::ID_UPDATE,FXComposite::onCmdUpdate),
  };


// Object implementation
FXIMPLEMENT(FXComposite,FXWindow,FXCompositeMap,ARRAYNUMBER(FXCompositeMap))


// Only used for Root Window
FXComposite::FXComposite(FXApp* a,FXVisual *vis):FXWindow(a,vis){
  }


// Only used for Shell Window
FXComposite::FXComposite(FXApp* a,FXWindow* own,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXWindow(a,own,opts,x,y,w,h){
  }


// Create empty composite window
FXComposite::FXComposite(FXComposite* p,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXWindow(p,opts,x,y,w,h){
  }


// Create window
void FXComposite::create(){
  FXWindow::create();
  for(FXWindow *c=getFirst(); c; c=c->getNext()) c->create();
  }


// Detach window
void FXComposite::detach(){
  for(FXWindow *c=getFirst(); c; c=c->getNext()) c->detach();
  FXWindow::detach();
  }


// Destroy window
void FXComposite::destroy(){
  for(FXWindow *c=getFirst(); c; c=c->getNext()) c->destroy();
  FXWindow::destroy();
  }


// Get width
FXint FXComposite::getDefaultWidth(){
  register FXWindow *child;
  FXint t,w=0;
  for(child=getFirst(); child; child=child->getNext()){
    if(child->shown()){
      t=child->getX()+child->getWidth();
      if(w<t) w=t;
      }
    }
  return w;
  }


// Get height
FXint FXComposite::getDefaultHeight(){
  register FXWindow *child;
  FXint t,h=0;
  for(child=getFirst(); child; child=child->getNext()){
    if(child->shown()){
      t=child->getY()+child->getHeight();
      if(h<t) h=t;
      }
    }
  return h;
  }


// Just tell server where the windows are!
void FXComposite::layout(){
  register FXWindow *child;
  for(child=getFirst(); child; child=child->getNext()){
    if(child->shown()){
      child->position(child->getX(),child->getY(),child->getWidth(),child->getHeight());
      }
    }
  flags&=~FLAG_DIRTY;
  }


// Update all subwindows
long FXComposite::onCmdUpdate(FXObject* sender,FXSelector,void* ptr){
  register FXWindow *child;
  update(); 
  for(child=getFirst(); child; child=child->getNext()){
    if(child->shown()) child->handle(sender,MKUINT(ID_UPDATE,SEL_COMMAND),ptr);
    }
  return 1;
  }


// Focus moved to next
long FXComposite::onFocusNext(FXObject*,FXSelector sel,void* ptr){
  FXWindow *child;
  if(getFocus())
    child=getFocus()->getNext();
  else
    child=getFirst();
  while(child){
    if(child->shown()){
      if(child->isEnabled() && child->canFocus()){
        child->handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
        return 1;
        }
      if(child->isComposite() && child->handle(this,sel,ptr)) return 1;
      }
    child=child->getNext();
    }
  return 0;
  }


// Focus moved to previous
long FXComposite::onFocusPrev(FXObject*,FXSelector sel,void* ptr){
  FXWindow *child;
  if(getFocus())
    child=getFocus()->getPrev();
  else
    child=getLast();
  while(child){
    if(child->shown()){
      if(child->isEnabled() && child->canFocus()){
        child->handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
        return 1;
        }
      if(child->isComposite() && child->handle(this,sel,ptr)) return 1;
      }
    child=child->getPrev();
    }
  return 0;
  }


// Is widget a composite
FXbool FXComposite::isComposite() const { return 1; }


// Dispose of all the children
FXComposite::~FXComposite(){
  while(getFirst()){ delete getFirst(); }
  }


