/********************************************************************************
*                                                                               *
*                         C o l o r W e l l   C l a s s                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXColorWell.cpp,v 1.13 2000/04/06 05:00:13 jeroen Exp $                  *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXObjectList.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXComposite.h"
#include "FXPacker.h"
#include "FXTab.h"
#include "FXCanvas.h"
#include "FXColorWell.h"
#include "FXShell.h"
#include "FXTopWindow.h"
#include "FXDialogBox.h"
#include "FXScrollbar.h"
#include "FXScrollArea.h"
#include "FXList.h"
#include "FXTextField.h"
#include "FXSlider.h"
#include "FXColorSelector.h"
#include "FXColorDialog.h"

/*
  Notes:
  - Need to popup color dialog on double click (but what to do
    when there's a custom color panel?)
  - Is there any reason why one wouldn't ^C ^V on the clipboard colors same as text?
  - Single-click should send SEL_COMMAND to target.
  - Perhaps change of color should send SEL_CHANGED.
  - Do not start drag operation unless moving a little bit.
  - Drive from keyboard.
  - Think some more about active well handling.
*/

#define WELLSIZE    12              // Minimum well size
#define FOCUSBORDER 3               // Focus border


/*******************************************************************************/


// Map
FXDEFMAP(FXColorWell) FXColorWellMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXColorWell::onPaint),
  FXMAPFUNC(SEL_MOTION,0,FXColorWell::onMotion),
  FXMAPFUNC(SEL_DND_MOTION,0,FXColorWell::onDNDMotion),
  FXMAPFUNC(SEL_DRAGGED,0,FXColorWell::onDragged),
  FXMAPFUNC(SEL_FOCUSIN,0,FXColorWell::onFocusIn),
  FXMAPFUNC(SEL_FOCUSOUT,0,FXColorWell::onFocusOut),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXColorWell::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXColorWell::onLeftBtnRelease),
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS,0,FXColorWell::onMiddleBtnPress),
  FXMAPFUNC(SEL_MIDDLEBUTTONRELEASE,0,FXColorWell::onMiddleBtnRelease),
  FXMAPFUNC(SEL_CLICKED,0,FXColorWell::onClicked),
  FXMAPFUNC(SEL_DOUBLECLICKED,0,FXColorWell::onDoubleClicked),
  FXMAPFUNC(SEL_TRIPLECLICKED,0,FXColorWell::onTripleClicked),
  FXMAPFUNC(SEL_KEYPRESS,0,FXColorWell::onKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXColorWell::onKeyRelease),
  FXMAPFUNC(SEL_UNGRABBED,0,FXColorWell::onUngrabbed),
  FXMAPFUNC(SEL_DND_DROP,0,FXColorWell::onDNDDrop),
  FXMAPFUNC(SEL_DND_REQUEST,0,FXColorWell::onDNDRequest),
  FXMAPFUNC(SEL_BEGINDRAG,0,FXColorWell::onBeginDrag),
  FXMAPFUNC(SEL_ENDDRAG,0,FXColorWell::onEndDrag),
  FXMAPFUNC(SEL_CHANGED,0,FXColorWell::onChanged),
  FXMAPFUNC(SEL_COMMAND,0,FXColorWell::onCommand),
  FXMAPFUNC(SEL_SELECTION_LOST,0,FXColorWell::onSelectionLost),
  FXMAPFUNC(SEL_SELECTION_GAINED,0,FXColorWell::onSelectionGained),
  FXMAPFUNC(SEL_SELECTION_REQUEST,0,FXColorWell::onSelectionRequest),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_TIP,FXColorWell::onQueryTip),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_HELP,FXColorWell::onQueryHelp),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXColorWell::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXColorWell::onCmdSetIntValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXColorWell::onCmdGetIntValue),
  FXMAPFUNC(SEL_CHANGED,FXColorWell::ID_COLORDIALOG,FXColorWell::onChgColorWell),
  FXMAPFUNC(SEL_COMMAND,FXColorWell::ID_COLORDIALOG,FXColorWell::onCmdColorWell),
  };


// Object implementation
FXIMPLEMENT(FXColorWell,FXFrame,FXColorWellMap,ARRAYNUMBER(FXColorWellMap))


  
/*******************************************************************************/


// Init
FXColorWell::FXColorWell(){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  rgba=0;
  wellColor[0]=0;
  wellColor[1]=0;
  }

  
// Make a color well
FXColorWell::FXColorWell(FXComposite* p,FXColor clr,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXFrame(p,opts,x,y,w,h,pl,pr,pt,pb){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  target=tgt;
  message=sel;
  rgba=clr;
  wellColor[0]=rgbaoverwhite(rgba);
  wellColor[1]=rgbaoverblack(rgba);
  }


// Create window
void FXColorWell::create(){
  FXFrame::create();
  if(!colorType){colorType=getApp()->registerDragType(colorTypeName);}
  dropEnable();
  }


// Detach window
void FXColorWell::detach(){
  FXFrame::detach();
  colorType=0;
  }


// If window can have focus
FXbool FXColorWell::canFocus() const { return 1; }


// temp=fg*alpha+bg*(255-alpha)+127
// result=(temp+(temp>>8))>>8

// result=(fg*alpha+bg*(255-alpha)+127)/255


// Compute color over black
FXColor FXColorWell::rgbaoverblack(FXColor clr){
  FXint r,g,b,mul=FXALPHAVAL(clr);
  r=(FXREDVAL(clr)*mul+127)/255;
  g=(FXGREENVAL(clr)*mul+127)/255;
  b=(FXBLUEVAL(clr)*mul+127)/255;
  return FXRGB(r,g,b);
  }


// Compute color over white
FXColor FXColorWell::rgbaoverwhite(FXColor clr){
  FXint r,g,b,mul=FXALPHAVAL(clr),lum=(255-mul);
  r=(lum*255+FXREDVAL(clr)*mul+127)/255;
  g=(lum*255+FXGREENVAL(clr)*mul+127)/255;
  b=(lum*255+FXBLUEVAL(clr)*mul+127)/255;
  return FXRGB(r,g,b);
  }


// Get default size
FXint FXColorWell::getDefaultWidth(){
  return WELLSIZE+FOCUSBORDER+padleft+padright+4;
  }


FXint FXColorWell::getDefaultHeight(){
  return WELLSIZE+FOCUSBORDER+padtop+padbottom+4;
  }


// Handle repaint 
long FXColorWell::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXPoint points[3];
  dc.setForeground(backColor);
  dc.fillRectangle(0,0,width,padtop+FOCUSBORDER);
  dc.fillRectangle(0,padtop+FOCUSBORDER,padleft+FOCUSBORDER,height-padtop-padbottom-(FOCUSBORDER<<1));
  dc.fillRectangle(width-padright-FOCUSBORDER,padtop+FOCUSBORDER,padright+FOCUSBORDER,height-padtop-padbottom-(FOCUSBORDER<<1));
  dc.fillRectangle(0,height-padbottom-FOCUSBORDER,width,padbottom+FOCUSBORDER);
  if(hasSelection()){
    dc.setForeground(borderColor);
    dc.drawRectangle(padleft+1,padtop+1,width-padright-padleft-3,height-padbottom-padtop-3);
    }
  dc.setForeground(wellColor[0]);
  points[0].x=points[1].x=padleft+FOCUSBORDER+2; 
  points[2].x=width-padright-FOCUSBORDER-2;
  points[0].y=points[2].y=padtop+FOCUSBORDER+2;
  points[1].y=height-padbottom-FOCUSBORDER-2;
  dc.fillPolygon(points,3);
  dc.setForeground(wellColor[1]);
  points[0].x=padleft+FOCUSBORDER+2; 
  points[1].x=points[2].x=width-padright-FOCUSBORDER-2;
  points[0].y=points[1].y=height-padbottom-FOCUSBORDER-2;
  points[2].y=padtop+FOCUSBORDER+2;
  dc.fillPolygon(points,3);
  drawDoubleSunkenRectangle(dc,padleft+FOCUSBORDER,padtop+FOCUSBORDER,width-padright-padleft-(FOCUSBORDER<<1),height-padbottom-padtop-(FOCUSBORDER<<1));
  if(hasFocus()){
    drawFocusRectangle(dc,padleft,padtop,width-padright-padleft,height-padbottom-padtop);
    }
  return 1;
  }


// Gained focus
long FXColorWell::onFocusIn(FXObject* sender,FXSelector sel,void* ptr){
  FXFrame::onFocusIn(sender,sel,ptr);
  update();
  return 1;
  }

  
// Lost focus
long FXColorWell::onFocusOut(FXObject* sender,FXSelector sel,void* ptr){
  FXFrame::onFocusOut(sender,sel,ptr);
  update();
  return 1;
  }


// Handle drag-and-drop motion
long FXColorWell::onDNDMotion(FXObject* sender,FXSelector sel,void* ptr){
  
  // Handle base class first
  if(FXFrame::onDNDMotion(sender,sel,ptr)) return 1;
  
  // No more messages while inside
  setDragRectangle(0,0,width,height,FALSE);
  
  // Is it a color being dropped?
  if(offeredDNDType(FROM_DRAGNDROP,FXColorWell::colorType)){
    acceptDrop(DRAG_COPY);
    return 1;
    }
  return 0;
  }


// Handle drag-and-drop drop
long FXColorWell::onDNDDrop(FXObject* sender,FXSelector sel,void* ptr){
  FXuchar *data; FXuint len,r,g,b,a;
  
  // Try handling it in base class first
  if(FXFrame::onDNDDrop(sender,sel,ptr)) return 1;
  
  // Try handle here
  if(getDNDData(FROM_DRAGNDROP,colorType,data,len)){
    sscanf((char*)data,"#%02x%02x%02x%02x",&r,&g,&b,&a);
    FXFREE(&data);
    handle(this,MKUINT(0,SEL_CHANGED),(void*)FXRGBA(r,g,b,a)); 
    handle(this,MKUINT(0,SEL_COMMAND),(void*)rgba); 
    return 1;
    }
  return 0;
  }


// Service requested DND data
long FXColorWell::onDNDRequest(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXchar *value;
  
  // Try handling it in base class first
  if(FXFrame::onDNDRequest(sender,sel,ptr)) return 1;
  
  // Try handle here
  if(event->target==colorType){
    FXTRACE((100,"%s: Get color\n",getClassName()));
    FXMALLOC(&value,FXchar,50);
    sprintf(value,"#%02x%02x%02x%02x",FXREDVAL(rgba),FXGREENVAL(rgba),FXBLUEVAL(rgba),FXALPHAVAL(rgba));
    setDNDData(event->origin,colorType,(FXuchar*)value,50);
    return 1;
    }
  return 0;
  }


// We now really do have the selection; repaint the text field
long FXColorWell::onSelectionGained(FXObject* sender,FXSelector sel,void* ptr){
  FXFrame::onSelectionGained(sender,sel,ptr);
  update();
  return 1;
  }


// We lost the selection somehow; repaint the text field
long FXColorWell::onSelectionLost(FXObject* sender,FXSelector sel,void* ptr){
  FXFrame::onSelectionLost(sender,sel,ptr);
  update();
  return 1;
  }


// Somebody wants our selection
long FXColorWell::onSelectionRequest(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXchar *value;
  
  // Try handling it in base class first
  if(FXFrame::onSelectionRequest(sender,sel,ptr)) return 1;
  
  // Requested as standard FOX color type
  if(event->target==colorType){
    FXMALLOC(&value,FXchar,50);
    sprintf(value,"#%02x%02x%02x%02x",FXREDVAL(rgba),FXGREENVAL(rgba),FXBLUEVAL(rgba),FXALPHAVAL(rgba));
    setDNDData(event->origin,colorType,(FXuchar*)value,strlen(value));
    return 1;
    }

  // Requested as string of the form #rrggbb
  if(event->target==stringType){
    FXMALLOC(&value,FXchar,50);
    fxnamefromcolor(value,rgba);    // This is so cool!!
    setDNDData(event->origin,stringType,(FXuchar*)value,strlen(value)+1);
    return 1;
    }

  return 0;
  }


// Start a drag operation
long FXColorWell::onBeginDrag(FXObject* sender,FXSelector sel,void* ptr){
  if(FXFrame::onBeginDrag(sender,sel,ptr)) return 1;
  beginDrag(&FXColorWell::colorType,1);
  setDragCursor(getApp()->swatchCursor);
  return 1;
  }


// End drag operation
long FXColorWell::onEndDrag(FXObject* sender,FXSelector sel,void* ptr){
  if(FXFrame::onEndDrag(sender,sel,ptr)) return 1;
  endDrag(didAccept()==DRAG_COPY);
  setDragCursor(getApp()->arrowCursor);
  return 1;
  }


// Dragged stuff around
long FXColorWell::onDragged(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  if(FXFrame::onDragged(sender,sel,ptr)) return 1;
  handleDrag(event->root_x,event->root_y,DRAG_COPY);
  if(didAccept()==DRAG_COPY){
    setDragCursor(getApp()->swatchCursor);
    }
  else{
    setDragCursor(getApp()->dontdropCursor);
    }
  return 1;
  }


// Moving 
long FXColorWell::onMotion(FXObject*,FXSelector,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  if(flags&FLAG_PRESSED){
    if(flags&FLAG_DODRAG){
      handle(this,MKUINT(0,SEL_DRAGGED),ptr);
      return 1;
      }
    if(flags&FLAG_TRYDRAG){
      if(event->moved){
        flags&=~FLAG_TRYDRAG;
        if(handle(this,MKUINT(0,SEL_BEGINDRAG),ptr)){
          flags|=FLAG_DODRAG;
          }
        }
      return 1;
      }
    }
  return 0;
  }


// Drag start
long FXColorWell::onLeftBtnPress(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    grab();
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONPRESS),ptr)) return 1;
    if(event->click_count==1){
      flags&=~FLAG_UPDATE;
      flags|=FLAG_PRESSED;
      flags|=FLAG_TRYDRAG;
      }
    }
  return 1;
  }


// Drop 
long FXColorWell::onLeftBtnRelease(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    ungrab();
    flags&=~FLAG_PRESSED;
    flags|=FLAG_UPDATE;
    if(target && target->handle(this,MKUINT(message,SEL_LEFTBUTTONRELEASE),ptr)) return 1;
    if(flags&FLAG_DODRAG){
      handle(this,MKUINT(0,SEL_ENDDRAG),ptr);
      flags&=~FLAG_DODRAG;
      }
    if(event->click_count==1){
      handle(this,MKUINT(0,SEL_CLICKED),(void*)rgba);
      if(!event->moved){
        handle(this,MKUINT(0,SEL_COMMAND),(void*)rgba); 
        }
      }
    else if(event->click_count==2){
      handle(this,MKUINT(0,SEL_DOUBLECLICKED),(void*)rgba);
      }
    else if(event->click_count==3){
      handle(this,MKUINT(0,SEL_TRIPLECLICKED),(void*)rgba);
      }
    return 1;
    }
  return 1;
  }


// Pressed middle button to paste
long FXColorWell::onMiddleBtnPress(FXObject*,FXSelector,void* ptr){
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    grab();
    if(target && target->handle(this,MKUINT(message,SEL_MIDDLEBUTTONPRESS),ptr)) return 1;
    return 1;
    }
  return 0;
  }


// Released middle button causes paste of selection
long FXColorWell::onMiddleBtnRelease(FXObject*,FXSelector,void* ptr){
  FXuchar *data; FXuint len,r,g,b,a; FXColor color;
  if(isEnabled()){
    ungrab();
    if(target && target->handle(this,MKUINT(message,SEL_MIDDLEBUTTONRELEASE),ptr)) return 1;
    if(getDNDData(FROM_SELECTION,colorType,data,len)){
      sscanf((char*)data,"#%02x%02x%02x%02x",&r,&g,&b,&a);
      FXFREE(&data);
      handle(this,MKUINT(0,SEL_CHANGED),(void*)FXRGBA(r,g,b,a)); 
      handle(this,MKUINT(0,SEL_COMMAND),(void*)rgba); 
      return 1;
      }
    if(getDNDData(FROM_SELECTION,stringType,data,len)){
      color=fxcolorfromname((FXchar*)data);      // This is so cool!!
      FXFREE(&data);
      handle(this,MKUINT(0,SEL_CHANGED),(void*)color); 
      handle(this,MKUINT(0,SEL_COMMAND),(void*)color); 
      return 1;
      }
    }
  return 0;
  }


// Key Press
long FXColorWell::onKeyPress(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  flags&=~FLAG_TIP;
  if(isEnabled()){
    if(target && target->handle(this,MKUINT(message,SEL_KEYPRESS),ptr)) return 1;
    switch(event->code){
      case KEY_space:
      case KEY_KP_Enter:
        flags&=~FLAG_UPDATE;
        flags|=FLAG_KEY;
      case KEY_Return:
        flags&=~FLAG_UPDATE;
        flags|=FLAG_KEY;
        return 1;
      }
    }
  return 0;
  }


// Key Release 
long FXColorWell::onKeyRelease(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  if(isEnabled()){
    flags|=FLAG_UPDATE;
    flags&=~FLAG_KEY;
    if(target && target->handle(this,MKUINT(message,SEL_KEYRELEASE),ptr)) return 1;
    switch(event->code){
      case KEY_space:
        handle(this,MKUINT(0,SEL_CLICKED),(void*)rgba);
        handle(this,MKUINT(0,SEL_COMMAND),(void*)rgba);
        return 1;
      case KEY_KP_Enter:
      case KEY_Return:
        handle(this,MKUINT(0,SEL_DOUBLECLICKED),(void*)rgba);
        return 1;
      }
    }
  return 0;
  }


// Change color value
long FXColorWell::onChanged(FXObject*,FXSelector,void* ptr){
  FXColor clr=(FXColor)(long)ptr;
  if(clr!=rgba){
    setRGBA(clr);
    if(target) target->handle(this,MKUINT(message,SEL_CHANGED),(void*)rgba);
    }
  return 1;
  }


// Command from cell
long FXColorWell::onCommand(FXObject*,FXSelector,void*){
  return target && target->handle(this,MKUINT(message,SEL_COMMAND),(void*)rgba);
  }


// Clicked in the well
long FXColorWell::onClicked(FXObject*,FXSelector,void*){
  FXDragType types[2];
  
  if(target && target->handle(this,MKUINT(message,SEL_CLICKED),(void*)rgba)) return 1;
  
  // Double click means claim selection
  if(!hasSelection()){
    types[0]=stringType;
    types[1]=colorType;
    acquireSelection(types,2);
    }
  return 1;
  }


// Double clicked in well
long FXColorWell::onDoubleClicked(FXObject*,FXSelector,void*){
  
  // Double click
  if(target && target->handle(this,MKUINT(message,SEL_DOUBLECLICKED),(void*)rgba)) return 1;
  
  // Can not be edited
  if(options&COLORWELL_SOURCEONLY) return 1;
  
  // OK, edit the color now
  FXColorDialog colordialog(this,"Color Dialog");
  FXColor oldcolor=getRGBA();
  colordialog.setTarget(this);
  colordialog.setSelector(ID_COLORDIALOG);
  colordialog.setRGBA(oldcolor);
  
  // We canceled, so restore the old color
  if(!colordialog.execute()){
    handle(this,MKUINT(0,SEL_CHANGED),(void*)oldcolor); 
    handle(this,MKUINT(0,SEL_COMMAND),(void*)oldcolor); 
    }
  return 1;
  }


// Triple clicked in well, to edit its color; only if not a source-only well
long FXColorWell::onTripleClicked(FXObject*,FXSelector,void*){
  return target && target->handle(this,MKUINT(message,SEL_TRIPLECLICKED),(void*)rgba);
  }


// The widget lost the grab for some reason
long FXColorWell::onUngrabbed(FXObject* sender,FXSelector sel,void* ptr){
  FXFrame::onUngrabbed(sender,sel,ptr);
  flags&=~FLAG_PRESSED;
  flags|=FLAG_UPDATE;
  endDrag(FALSE);
  return 1;
  }


// Change from another Color Well
long FXColorWell::onChgColorWell(FXObject*,FXSelector,void* ptr){
  FXTRACE((100,"%s::onChgColorWell %08x\n",getClassName(),this));
  flags&=~FLAG_UPDATE;
  setRGBA((FXColor)(long)ptr);
  if(target) target->handle(this,MKUINT(message,SEL_CHANGED),ptr);
  return 1;
  }


// Command from another Color Well
long FXColorWell::onCmdColorWell(FXObject*,FXSelector,void* ptr){
  FXTRACE((100,"%s::onCmdColorWell %08x\n",getClassName(),this));
  setRGBA((FXColor)(long)ptr);
  if(target) target->handle(this,MKUINT(message,SEL_COMMAND),ptr);
  flags|=FLAG_UPDATE;
  return 1;
  }


// We were asked about status text
long FXColorWell::onQueryHelp(FXObject* sender,FXSelector,void*){
  if(!help.empty() && (flags&FLAG_HELP)){
    sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&help);
    return 1;
    }
  return 0;
  }


// We were asked about tip text
long FXColorWell::onQueryTip(FXObject* sender,FXSelector,void*){
  if(!tip.empty() && (flags&FLAG_TIP)){
    sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&tip);
    return 1;
    }
  return 0;
  }


// Change help text
void FXColorWell::setHelpText(const FXString& text){
  help=text;
  }


// Change tip text
void FXColorWell::setTipText(const FXString& text){
  tip=text;
  }


// Change RGBA color 
void FXColorWell::setRGBA(FXColor clr){
  if(clr!=rgba){
    rgba=clr;
    FXTRACE((250,"%s::setRGBA(%08x)\n",getClassName(),clr));
    wellColor[0]=rgbaoverwhite(rgba);
    wellColor[1]=rgbaoverblack(rgba);
    update();
    }
  }


// Set color
long FXColorWell::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setRGBA((FXColor)(long)ptr);
  return 1;
  }


// Update value from a message
long FXColorWell::onCmdSetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetIntValue: NULL pointer.\n",getClassName()); }
  setRGBA(*((FXColor*)ptr));
  return 1;
  }


// Obtain value from text field
long FXColorWell::onCmdGetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetIntValue: NULL pointer.\n",getClassName()); }
  *((FXColor*)ptr)=getRGBA();
  return 1;
  }


// Get RGBA color
FXColor FXColorWell::getRGBA() const { 
  return rgba; 
  }


// Save data
void FXColorWell::save(FXStream& store) const {
  FXFrame::save(store);
  store << wellColor[0] << wellColor[1];
  store << rgba;
  store << tip;
  store << help;
  }


// Load data
void FXColorWell::load(FXStream& store){ 
  FXFrame::load(store);
  store >> wellColor[0] >> wellColor[1];
  store >> rgba;
  store >> tip;
  store >> help;
  }


// Destroy
FXColorWell::~FXColorWell(){
  }


// {
//   FXEvent *ev=(FXEvent*)ptr;
//   XEvent se;
//   FXint tox,toy;
//   Window tmp;
//   Window www=getWindowAt(ev->root_x,ev->root_y);
//   
//   XTranslateCoordinates(getDisplay(),XDefaultRootWindow(getDisplay()),www,ev->root_x,ev->root_y,&tox,&toy,&tmp);
// 
//   se.xbutton.type=ButtonPress;
//   se.xbutton.serial=0;
//   se.xbutton.send_event=1;
//   se.xbutton.display=getDisplay();
//   se.xbutton.window=www;
//   se.xbutton.root=XDefaultRootWindow(getDisplay());
//   se.xbutton.subwindow=None;
//   se.xbutton.time=ev->time;
//   se.xbutton.x=tox;
//   se.xbutton.y=toy;
//   se.xbutton.x_root=ev->root_x;
//   se.xbutton.y_root=ev->root_y;
//   se.xbutton.state=0;
//   se.xbutton.button=2;
//   se.xbutton.same_screen=TRUE;
// fprintf(stderr,"SendEvent to window %d\n",se.xbutton.window);
//   XSendEvent(getDisplay(),se.xbutton.window,True,NoEventMask,&se);
//   
//   se.xbutton.type=ButtonRelease;
//   se.xbutton.serial=0;
//   se.xbutton.send_event=1;
//   se.xbutton.display=getDisplay();
//   se.xbutton.window=www;
//   se.xbutton.root=XDefaultRootWindow(getDisplay());
//   se.xbutton.subwindow=None;
//   se.xbutton.time=ev->time+1;
//   se.xbutton.x=tox;
//   se.xbutton.y=toy;
//   se.xbutton.x_root=ev->root_x;
//   se.xbutton.y_root=ev->root_y;
//   se.xbutton.state=Button2Mask;
//   se.xbutton.button=2;
//   se.xbutton.same_screen=TRUE;
// fprintf(stderr,"SendEvent to window %d\n",se.xbutton.window);
//   XSendEvent(getDisplay(),se.xbutton.window,True,NoEventMask,&se);
// }
