/********************************************************************************
*                                                                               *
*                           B u t t o n    O b j e c t s                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXButton.cpp,v 1.8 2000/03/18 06:27:29 jeroen Exp $                      *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXButton.h"


/*
  Notes:
  - Use flags for button instead of a whole integer
  - Add ``flat'' toolbar style also
  - Need check-style also (stay in when pressed, pop out when unpressed).
  - Who owns the icon(s)?
  - Arrow buttons should auto-repeat with a timer of some kind
  - "&Label\tTooltip\tHelptext\thttp://server/application/helponitem.html"
  - CheckButton should send SEL_COMMAND.
  - Default button mode:- should somehow get focus.
  - Add button multiple-click translations elsewhere
  - Button should be able to behave like a check (radio) button.
  - Need to draw ``around'' the icon etc. So it doesn't flash to background.
*/

// Button styles
#define BUTTON_MASK        (BUTTON_AUTOGRAY|BUTTON_AUTOHIDE|BUTTON_TOOLBAR)

/*******************************************************************************/

// Map
FXDEFMAP(FXButton) FXButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXButton::onPaint),
  FXMAPFUNC(SEL_UPDATE,0,FXButton::onUpdate),
  FXMAPFUNC(SEL_ACTIVATE,0,FXButton::onActivate),
  FXMAPFUNC(SEL_DEACTIVATE,0,FXButton::onDeactivate),
  FXMAPFUNC(SEL_ENTER,0,FXButton::onEnter),
  FXMAPFUNC(SEL_LEAVE,0,FXButton::onLeave),
  FXMAPFUNC(SEL_FOCUSIN,0,FXButton::onFocusIn),
  FXMAPFUNC(SEL_FOCUSOUT,0,FXButton::onFocusOut),
  FXMAPFUNC(SEL_KEYPRESS,FXWindow::ID_HOTKEY,FXButton::onHotKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,FXWindow::ID_HOTKEY,FXButton::onHotKeyRelease),
  FXMAPFUNC(SEL_UNGRABBED,0,FXButton::onUngrabbed),
  FXMAPFUNC(SEL_CLICKED,0,FXButton::onClicked),
  FXMAPFUNC(SEL_DOUBLECLICKED,0,FXButton::onDoubleClicked),
  FXMAPFUNC(SEL_TRIPLECLICKED,0,FXButton::onTripleClicked),
  FXMAPFUNC(SEL_COMMAND,0,FXButton::onCommand),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_CHECK,FXButton::onCheck),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_UNCHECK,FXButton::onUncheck),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXButton::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXButton::onCmdSetIntValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXButton::onCmdGetIntValue),
  };


// Object implementation
FXIMPLEMENT(FXButton,FXLabel,FXButtonMap,ARRAYNUMBER(FXButtonMap))

  
// Deserialization
FXButton::FXButton(){
  flags|=FLAG_ENABLED;
  state=STATE_UP;
  }


// Construct and init
FXButton::FXButton(FXComposite* p,const FXString& text,FXIcon* ic,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXLabel(p,text,ic,opts,x,y,w,h,pl,pr,pt,pb){
  flags|=FLAG_ENABLED;
  target=tgt;
  message=sel;
  state=STATE_UP;
  if(options&BUTTON_DEFAULT) addHotKey(MKUINT(KEY_Return,0));
  }


// Enable the window
void FXButton::enable(){
  if(!(flags&FLAG_ENABLED)){
    FXWindow::enable();
    update();
    }
  }


// Disable the window
void FXButton::disable(){
  if(flags&FLAG_ENABLED){
    FXWindow::disable();
    update();
    }
  }


// Set button state
void FXButton::setState(FXuint s){
  if(state!=s){
    state=s;
    update();
    }
  }


// If window can have focus
FXbool FXButton::canFocus() const { return 1; }


// Update value from a message
long FXButton::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setState((FXint)(long)ptr);
  return 1;
  }


// Update value from a message
long FXButton::onCmdSetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetIntValue: NULL pointer.\n",getClassName()); }
  setState(*((FXint*)ptr));
  return 1;
  }


// Obtain value from text field
long FXButton::onCmdGetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetIntValue: NULL pointer.\n",getClassName()); }
  *((FXint*)ptr)=getState();
  return 1;
  }


// Check the menu button
long FXButton::onCheck(FXObject*,FXSelector,void*){ 
  setState(STATE_ENGAGED); 
  return 1; 
  }


// Check the menu button
long FXButton::onUncheck(FXObject*,FXSelector,void*){ 
  setState(STATE_UP); 
  return 1; 
  }


// Implement auto-hide or auto-gray modes
long FXButton::onUpdate(FXObject* sender,FXSelector sel,void* ptr){
  if(!FXLabel::onUpdate(sender,sel,ptr)){
    if(options&BUTTON_AUTOHIDE){if(shown()){hide();recalc();}}
    if(options&BUTTON_AUTOGRAY){disable();}
    }
  return 1;
  }


// Gained focus
long FXButton::onFocusIn(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusIn(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }

  
// Lost focus
long FXButton::onFocusOut(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onFocusOut(sender,sel,ptr);
  update(border,border,width-(border<<1),height-(border<<1));
  return 1;
  }


// Hot key combination pressed
long FXButton::onHotKeyPress(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyPress %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    handle(this,MKUINT(0,SEL_ACTIVATE),ptr);
    }
  return 1;
  }


// Hot key combination released
long FXButton::onHotKeyRelease(FXObject*,FXSelector,void* ptr){
  FXTRACE((200,"%s::onHotKeyRelease %08x\n",getClassName(),this));
  flags&=~FLAG_TIP;
  if(isEnabled()){ 
    handle(this,MKUINT(0,SEL_DEACTIVATE),ptr); 
    }
  return 1;
  }

 
// The widget lost the grab for some reason
long FXButton::onUngrabbed(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onUngrabbed(sender,sel,ptr);
  flags&=~FLAG_PRESSED;
  flags|=FLAG_UPDATE;
  if(state!=STATE_ENGAGED) setState(STATE_UP);
  return 1;
  }


// Button being activated
long FXButton::onActivate(FXObject*,FXSelector,void*){
  flags|=FLAG_PRESSED;
  flags&=~FLAG_UPDATE;
  if(state!=STATE_ENGAGED) setState(STATE_DOWN);
  return 1;
  }
  

// Button being deactivated
long FXButton::onDeactivate(FXObject*,FXSelector,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  FXuint click=(state==STATE_DOWN);
  flags&=~FLAG_PRESSED;
  flags|=FLAG_UPDATE;
  if(state!=STATE_ENGAGED) setState(STATE_UP);
  if(event->click_count==1) handle(this,MKUINT(0,SEL_CLICKED),(void*)click);
  else if(event->click_count==2) handle(this,MKUINT(0,SEL_DOUBLECLICKED),(void*)click);
  else if(event->click_count==3) handle(this,MKUINT(0,SEL_TRIPLECLICKED),(void*)click);
  if(click) handle(this,MKUINT(0,SEL_COMMAND),(void*)click);
  return 1;
  }


// Clicked on button
long FXButton::onClicked(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_CLICKED),ptr);
  }
  

// Double clicked on button
long FXButton::onDoubleClicked(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_DOUBLECLICKED),ptr);
  }
  
  
// Triple clicked
long FXButton::onTripleClicked(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_TRIPLECLICKED),ptr);
  }


// Command message
long FXButton::onCommand(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_COMMAND),ptr);
  }


// Entered button
long FXButton::onEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onEnter(sender,sel,ptr);
  if(isEnabled()){
    if((flags&FLAG_PRESSED) && (state!=STATE_ENGAGED)) setState(STATE_DOWN);
    if(options&BUTTON_TOOLBAR) update();
    }
  return 1;
  }


// Left button
long FXButton::onLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXLabel::onLeave(sender,sel,ptr);
  if(isEnabled()){
    if((flags&FLAG_PRESSED) && (state!=STATE_ENGAGED)) setState(STATE_UP);
    if(options&BUTTON_TOOLBAR) update();
    }
  return 1;
  }


// Test
// void FXButton::drawback(FXDCWindow& dc,FXint xl,FXint yt,FXint xr,FXint yb){
//   FXColor color=dc.getForeground();
//   FXfloat drx,dgx,dbx,dry,dgy,dby;
//   FXint x,y;
//   FXint r=FXREDVAL(color);
//   FXint g=FXGREENVAL(color);
//   FXint b=FXBLUEVAL(color);
//   FXint r1=FXMAX(0,r-30);       // Darker
//   FXint g1=FXMAX(0,g-30);
//   FXint b1=FXMAX(0,b-30);
//   FXint r2=FXMIN(255,r+30);    // Lighter
//   FXint g2=FXMIN(255,g+30);
//   FXint b2=FXMIN(255,b+30);
//   FXint w=2*(xr-xl);
//   FXint h=2*(yb-yt);
//   dry=drx=(FXfloat)(r2-r1);
//   dgy=dgx=(FXfloat)(g2-g1);
//   dby=dbx=(FXfloat)(b2-b1);
//   drx/=w;
//   dgx/=w;
//   dbx/=w;
//   dry/=h;
//   dgy/=h;
//   dby/=h;
//   for(y=yt; y<=yb; y++){
//     for(x=xl; x<=xr; x++){
//       r=r1+drx*(x-xl)+dry*(y-yt);
//       g=g1+dgx*(x-xl)+dgy*(y-yt);
//       b=b1+dbx*(x-xl)+dby*(y-yt);
//       color=FXRGB(r,g,b);
//       dc.setForeground(color);
//       dc.drawPoint(x,y);
//       }
//     }
//   }


// Handle repaint 
long FXButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXint tw=0,th=0,iw=0,ih=0,tx,ty,ix,iy;
  FXEvent *ev=(FXEvent*)ptr;
  
  // Start drawing
  FXDCWindow dc(this,ev);
  
  // Got a border at all?
  if(options&(FRAME_RAISED|FRAME_SUNKEN)){

    // Toolbar style
    if(options&BUTTON_TOOLBAR){
      
      // Enabled and cursor inside, and up
      if(isEnabled() && underCursor() && (state==STATE_UP)){
        dc.setForeground(backColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,0,0,width,height);
        else drawRaisedRectangle(dc,0,0,width,height);
        }
      
      // Enabled and cursor inside and down
      else if(isEnabled() && underCursor() && (state==STATE_DOWN)){
        dc.setForeground(backColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
        else drawSunkenRectangle(dc,0,0,width,height);
        }
      
      // Enabled and checked
      else if(isEnabled() && (state==STATE_ENGAGED)){
        dc.setForeground(hiliteColor);
        dc.fillRectangle(border,border,width-border*2,height-border*2);
        if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
        else drawSunkenRectangle(dc,0,0,width,height);
        }
        
      // Disabled or unchecked or not under cursor
      else{
        dc.setForeground(backColor);
        dc.fillRectangle(0,0,width,height);
        }
      }
 
    // Normal style
    else{
      
      // Default
      if(isDefault()){
        
        // Draw in up state if disabled or up
        if(!isEnabled() || (state==STATE_UP)){
          dc.setForeground(backColor);
          dc.fillRectangle(border+1,border+1,width-border*2-1,height-border*2-1);
          //drawback(dc,border+1,border+1,width-border-1,height-border-1);
          if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,1,1,width-1,height-1);
          else drawRaisedRectangle(dc,1,1,width-1,height-1);
          }
        
        // Draw sunken if enabled and either checked or pressed
        else{
          if(state==STATE_ENGAGED) dc.setForeground(hiliteColor); else dc.setForeground(backColor);
          dc.fillRectangle(border,border,width-border*2-1,height-border*2-1);
          //drawback(dc,border,border,width-border-1,height-border-1);
          if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width-1,height-1);
          else drawSunkenRectangle(dc,0,0,width-1,height-1);
          }
        
        // Black default border
        drawBorderRectangle(dc,0,0,width,height);
        }
      
      // Non-Default
      else{
        
        // Draw in up state if disabled or up
        if(!isEnabled() || (state==STATE_UP)){
          dc.setForeground(backColor);
          dc.fillRectangle(border,border,width-border*2,height-border*2);
          //drawback(dc,border,border,width-border-1,height-border-1);
          if(options&FRAME_THICK) drawDoubleRaisedRectangle(dc,0,0,width,height);
          else drawRaisedRectangle(dc,0,0,width,height);
          }
        
        // Draw sunken if enabled and either checked or pressed
        else{
          if(state==STATE_ENGAGED) dc.setForeground(hiliteColor); else dc.setForeground(backColor);
          dc.fillRectangle(border,border,width-border*2,height-border*2);
          //drawback(dc,border,border,width-border-1,height-border-1);
          if(options&FRAME_THICK) drawDoubleSunkenRectangle(dc,0,0,width,height);
          else drawSunkenRectangle(dc,0,0,width,height);
          }
        }
      }
    }
  
  // No borders
  else{
    if(isEnabled() && (state==STATE_ENGAGED)){
      dc.setForeground(hiliteColor);
      dc.fillRectangle(0,0,width,height);
      }
    else{
      dc.setForeground(backColor);
      dc.fillRectangle(0,0,width,height);
      }
    }
  
  // Place text & icon
  if(!label.empty()){
    tw=labelWidth(label);
    th=labelHeight(label);
    }
  if(icon){
    iw=icon->getWidth();
    ih=icon->getHeight();
    }
  just_x(tx,ix,tw,iw);
  just_y(ty,iy,th,ih);
  
  // Shift a bit when pressed
  if(state && (options&(FRAME_RAISED|FRAME_SUNKEN))){ ++tx; ++ty; ++ix; ++iy; }

  // Draw the icon
  if(icon){
    if(isEnabled())
      dc.drawIcon(icon,ix,iy);
    else
      dc.drawIconSunken(icon,ix,iy);
    }
  
  // Draw the text
  if(!label.empty()){
    dc.setTextFont(font);
    if(isEnabled()){
      dc.setForeground(textColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      if(hasFocus()){
        drawFocusRectangle(dc,border+2,border+2,width-2*border-4,height-2*border-4);
        }
      }
    else{
      dc.setForeground(hiliteColor);
      drawLabel(dc,label,hotoff,tx+1,ty+1,tw,th);
      dc.setForeground(shadowColor);
      drawLabel(dc,label,hotoff,tx,ty,tw,th);
      }
    }
  return 1;
  }


// Set icon positioning
void FXButton::setButtonStyle(FXuint style){
  FXuint opts=(options&~BUTTON_MASK) | (style&BUTTON_MASK);
  if(options!=opts){
    options=opts;
    update();
    }
  }


// Get icon positioning
FXuint FXButton::getButtonStyle() const { 
  return (options&BUTTON_MASK); 
  }


// Test if default
FXbool FXButton::isDefault() const {
  return (options&BUTTON_DEFAULT)!=0;
  }


// Set as default widget
void FXButton::setDefault(FXbool def){
  if((options&BUTTON_DEFAULT) && !def){
    options&=~BUTTON_DEFAULT;
    remHotKey(MKUINT(KEY_Return,0));
    update();
    }
  else if(!(options&BUTTON_DEFAULT) && def){
    options|=BUTTON_DEFAULT;
    addHotKey(MKUINT(KEY_Return,0));
    update();
    }
  }


// Destroy
FXButton::~FXButton(){
  if(options&BUTTON_DEFAULT) remHotKey(MKUINT(KEY_Return,0));
  }
