/********************************************************************************
*                                                                               *
*                  F i l e   P r o p e r t i e s   D i a l o g                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: PropertyDialog.cpp,v 1.2 2000/01/09 04:34:54 jeroen Exp $                *
********************************************************************************/
#include "xincs.h"
#include "fx.h"
#include "PropertyDialog.h"
#include "icons.h"
#include <stdio.h>
#include <stdlib.h>

/**********************************  Preferences  ******************************/

FXDEFMAP(PropertyDialog) PropertyDialogMap[]={
  FXMAPFUNC(SEL_COMMAND,PropertyDialog::ID_KUL,PropertyDialog::onCmdAbout),
  };

  
FXIMPLEMENT(PropertyDialog,FXDialogBox,PropertyDialogMap,ARRAYNUMBER(PropertyDialogMap))


PropertyDialog::PropertyDialog(FXWindow *owner,const FXString& title):
  FXDialogBox(owner,title,DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE){
 
  // Interior
  FXVerticalFrame *vertical=new FXVerticalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  // Close button
  FXHorizontalFrame *closebox=new FXHorizontalFrame(vertical,LAYOUT_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH);
  new FXButton(closebox,"&OK",NULL,this,FXDialogBox::ID_ACCEPT,LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20,5,5);
  new FXButton(closebox,"&Cancel",NULL,this,FXDialogBox::ID_CANCEL,LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20,5,5);

  new FXFrame(vertical,LAYOUT_FILL_X|FRAME_SUNKEN|LAYOUT_BOTTOM,0,0,0,0,0,0,0,0);

  FXTabBook* tabbook=new FXTabBook(vertical,NULL,0,LAYOUT_RIGHT|TABBOOK_TOPTABS|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  // General Info
  new FXTabItem(tabbook,"&General\tGeneral Information\tGeneral information about the item.",NULL,TAB_TOP|ICON_BEFORE_TEXT);
  FXVerticalFrame *generalFrame=new FXVerticalFrame(tabbook,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED|FRAME_THICK);

    FXGroupBox *namegroup=new FXGroupBox(generalFrame,"Description",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    fileiconbig=new FXBMPIcon(getApp(),bigpenguin,0,IMAGE_ALPHAGUESS);
    new FXLabel(namegroup,NULL,fileiconbig,LAYOUT_CENTER_Y|LAYOUT_SIDE_LEFT);
    FXTextField* name=new FXTextField(namegroup,20,NULL,0,LAYOUT_SIDE_LEFT|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK);
    name->setText("PathFinder.cpp");
  
    FXGroupBox *attrgroup=new FXGroupBox(generalFrame,"Attributes",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    FXMatrix *attrmatrix=new FXMatrix(attrgroup,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(attrmatrix,"Type:",NULL,LAYOUT_RIGHT);
    new FXLabel(attrmatrix,"Symlink",NULL,LAYOUT_LEFT|LAYOUT_FILL_COLUMN);
    new FXLabel(attrmatrix,"Location:",NULL,LAYOUT_RIGHT);
    new FXLabel(attrmatrix,"/",NULL,LAYOUT_LEFT|LAYOUT_FILL_COLUMN);
    new FXLabel(attrmatrix,"Size:",NULL,LAYOUT_RIGHT);
    new FXLabel(attrmatrix,"3 bytes",NULL,LAYOUT_LEFT|LAYOUT_FILL_COLUMN);
    
    FXGroupBox *timegroup=new FXGroupBox(generalFrame,"File Time",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    FXMatrix *timematrix=new FXMatrix(timegroup,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(timematrix,"Created:",NULL,LAYOUT_RIGHT);
    new FXLabel(timematrix,"Jan  6 23:51 2000",NULL,LAYOUT_LEFT|LAYOUT_FILL_COLUMN);
    new FXLabel(timematrix,"Modified:",NULL,LAYOUT_RIGHT);
    new FXLabel(timematrix,"Jan  6 23:51 2000",NULL,LAYOUT_LEFT|LAYOUT_FILL_COLUMN);
    new FXLabel(timematrix,"Accessed:",NULL,LAYOUT_RIGHT);
    new FXLabel(timematrix,"Jan  6 23:51 2000",NULL,LAYOUT_LEFT|LAYOUT_FILL_COLUMN);
    
  // Permissions
  new FXTabItem(tabbook,"&Permissions\tAccess Permissions\tAccess permissions for this item.",NULL,TAB_TOP|ICON_BEFORE_TEXT);
  FXVerticalFrame *permFrame=new FXVerticalFrame(tabbook,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED|FRAME_THICK);
    FXGroupBox *accessgroup=new FXGroupBox(permFrame,"Access Permissions",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    FXMatrix *accessmatrix=new FXMatrix(accessgroup,6,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXFrame(accessmatrix,LAYOUT_FILL_COLUMN);
    new FXLabel(accessmatrix,"Read",NULL,LAYOUT_CENTER_X);
    new FXLabel(accessmatrix,"Write",NULL,LAYOUT_CENTER_X);
    new FXLabel(accessmatrix,"Exec",NULL,LAYOUT_CENTER_X);
    new FXFrame(accessmatrix,LAYOUT_FILL_COLUMN);
    new FXLabel(accessmatrix,"Special",NULL,LAYOUT_CENTER_X);
    
    new FXLabel(accessmatrix,"&User",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXLabel(accessmatrix,"Set UID",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    
    new FXLabel(accessmatrix,"&Group",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXLabel(accessmatrix,"Set GID",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    
    new FXLabel(accessmatrix,"&Other",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    new FXLabel(accessmatrix,"Sticky",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXCheckButton(accessmatrix,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_CENTER_Y);
    
    FXGroupBox *ownergroup=new FXGroupBox(permFrame,"Ownership",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    FXMatrix *ownermatrix=new FXMatrix(ownergroup,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(ownermatrix,"O&wner",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXTextField(ownermatrix,20,NULL,0,LAYOUT_FILL_X|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|FRAME_SUNKEN|FRAME_THICK);
    new FXLabel(ownermatrix,"Grou&p",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
    new FXTextField(ownermatrix,20,NULL,0,LAYOUT_FILL_X|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|FRAME_SUNKEN|FRAME_THICK);
    
  // Bindings
  new FXTabItem(tabbook,"&Bindings\tBindings\tBindings associated with the item.",NULL,TAB_TOP|ICON_BEFORE_TEXT);
  FXVerticalFrame *bindingFrame=new FXVerticalFrame(tabbook,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED|FRAME_THICK);

    FXGroupBox *bindinggroup=new FXGroupBox(bindingFrame,"Line Attributes",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
  }


long PropertyDialog::onCmdAbout(FXObject*,FXSelector,void*){
  return 1;
  }


PropertyDialog::~PropertyDialog(){
  delete fileiconbig;
  }
