/********************************************************************************
*                                                                               *
*              T h e   P a t h F i n d e r   F i l e   B r o w s e r            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: PathFinder.cpp,v 1.13 2000/01/12 04:37:48 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fx.h"
#include "PathFinder.h"
#include "PropertyDialog.h"
#include "icons.h"
#include <stdio.h>
#include <stdlib.h>


  
/*******************************************************************************/

// Map
FXDEFMAP(PathFinderMain) PathFinderMainMap[]={
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_QUIT,PathFinderMain::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,PathFinderMain::ID_QUIT,PathFinderMain::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,PathFinderMain::ID_MAINWINDOW,PathFinderMain::onCmdQuit),
  FXMAPFUNC(SEL_UPDATE,PathFinderMain::ID_MAINWINDOW,PathFinderMain::onUpdTitle),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_DIRECTORYLIST,PathFinderMain::onCmdDirectory),
  FXMAPFUNC(SEL_CLICKED,PathFinderMain::ID_FILELIST,PathFinderMain::onCmdFileClicked),
  FXMAPFUNC(SEL_DOUBLECLICKED,PathFinderMain::ID_FILELIST,PathFinderMain::onCmdFileDblClicked),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE,PathFinderMain::ID_FILELIST,PathFinderMain::onFileListPopup),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_ABOUT,PathFinderMain::onCmdAbout),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_DIRBOX,PathFinderMain::onCmdDirTree),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_SEARCHPATH,PathFinderMain::onCmdSetSearchPath),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_UPDIRECTORY,PathFinderMain::onCmdUpDirectory),
  FXMAPFUNC(SEL_UPDATE,PathFinderMain::ID_UPDATE_FILES,PathFinderMain::onUpdFiles),
  FXMAPFUNC(SEL_UPDATE,PathFinderMain::ID_STATUSLINE,PathFinderMain::onUpdStatusline),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_GO_HOME,PathFinderMain::onCmdHomeDirectory),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_GO_RECENT,PathFinderMain::onCmdRecentDirectory),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_GO_BACK,PathFinderMain::onCmdBackDirectory),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_GO_FORWARD,PathFinderMain::onCmdForwardDirectory),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_SAVE_SETTINGS,PathFinderMain::onCmdSaveSettings),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_NEW_PATHFINDER,PathFinderMain::onCmdNewPathFinder),
  FXMAPFUNC(SEL_COMMAND,PathFinderMain::ID_PROPERTIES,PathFinderMain::onCmdProperties),
  FXMAPFUNC(SEL_UPDATE,PathFinderMain::ID_PROPERTIES,PathFinderMain::onUpdProperties),
  };


// Object implementation
FXIMPLEMENT(PathFinderMain,FXMainWindow,PathFinderMainMap,ARRAYNUMBER(PathFinderMainMap))

/*******************************************************************************/
  

// Executable for another PathFinder
FXchar* PathFinderMain::pathfindercommand;

/*******************************************************************************/
  
// Make some windows
PathFinderMain::PathFinderMain(FXApp* a):
  FXMainWindow(a,"PathFinder",NULL,NULL,DECOR_ALL,0,0,800,600),
  mrufiles("Recent Directories"){
  
  // Make some icons
  bigp=new FXBMPIcon(getApp(),bigpenguin,0,IMAGE_ALPHAGUESS);
  minip=new FXBMPIcon(getApp(),minipenguin,0,IMAGE_ALPHAGUESS);
  
  setIcon(bigp);
  setMiniIcon(minip);
  
  // Make main window; set myself as the target
  setTarget(this);
  setSelector(ID_MAINWINDOW);
  
  // Menu bar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // File menu pane
  FXMenuPane* filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"New &PathFinder...\tCtl-P\tStart another PathFinder.",minip,this,ID_NEW_PATHFINDER);
  new FXMenuCommand(filemenu,"&New Folder",NULL,NULL,0);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q\tQuit PathFinder",NULL,this,ID_QUIT);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
    
  // Separator
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  
  // Toolbar
  toolbar=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X,0,0,0,0, 4,4,0,0, 0,0);

  
  // Status bar
  FXStatusbar *status=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  FXStatusline *statusline=status->getStatusline();
  statusline->setTarget(this);
  statusline->setSelector(ID_STATUSLINE);
  
  // Subtle plug for LINUX
  new FXButton(status,"\tHello, I'm Tux...\nThe symbol for the Linux Operating System.\nAnd all it stands for.\tLinux:- the alternative operating system.",minip,this,ID_ABOUT,LAYOUT_TOP|LAYOUT_RIGHT);
  
  // Make file associations object; shared between FXFileList and FXDirList
  associations=new FXFileDict(getApp());

  // Main window interior
  splitter=new FXSplitter(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);
  group1=new FXVerticalFrame(splitter,LAYOUT_FILL_Y|LAYOUT_FILL_Y, 0,0,180,0, 0,0,0,0);
  group2=new FXVerticalFrame(splitter,LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);


  // Directories
  new FXLabel(group1,"Directories",NULL,JUSTIFY_LEFT|LAYOUT_TOP|LAYOUT_FILL_X|FRAME_SUNKEN);
  subgroup1=new FXVerticalFrame(group1,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  
  // Files
  FXLabel* files=new FXLabel(group2,"Files",NULL,JUSTIFY_LEFT|LAYOUT_TOP|LAYOUT_FILL_X|FRAME_SUNKEN);
  files->setTarget(this);
  files->setSelector(ID_UPDATE_FILES);
  subgroup2=new FXVerticalFrame(group2,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);

  // Directory List on the left
  dirlist=new FXDirList(subgroup1,0,this,ID_DIRECTORYLIST,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_RIGHT|TREELIST_SHOWS_LINES|TREELIST_SHOWS_BOXES|TREELIST_BROWSESELECT|DIRLIST_NO_OWN_ASSOC);
  dirlist->setAssociations(associations);
  
  // Icon list on the right
  filelist=new FXFileList(subgroup2,this,ID_FILELIST,LAYOUT_FILL_X|LAYOUT_FILL_Y|ICONLIST_BIG_ICONS|ICONLIST_AUTOSIZE|FILELIST_NO_OWN_ASSOC);
  filelist->setAssociations(associations);
  
  // Make some icons
  cuticon=new FXBMPIcon(getApp(),cut,0,IMAGE_ALPHAGUESS);
  copyicon=new FXBMPIcon(getApp(),copy,0,IMAGE_ALPHAGUESS);
  pasteicon=new FXBMPIcon(getApp(),paste,0,IMAGE_ALPHAGUESS);

  // Edit Menu Pane
  FXMenuPane* editmenu=new FXMenuPane(this);
  new FXMenuCommand(editmenu,"&Select All\tCtl-A\tSelect all icons",NULL,filelist,FXFileList::ID_SELECT_ALL);
  new FXMenuCommand(editmenu,"&Deselect All\t\tDeselect all icons",NULL,filelist,FXFileList::ID_DESELECT_ALL);
  new FXMenuCommand(editmenu,"&Invert Selection\t\tInvert selection",NULL,filelist,FXFileList::ID_SELECT_INVERSE);
  new FXMenuCommand(editmenu,"Cu&t\tCtl-X\tCut to clipboard.",cuticon,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXMenuCommand(editmenu,"&Copy\tCtl-C\tCopy to clipboard.",copyicon,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXMenuCommand(editmenu,"&Paste\tCtl-V\tPaste from clipboard.",pasteicon,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXMenuTitle(menubar,"&Edit",NULL,editmenu);
  
  // View Menu Pane
  FXMenuPane *viewmenu=new FXMenuPane(this);
  new FXMenuCommand(viewmenu,"&Toolbar\t\tShow or hide tool bar",NULL,toolbar,FXWindow::ID_TOGGLESHOWN);
  new FXMenuCommand(viewmenu,"&Statusbar\t\tShow or hide status bar",NULL,status,FXWindow::ID_TOGGLESHOWN);
  new FXMenuTitle(menubar,"&View",NULL,viewmenu);
  
  // Pattern
  pattern=new FXTextField(status,10,filelist,FXFileList::ID_SET_PATTERN,FRAME_SUNKEN|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0, 0,0,1,1);

  // Caption before pattern  
  new FXLabel(status,"Pattern:",NULL,LAYOUT_RIGHT|LAYOUT_CENTER_Y);
  
  // Directory box
  dirbox=new FXDirBox(toolbar,5,this,ID_DIRBOX,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FIX_WIDTH|LAYOUT_CENTER_Y,0,0,180,0, 0,0, 1,1);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);

  upicon=new FXBMPIcon(getApp(),dirup,0,IMAGE_ALPHAGUESS);
  homeicon=new FXBMPIcon(getApp(),home,0,IMAGE_ALPHAGUESS);
  backicon=new FXBMPIcon(getApp(),goback,0,IMAGE_ALPHAGUESS);
  forwicon=new FXBMPIcon(getApp(),goforw,0,IMAGE_ALPHAGUESS);
    
  // Add some toolbar buttons
  new FXButton(toolbar,"\tUp\tChange up one level.",upicon,this,ID_UPDIRECTORY,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tHome\tChange to home directory.",homeicon,this,ID_GO_HOME,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tBack\tChange to previous directory.",backicon,this,ID_GO_BACK,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tForward\tChange to next directory.",forwicon,this,ID_GO_FORWARD,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  new FXButton(toolbar,"\tMount\tMount device.",new FXBMPIcon(getApp(),maphost,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tUnmount\tUnmount device.",new FXBMPIcon(getApp(),unmaphost,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  new FXButton(toolbar,"\tCut\tCut to clipboard.",cuticon,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tCopy\tCopy to clipboard.",copyicon,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tPaste\tPaste from clipboard.",pasteicon,NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  new FXButton(toolbar,"\tProperties\tDisplay file properties.",new FXBMPIcon(getApp(),properties,0,IMAGE_ALPHAGUESS),this,ID_PROPERTIES,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,8,0);
  
  bigiconsicon=new FXBMPIcon(getApp(),bigicons,0,IMAGE_ALPHAGUESS);
  miniiconsicon=new FXBMPIcon(getApp(),smallicons,0,IMAGE_ALPHAGUESS);
  detailsicon=new FXBMPIcon(getApp(),details,0,IMAGE_ALPHAGUESS);
  
  // Switch display modes
  new FXButton(toolbar,"\tBig Icons\tShow big icons.",bigiconsicon,filelist,FXFileList::ID_SHOW_BIG_ICONS,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tSmall Icons\tShow small icons.",miniiconsicon,filelist,FXFileList::ID_SHOW_MINI_ICONS,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(toolbar,"\tDetails\tShow detail view.",detailsicon,filelist,FXFileList::ID_SHOW_DETAILS,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Spacer  
  new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH,0,0,16,0);
  
  // Delete button far away
  new FXButton(toolbar,"\tDelete\tDelete file.",new FXBMPIcon(getApp(),deleteit,0,IMAGE_ALPHAGUESS),NULL,0,FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  
  // Go Menu Pane
  gomenu=new FXMenuPane(this);
  new FXMenuCommand(gomenu,"&Up\t\tChange up one level.",upicon,this,ID_UPDIRECTORY);
  new FXMenuCommand(gomenu,"&Back\t\tChange to previous directory.",backicon,this,ID_GO_BACK);
  new FXMenuCommand(gomenu,"&Forward\t\tChange to next directory.",forwicon,this,ID_GO_FORWARD);
  new FXMenuCommand(gomenu,"&Home\t\tChange to home directory.",homeicon,this,ID_GO_HOME);
  FXMenuSeparator* sep1=new FXMenuSeparator(gomenu);
  sep1->setTarget(&mrufiles);
  sep1->setSelector(FXRecentFiles::ID_ANYFILES);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_1);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_2);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_3);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_4);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_5);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_6);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_7);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_8);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_9);
  new FXMenuCommand(gomenu,NULL,NULL,&mrufiles,FXRecentFiles::ID_FILE_10);
  new FXMenuTitle(menubar,"&Go",NULL,gomenu);
  
  // Arrange menu
  arrangemenu=new FXMenuPane(this);
  new FXMenuCommand(arrangemenu,"&Details\t\tShow detail view.",NULL,filelist,FXFileList::ID_SHOW_DETAILS);
  new FXMenuCommand(arrangemenu,"&Small Icons\t\tShow small icons.",NULL,filelist,FXFileList::ID_SHOW_MINI_ICONS);
  new FXMenuCommand(arrangemenu,"&Big Icons\t\tShow big icons.",NULL,filelist,FXFileList::ID_SHOW_BIG_ICONS);
  new FXMenuCommand(arrangemenu,"&Rows\t\tView row-wise.",NULL,filelist,FXFileList::ID_ARRANGE_BY_ROWS);
  new FXMenuCommand(arrangemenu,"&Columns\t\tView column-wise.",NULL,filelist,FXFileList::ID_ARRANGE_BY_COLUMNS);
  new FXMenuTitle(menubar,"&Arrange",NULL,arrangemenu);
  
  // Sort menu
  sortmenu=new FXMenuPane(this);
  new FXMenuCommand(sortmenu,"&Name\t\tSort by file name.",NULL,filelist,FXFileList::ID_SORT_BY_NAME);
  new FXMenuCommand(sortmenu,"&Type\t\tSort by file type.",NULL,filelist,FXFileList::ID_SORT_BY_TYPE);
  new FXMenuCommand(sortmenu,"&Size\t\tSort by file size.",NULL,filelist,FXFileList::ID_SORT_BY_SIZE);
  new FXMenuCommand(sortmenu,"T&ime\t\tSort by modification time.",NULL,filelist,FXFileList::ID_SORT_BY_TIME);
  new FXMenuCommand(sortmenu,"&User\t\tSort by user name.",NULL,filelist,FXFileList::ID_SORT_BY_USER);
  new FXMenuCommand(sortmenu,"&Group\t\tSort by group name.",NULL,filelist,FXFileList::ID_SORT_BY_GROUP);
  new FXMenuCommand(sortmenu,"&Reverse\t\tReverse sort direction.",NULL,filelist,FXFileList::ID_SORT_REVERSE);
  new FXMenuTitle(menubar,"&Sort",NULL,sortmenu);
  
  // Options menu
  FXMenuPane* optionsmenu=new FXMenuPane(this);
  new FXMenuCommand(optionsmenu,"&Hidden Directories\t\tShow hidden directories.",NULL,dirlist,FXDirList::ID_TOGGLE_HIDDEN);
  new FXMenuCommand(optionsmenu,"&Hidden Files\t\tShow hidden files and directories.",NULL,filelist,FXFileList::ID_TOGGLE_HIDDEN);
  new FXMenuTitle(menubar,"&Options",NULL,optionsmenu);
  
  // Preferences menu
  FXMenuPane* prefmenu=new FXMenuPane(this);
  new FXMenuCommand(prefmenu,"&Icon path...\t\tIcon search path.",NULL,this,ID_SEARCHPATH);
  new FXMenuCommand(prefmenu,"&Clear Recent\t\tClear recently visited directory menu.",NULL,&mrufiles,FXRecentFiles::ID_CLEAR);
  new FXMenuCommand(prefmenu,"&Save Settings...\t\tSave current settings.",NULL,this,ID_SAVE_SETTINGS);
  new FXMenuTitle(menubar,"&Preferences",NULL,prefmenu);
  
  // Help menu
  FXMenuPane* helpmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu,LAYOUT_RIGHT);
  new FXMenuCommand(helpmenu,"&About PathFinder...\t\tDisplay PathFinder About Panel.",NULL,this,ID_ABOUT,0);
  
  // Make a tool tip
  new FXTooltip(getApp(),0);
  
  // Recent directories
  mrufiles.setTarget(this);
  mrufiles.setSelector(ID_GO_RECENT);
  }
  

// File Item was double-clicked
long PathFinderMain::onCmdFileDblClicked(FXObject*,FXSelector,void* ptr){
  FXint index=(FXint)(long)ptr;
  if(0<=index){
    
    // If directory, open the directory
    if(filelist->isItemDirectory(index)){
      FXString directory=filelist->getItemPathname(index);
      filelist->setDirectory(directory);
      dirlist->setDirectory(directory);
      dirbox->setDirectory(directory);
      mrufiles.appendFile(directory);
      }
    
    // If executable, execute it!
    else if(filelist->isItemExecutable(index)){
      FXString executable=filelist->getItemPathname(index) + " &";
      system(executable.text());
      }

    // If regular file return as the selected file
    else if(filelist->isItemFile(index)){
      FXFileAssoc *association=filelist->getItemAssoc(index);
      if(association){
        if(association->command.text()){
          FXString command=FXStringFormat(association->command.text(),filelist->getItemPathname(index).text());
          system(command.text());
          }
        else{
          FXMessageBox::information(this,MBOX_OK,"Unknown Command","No command defined for file: %s",filelist->getItemFilename(index).text());
          }
        }
      else{
        FXMessageBox::information(this,MBOX_OK,"Unknown File Type","No association has been set for file: %s",filelist->getItemFilename(index).text());
        }
      }
    }
  return 1;
  }


// File Item was clicked
long PathFinderMain::onCmdFileClicked(FXObject*,FXSelector,void* ptr){
//   FXchar path[MAXPATHLEN+1],name[MAXPATHLEN+1],dir[MAXPATHLEN+1],*p;
//   FXOldIconItem *item=(FXOldIconItem*)ptr;
//   name[0]=0;
//   strcpy(path,filelist->getDirectory());
//   if(item){
//     strcpy(name,filelist->getItemText(item));
//     if((p=strchr(name,'\t'))) *p=0;
//     }
//   fxpathname(dir,path,name);
//   filename->setText(dir);
  return 1;
  }


// Popup menu for item in file list
long PathFinderMain::onFileListPopup(FXObject*,FXSelector,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  if(event->moved) return 1;
  FXint index=filelist->getItemAt(event->win_x,event->win_y);
  FXMenuPane pane(this);
  
  // We clicked in the background
  if(index<0){
    new FXMenuCommand(&pane,"&Up\t\tChange up one level.",upicon,this,ID_UPDIRECTORY);
    new FXMenuCommand(&pane,"&Back\t\tChange to previous directory.",backicon,this,ID_GO_BACK);
    new FXMenuCommand(&pane,"&Forward\t\tChange to next directory.",forwicon,this,ID_GO_FORWARD);
    new FXMenuCommand(&pane,"&Home\t\tChange to home directory.",homeicon,this,ID_GO_HOME);
    new FXMenuSeparator(&pane);
    new FXMenuCascade(&pane,"Arrange",NULL,arrangemenu);
    new FXMenuSeparator(&pane);
    new FXMenuCascade(&pane,"Sort by",NULL,sortmenu);
    }
  
  // We clicked on an item
  else{
    new FXMenuCommand(&pane,"Open with...",NULL,NULL,0);
    new FXMenuSeparator(&pane);
    new FXMenuCommand(&pane,"Copy",NULL,NULL,0);
    new FXMenuCommand(&pane,"Rename",NULL,NULL,0);
    new FXMenuCommand(&pane,"Delete",NULL,NULL,0);
    new FXMenuSeparator(&pane);
    new FXMenuCommand(&pane,"Properties...",NULL,this,ID_PROPERTIES);
    }
  pane.create();
  pane.popup(NULL,event->root_x,event->root_y);
  getApp()->runModalWhileShown(&pane);
  return 1;
  }


// About
long PathFinderMain::onCmdAbout(FXObject*,FXSelector,void*){
  FXMessageBox about(this,"About PathFinder","PathFinder File Browser V0.2\n\nUsing the FOX C++ GUI Library (http://cyberia.cfdrc.com/FOX/fox.html)\n\nCopyright (C) 1998,1999,2000 Jeroen van der Zijp (jvz@cfdrc.com)",bigp,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
  about.execute();  
  return 1;
  }


// Set search path
long PathFinderMain::onCmdSetSearchPath(FXObject*,FXSelector,void*){
  FXDialogBox dialog(getApp(),"Change icon search path",DECOR_TITLE|DECOR_BORDER);
  const FXchar *path;
  FXVerticalFrame* content=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,10,10,10,10,10,10);
  new FXLabel(content,"&Specify a `" PATHLISTSEPSTRING "' separated list of directories where icons are to be found:",NULL,LAYOUT_FILL_X);
  FXTextField *text=new FXTextField(content,30,NULL,0,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X);
  new FXHorizontalSeparator(content,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  FXHorizontalFrame* buttons=new FXHorizontalFrame(content,LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,0,0,0,0);
  new FXButton(buttons,"&OK",NULL,&dialog,FXDialogBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT);
  new FXButton(buttons,"&Cancel",NULL,&dialog,FXDialogBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT,0,0,0,0,20,20);
  path=getApp()->reg().readStringEntry("SETTINGS","iconpath","~/.foxicons");
  text->setText(path);
  if(dialog.execute()){
    getApp()->reg().writeStringEntry("SETTINGS","iconpath",text->getText().text());
    }
  return 1;
  }


// Change the directory from the FXDirList
long PathFinderMain::onCmdDirectory(FXObject*,FXSelector,void* ptr){
  FXTreeItem *item=(FXTreeItem*)ptr;
  FXString path=dirlist->getItemPathname(item);
  filelist->setDirectory(path);
  dirbox->setDirectory(path);
  mrufiles.appendFile(path);
  return 1;
  }


// Change the directory from the FXDirBox
long PathFinderMain::onCmdDirTree(FXObject*,FXSelector,void*){
  FXString path=dirbox->getDirectory();
  dirlist->setDirectory(path);
  filelist->setDirectory(path);
  mrufiles.appendFile(path);
  return 1;
  }


// Move up one directory
long PathFinderMain::onCmdUpDirectory(FXObject*,FXSelector,void*){
  FXchar path[MAXPATHLEN];
  fxupdir(path,filelist->getDirectory().text());
  filelist->setDirectory(path);
  dirlist->setDirectory(path);
  dirbox->setDirectory(path);
  mrufiles.appendFile(path);
  return 1;
  }


// Move to home directory
long PathFinderMain::onCmdHomeDirectory(FXObject*,FXSelector,void*){
  FXchar path[MAXPATHLEN];
  fxgethomedir(path);
  filelist->setDirectory(path);
  dirbox->setDirectory(path);
  dirlist->setDirectory(path);
  mrufiles.appendFile(path);
  return 1;
  }

// Move to recent directory
long PathFinderMain::onCmdRecentDirectory(FXObject*,FXSelector,void* ptr){
  FXString path((FXchar*)ptr);
  filelist->setDirectory(path);
  dirbox->setDirectory(path);
  dirlist->setDirectory(path);
  return 1;
  }


// Move to previous directory
long PathFinderMain::onCmdBackDirectory(FXObject*,FXSelector,void* ){
  mrufiles.handle(this,MKUINT(FXRecentFiles::ID_FILE_2,SEL_COMMAND),NULL);
  return 1;
  }


// Move to next directory
long PathFinderMain::onCmdForwardDirectory(FXObject*,FXSelector,void* ){
  mrufiles.handle(this,MKUINT(FXRecentFiles::ID_FILE_1,SEL_COMMAND),NULL);
  return 1;
  }


// Update title
long PathFinderMain::onUpdTitle(FXObject* sender,FXSelector,void*){
  FXString title="PathFinder:- " + filelist->getDirectory();
  sender->handle(this,MKUINT(FXWindow::ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&title);
  return 1;
  }


// Update files heading
long PathFinderMain::onUpdFiles(FXObject* sender,FXSelector,void*){
  FXString string="Files in: " + filelist->getDirectory();
  sender->handle(this,MKUINT(FXWindow::ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&string);
  return 1;
  }


// Update status line to show some info about the icon the cursor is over
long PathFinderMain::onUpdStatusline(FXObject* sender,FXSelector,void*){
  FXint index; 
  index=filelist->getCursorItem();
  if(0<=index){
    FXString info;
    FXFileItem *item=(FXFileItem*)filelist->retrieveItem(index);
    FXFileAssoc *assoc=item->getAssoc();
    
    // What is this thing?
    if(item->isDirectory())       info="Directory: ";
    else if(item->isSymlink())    info="Symlink: ";
    else if(item->isSocket())     info="Socket: ";
    else if(item->isFifo())       info="Fifo: ";
    else if(item->isBlockdev())   info="BlockDev: ";
    else if(item->isChardev())    info="CharDev: ";
    else if(item->isExecutable()) info="Application: ";
    else                          info="File: ";
    
    // Add the name
    info+=filelist->getItemFilename(index);
    
    // Add size if its a file
    if(item->isFile()) info+=" ("+FXStringVal((FXuint)item->getSize())+" bytes) ";
    
    // Add the extension
    if(assoc) info+=assoc->extension;
    
    // Set the status line
    sender->handle(this,MKUINT(ID_SETSTRINGVALUE,SEL_COMMAND),(void*)&info);
    return 1;
    }
  return 0;
  }


// Save settings to disk
long PathFinderMain::onCmdSaveSettings(FXObject*,FXSelector,void*){
  saveSettings();
  getApp()->reg().write();
  return 1;
  }


// Spawn new PathFinder
long PathFinderMain::onCmdNewPathFinder(FXObject*,FXSelector,void*){
  FXString path=filelist->getDirectory();
  saveSettings();
  getApp()->reg().write();
  FXString command=FXStringFormat("%s %s &",pathfindercommand,path.text());
  system(command.text());
  return 1;
  }


// Pop up properties panel
long PathFinderMain::onCmdProperties(FXObject*,FXSelector,void*){
  PropertyDialog properties(this,"Properties");
  properties.execute();
  return 1;
  }


// Update Pop up properties panel buttons
long PathFinderMain::onUpdProperties(FXObject* sender,FXSelector,void*){
  return 1;
  }


// Save settings
void PathFinderMain::saveSettings(){
  FXString path;
  FXString filter;
  FXuint   iconview;
  FXuint   hiddenfiles;
  FXuint   hiddendirs;

  // Save pathfinder directory
  path=filelist->getDirectory();
  getApp()->reg().writeStringEntry("PathFinder Settings","directory",path.text());
  
  // Save file list mode
  iconview=filelist->getListStyle();
  getApp()->reg().writeUnsignedEntry("PathFinder Settings","iconview",iconview);
  
  // Showing hidden files...
  hiddenfiles=filelist->showHiddenFiles();
  getApp()->reg().writeUnsignedEntry("PathFinder Settings","hiddenfiles",hiddenfiles);
  
  // Showing hidden directories...
  hiddendirs=dirlist->showHiddenFiles();
  getApp()->reg().writeUnsignedEntry("PathFinder Settings","hiddendirs",hiddendirs);
  
  // Write new window size back to registry
  getApp()->reg().writeIntEntry("PathFinder Settings","x",getX());
  getApp()->reg().writeIntEntry("PathFinder Settings","y",getY());
  getApp()->reg().writeIntEntry("PathFinder Settings","width",getWidth());
  getApp()->reg().writeIntEntry("PathFinder Settings","height",getHeight());
  
  // Width of tree
  getApp()->reg().writeIntEntry("PathFinder Settings","dirwidth",group1->getWidth());
  
  // Filter
  filter=filelist->getPattern();
  getApp()->reg().writeStringEntry("PathFinder Settings","filter",filter.text());
  
  // Header sizes
  getApp()->reg().writeIntEntry("PathFinder Settings","nameheader",filelist->getHeaderSize(0));
  getApp()->reg().writeIntEntry("PathFinder Settings","typeheader",filelist->getHeaderSize(1));
  getApp()->reg().writeIntEntry("PathFinder Settings","sizeheader",filelist->getHeaderSize(2));
  getApp()->reg().writeIntEntry("PathFinder Settings","dateheader",filelist->getHeaderSize(3));
  getApp()->reg().writeIntEntry("PathFinder Settings","userheader",filelist->getHeaderSize(4));
  getApp()->reg().writeIntEntry("PathFinder Settings","attrheader",filelist->getHeaderSize(5));
  }


// Load settings
void PathFinderMain::loadSettings(){
  FXString path;
  FXString filter;
  FXuint   iconview;
  FXuint   hiddenfiles;
  FXuint   hiddendirs;
  FXint    ww,hh,xx,yy,treewidth;
  
  // Read last path setting
  path=getApp()->reg().readStringEntry("PathFinder Settings","directory","~");
  setDirectory(path);
  
  // Read icon view mode
  iconview=getApp()->reg().readUnsignedEntry("PathFinder Settings","iconview",ICONLIST_BIG_ICONS|ICONLIST_AUTOSIZE);
  filelist->setListStyle(iconview);
  
  // Showing hidden files...
  hiddenfiles=getApp()->reg().readUnsignedEntry("PathFinder Settings","hiddenfiles",FALSE);
  filelist->showHiddenFiles(hiddenfiles);
  
  // Showing hidden directories...
  hiddendirs=getApp()->reg().readUnsignedEntry("PathFinder Settings","hiddendirs",FALSE);
  dirlist->showHiddenFiles(hiddendirs);

  // Get size
  xx=getApp()->reg().readIntEntry("PathFinder Settings","x",100);
  yy=getApp()->reg().readIntEntry("PathFinder Settings","y",100);
  ww=getApp()->reg().readIntEntry("PathFinder Settings","width",800);
  hh=getApp()->reg().readIntEntry("PathFinder Settings","height",600);
  
  setX(xx);
  setY(yy);
  setWidth(ww);
  setHeight(hh);
  
  // Width of tree
  treewidth=getApp()->reg().readIntEntry("PathFinder Settings","dirwidth",100);

  // Set tree width
  group1->setWidth(treewidth);
  
  // Filter
  filter=getApp()->reg().readStringEntry("PathFinder Settings","filter","*");
  filelist->setPattern(filter);

  // Header sizes
  filelist->setHeaderSize(0,getApp()->reg().readIntEntry("PathFinder Settings","nameheader",200));
  filelist->setHeaderSize(1,getApp()->reg().readIntEntry("PathFinder Settings","typeheader",100));
  filelist->setHeaderSize(2,getApp()->reg().readIntEntry("PathFinder Settings","sizeheader",60));
  filelist->setHeaderSize(3,getApp()->reg().readIntEntry("PathFinder Settings","dateheader",150));
  filelist->setHeaderSize(4,getApp()->reg().readIntEntry("PathFinder Settings","userheader",50));
  filelist->setHeaderSize(5,getApp()->reg().readIntEntry("PathFinder Settings","attrheader",60));
  }


// Handle quitting
long PathFinderMain::onCmdQuit(FXObject*,FXSelector,void*){
  saveSettings();
  getApp()->exit(0);
  return 1;
  }


// Switch to given directory
void PathFinderMain::setDirectory(const FXString& dir){
  filelist->setDirectory(dir);
  dirbox->setDirectory(dir);
  dirlist->setDirectory(dir);
  mrufiles.appendFile(dir);
  }


// Make application
void PathFinderMain::create(){    
  loadSettings();
  FXMainWindow::create();
  show();
  }



/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){
  PathFinderMain::pathfindercommand=argv[0];
  FXApp* application=new FXApp("Desktop",NULL);
  application->init(argc,argv);
  PathFinderMain* window=new PathFinderMain(application);
  application->addSignal(SIGINT,window,PathFinderMain::ID_QUIT);
  application->create();
  if(argc==2) window->setDirectory(argv[1]);
  application->run();
  }


