/********************************************************************************
*                                                                               *
*                  U n d o / R e d o - a b l e   C o m m a n d                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXUndoList.h,v 1.3 2000/01/27 19:25:48 jeroen Exp $                      *
********************************************************************************/
#ifndef FXUNDOLIST_H
#define FXUNDOLIST_H


// An undoable command
class FXCommand {
  friend class FXUndoList;
private:
  FXCommand *next;
private:
  FXCommand(const FXCommand&);
  FXCommand &operator=(const FXCommand&);
protected:
  FXCommand():next(NULL){}
public:
  virtual void undo() = 0;
  virtual void redo() = 0;
  virtual ~FXCommand(){}
  };


// A list of commands
class FXUndoList {
private:
  FXCommand *redolist;     // List yet to be done from this point
  FXCommand *undolist;     // List which has been done from this point
public:

  /// Make new empty undo list
  FXUndoList();

  /// Add new command, executing if if desired
  FXbool add(FXCommand* command,FXbool doit=TRUE);

  /// Undo last command
  FXbool undo();

  /// Redo next command
  FXbool redo();

  /// Can we undo more commands
  FXbool canUndo() const { return undolist!=NULL; }

  /// Can we redo more commands
  FXbool canRedo() const { return redolist!=NULL; }

  /// Clear list
  void clear();

  /// Clean up
  ~FXUndoList();
  };


#endif
