/********************************************************************************
*                                                                               *
*                    T o o l b a r   S h e l l   W i d g e t                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXToolbarShell.h,v 1.6 2000/04/14 04:46:54 jeroen Exp $                  *
********************************************************************************/
#ifndef FXTOOLBARSHELL_H
#define FXTOOLBARSHELL_H



/**
* A Tool bar shell is a widget floating around over the Main Window.
* It typically contains an undocked tool bar.
*/
class FXAPI FXToolbarShell : public FXTopWindow {
  FXDECLARE(FXToolbarShell)
protected:
  FXColor   baseColor;
  FXColor   hiliteColor;
  FXColor   shadowColor;
  FXColor   borderColor;
  FXint     border;
protected:
  FXToolbarShell(){}
  virtual void layout();
  void drawBorderRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawRaisedRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawSunkenRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawRidgeRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawGrooveRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawDoubleRaisedRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawDoubleSunkenRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawFrame(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
private:
  FXToolbarShell(const FXToolbarShell&);
  FXToolbarShell &operator=(const FXToolbarShell&);
public:
  long onPaint(FXObject*,FXSelector,void*);
public:

  /// Construct a toolbar shell
  FXToolbarShell(FXWindow* owner,FXuint opts=FRAME_RAISED|FRAME_THICK,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint hs=4,FXint vs=4);

  /// Create server-side resources
  virtual void create();

  /// Return the default width of this window
  virtual FXint getDefaultWidth();
  
  /// Return the default height of this window 
  virtual FXint getDefaultHeight();
  
  };



#endif
