/********************************************************************************
*                                                                               *
*                        T o o l b a r   W i d g e t                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXToolbar.h,v 1.12 2000/04/27 19:46:20 jeroen Exp $                      *
********************************************************************************/
#ifndef FXTOOLBAR_H
#define FXTOOLBAR_H


  
/// Tool bar options
enum {
  TOOLBAR_DOCKED        = 0,            /// Bar is docked 
  TOOLBAR_FLOATING      = 0x00020000    /// Bar is floating
  };
  
  
/// Docking modes
enum FXDocking {
  DOCK_FLOAT,         /// Floating
  DOCK_TOP,           /// Docked at the top
  DOCK_BOTTOM,        /// Docked at the bottom
  DOCK_LEFT,          /// Docked at the left
  DOCK_RIGHT          /// Docked at the right
  };

  
class FXTopWindow;
  
/**
* Toolbar control.
*/
class FXAPI FXToolbar : public FXPacker {
  FXDECLARE(FXToolbar)
protected:
  FXTopWindow *drydock;       // Parent when docked 
  FXTopWindow *wetdock;       // Parent when floating
  FXRectangle  location;      // Location where dragged
  FXDocking    docking;       // Docking state
protected:
  FXToolbar();
  virtual void layout();
  virtual void drawhgrip(FXDCWindow& dc,FXint l,FXint r,FXint t,FXint b);
  virtual void drawvgrip(FXDCWindow& dc,FXint l,FXint r,FXint t,FXint b);
  virtual void findside(FXint x,FXint y,FXRectangle& pos,FXDocking& side,FXWindow*& before);
private:
  FXToolbar(const FXToolbar&);
  FXToolbar &operator=(const FXToolbar&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onBeginDrag(FXObject*,FXSelector,void*);
  long onEndDrag(FXObject*,FXSelector,void*);
  long onDragged(FXObject*,FXSelector,void*);
public:

  /**
  * Construct a toolbar layout manager.
  * The window p is the normal parent, and q is the floating window
  * alternate parent.
  */
  FXToolbar(FXTopWindow* p,FXTopWindow* q,FXuint opts=TOOLBAR_DOCKED,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0,FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING);

  /// Return default width 
  virtual FXint getDefaultWidth();

  /// Return default height 
  virtual FXint getDefaultHeight();
  
  /// Return width for given height
  virtual FXint getWidthForHeight(FXint h);
  
  /// Return height for given width
  virtual FXint getHeightForWidth(FXint w);

  /// Dock bar at given position
  void dockBar(FXint x,FXint y);
  
  /// Move bar to given position
  void moveBar(FXint x,FXint y);

  /// Save drag corner to a stream
  virtual void save(FXStream& store) const;
  
  /// Load drag corner from a stream
  virtual void load(FXStream& store);
  
  /// Destroy
  virtual ~FXToolbar();
  };



#endif
