/********************************************************************************
*                                                                               *
*                   T o g g l e    B u t t o n    W i d g e t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXToggleButton.h,v 1.8 2000/01/25 19:18:52 jeroen Exp $                  *
********************************************************************************/
#ifndef FXTOGGLEBUTTON_H
#define FXTOGGLEBUTTON_H



/// Toggle button flags
enum {
  TOGGLEBUTTON_AUTOGRAY = 0x00800000,       /// Automatically gray out when not updated
  TOGGLEBUTTON_AUTOHIDE = 0x01000000,       /// Automatically hide toggle button when not updated
  TOGGLEBUTTON_TOOLBAR  = 0x02000000        /// Toolbar style toggle button [flat look]
  };


/// Toggle Button
class FXAPI FXToggleButton : public FXLabel {
  FXDECLARE(FXToggleButton)
protected:
  FXString  altlabel; 
  FXIcon   *alticon;
  FXHotKey  althotkey;
  FXint     althotoff;
  FXuchar   oldstate;
  FXuchar   state;
  FXString  alttip;
  FXString  althelp;
protected:
  FXToggleButton();
private:
  FXToggleButton(const FXToggleButton&);
  FXToggleButton& operator=(const FXToggleButton&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onCheck(FXObject*,FXSelector,void*);
  long onUncheck(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
public:

  /// Construct toggle button with two text labels, and two icons, one for each state
  FXToggleButton(FXComposite* p,const FXString& text1,const FXString& text2,FXIcon* icon1=NULL,FXIcon* icon2=NULL,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_RAISED|FRAME_THICK|JUSTIFY_NORMAL|ICON_BEFORE_TEXT,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Create server-side resources
  virtual void create();
  
  /// Detach server-side resources
  virtual void detach();
  
  /// Enable the toggle button 
  virtual void enable();
  
  /// Disable the toggle button 
  virtual void disable();
  
  /// Returns true because a toggle button can receive focus
  virtual FXbool canFocus() const;

  /// Get default width
  virtual FXint getDefaultWidth();
  
  /// Get default height
  virtual FXint getDefaultHeight();
  
  /// Change alternate text shown when toggled
  void setAltText(const FXString& text);
  
  /// Return alternate text
  FXString getAltText() const { return altlabel; }

  /// Change alternate icon shown when toggled
  void setAltIcon(FXIcon* ic);
  
  /// Return alternate icon
  FXIcon* getAltIcon() const { return alticon; }

  /// Change toggled state
  void setState(FXuint s=TRUE);
  
  /// return toggled state
  FXuint getState() const { return state; }

  /// Change alternate help text shown when toggled
  void setAltHelpText(const FXString& text);
  
  /// Return alternate help text
  FXString getAltHelpText() const { return althelp; }

  /// Change alternate tip text shown when toggled
  void setAltTipText(const FXString& text);
  
  /// Return alternate tip text
  FXString getAltTipText() const { return alttip; }

  /// Set the toggle button style flags
  void setToggleStyle(FXuint style);

  /// Get the toggle button style flags
  FXuint getToggleStyle() const;

  /// Save toggle button to a stream
  virtual void save(FXStream& store) const;

  /// Load toggle button from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXToggleButton();
  };

  
#endif
