/********************************************************************************
*                                                                               *
*                    M u l t i - L i ne   T e x t   W i d g e t                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXText.h,v 1.22 2000/05/01 17:36:05 jeroen Exp $                         *
********************************************************************************/
#ifndef FXTEXT_H
#define FXTEXT_H


/// Text widget options
enum {
  TEXT_READONLY      = 0x00100000,              /// Text is NOT editable
  TEXT_TABPIXELS     = 0x00200000,              /// Tabs are in terms of pixels
  TEXT_WORDWRAP      = 0x00400000               /// Wrap at word breaks
  };

  
/// Selection modes
enum FXTextSelectionMode {
  SELECT_CHARS,
  SELECT_WORDS,
  SELECT_LINES
  };

  
/// Multiline text widget
class FXAPI FXText : public FXScrollArea {
  FXDECLARE(FXText)
protected:
  FXchar       *buffer;               // Text buffer being edited
  FXint        *lines;                // Starts of lines in buffer
  FXint         length;               // Length of the actual text in the buffer.
  FXint         nlines;               // Number of lines
  FXint         nvislines;            // Number of visible lines
  FXint         gapstart;             // Start of the insertion point (the gap)
  FXint         gapend;               // End of the insertion point+1
  FXint         topline;              // Begin of first visible line
  FXint         toplineno;            // Line number of first line
  FXint         topy;                 // Y coordinate of first visible line
  FXint         selstartpos;          // Start of selection
  FXint         selendpos;            // End of selection
  FXint         anchorpos;            // Anchor position
  FXint         cursorpos;            // Cursor position
  FXint         cursorline;           // Cursor line start
  FXint         cursorlineno;         // Cursor line number
  FXint         cursorcol;            // Cursor column
  FXint         cursorx;              // X position of cursor
  FXint         cursory;              // Y position of cursor
  FXint         cursorprefx;          // Preferred cursor coordinate
  FXint         margintop;            // Margins top
  FXint         marginbottom;         // Margin bottom
  FXint         marginleft;           // Margin left
  FXint         marginright;          // Margin right
  FXint         wrapwidth;            // Wrap width
  FXFont       *font;                 // Text font
  FXColor       textColor;            // Normal text color
  FXColor       selbackColor;         // Select background color
  FXColor       seltextColor;         // Select text color
  FXColor       cursorColor;          // Cursor color
  FXTimer      *blinker;              // Timer to blick cursor
  FXint         textWidth;            // Total width of all text
  FXint         textHeight;           // Total height of all text
  FXint         tabdist;              // Tab distance
  FXchar       *clipbuffer;           // Clipped text
  FXint         cliplength;           // Length of clipped text
  FXString      delimiters;           // Delimiters
  FXString      help;                 // Status line help
  FXbool        modified;             // User has modified text
  FXuint        dragmode;             // Drag mode
  FXint         grabx;                // Grab point x
  FXint         graby;                // Grab point y
  
protected:
  FXText(){}
  void recompute();
  virtual void layout();
  void calcLineStarts(FXint s,FXint e);
  void updateLineStarts(FXint pos,FXint ncinserted,FXint ncdeleted,FXint nlinserted,FXint nldeleted);
  void showCursor(FXuint state);
  virtual void drawCursor(FXuint state);
  void eraseCursorOverhang();
  void drawBufString(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h,FXint pos,FXint n,FXuint style);
  virtual void drawTextLine(FXDCWindow& dc,FXint line,FXint lclip,FXint rclip,FXint fc,FXint tc);
  void drawTextRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  FXint posToLine(FXint pos) const;
  FXbool posVisible(FXint pos) const;
  void updateRange(FXint beg,FXint end);
  void findTopLine();
  void movegap(FXint pos);
  void sizegap(FXint sz);
  FXchar getChar(FXint pos) const;
  void setChar(FXint pos,FXchar ch);
  FXint findf(FXchar c,FXint pos=0) const;
  FXint findb(FXchar c,FXint pos=0) const;
  FXuint getStyleAt(FXint linepos,FXint linelen,FXint column) const;
  FXint charWidth(FXchar ch,FXint indent) const;
  FXint countLines(FXint pos,FXint len) const;
  FXint wrap(FXint linestart) const;
  FXint forwardNWrappedLines(FXint pos,FXint nlines=1) const;
  FXint backwardNWrappedLines(FXint pos,FXint nlines=1) const;
  FXint wrappedLineStart(FXint pos) const;
  FXint wrappedLineEnd(FXint pos) const;
// void testing(FXint pos) const;
// void dump(FXint f,FXint t) const;
private:
  FXText(const FXText&);
  FXText& operator=(const FXText&);
public:
  
  // System messages
  long onPaint(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onBeginDrag(FXObject*,FXSelector,void*);
  long onEndDrag(FXObject*,FXSelector,void*);
  long onDragged(FXObject*,FXSelector,void*);
  long onDNDEnter(FXObject*,FXSelector,void*);
  long onDNDLeave(FXObject*,FXSelector,void*);
  long onDNDMotion(FXObject*,FXSelector,void*);
  long onDNDDrop(FXObject*,FXSelector,void*);
  long onDNDRequest(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onSelectionRequest(FXObject*,FXSelector,void* ptr);
  long onClipboardLost(FXObject*,FXSelector,void*);
  long onClipboardGained(FXObject*,FXSelector,void*);
  long onClipboardRequest(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onBlink(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onSelected(FXObject*,FXSelector,void*);
  long onDeselected(FXObject*,FXSelector,void*);
  long onInserted(FXObject*,FXSelector,void*);
  long onDeleted(FXObject*,FXSelector,void*);
  long onCmdToggleEditable(FXObject*,FXSelector,void*);
  long onUpdToggleEditable(FXObject*,FXSelector,void*);
  long onCmdCursorLine(FXObject*,FXSelector,void*);
  long onUpdCursorLine(FXObject*,FXSelector,void*);
  long onCmdCursorColumn(FXObject*,FXSelector,void*);
  long onUpdCursorColumn(FXObject*,FXSelector,void*);
  long onUpdHaveSelection(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  
  // Cursor movement
  long onCmdCursorTop(FXObject*,FXSelector,void*);
  long onCmdCursorBottom(FXObject*,FXSelector,void*);
  long onCmdCursorHome(FXObject*,FXSelector,void*);
  long onCmdCursorEnd(FXObject*,FXSelector,void*);
  long onCmdCursorRight(FXObject*,FXSelector,void*);
  long onCmdCursorLeft(FXObject*,FXSelector,void*);
  long onCmdCursorUp(FXObject*,FXSelector,void*);
  long onCmdCursorDown(FXObject*,FXSelector,void*);
  long onCmdCursorWordLeft(FXObject*,FXSelector,void*);
  long onCmdCursorWordRight(FXObject*,FXSelector,void*);
  long onCmdCursorPageDown(FXObject*,FXSelector,void*);
  long onCmdCursorPageUp(FXObject*,FXSelector,void*);
  long onCmdCursorScreenTop(FXObject*,FXSelector,void*);
  long onCmdCursorScreenBottom(FXObject*,FXSelector,void*);
  long onCmdCursorScreenCenter(FXObject*,FXSelector,void*);
  
  // Mark and extend
  long onCmdMark(FXObject*,FXSelector,void*);
  long onCmdExtend(FXObject*,FXSelector,void*);
  
  // Inserting
  long onCmdInsertChar(FXObject*,FXSelector,void*);
  long onCmdInsertString(FXObject*,FXSelector,void*);
  long onCmdInsertNewline(FXObject*,FXSelector,void*);
  
  // Manipulation Selection
  long onCmdCutSel(FXObject*,FXSelector,void*);
  long onCmdCopySel(FXObject*,FXSelector,void*);
  long onCmdPasteSel(FXObject*,FXSelector,void*);
  long onCmdDeleteSel(FXObject*,FXSelector,void*);
  
  // Changing Selection
  long onCmdSelectChar(FXObject*,FXSelector,void*);
  long onCmdSelectWord(FXObject*,FXSelector,void*);
  long onCmdSelectLine(FXObject*,FXSelector,void*);
  long onCmdSelectAll(FXObject*,FXSelector,void*);
  long onCmdDeselectAll(FXObject*,FXSelector,void*);
  
  // Deletion
  long onCmdBackspace(FXObject*,FXSelector,void*);
  long onCmdBackspaceWord(FXObject*,FXSelector,void*);
  long onCmdBackspaceBol(FXObject*,FXSelector,void*);
  long onCmdDelete(FXObject*,FXSelector,void*);
  long onCmdDeleteWord(FXObject*,FXSelector,void*);
  long onCmdDeleteEol(FXObject*,FXSelector,void*);
  long onCmdDeleteLine(FXObject*,FXSelector,void*);
  
  // Colors
  long onCmdTextColor(FXObject*,FXSelector,void*);
  long onUpdTextColor(FXObject*,FXSelector,void*);
  long onCmdSelTextColor(FXObject*,FXSelector,void*);
  long onUpdSelTextColor(FXObject*,FXSelector,void*);
  long onCmdSelBackColor(FXObject*,FXSelector,void*);
  long onUpdSelBackColor(FXObject*,FXSelector,void*);
  long onCmdBackColor(FXObject*,FXSelector,void*);
  long onUpdBackColor(FXObject*,FXSelector,void*);
  long onCmdCursorColor(FXObject*,FXSelector,void*);
  long onUpdCursorColor(FXObject*,FXSelector,void*);
  
public:
  
  enum {
    ID_CURSOR_TOP=FXScrollArea::ID_LAST,
    ID_CURSOR_BOTTOM,
    ID_CURSOR_HOME,
    ID_CURSOR_END,
    ID_CURSOR_RIGHT,
    ID_CURSOR_LEFT,
    ID_CURSOR_UP,
    ID_CURSOR_DOWN,
    ID_CURSOR_WORD_LEFT,
    ID_CURSOR_WORD_RIGHT,
    ID_CURSOR_PAGEDOWN,
    ID_CURSOR_PAGEUP,
    ID_CURSOR_SCRNTOP,
    ID_CURSOR_SCRNBTM,
    ID_CURSOR_SCRNCTR,
    ID_MARK,
    ID_EXTEND,
    ID_INSERT_CHAR,
    ID_INSERT_STRING,
    ID_INSERT_NEWLINE,
    ID_CUT_SEL,
    ID_COPY_SEL,
    ID_PASTE_SEL,
    ID_DELETE_SEL,
    ID_SELECT_CHAR,
    ID_SELECT_WORD,
    ID_SELECT_LINE,
    ID_SELECT_ALL,
    ID_DESELECT_ALL,
    ID_BACKSPACE,
    ID_BACKSPACE_WORD,
    ID_BACKSPACE_BOL,
    ID_DELETE,
    ID_DELETE_WORD,
    ID_DELETE_EOL,
    ID_DELETE_LINE,
    ID_TOGGLE_EDITABLE,
    ID_CURSOR_LINE,
    ID_CURSOR_COLUMN,
    ID_TEXT_COLOR,
    ID_BACK_COLOR,
    ID_SELTEXT_COLOR,
    ID_SELBACK_COLOR,
    ID_CURSOR_COLOR,
    ID_LAST
    };
    
public:

  /// Construct multi-line text widget
  FXText(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// Create server-side resources
  virtual void create();
  
  /// Detach server-side resources
  virtual void detach();
  
  /// Enable the text widget
  virtual void enable();
  
  /// Disable the text widget
  virtual void disable();
  
  /// Need to recalculate size
  virtual void recalc();

  /// Resize this window to the specified width and height 
  virtual void resize(FXint w,FXint h);
  
  /// Move and resize this window in the parent's coordinates
  virtual void position(FXint x,FXint y,FXint w,FXint h);
  
  /// Get default width
  virtual FXint getContentWidth();
  
  /// Get default height
  virtual FXint getContentHeight();
  
  /// Returns true because a text widget can receive focus
  virtual FXbool canFocus() const;
  
  /// Scroll the contents
  void moveContents(FXint x,FXint y);
  
  /// Change top margin
  void setMarginTop(FXint pt);
  
  /// Return top margin
  FXint getMarginTop() const { return margintop; }

  /// Change bottom margin
  void setMarginBottom(FXint pb);
  
  /// Return bottom margin
  FXint getMarginBottom() const { return marginbottom; }

  /// Change left margin
  void setMarginLeft(FXint pl);
  
  /// Return left margin
  FXint getMarginLeft() const { return marginleft; }

  /// Change right margin
  void setMarginRight(FXint pr);
  
  /// Return right margin
  FXint getMarginRight() const { return marginright; }

  /// Return TRUE if text was modified
  FXbool isModified() const { return modified; }

  /// Set modified flag
  void setModified(FXbool mod=TRUE){ modified=mod; }

  /// Return TRUE if text is editable
  FXbool isEditable() const;
  
  /// Set editable flag
  void setEditable(FXbool edit=TRUE);
  
  /// Change delimiters of words
  void setDelimiters(const FXString& delims){ delimiters=delims; }

  /// Return word delimiters  
  FXString getDelimiters() const { return delimiters; }

  /// Return TRUE if character is a delimiter
  FXbool isdelim(FXchar ch) const;

  /// Change text font
  void setFont(FXFont* fnt);
  
  /// Return text font
  FXFont* getFont() const { return font; }

  /// Change text color
  void setTextColor(FXColor clr);
  
  /// Return text color
  FXColor getTextColor() const { return textColor; }

  /// Change selected background color
  void setSelBackColor(FXColor clr);
  
  /// Return selected background color
  FXColor getSelBackColor() const { return selbackColor; }

  /// Change selected text color
  void setSelTextColor(FXColor clr);
  
  /// Return selected text color
  FXColor getSelTextColor() const { return seltextColor; }

  /// Change cursor color
  void setCursorColor(FXColor clr);
  
  /// Return cursor color
  FXColor getCursorColor() const { return cursorColor; }

  /// Set help text
  void setHelpText(const FXString& text);
  
  /// Return help text
  FXString getHelpText() const { return help; }

  /// Extract n characters of text from position pos
  void extractText(FXchar *text,FXint pos,FXint n) const;
  
  /// Append n characters of text at the end of the buffer
  void appendText(const FXchar *text,FXint n);
  
  /// Insert n characters of text at position pos into the buffer
  void insertText(FXint pos,const FXchar *text,FXint n);
  
  /// Remove n characters of text at position pos from the buffer
  void removeText(FXint pos,FXint n);
  
  /// Change the text in the buffer to new text
  void setText(const FXchar* text);
  
  /// Return pointer to text in buffer
  const FXchar *getText();
  
  /// Return length of buffer
  FXint getLength() const { return length; }

  /// Return TRUE if position pos is selected
  FXbool isPosSelected(FXint pos) const;
  
  /// Return text position at given x,y coordinate
  FXint getPosAt(FXint x,FXint y) const;
  
  /// Return Y coordinate of position pos
  FXint getYOfPos(FXint pos) const;
  
  /// Return X coordinate of position pos
  FXint getXOfPos(FXint pos) const;
  
  /// Return width of line of n characters starting at pos 
  FXint lineWidth(FXint pos,FXint n) const;
  
  /// Return height of line of n characters starting at pos 
  FXint lineHeight(FXint pos,FXint n) const;
  
  /// Return line number of position
  FXint getLineOfPos(FXint pos) const;
  
  /// Return column number of position
  FXint getColumnOfPos(FXint pos) const;
  
  /// Return position forward n lines from position pos
  FXint forwardNLines(FXint pos,FXint nlines=1) const;
  
  /// Return position backward n lines from position pos
  FXint backwardNLines(FXint pos,FXint nlines=1) const;
  
  /// Return position of begin of line containing position pos
  FXint lineStart(FXint pos) const;
  
  /// Return position of end of line containing position pos
  FXint lineEnd(FXint pos) const;
  
  /// Return end of previous word
  FXint leftWord(FXint pos) const;
  
  /// Return begin of next word
  FXint rightWord(FXint pos) const;
  
  /// Return begin of word
  FXint wordStart(FXint pos) const;
  
  /// Return end of word
  FXint wordEnd(FXint pos) const;
  
  /// Return validated position
  FXint validPos(FXint pos) const;
  
  /// Make line containing pos the top line
  void setTopLine(FXint pos);
  
  /// Return position of top line
  FXint getTopLine() const;
  
  /// Make line containing pos the bottom line
  void setBottomLine(FXint pos);
  
  /// Return the position of the bottom line
  FXint getBottomLine() const;
  
  /// Make line containing pos the center line
  void setCenterLine(FXint pos);

  /// Set the anchor position
  void setAnchorPos(FXint pos);
  
  /// Return the anchor position
  FXint getAnchorPos() const { return anchorpos; }

  /// Set the cursor position
  void setCursorPos(FXint pos);
  
  /// Return the cursor position
  FXint getCursorPos() const { return cursorpos; }
  
  /// Return selstartpos
  FXint getSelStartPos() const { return selstartpos; }

  /// Return selendpos
  FXint getSelEndPos() const { return selendpos; }

  /// Select len characters starting at given position pos
  FXbool setSelection(FXint pos,FXint len);
  
  /// Extend the selection from the anchor to the given position
  FXbool extendSelection(FXint pos,FXTextSelectionMode mode=SELECT_CHARS); 
  
  /// Unselect the text
  FXbool killSelection(); 
  
  /// Scroll text to make the given position visible
  void makePositionVisible(FXint pos);

  /// Change text style
  void setTextStyle(FXuint style);
  
  /// Return text style
  FXuint getTextStyle() const;
  
  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXText();
  };



#endif
