/********************************************************************************
*                                                                               *
*                           S l i d e r   W i d g e t                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXSlider.h,v 1.11 1999/12/21 21:03:20 jeroen Exp $                       *
********************************************************************************/
#ifndef FXSLIDER_H
#define FXSLIDER_H


/// Slider Control styles
enum {
  SLIDER_HORIZONTAL  = 0,                          /// Slider shown horizontally
  SLIDER_VERTICAL    = 0x00008000,                 /// Slider shown vertically
  SLIDER_ARROW_UP    = 0x00010000,                 /// Slider has arrow head pointing up
  SLIDER_ARROW_DOWN  = 0x00020000,                 /// Slider has arrow head pointing down
  SLIDER_ARROW_LEFT  = SLIDER_ARROW_UP,            /// Slider has arrow head pointing left
  SLIDER_ARROW_RIGHT = SLIDER_ARROW_DOWN,          /// Slider has arrow head pointing right
  SLIDER_INSIDE_BAR  = 0x00040000                  /// Slider is inside the slot rather than overhanging
  };
 
 
  
/// Slider Control
class FXAPI FXSlider : public FXFrame {
  FXDECLARE(FXSlider)
protected:
  FXint         range[2];                 // Reported data range
  FXint         pos;                      // Reported data position
  FXint         incr;                     // Increment when auto-sliding
  FXint         headpos;                  // Head position
  FXint         headsize;                 // Head size
  FXint         slotsize;                 // Slot size
  FXColor       slotColor;                // Color of slot the head moves in
  FXTimer      *timer;                    // Timer for auto-sliding
  FXint         dragpoint;                // Where on the head it's grabbed
  FXString      help;                     // Help string
  FXString      tip;                      // Tip string
protected:
  FXSlider();
  virtual void layout();
  void drawSliderHead(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
private:
  FXSlider(const FXSlider&);
  FXSlider &operator=(const FXSlider&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onTimeInc(FXObject*,FXSelector,void*);
  long onTimeDec(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdSetRealValue(FXObject*,FXSelector,void*);
  long onCmdGetRealValue(FXObject*,FXSelector,void*);
  long onCmdSetIntRange(FXObject*,FXSelector,void*);
  long onCmdGetIntRange(FXObject*,FXSelector,void*);
  long onCmdSetRealRange(FXObject*,FXSelector,void*);
  long onCmdGetRealRange(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
public:
  enum{
    ID_AUTOINC=FXFrame::ID_LAST,
    ID_AUTODEC,
    ID_LAST
    };
public:
  
  /// Construct a slider widget
  FXSlider(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0);

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();
  
  /// Enable the slider 
  virtual void enable();
  
  /// Disable the slider
  virtual void disable();
  
  /// Change the slider's range
  void setRange(FXint lo,FXint hi);
  
  /// Get the slider's current range
  void getRange(FXint& lo,FXint& hi) const { lo=range[0]; hi=range[1]; }

  /// Change the slider position
  void setPosition(FXint p);
  
  /// Get the current slider position
  FXint getPosition() const { return pos; }

  /// Change the slider style
  FXuint getSliderStyle() const;
  
  /// Get the current slider style
  void setSliderStyle(FXuint opts);
  
  /// Get the slider's head size
  FXint getHeadSize() const { return headsize; }

  /// Change the slider's head size
  void setHeadSize(FXint hs);
  
  /// Get the slider's current slot size
  FXint getSlotSize() const { return slotsize; }

  /// Change the slider's slot size
  void setSlotSize(FXint bs);
  
  /// Get the slider's auto-increment/decrement value
  FXint getIncrement() const { return incr; }

  /// Change the slider's auto-increment/decrement value
  void setIncrement(FXint inc);
  
  /// Change the color of the slot the slider head moves in
  void setSlotColor(FXColor clr);
  
  /// Get the current slot color
  FXColor getSlotColor() const { return slotColor; }

  /// Set the help text to be displayed on the status line
  void setHelpText(const FXString& text);
  
  /// Get the current help text
  FXString getHelpText() const { return help; }

  /// Set the tip text to be displayed in the tooltip
  void setTipText(const FXString& text);
  
  /// Get the current tooltip text value
  FXString getTipText() const { return tip; }

  /// Save to stream
  virtual void save(FXStream& store) const;
  
  /// Load from stream
  virtual void load(FXStream& store);
  
  /// Destroy the slider
  virtual ~FXSlider();
  };

  
#endif
