/********************************************************************************
*                                                                               *
*                     R e c e n t   F i l e s   L i s t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXRecentFiles.h,v 1.8 2000/01/12 00:27:46 jeroen Exp $                   *
********************************************************************************/
#ifndef FXRECENTFILES_H
#define FXRECENTFILES_H


/**
* The Recent files manages a most recently used (MRU) file list by
* means of the standard system registry.  
*/
class FXAPI FXRecentFiles : public FXObject {
  FXDECLARE(FXRecentFiles)
protected:
  FXString    group;          // MRU File group
  FXObject   *target;         // Target object to send message
  FXSelector  message;        // Message to send
  FXint       maxfiles;       // Maximum number of files to track
protected:
  FXRecentFiles(const FXRecentFiles&);
public:
  long onCmdClear(FXObject*,FXSelector,void*);
  long onCmdFile(FXObject*,FXSelector,void*);
  long onUpdFile(FXObject*,FXSelector,void*);
  long onUpdAnyFiles(FXObject*,FXSelector,void*);
public:
  enum{
    ID_CLEAR,
    ID_ANYFILES,
    ID_FILE_1,
    ID_FILE_2,
    ID_FILE_3,
    ID_FILE_4,
    ID_FILE_5,
    ID_FILE_6,
    ID_FILE_7,
    ID_FILE_8,
    ID_FILE_9,
    ID_FILE_10
    };
public:

  /// Make new Recent Files Group with default groupname
  FXRecentFiles();

  /// Make new Recent Files Group with groupname gp
  FXRecentFiles(const FXString& gp,FXObject *tgt=NULL,FXSelector sel=0);

  /// Change number of files we're tracking
  void setMaxFiles(FXint mx){ maxfiles=mx; }

  /// Return the maximum number of files being tracked
  FXint getMaxFiles() const { return maxfiles; }

  /// Change the target
  void setTarget(FXObject *t){ target=t; }

  /// Get the target
  FXObject *getTarget() const { return target; }

  /// Change the message
  void setSelector(FXSelector sel){ message=sel; }

  /// Return the message id
  FXSelector getSelector() const { return message; }

  /// Append a file
  void appendFile(const FXString& filename);

  /// Remove a file
  void removeFile(const FXString& filename);

  /// Clear the list of files
  void clear();

  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXRecentFiles();
  };


#endif
