/********************************************************************************
*                                                                               *
*                  R a d i o   B u t t o n    W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXRadioButton.h,v 1.9 1999/12/18 06:17:20 jeroen Exp $                   *
********************************************************************************/
#ifndef FXRADIOBUTTON_H
#define FXRADIOBUTTON_H



/// RadioButton flags
enum {
  RADIOBUTTON_AUTOGRAY = 0x00800000,  /// Automatically gray out when not updated
  RADIOBUTTON_AUTOHIDE = 0x01000000   /// Automatically hide when not updated
  };



/// Radio button
class FXAPI FXRadioButton : public FXLabel {
  FXDECLARE(FXRadioButton)
protected:
  FXuchar  check;
  FXuchar  oldcheck;
  FXColor  radioColor;
protected:
  FXRadioButton();
private:
  FXRadioButton(const FXRadioButton&);
  FXRadioButton &operator=(const FXRadioButton&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onUncheckRadio(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onCheck(FXObject*,FXSelector,void*);
  long onUncheck(FXObject*,FXSelector,void*);
  long onUnknown(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
public:
  
  /// Construct new radio button
  FXRadioButton(FXComposite* p,const FXString& text,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=JUSTIFY_NORMAL|ICON_BEFORE_TEXT,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Enable the radio button 
  virtual void enable();
   
  /// Disable the radio button
  virtual void disable();
  
  /// Returns true because a radio button can receive focus
  virtual FXbool canFocus() const;

  /// Get default width
  virtual FXint getDefaultWidth();
  
  /// Get default height
  virtual FXint getDefaultHeight();

  /// Set radio button state (TRUE, FALSE or MAYBE)
  void setCheck(FXuint s=TRUE);

  /// Get radio button state (TRUE, FALSE or MAYBE)
  FXuint getCheck() const { return check; }

  /// Change radio button style
  void setRadioButtonStyle(FXuint style);
  
  /// Return current radio button style
  FXuint getRadioButtonStyle() const;
  
  /// Get the radio background color
  FXColor getRadioColor() const { return radioColor; }

  /// Set the radio background color
  void setRadioColor(FXColor clr);

  /// Save radio button to a stream
  virtual void save(FXStream& store) const;

  /// Load radio button from a stream
  virtual void load(FXStream& store);
  };


#endif
