/********************************************************************************
*                                                                               *
*                        P r i n t   J o b   D i a l o g                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXPrintDialog.h,v 1.3 1999/12/02 16:58:04 gui Exp $                   *
********************************************************************************/
#ifndef FXPRINTDIALOG_H
#define FXPRINTDIALOG_H


/// Printer selection dialog
class FXAPI FXPrintDialog : public FXDialogBox {
  FXDECLARE(FXPrintDialog)
protected:
  FXRadioButton *sendtoprinter;
  FXComboBox    *printername;
  FXRadioButton *sendtofile;
  FXTextField   *filename;
  FXRadioButton *printall;
  FXRadioButton *printeven;
  FXRadioButton *printodd;
  FXRadioButton *printrange;
  FXRadioButton *firstpagefirst;
  FXRadioButton *lastpagefirst;
  FXRadioButton *printincolor;
  FXRadioButton *printinblacknwhite;
  FXRadioButton *orientportrait;
  FXRadioButton *orientlanscape;
  FXRadioButton *sizeletter;
  FXRadioButton *sizelegal;
  FXRadioButton *sizeA4;
  FXRadioButton *sizeenvelope;
  FXRadioButton *sizecustom;
  FXTextField   *sizewidth;
  FXTextField   *sizeheight;
  FXSpinner     *firstpage;
  FXSpinner     *lastpage;
  FXSpinner     *numberofcopies;
  FXGIFIcon     *landscapeIcon;
  FXGIFIcon     *portraitIcon;
  FXPrinter      printer;
protected:
  FXPrintDialog(){}
private:
  FXPrintDialog(const FXPrintDialog&);
  FXPrintDialog &operator=(const FXPrintDialog&);
public:
  long onCmdToPrinter(FXObject*,FXSelector,void*);
  long onUpdToPrinter(FXObject*,FXSelector,void*);
  long onCmdToFile(FXObject*,FXSelector,void*);
  long onUpdToFile(FXObject*,FXSelector,void*);
  long onCmdBrowse(FXObject*,FXSelector,void*);
  long onUpdBrowse(FXObject*,FXSelector,void*);
  long onCmdProps(FXObject*,FXSelector,void*);
  long onUpdProps(FXObject*,FXSelector,void*);
  long onCmdPortrait(FXObject*,FXSelector,void*);
  long onUpdPortrait(FXObject*,FXSelector,void*);
  long onCmdLandscape(FXObject*,FXSelector,void*);
  long onUpdLandscape(FXObject*,FXSelector,void*);
  long onCmdPages(FXObject*,FXSelector,void*);
  long onUpdPages(FXObject*,FXSelector,void*);
  long onCmdColor(FXObject*,FXSelector,void*);
  long onUpdColor(FXObject*,FXSelector,void*);
  long onCmdGray(FXObject*,FXSelector,void*);
  long onUpdGray(FXObject*,FXSelector,void*);
  long onCmdNumCopies(FXObject*,FXSelector,void*);
  long onUpdNumCopies(FXObject*,FXSelector,void*);
  long onCmdFirstPage(FXObject*,FXSelector,void*);
  long onUpdFirstPage(FXObject*,FXSelector,void*);
  long onCmdLastPage(FXObject*,FXSelector,void*);
  long onUpdLastPage(FXObject*,FXSelector,void*);
  long onCmdCollateNormal(FXObject*,FXSelector,void*);
  long onUpdCollateNormal(FXObject*,FXSelector,void*);
  long onCmdCollateReversed(FXObject*,FXSelector,void*);
  long onUpdCollateReversed(FXObject*,FXSelector,void*);
  long onCmdMedia(FXObject*,FXSelector,void*);
  long onUpdMedia(FXObject*,FXSelector,void*);
  long onCmdMediaWidth(FXObject*,FXSelector,void*);
  long onUpdMediaWidth(FXObject*,FXSelector,void*);
  long onCmdMediaHeight(FXObject*,FXSelector,void*);
  long onUpdMediaHeight(FXObject*,FXSelector,void*);
  long onCmdFileName(FXObject*,FXSelector,void*);
  long onUpdFileName(FXObject*,FXSelector,void*);
  long onCmdPrinterName(FXObject*,FXSelector,void*);
  long onUpdPrinterName(FXObject*,FXSelector,void*);
public:
  enum{
    ID_TO_PRINTER=FXDialogBox::ID_LAST,
    ID_TO_FILE,
    ID_PRINTER_NAME,
    ID_FILE_NAME,
    ID_LANDSCAPE,
    ID_PORTRAIT,
    ID_SIZE_CUSTOM,
    ID_SIZE_LETTER,
    ID_SIZE_LEGAL,
    ID_SIZE_A4,
    ID_SIZE_ENVELOPE,
    ID_SIZE_WIDTH,
    ID_SIZE_HEIGHT,
    ID_COLLATE_NORMAL,
    ID_COLLATE_REVERSED,
    ID_PAGES_ALL,
    ID_PAGES_EVEN,
    ID_PAGES_ODD,
    ID_PAGES_RANGE,
    ID_PAGES_FIRST,
    ID_PAGES_LAST,
    ID_BROWSE_FILE,
    ID_PROPERTIES,
    ID_COLOR_PRINTER,
    ID_GRAY_PRINTER,
    ID_NUM_COPIES
    };
public:
  /// Constructor
  FXPrintDialog(FXWindow* owner,const FXString& name,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  void setPrinter(const FXPrinter& pr);
  void getPrinter(FXPrinter& pr);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXPrintDialog();
  };


#endif
