/********************************************************************************
*                                                                               *
*                     M e n u   C o m m a n d   W i d g e t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuCommand.h,v 1.8 2000/01/28 00:50:16 jeroen Exp $                   *
********************************************************************************/
#ifndef FXMENUCOMMAND_H
#define FXMENUCOMMAND_H


// States the menu can be in
enum {
  MENUSTATE_NORMAL   = 0,           // Normal, unchecked state
  MENUSTATE_CHECKED  = 1,           // Checked with a checkmark
  MENUSTATE_RCHECKED = 2            // Checked with a bullet
  };
  
  
 
/// Command menu item
class FXAPI FXMenuCommand : public FXMenuCaption {
  FXDECLARE(FXMenuCommand)
protected:
  FXuchar      state;       // State of menu
  FXString     accel;       // Accelerator string
  FXHotKey     acckey;      // Accelerator key
protected:
  FXMenuCommand(){}
  void drawCheck(FXDCWindow& dc,FXint x,FXint y);
  void drawBullit(FXDCWindow& dc,FXint x,FXint y);
private:
  FXMenuCommand(const FXMenuCommand&);
  FXMenuCommand &operator=(const FXMenuCommand&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onCheck(FXObject*,FXSelector,void*);
  long onUncheck(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdAccel(FXObject*,FXSelector,void*);
public:
  /// Constructor
  FXMenuCommand(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0);

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();
  
  /// Yes it can receive the focus
  virtual FXbool canFocus() const;
  
  /// Move the focus to this window
  virtual void setFocus();
  
  /// Remove the focus from this window
  virtual void killFocus();
  
  /// Make appear as default
  void setDefault();
  
  /// Make appear as non-default
  void setOther();
  
  /// True if appearing as default
  FXint isDefault() const;
  
  /// Place checkmark next to text
  void check();
  
  /// Uncheck the item
  void uncheck();
  
  /// Return TRUE if checked
  FXint isChecked() const;
  
  /// Place radio bullit next to text
  void checkRadio();
  
  /// Uncheck radio bullit
  void uncheckRadio();
  
  /// Return TRUE if radio-checked
  FXint isRadioChecked() const;
  
  /// Set accelerator text
  void setAccelText(const FXString& text);
  
  /// Return accelarator text
  FXString getAccelText() const { return accel; }

  /// Save menu to a stream
  virtual void save(FXStream& store) const;

  /// Load menu from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXMenuCommand();
  };


#endif
