/********************************************************************************
*                                                                               *
*                           M e n u   B a r   W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuBar.h,v 1.4 1999/12/15 05:48:10 jeroen Exp $                       *
********************************************************************************/
#ifndef FXMENUBAR_H
#define FXMENUBAR_H


/// Menu bar 
class FXAPI FXMenuBar : public FXHorizontalFrame {
  FXDECLARE(FXMenuBar)
protected:
  FXMenuBar(){}
private:
  FXMenuBar(const FXMenuBar&);
  FXMenuBar &operator=(const FXMenuBar&);
public:
  long onFocusLeft(FXObject*,FXSelector,void*);
  long onFocusRight(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onBtnPress(FXObject*,FXSelector,void*);
  long onBtnRelease(FXObject*,FXSelector,void*);
  long onCmdUnpost(FXObject*,FXSelector,void*);
public:

  /// Construct a menu bar
  FXMenuBar(FXComposite* p,FXuint opts=LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=2,FXint pr=2,FXint pt=1,FXint pb=1,FXint hs=3,FXint vs=0);

  /// Returns true if specified coordinate (in parent's coordinate system) is in menu bar
  virtual FXbool contains(FXint parentx,FXint parenty) const;
  };


#endif
