/********************************************************************************
*                                                                               *
*                      J P E G   I m a g e   O b j e c t                        *
*                                                                               *
*********************************************************************************
* Author: David Tyree   Email: celer@ipro.lug.usf.edu                           *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXJPEGImage.h,v 1.6 1999/11/30 14:58:59 jeroen Exp $                     *
********************************************************************************/
#ifndef FXJPEGIMAGE_H
#define FXJPEGIMAGE_H


/// JPEG Image class
class FXJPEGImage : public FXImage {
  FXDECLARE(FXJPEGImage)
protected:
  FXint quality;
protected:
  FXJPEGImage(){}      
private:
  FXJPEGImage(const FXJPEGImage&);
  FXJPEGImage &operator=(const FXJPEGImage&);
public:
  
  /// Construct an image from memory stream formatted in JPEG format
  FXJPEGImage(FXApp *a,const void *pix=NULL,FXuint opts=0,FXint w=1,FXint h=1);

  /// Save pixels into stream in JPEG format
  virtual void loadPixels(FXStream& store);
  
  /// Load pixels from stream in JPEG format
  virtual void savePixels(FXStream& store) const;
  
  /// Set image quality to save with
  void setQuality(FXint q){ quality=q; }

  /// Get image quality setting
  FXint getQuality() const { return quality; }
  
  /// Destroy
  virtual ~FXJPEGImage();
  };


/// Load a jpeg from a stream
extern FXAPI FXbool fxloadJPEG(FXStream& store,FXuchar*& data,FXColor& transp,FXint& width,FXint& height,FXint& quality);


/// Save a jpeg to a stream
extern FXAPI FXbool fxsaveJPEG(FXStream& store,const FXuchar* data,FXColor transp,FXint width,FXint height,FXint quality);


#endif
